/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.depot;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.relays.belt.transport.TransportedItemStack;
import com.simibubi.create.content.logistics.block.depot.DepotBehaviour;
import com.simibubi.create.content.logistics.block.depot.EjectorAwardPacket;
import com.simibubi.create.content.logistics.block.depot.EjectorBlock;
import com.simibubi.create.content.logistics.block.depot.EjectorElytraPacket;
import com.simibubi.create.content.logistics.block.depot.EntityLauncher;
import com.simibubi.create.content.logistics.block.funnel.AbstractFunnelBlock;
import com.simibubi.create.content.logistics.block.funnel.FunnelBlock;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.DirectBeltInputBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.LongAttached;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import io.github.fabricators_of_create.porting_lib.util.NBTSerializer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import me.pepperbell.simplenetworking.C2SPacket;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SidedStorageBlockEntity;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1770;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2426;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2945;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3619;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4587;

public class EjectorTileEntity
extends KineticTileEntity
implements SidedStorageBlockEntity {
    List<LongAttached<class_1799>> launchedItems;
    ScrollValueBehaviour maxStackSize;
    DepotBehaviour depotBehaviour;
    EntityLauncher launcher = new EntityLauncher(1, 0);
    LerpedFloat lidProgress = LerpedFloat.linear().startWithValue(1.0);
    boolean powered = false;
    boolean launch;
    State state = State.RETRACTING;
    @Nullable
    Pair<class_243, class_2338> earlyTarget;
    float earlyTargetTime;
    int scanCooldown;
    class_1799 trackedItem;

    public EjectorTileEntity(class_2591<?> typeIn, class_2338 pos, class_2680 state) {
        super(typeIn, pos, state);
        this.launchedItems = new ArrayList<LongAttached<class_1799>>();
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.depotBehaviour = new DepotBehaviour(this);
        behaviours.add(this.depotBehaviour);
        this.maxStackSize = new ScrollValueBehaviour((class_2561)Lang.translateDirect("weighted_ejector.stack_size", new Object[0]), this, new EjectorSlot()).between(0, 64).withFormatter(i -> i == 0 ? "*" : String.valueOf(i)).onlyActiveWhen(() -> this.state == State.CHARGED).requiresWrench();
        behaviours.add(this.maxStackSize);
        this.depotBehaviour.maxStackSize = () -> this.maxStackSize.getValue();
        this.depotBehaviour.canAcceptItems = () -> this.state == State.CHARGED;
        this.depotBehaviour.canFunnelsPullFrom = side -> side != this.getFacing();
        this.depotBehaviour.enableMerging();
        this.depotBehaviour.addSubBehaviours(behaviours);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.updateSignal();
    }

    public void activate() {
        this.launch = true;
        this.nudgeEntities();
    }

    protected boolean cannotLaunch() {
        return this.state != State.CHARGED && (!this.field_11863.field_9236 || this.state != State.LAUNCHING);
    }

    public void activateDeferred() {
        boolean doLogic;
        if (this.cannotLaunch()) {
            return;
        }
        class_2350 facing = this.getFacing();
        List entities = this.field_11863.method_18467(class_1297.class, new class_238(this.field_11867).method_1009(-0.0625, 0.0, -0.0625));
        boolean bl = doLogic = !this.field_11863.field_9236 || this.isVirtual();
        if (doLogic) {
            this.launchItems();
        }
        for (class_1297 entity : entities) {
            boolean isPlayerEntity = entity instanceof class_1657;
            if (!entity.method_5805() || entity instanceof class_1542 || entity.method_5657() == class_3619.field_15975) continue;
            entity.method_24830(false);
            if (isPlayerEntity != this.field_11863.field_9236) continue;
            entity.method_5814((double)((float)this.field_11867.method_10263() + 0.5f), (double)(this.field_11867.method_10264() + 1), (double)((float)this.field_11867.method_10260() + 0.5f));
            this.launcher.applyMotion(entity, facing);
            if (!isPlayerEntity) continue;
            class_1657 playerEntity = (class_1657)entity;
            if (this.launcher.getHorizontalDistance() * this.launcher.getHorizontalDistance() + this.launcher.getVerticalDistance() * this.launcher.getVerticalDistance() >= 625) {
                AllPackets.channel.sendToServer((C2SPacket)new EjectorAwardPacket(this.field_11867));
            }
            if (!(playerEntity.method_6118(class_1304.field_6174).method_7909() instanceof class_1770)) continue;
            playerEntity.method_36457(-35.0f);
            playerEntity.method_36456(facing.method_10144());
            playerEntity.method_18799(playerEntity.method_18798().method_1021(0.75));
            this.deployElytra(playerEntity);
            AllPackets.channel.sendToServer((C2SPacket)new EjectorElytraPacket(this.field_11867));
        }
        if (doLogic) {
            this.lidProgress.chase(1.0, 0.8f, LerpedFloat.Chaser.EXP);
            this.state = State.LAUNCHING;
            if (!this.field_11863.field_9236) {
                this.field_11863.method_8396(null, this.field_11867, class_3417.field_15080, class_3419.field_15245, 0.35f, 1.0f);
                this.field_11863.method_8396(null, this.field_11867, class_3417.field_14982, class_3419.field_15245, 0.1f, 1.4f);
            }
        }
    }

    public void deployElytra(class_1657 playerEntity) {
        EntityHack.setElytraFlying((class_1297)playerEntity);
    }

    protected void launchItems() {
        class_1799 heldItemStack = this.depotBehaviour.getHeldItemStack();
        class_2350 funnelFacing = this.getFacing().method_10153();
        if (AbstractFunnelBlock.getFunnelFacing(this.field_11863.method_8320(this.field_11867.method_10084())) == funnelFacing) {
            class_1799 remainder;
            class_1799 stack;
            class_1799 remainder2;
            DirectBeltInputBehaviour directOutput = this.getBehaviour(DirectBeltInputBehaviour.TYPE);
            if (this.depotBehaviour.heldItem != null && (remainder2 = directOutput.tryExportingToBeltFunnel(heldItemStack, funnelFacing, false)) != null) {
                if (remainder2.method_7960()) {
                    this.depotBehaviour.removeHeldItem();
                } else if (!remainder2.method_7962(heldItemStack)) {
                    this.depotBehaviour.heldItem.stack = remainder2;
                }
            }
            Iterator<TransportedItemStack> iterator = this.depotBehaviour.incoming.iterator();
            while (iterator.hasNext()) {
                TransportedItemStack transportedItemStack = iterator.next();
                stack = transportedItemStack.stack;
                remainder = directOutput.tryExportingToBeltFunnel(stack, funnelFacing, false);
                if (remainder == null) continue;
                if (remainder.method_7960()) {
                    iterator.remove();
                    continue;
                }
                if (remainder.method_7962(stack)) continue;
                transportedItemStack.stack = remainder;
            }
            ItemStackHandler outputs = this.depotBehaviour.processingOutputBuffer;
            for (int i = 0; i < outputs.getSlots(); ++i) {
                stack = outputs.getStackInSlot(i);
                if (stack.method_7960() || (remainder = directOutput.tryExportingToBeltFunnel(stack, funnelFacing, false)) == null) continue;
                outputs.setStackInSlot(i, remainder);
            }
            return;
        }
        if (!this.field_11863.field_9236) {
            for (class_2350 d : Iterate.directions) {
                class_2680 blockState = this.field_11863.method_8320(this.field_11867.method_10093(d));
                if (!(blockState.method_26204() instanceof class_2426) || blockState.method_11654((class_2769)class_2426.field_10927) != d.method_10153()) continue;
                blockState.method_26191(d.method_10153(), blockState, (class_1936)this.field_11863, this.field_11867.method_10093(d), this.field_11867);
            }
        }
        if (this.depotBehaviour.heldItem != null) {
            this.addToLaunchedItems(heldItemStack);
            this.depotBehaviour.removeHeldItem();
        }
        for (TransportedItemStack transportedItemStack : this.depotBehaviour.incoming) {
            this.addToLaunchedItems(transportedItemStack.stack);
        }
        this.depotBehaviour.incoming.clear();
        ItemStackHandler outputs = this.depotBehaviour.processingOutputBuffer;
        try (Transaction t = TransferUtil.getTransaction();){
            for (StorageView view : TransferUtil.getNonEmpty((Storage)outputs)) {
                ItemVariant var = (ItemVariant)view.getResource();
                long extracted = view.extract((Object)((ItemVariant)view.getResource()), 64L, (TransactionContext)t);
                if (extracted == 0L) continue;
                this.addToLaunchedItems(var.toStack(ItemHelper.truncateLong(extracted)));
            }
            t.commit();
        }
    }

    protected boolean addToLaunchedItems(class_1799 stack) {
        if ((!this.field_11863.field_9236 || this.isVirtual()) && this.trackedItem == null && this.scanCooldown == 0) {
            this.scanCooldown = (Integer)AllConfigs.SERVER.kinetics.ejectorScanInterval.get();
            this.trackedItem = stack;
        }
        return this.launchedItems.add(LongAttached.withZero(stack));
    }

    protected class_2350 getFacing() {
        class_2680 blockState = this.method_11010();
        if (!AllBlocks.WEIGHTED_EJECTOR.has(blockState)) {
            return class_2350.field_11036;
        }
        class_2350 facing = (class_2350)blockState.method_11654(EjectorBlock.HORIZONTAL_FACING);
        return facing;
    }

    @Override
    public void tick() {
        super.tick();
        boolean doLogic = !this.field_11863.field_9236 || this.isVirtual();
        State prevState = this.state;
        float totalTime = Math.max(3.0f, (float)this.launcher.getTotalFlyingTicks());
        if (this.scanCooldown > 0) {
            --this.scanCooldown;
        }
        if (this.launch) {
            this.launch = false;
            this.activateDeferred();
        }
        Iterator<LongAttached<class_1799>> iterator = this.launchedItems.iterator();
        while (iterator.hasNext()) {
            float maxTime;
            LongAttached<class_1799> LongAttached2 = iterator.next();
            boolean hit = false;
            if (LongAttached2.getSecond() == this.trackedItem) {
                hit = this.scanTrajectoryForObstacles((Long)LongAttached2.getFirst());
            }
            float f = maxTime = this.earlyTarget != null ? Math.min(this.earlyTargetTime, totalTime) : totalTime;
            if (hit || LongAttached2.exceeds((int)maxTime)) {
                this.placeItemAtTarget(doLogic, maxTime, LongAttached2);
                iterator.remove();
            }
            LongAttached2.increment();
        }
        if (this.state == State.LAUNCHING) {
            this.lidProgress.chase(1.0, 0.8f, LerpedFloat.Chaser.EXP);
            this.lidProgress.tickChaser();
            if (this.lidProgress.getValue() > 0.9375f && doLogic) {
                this.state = State.RETRACTING;
                this.lidProgress.setValue(1.0);
            }
        }
        if (this.state == State.CHARGED) {
            this.lidProgress.setValue(0.0);
            this.lidProgress.updateChaseSpeed(0.0);
            if (doLogic) {
                this.ejectIfTriggered();
            }
        }
        if (this.state == State.RETRACTING) {
            if (this.lidProgress.getChaseTarget() == 1.0f && !this.lidProgress.settled()) {
                this.lidProgress.tickChaser();
            } else {
                this.lidProgress.updateChaseTarget(0.0f);
                this.lidProgress.updateChaseSpeed(0.0);
                if (this.lidProgress.getValue() == 0.0f && doLogic) {
                    this.state = State.CHARGED;
                    this.lidProgress.setValue(0.0);
                    this.sendData();
                }
                float value = class_3532.method_15363((float)(this.lidProgress.getValue() - this.getWindUpSpeed()), (float)0.0f, (float)1.0f);
                this.lidProgress.setValue(value);
                int soundRate = (int)(1.0f / (this.getWindUpSpeed() * 5.0f)) + 1;
                float volume = 0.125f;
                float pitch = 1.5f - this.lidProgress.getValue();
                if ((int)this.field_11863.method_8510() % soundRate == 0 && doLogic) {
                    this.field_11863.method_8396(null, this.field_11867, class_3417.field_15105, class_3419.field_15245, volume, pitch);
                }
            }
        }
        if (this.state != prevState) {
            this.notifyUpdate();
        }
    }

    private boolean scanTrajectoryForObstacles(long time) {
        class_2680 blockState;
        boolean miss;
        class_243 target;
        if (time <= 2L) {
            return false;
        }
        class_243 source = this.getLaunchedItemLocation(time);
        class_3965 rayTraceBlocks = this.field_11863.method_17742(new class_3959(source, target = this.getLaunchedItemLocation(time + 1L), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, null));
        boolean bl = miss = rayTraceBlocks.method_17783() == class_239.class_240.field_1333;
        if (!miss && rayTraceBlocks.method_17783() == class_239.class_240.field_1332 && FunnelBlock.isFunnel(blockState = this.field_11863.method_8320(rayTraceBlocks.method_17777())) && blockState.method_28498((class_2769)FunnelBlock.EXTRACTING) && ((Boolean)blockState.method_11654((class_2769)FunnelBlock.EXTRACTING)).booleanValue()) {
            miss = true;
        }
        if (miss) {
            if (this.earlyTarget != null && this.earlyTargetTime < (float)(time + 1L)) {
                this.earlyTarget = null;
                this.earlyTargetTime = 0.0f;
            }
            return false;
        }
        class_243 vec = rayTraceBlocks.method_17784();
        this.earlyTarget = Pair.of(vec.method_1019(class_243.method_24954((class_2382)rayTraceBlocks.method_17780().method_10163()).method_1021(0.25)), rayTraceBlocks.method_17777());
        this.earlyTargetTime = (float)((double)time + source.method_1022(vec) / source.method_1022(target));
        this.sendData();
        return true;
    }

    protected void nudgeEntities() {
        for (class_1297 entity : this.field_11863.method_18467(class_1297.class, new class_238(this.field_11867).method_1009(-0.0625, 0.0, -0.0625))) {
            if (!entity.method_5805() || entity.method_5657() == class_3619.field_15975 || entity instanceof class_1657) continue;
            entity.method_5814(entity.method_23317(), entity.method_23318() + 0.125, entity.method_23321());
        }
    }

    protected void ejectIfTriggered() {
        DirectBeltInputBehaviour targetOpenInv;
        if (this.powered) {
            return;
        }
        int presentStackSize = this.depotBehaviour.getPresentStackSize();
        if (presentStackSize == 0) {
            return;
        }
        if (presentStackSize < this.maxStackSize.getValue()) {
            return;
        }
        if (this.depotBehaviour.heldItem != null && this.depotBehaviour.heldItem.beltPosition < 0.49f) {
            return;
        }
        class_2350 funnelFacing = this.getFacing().method_10153();
        class_1799 held = this.depotBehaviour.getHeldItemStack();
        if (AbstractFunnelBlock.getFunnelFacing(this.field_11863.method_8320(this.field_11867.method_10084())) == funnelFacing) {
            class_1799 tryFunnel;
            DirectBeltInputBehaviour directOutput = this.getBehaviour(DirectBeltInputBehaviour.TYPE);
            if (!(this.depotBehaviour.heldItem == null || (tryFunnel = directOutput.tryExportingToBeltFunnel(held, funnelFacing, true)) != null && tryFunnel.method_7960())) {
                return;
            }
        }
        if ((targetOpenInv = this.getTargetOpenInv()) != null && this.depotBehaviour.heldItem != null && targetOpenInv.handleInsertion(held, class_2350.field_11036, true).method_7947() == held.method_7947()) {
            return;
        }
        this.activate();
        this.notifyUpdate();
    }

    protected void placeItemAtTarget(boolean doLogic, float maxTime, LongAttached<class_1799> LongAttached2) {
        DirectBeltInputBehaviour targetOpenInv;
        if (!doLogic) {
            return;
        }
        if (LongAttached2.getSecond() == this.trackedItem) {
            this.trackedItem = null;
        }
        if ((targetOpenInv = this.getTargetOpenInv()) != null) {
            class_1799 remainder = targetOpenInv.handleInsertion(LongAttached2.getValue(), class_2350.field_11036, false);
            LongAttached2.setSecond(remainder);
        }
        if (LongAttached2.getValue().method_7960()) {
            return;
        }
        class_243 ejectVec = this.earlyTarget != null ? this.earlyTarget.getFirst() : this.getLaunchedItemLocation(maxTime);
        class_243 ejectMotionVec = this.getLaunchedItemMotion(maxTime);
        class_1542 item = new class_1542(this.field_11863, ejectVec.field_1352, ejectVec.field_1351, ejectVec.field_1350, LongAttached2.getValue());
        item.method_18799(ejectMotionVec);
        item.method_6988();
        this.field_11863.method_8649((class_1297)item);
    }

    public DirectBeltInputBehaviour getTargetOpenInv() {
        class_2338 targetPos = this.earlyTarget != null ? this.earlyTarget.getSecond() : this.field_11867.method_10086(this.launcher.getVerticalDistance()).method_10079(this.getFacing(), Math.max(1, this.launcher.getHorizontalDistance()));
        return TileEntityBehaviour.get((class_1922)this.field_11863, targetPos, DirectBeltInputBehaviour.TYPE);
    }

    public class_243 getLaunchedItemLocation(float time) {
        return this.launcher.getGlobalPos(time, this.getFacing().method_10153(), this.field_11867);
    }

    public class_243 getLaunchedItemMotion(float time) {
        return this.launcher.getGlobalVelocity(time, this.getFacing().method_10153(), this.field_11867).method_1021(0.5);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.dropFlyingItems();
    }

    public void dropFlyingItems() {
        for (LongAttached<class_1799> LongAttached2 : this.launchedItems) {
            class_243 ejectVec = this.getLaunchedItemLocation(((Long)LongAttached2.getFirst()).longValue());
            class_243 ejectMotionVec = this.getLaunchedItemMotion(((Long)LongAttached2.getFirst()).longValue());
            class_1542 item = new class_1542(this.field_11863, 0.0, 0.0, 0.0, LongAttached2.getValue());
            item.method_23327(ejectVec.field_1352, ejectVec.field_1351, ejectVec.field_1350);
            item.method_18799(ejectMotionVec);
            item.method_6988();
            this.field_11863.method_8649((class_1297)item);
        }
        this.launchedItems.clear();
    }

    public float getWindUpSpeed() {
        int hd = this.launcher.getHorizontalDistance();
        int vd = this.launcher.getVerticalDistance();
        float speedFactor = Math.abs(this.getSpeed()) / 256.0f;
        float distanceFactor = hd == 0 && vd == 0 ? 1.0f : 1.0f * class_3532.method_15355((float)(hd * hd + vd * vd));
        return speedFactor / distanceFactor;
    }

    @Override
    protected void write(class_2487 compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.method_10569("HorizontalDistance", this.launcher.getHorizontalDistance());
        compound.method_10569("VerticalDistance", this.launcher.getVerticalDistance());
        compound.method_10556("Powered", this.powered);
        NBTHelper.writeEnum(compound, "State", this.state);
        compound.method_10566("Lid", (class_2520)this.lidProgress.writeNBT());
        compound.method_10566("LaunchedItems", (class_2520)NBTHelper.writeCompoundList(this.launchedItems, ia -> ia.serializeNBT(NBTSerializer::serializeNBTCompound)));
        if (this.earlyTarget != null) {
            compound.method_10566("EarlyTarget", (class_2520)VecHelper.writeNBT(this.earlyTarget.getFirst()));
            compound.method_10566("EarlyTargetPos", (class_2520)class_2512.method_10692((class_2338)this.earlyTarget.getSecond()));
            compound.method_10548("EarlyTargetTime", this.earlyTargetTime);
        }
    }

    @Override
    public void writeSafe(class_2487 compound) {
        super.writeSafe(compound);
        compound.method_10569("HorizontalDistance", this.launcher.getHorizontalDistance());
        compound.method_10569("VerticalDistance", this.launcher.getVerticalDistance());
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        int horizontalDistance = compound.method_10550("HorizontalDistance");
        int verticalDistance = compound.method_10550("VerticalDistance");
        if (this.launcher.getHorizontalDistance() != horizontalDistance || this.launcher.getVerticalDistance() != verticalDistance) {
            this.launcher.set(horizontalDistance, verticalDistance);
            this.launcher.clamp((Integer)AllConfigs.SERVER.kinetics.maxEjectorDistance.get());
        }
        this.powered = compound.method_10577("Powered");
        this.state = NBTHelper.readEnum(compound, "State", State.class);
        this.lidProgress.readNBT(compound.method_10562("Lid"), false);
        this.launchedItems = NBTHelper.readCompoundList(compound.method_10554("LaunchedItems", 10), nbt -> LongAttached.read(nbt, class_1799::method_7915));
        this.earlyTarget = null;
        this.earlyTargetTime = 0.0f;
        if (compound.method_10545("EarlyTarget")) {
            this.earlyTarget = Pair.of(VecHelper.readNBT(compound.method_10554("EarlyTarget", 6)), class_2512.method_10691((class_2487)compound.method_10562("EarlyTargetPos")));
            this.earlyTargetTime = compound.method_10583("EarlyTargetTime");
        }
        if (compound.method_10545("ForceAngle")) {
            this.lidProgress.startWithValue(compound.method_10583("ForceAngle"));
        }
    }

    public void updateSignal() {
        boolean shoudPower = this.field_11863.method_8479(this.field_11867);
        if (shoudPower == this.powered) {
            return;
        }
        this.powered = shoudPower;
        this.sendData();
    }

    public void setTarget(int horizontalDistance, int verticalDistance) {
        this.launcher.set(Math.max(1, horizontalDistance), verticalDistance);
        this.sendData();
    }

    public class_2338 getTargetPosition() {
        class_2680 blockState = this.method_11010();
        if (!AllBlocks.WEIGHTED_EJECTOR.has(blockState)) {
            return this.field_11867;
        }
        class_2350 facing = (class_2350)blockState.method_11654(EjectorBlock.HORIZONTAL_FACING);
        return this.field_11867.method_10079(facing, this.launcher.getHorizontalDistance()).method_10086(this.launcher.getVerticalDistance());
    }

    public Storage<ItemVariant> getItemStorage(@Nullable class_2350 face) {
        return this.depotBehaviour.itemHandler;
    }

    public float getLidProgress(float pt) {
        return this.lidProgress.getValue(pt);
    }

    public State getState() {
        return this.state;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_238 getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public static enum State {
        CHARGED,
        LAUNCHING,
        RETRACTING;

    }

    private static class EjectorSlot
    extends ValueBoxTransform.Sided {
        private EjectorSlot() {
        }

        @Override
        protected class_243 getLocalOffset(class_2680 state) {
            return new class_243(0.5, 0.8125, 0.5).method_1019(VecHelper.rotate(new class_243(0.0, 0.0, -0.3), this.angle(state), class_2350.class_2351.field_11052));
        }

        @Override
        protected void rotate(class_2680 state, class_4587 ms) {
            ((TransformStack)TransformStack.cast((class_4587)ms).rotateY((double)this.angle(state))).rotateX(90.0);
        }

        protected float angle(class_2680 state) {
            float horizontalAngle = AllBlocks.WEIGHTED_EJECTOR.has(state) ? AngleHelper.horizontalAngle((class_2350)state.method_11654(EjectorBlock.HORIZONTAL_FACING)) : 0.0f;
            return horizontalAngle;
        }

        @Override
        protected boolean isSideActive(class_2680 state, class_2350 direction) {
            return direction == class_2350.field_11036;
        }

        @Override
        protected float getScale() {
            return 0.2f;
        }

        @Override
        protected class_243 getSouthLocation() {
            return class_243.field_1353;
        }
    }

    private static abstract class EntityHack
    extends class_1297 {
        public EntityHack(class_1299<?> p_i48580_1_, class_1937 p_i48580_2_) {
            super(p_i48580_1_, p_i48580_2_);
        }

        public static void setElytraFlying(class_1297 e) {
            class_2945 data = e.method_5841();
            data.method_12778(field_5990, (Object)((byte)((Byte)data.method_12789(field_5990) | 0x80)));
        }
    }
}

