/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.tools;

import com.simibubi.create.AllEntityTypes;
import com.simibubi.create.AllItems;
import com.simibubi.create.Create;
import com.simibubi.create.content.curiosities.tools.BlueprintContainer;
import com.simibubi.create.content.curiosities.tools.BlueprintItem;
import com.simibubi.create.content.logistics.item.filter.FilterItem;
import com.simibubi.create.content.schematics.ISpecialEntityItemRequirement;
import com.simibubi.create.content.schematics.ItemRequirement;
import com.simibubi.create.foundation.networking.ISyncPersistentData;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.IInteractionChecker;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.fabric.ReachUtil;
import io.github.fabricators_of_create.porting_lib.entity.ExtraSpawnDataEntity;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import io.github.fabricators_of_create.porting_lib.util.NetworkUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.PlayerInventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1530;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1715;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2312;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3908;
import net.minecraft.class_3956;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4538;
import org.apache.commons.lang3.Validate;

public class BlueprintEntity
extends class_1530
implements ExtraSpawnDataEntity,
ISpecialEntityItemRequirement,
ISyncPersistentData,
IInteractionChecker {
    protected int size;
    protected class_2350 verticalOrientation;
    private Map<Integer, BlueprintSection> sectionCache = new HashMap<Integer, BlueprintSection>();

    public BlueprintEntity(class_1299<?> p_i50221_1_, class_1937 p_i50221_2_) {
        super(p_i50221_1_, p_i50221_2_);
        this.size = 1;
    }

    public BlueprintEntity(class_1937 world, class_2338 pos, class_2350 facing, class_2350 verticalOrientation) {
        super((class_1299)AllEntityTypes.CRAFTING_BLUEPRINT.get(), world, pos);
        int size = 3;
        while (size > 0) {
            this.size = size--;
            this.updateFacingWithBoundingBox(facing, verticalOrientation);
            if (this.method_6888()) break;
        }
    }

    public static FabricEntityTypeBuilder<?> build(FabricEntityTypeBuilder<?> builder) {
        return builder;
    }

    public class_2596<?> method_18002() {
        return ExtraSpawnDataEntity.createExtraDataSpawnPacket((ExtraSpawnDataEntity)this, (class_2604)new class_2604((class_1297)this, this.method_5628()));
    }

    public void method_5652(class_2487 p_213281_1_) {
        p_213281_1_.method_10567("Facing", (byte)this.field_7099.method_10146());
        p_213281_1_.method_10567("Orientation", (byte)this.verticalOrientation.method_10146());
        p_213281_1_.method_10569("Size", this.size);
        super.method_5652(p_213281_1_);
    }

    public void method_5749(class_2487 p_70037_1_) {
        if (p_70037_1_.method_10573("Facing", 99)) {
            this.field_7099 = class_2350.method_10143((int)p_70037_1_.method_10571("Facing"));
            this.verticalOrientation = class_2350.method_10143((int)p_70037_1_.method_10571("Orientation"));
            this.size = p_70037_1_.method_10550("Size");
        } else {
            this.field_7099 = class_2350.field_11035;
            this.verticalOrientation = class_2350.field_11033;
            this.size = 1;
        }
        super.method_5749(p_70037_1_);
        this.updateFacingWithBoundingBox(this.field_7099, this.verticalOrientation);
    }

    protected void updateFacingWithBoundingBox(class_2350 facing, class_2350 verticalOrientation) {
        Validate.notNull((Object)facing);
        this.field_7099 = facing;
        this.verticalOrientation = verticalOrientation;
        if (facing.method_10166().method_10179()) {
            this.method_36457(0.0f);
            this.method_36456(this.field_7099.method_10161() * 90);
        } else {
            this.method_36457(-90 * facing.method_10171().method_10181());
            this.method_36456(verticalOrientation.method_10166().method_10179() ? 180.0f + verticalOrientation.method_10144() : 0.0f);
        }
        this.field_6004 = this.method_36455();
        this.field_5982 = this.method_36454();
        this.method_6895();
    }

    protected float method_18378(class_4050 p_213316_1_, class_4048 p_213316_2_) {
        return 0.0f;
    }

    protected void method_6895() {
        if (this.field_7099 == null) {
            return;
        }
        if (this.verticalOrientation == null) {
            return;
        }
        class_243 pos = class_243.method_24954((class_2382)this.method_6896()).method_1031(0.5, 0.5, 0.5).method_1020(class_243.method_24954((class_2382)this.field_7099.method_10163()).method_1021(0.46875));
        double d1 = pos.field_1352;
        double d2 = pos.field_1351;
        double d3 = pos.field_1350;
        this.method_23327(d1, d2, d3);
        class_2350.class_2351 axis = this.field_7099.method_10166();
        if (this.size == 2) {
            pos = pos.method_1019(class_243.method_24954((class_2382)(axis.method_10179() ? this.field_7099.method_10160().method_10163() : this.verticalOrientation.method_10170().method_10163())).method_1021(0.5)).method_1019(class_243.method_24954((class_2382)(axis.method_10179() ? class_2350.field_11036.method_10163() : (this.field_7099 == class_2350.field_11036 ? this.verticalOrientation.method_10163() : this.verticalOrientation.method_10153().method_10163()))).method_1021(0.5));
        }
        d1 = pos.field_1352;
        d2 = pos.field_1351;
        d3 = pos.field_1350;
        double d4 = this.method_6897();
        double d5 = this.method_6891();
        double d6 = this.method_6897();
        class_2350.class_2351 direction$axis = this.field_7099.method_10166();
        switch (direction$axis) {
            case field_11048: {
                d4 = 1.0;
                break;
            }
            case field_11052: {
                d5 = 1.0;
                break;
            }
            case field_11051: {
                d6 = 1.0;
            }
        }
        this.method_5857(new class_238(d1 - (d4 /= 32.0), d2 - (d5 /= 32.0), d3 - (d6 /= 32.0), d1 + d4, d2 + d5, d3 + d6));
    }

    public boolean method_6888() {
        if (!this.field_6002.method_17892((class_1297)this)) {
            return false;
        }
        int i = Math.max(1, this.method_6897() / 16);
        int j = Math.max(1, this.method_6891() / 16);
        class_2338 blockpos = this.field_7100.method_10093(this.field_7099.method_10153());
        class_2350 upDirection = this.field_7099.method_10166().method_10179() ? class_2350.field_11036 : (this.field_7099 == class_2350.field_11036 ? this.verticalOrientation : this.verticalOrientation.method_10153());
        class_2350 newDirection = this.field_7099.method_10166().method_10178() ? this.verticalOrientation.method_10170() : this.field_7099.method_10160();
        class_2338.class_2339 blockpos$mutable = new class_2338.class_2339();
        for (int k = 0; k < i; ++k) {
            for (int l = 0; l < j; ++l) {
                int i1 = (i - 1) / -2;
                int j1 = (j - 1) / -2;
                blockpos$mutable.method_10101((class_2382)blockpos).method_10104(newDirection, k + i1).method_10104(upDirection, l + j1);
                class_2680 blockstate = this.field_6002.method_8320((class_2338)blockpos$mutable);
                if (class_2248.method_20044((class_4538)this.field_6002, (class_2338)blockpos$mutable, (class_2350)this.field_7099) || blockstate.method_26207().method_15799() || class_2312.method_9999((class_2680)blockstate)) continue;
                return false;
            }
        }
        return this.field_6002.method_8333((class_1297)this, this.method_5829(), field_7098).isEmpty();
    }

    public int method_6897() {
        return 16 * this.size;
    }

    public int method_6891() {
        return 16 * this.size;
    }

    public boolean method_5698(class_1297 source) {
        if (!(source instanceof class_1657) || this.field_6002.field_9236) {
            return super.method_5698(source);
        }
        class_1657 player = (class_1657)source;
        double attrib = ReachUtil.reach(player);
        class_243 eyePos = source.method_5836(1.0f);
        class_243 look = source.method_5828(1.0f);
        class_243 target = eyePos.method_1019(look.method_1021(attrib));
        Optional rayTrace = this.method_5829().method_992(eyePos, target);
        if (!rayTrace.isPresent()) {
            return super.method_5698(source);
        }
        class_243 hitVec = (class_243)rayTrace.get();
        BlueprintSection sectionAt = this.getSectionAt(hitVec.method_1020(this.method_19538()));
        ItemStackHandler items = sectionAt.getItems();
        if (items.getStackInSlot(9).method_7960()) {
            return super.method_5698(source);
        }
        for (int i = 0; i < items.getSlots(); ++i) {
            items.setStackInSlot(i, class_1799.field_8037);
        }
        sectionAt.save(items);
        return true;
    }

    public void method_6889(@Nullable class_1297 p_110128_1_) {
        if (!this.field_6002.method_8450().method_8355(class_1928.field_19393)) {
            return;
        }
        this.method_5783(class_3417.field_14809, 1.0f, 1.0f);
        if (p_110128_1_ instanceof class_1657) {
            class_1657 playerentity = (class_1657)p_110128_1_;
            if (playerentity.method_31549().field_7477) {
                return;
            }
        }
        this.method_5775(AllItems.CRAFTING_BLUEPRINT.asStack());
    }

    @Nullable
    public class_1799 method_31480() {
        return AllItems.CRAFTING_BLUEPRINT.asStack();
    }

    @Override
    public ItemRequirement getRequiredItems() {
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, (class_1792)AllItems.CRAFTING_BLUEPRINT.get());
    }

    public void method_6894() {
        this.method_5783(class_3417.field_14875, 1.0f, 1.0f);
    }

    public void method_5808(double p_70012_1_, double p_70012_3_, double p_70012_5_, float p_70012_7_, float p_70012_8_) {
        this.method_5814(p_70012_1_, p_70012_3_, p_70012_5_);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_5759(double p_180426_1_, double p_180426_3_, double p_180426_5_, float p_180426_7_, float p_180426_8_, int p_180426_9_, boolean p_180426_10_) {
        class_2338 blockpos = this.field_7100.method_10080(p_180426_1_ - this.method_23317(), p_180426_3_ - this.method_23318(), p_180426_5_ - this.method_23321());
        this.method_5814(blockpos.method_10263(), blockpos.method_10264(), blockpos.method_10260());
    }

    public void writeSpawnData(class_2540 buffer) {
        class_2487 compound = new class_2487();
        this.method_5652(compound);
        buffer.method_10794(compound);
        buffer.method_10794(this.getExtraCustomData());
    }

    public void readSpawnData(class_2540 additionalData) {
        this.method_5749(additionalData.method_10798());
        this.getExtraCustomData().method_10543(additionalData.method_10798());
    }

    public class_1269 method_5664(class_1657 player, class_243 vec, class_1268 hand) {
        if (player.isFake()) {
            return class_1269.field_5811;
        }
        boolean holdingWrench = AllItems.WRENCH.isIn(player.method_5998(hand));
        BlueprintSection section = this.getSectionAt(vec);
        ItemStackHandler items = section.getItems();
        if (!(holdingWrench || this.field_6002.field_9236 || items.getStackInSlot(9).method_7960())) {
            PlayerInventoryStorage playerInv = PlayerInventoryStorage.of((class_1657)player);
            boolean firstPass = true;
            int amountCrafted = 0;
            Optional recipe = Optional.empty();
            do {
                try (Transaction t = TransferUtil.getTransaction();){
                    HashMap<Integer, class_1799> craftingGrid = new HashMap<Integer, class_1799>();
                    boolean success = true;
                    for (int i = 0; i < 9; ++i) {
                        class_1799 requestedItem = items.getStackInSlot(i);
                        if (requestedItem.method_7960()) {
                            craftingGrid.put(i, class_1799.field_8037);
                            continue;
                        }
                        ResourceAmount resource = StorageUtil.findExtractableContent((Storage)playerInv, v -> FilterItem.test(this.field_6002, v.toStack(), requestedItem), (TransactionContext)t);
                        if (resource != null) {
                            playerInv.extract((Object)((ItemVariant)resource.resource()), 1L, (TransactionContext)t);
                            craftingGrid.put(i, ((ItemVariant)resource.resource()).toStack());
                            continue;
                        }
                        success = false;
                        break;
                    }
                    if (success) {
                        class_1799 result;
                        BlueprintCraftingInventory craftingInventory = new BlueprintCraftingInventory(craftingGrid);
                        if (!recipe.isPresent()) {
                            recipe = this.field_6002.method_8433().method_8132(class_3956.field_17545, (class_1263)craftingInventory, this.field_6002);
                        }
                        if ((result = recipe.filter(r -> r.method_8115((class_1263)craftingInventory, this.field_6002)).map(r -> r.method_8116((class_1263)craftingInventory)).orElse(class_1799.field_8037)).method_7960()) {
                            success = false;
                        } else if (result.method_7947() + amountCrafted > 64) {
                            success = false;
                        } else {
                            amountCrafted += result.method_7947();
                            result.method_7982(player.field_6002, player, 1);
                            class_2371 nonnulllist = this.field_6002.method_8433().method_8128(class_3956.field_17545, (class_1263)craftingInventory, this.field_6002);
                            if (firstPass) {
                                this.field_6002.method_8396(null, player.method_24515(), class_3417.field_15197, class_3419.field_15248, 0.2f, 1.0f + Create.RANDOM.nextFloat());
                            }
                            player.method_31548().method_7398(result);
                            for (class_1799 itemStack : nonnulllist) {
                                player.method_31548().method_7398(itemStack);
                            }
                            firstPass = false;
                        }
                    }
                    if (!success) {
                        t.abort();
                        break;
                    }
                    t.commit();
                }
            } while (player.method_5715());
            return class_1269.field_5812;
        }
        int i = section.index;
        if (!this.field_6002.field_9236 && player instanceof class_3222) {
            NetworkUtil.openGui((class_3222)((class_3222)player), (class_3908)section, buf -> {
                buf.method_10804(this.method_5628());
                buf.method_10804(i);
            });
        }
        return class_1269.field_5812;
    }

    public BlueprintSection getSectionAt(class_243 vec) {
        int index = 0;
        if (this.size > 1) {
            vec = VecHelper.rotate(vec, this.method_36454(), class_2350.class_2351.field_11052);
            vec = VecHelper.rotate(vec, -this.method_36455(), class_2350.class_2351.field_11048);
            vec = vec.method_1031(0.5, 0.5, 0.0);
            if (this.size == 3) {
                vec = vec.method_1031(1.0, 1.0, 0.0);
            }
            int x = class_3532.method_15340((int)class_3532.method_15357((double)vec.field_1352), (int)0, (int)(this.size - 1));
            int y = class_3532.method_15340((int)class_3532.method_15357((double)vec.field_1351), (int)0, (int)(this.size - 1));
            index = x + y * this.size;
        }
        BlueprintSection section = this.getSection(index);
        return section;
    }

    public class_2487 getOrCreateRecipeCompound() {
        class_2487 persistentData = this.getExtraCustomData();
        if (!persistentData.method_10545("Recipes")) {
            persistentData.method_10566("Recipes", (class_2520)new class_2487());
        }
        return persistentData.method_10562("Recipes");
    }

    public BlueprintSection getSection(int index) {
        return this.sectionCache.computeIfAbsent(index, i -> new BlueprintSection((int)i));
    }

    @Override
    public void onPersistentDataUpdated() {
        this.sectionCache.clear();
    }

    @Override
    public boolean canPlayerUse(class_1657 player) {
        class_238 box = this.method_5829();
        double dx = 0.0;
        if (box.field_1323 > player.method_23317()) {
            dx = box.field_1323 - player.method_23317();
        } else if (player.method_23317() > box.field_1320) {
            dx = player.method_23317() - box.field_1320;
        }
        double dy = 0.0;
        if (box.field_1322 > player.method_23318()) {
            dy = box.field_1322 - player.method_23318();
        } else if (player.method_23318() > box.field_1325) {
            dy = player.method_23318() - box.field_1325;
        }
        double dz = 0.0;
        if (box.field_1321 > player.method_23321()) {
            dz = box.field_1321 - player.method_23321();
        } else if (player.method_23321() > box.field_1324) {
            dz = player.method_23321() - box.field_1324;
        }
        return dx * dx + dy * dy + dz * dz <= 64.0;
    }

    class BlueprintSection
    implements class_3908,
    IInteractionChecker {
        int index;
        Couple<class_1799> cachedDisplayItems;
        public boolean inferredIcon = false;

        public BlueprintSection(int index) {
            this.index = index;
        }

        public Couple<class_1799> getDisplayItems() {
            if (this.cachedDisplayItems != null) {
                return this.cachedDisplayItems;
            }
            ItemStackHandler items = this.getItems();
            this.cachedDisplayItems = Couple.create(items.getStackInSlot(9), items.getStackInSlot(10));
            return this.cachedDisplayItems;
        }

        public ItemStackHandler getItems() {
            ItemStackHandler newInv = new ItemStackHandler(11);
            class_2487 list = BlueprintEntity.this.getOrCreateRecipeCompound();
            class_2487 invNBT = list.method_10562("" + this.index);
            this.inferredIcon = list.method_10577("InferredIcon");
            if (!invNBT.method_33133()) {
                newInv.deserializeNBT(invNBT);
            }
            return newInv;
        }

        public void save(ItemStackHandler inventory) {
            class_2487 list = BlueprintEntity.this.getOrCreateRecipeCompound();
            list.method_10566("" + this.index, (class_2520)inventory.serializeNBT());
            list.method_10556("InferredIcon", this.inferredIcon);
            this.cachedDisplayItems = null;
            if (!BlueprintEntity.this.field_6002.field_9236) {
                BlueprintEntity.this.syncPersistentDataWithTracking((class_1297)BlueprintEntity.this);
            }
        }

        public boolean isEntityAlive() {
            return BlueprintEntity.this.method_5805();
        }

        public class_1937 getBlueprintWorld() {
            return BlueprintEntity.this.field_6002;
        }

        public class_1703 createMenu(int id, class_1661 inv, class_1657 player) {
            return BlueprintContainer.create(id, inv, this);
        }

        public class_2561 method_5476() {
            return ((BlueprintItem)((Object)AllItems.CRAFTING_BLUEPRINT.get())).method_7848();
        }

        @Override
        public boolean canPlayerUse(class_1657 player) {
            return BlueprintEntity.this.canPlayerUse(player);
        }
    }

    static class BlueprintCraftingInventory
    extends class_1715 {
        private static final class_1703 dummyContainer = new class_1703(null, -1){

            public boolean method_7597(class_1657 playerIn) {
                return false;
            }

            public class_1799 method_7601(class_1657 p_38941_, int p_38942_) {
                return class_1799.field_8037;
            }
        };

        public BlueprintCraftingInventory(Map<Integer, class_1799> items) {
            super(dummyContainer, 3, 3);
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 3; ++x) {
                    class_1799 stack = items.get(y * 3 + x);
                    this.method_5447(y * 3 + x, stack == null ? class_1799.field_8037 : stack.method_7972());
                }
            }
        }
    }
}

