/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.bell;

import com.simibubi.create.content.contraptions.components.actors.BellMovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.curiosities.bell.HauntedBellPulser;
import net.minecraft.class_2338;

public class HauntedBellMovementBehaviour
extends BellMovementBehaviour {
    public static final int DISTANCE = 3;

    @Override
    public void tick(MovementContext context) {
        int recharge = this.getRecharge(context);
        if (recharge > 0) {
            this.setRecharge(context, recharge - 1);
        }
    }

    @Override
    public void visitNewPosition(MovementContext context, class_2338 pos) {
        if (!context.world.field_9236 && this.getRecharge(context) == 0) {
            HauntedBellPulser.sendPulse(context.world, pos, 3, false);
            this.setRecharge(context, 65);
            HauntedBellMovementBehaviour.playSound(context);
        }
    }

    @Override
    public void writeExtraData(MovementContext context) {
        context.tileData.method_10569("Recharge", this.getRecharge(context));
    }

    private int getRecharge(MovementContext context) {
        if (!(context.temporaryData instanceof Integer) && context.world != null) {
            context.temporaryData = context.tileData.method_10550("Recharge");
        }
        return (Integer)context.temporaryData;
    }

    private void setRecharge(MovementContext context, int value) {
        context.temporaryData = value;
    }
}

