/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.processing;

import com.simibubi.create.content.contraptions.processing.BasinTileEntity;
import com.simibubi.create.foundation.item.SmartInventory;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;

public class BasinInventory
extends SmartInventory {
    private BasinTileEntity te;

    public BasinInventory(int slots, BasinTileEntity te) {
        super(slots, te, 16, true);
        this.te = te;
        this.whenContentsChanged(te::notifyChangeOfContents);
    }

    @Override
    public SmartInventory whenContentsChanged(Runnable updateCallback) {
        return super.whenContentsChanged(() -> {
            updateCallback.run();
            this.te.notifyChangeOfContents();
        });
    }

    @Override
    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative((TransferVariant)resource, (long)maxAmount);
        if (!this.insertionAllowed) {
            return 0L;
        }
        try (Transaction test = transaction.openNested();){
            long contained = this.extract(resource, Long.MAX_VALUE, (TransactionContext)test);
            if (contained != 0L) {
                long maxStackSize = Math.min(this.stackSize, resource.getItem().method_7882());
                long space = Math.max(0L, maxStackSize - contained);
                if (space <= 0L) {
                    long l = 0L;
                    return l;
                }
                maxAmount = Math.min(space, maxAmount);
            }
        }
        return super.insert(resource, maxAmount, transaction);
    }

    @Override
    protected void onFinalCommit() {
        super.onFinalCommit();
        this.te.notifyChangeOfContents();
    }
}

