/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.train;

import com.simibubi.create.AllItems;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.train.capability.CapabilityMinecartController;
import com.simibubi.create.content.contraptions.components.structureMovement.train.capability.MinecartController;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import io.github.fabricators_of_create.porting_lib.util.LazyOptional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1688;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2561;

public class CouplingHandler {
    public static class_1269 preventEntitiesFromMoutingOccupiedCart(class_1297 e, class_1297 mounting, boolean isMounting) {
        if (e instanceof class_1688) {
            class_1688 cart = (class_1688)e;
            LazyOptional optional = cart.lazyController();
            if (!optional.isPresent()) {
                return class_1269.field_5811;
            }
            if (mounting instanceof AbstractContraptionEntity) {
                return class_1269.field_5811;
            }
            MinecartController controller = (MinecartController)optional.orElse(null);
            if (controller.isCoupledThroughContraption()) {
                return class_1269.field_5814;
            }
        }
        return class_1269.field_5811;
    }

    public static void forEachLoadedCoupling(class_1937 world, Consumer<Couple<MinecartController>> consumer) {
        if (world == null) {
            return;
        }
        Set<UUID> cartsWithCoupling = CapabilityMinecartController.loadedMinecartsWithCoupling.get((class_1936)world);
        if (cartsWithCoupling == null) {
            return;
        }
        cartsWithCoupling.forEach(id -> {
            MinecartController controller = CapabilityMinecartController.getIfPresent(world, id);
            if (controller == null) {
                return;
            }
            if (!controller.isLeadingCoupling()) {
                return;
            }
            UUID coupledCart = controller.getCoupledCart(true);
            MinecartController coupledController = CapabilityMinecartController.getIfPresent(world, coupledCart);
            if (coupledController == null) {
                return;
            }
            consumer.accept(Couple.create(controller, coupledController));
        });
    }

    public static boolean tryToCoupleCarts(@Nullable class_1657 player, class_1937 world, int cartId1, int cartId2) {
        boolean contraptionCoupling;
        class_1297 entity1 = world.method_8469(cartId1);
        class_1297 entity2 = world.method_8469(cartId2);
        if (!(entity1 instanceof class_1688)) {
            return false;
        }
        if (!(entity2 instanceof class_1688)) {
            return false;
        }
        String tooMany = "two_couplings_max";
        String unloaded = "unloaded";
        String noLoops = "no_loops";
        String tooFar = "too_far";
        int distanceTo = (int)entity1.method_19538().method_1022(entity2.method_19538());
        boolean bl = contraptionCoupling = player == null;
        if (distanceTo < 2) {
            if (contraptionCoupling) {
                return false;
            }
            distanceTo = 2;
        }
        if (distanceTo > (Integer)AllConfigs.SERVER.kinetics.maxCartCouplingLength.get()) {
            CouplingHandler.status(player, tooFar);
            return false;
        }
        class_1688 cart1 = (class_1688)entity1;
        class_1688 cart2 = (class_1688)entity2;
        UUID mainID = cart1.method_5667();
        UUID connectedID = cart2.method_5667();
        MinecartController mainController = CapabilityMinecartController.getIfPresent(world, mainID);
        MinecartController connectedController = CapabilityMinecartController.getIfPresent(world, connectedID);
        if (mainController == null || connectedController == null) {
            CouplingHandler.status(player, unloaded);
            return false;
        }
        if (mainController.isFullyCoupled() || connectedController.isFullyCoupled()) {
            CouplingHandler.status(player, tooMany);
            return false;
        }
        if (mainController.isLeadingCoupling() && mainController.getCoupledCart(true).equals(connectedID) || connectedController.isLeadingCoupling() && connectedController.getCoupledCart(true).equals(mainID)) {
            return false;
        }
        for (boolean main : Iterate.trueAndFalse) {
            MinecartController current = main ? mainController : connectedController;
            boolean forward = current.isLeadingCoupling();
            int safetyCount = 1000;
            do {
                if (safetyCount-- <= 0) {
                    Create.LOGGER.warn("Infinite loop in coupling iteration");
                    return false;
                }
                if ((current = CouplingHandler.getNextInCouplingChain(world, current, forward)) == null) {
                    CouplingHandler.status(player, unloaded);
                    return false;
                }
                if (current != connectedController) continue;
                CouplingHandler.status(player, noLoops);
                return false;
            } while (current != MinecartController.EMPTY);
        }
        if (!contraptionCoupling) {
            for (class_1268 hand : class_1268.values()) {
                if (player.method_7337()) break;
                class_1799 heldItem = player.method_5998(hand);
                if (!AllItems.MINECART_COUPLING.isIn(heldItem)) continue;
                heldItem.method_7934(1);
                break;
            }
        }
        mainController.prepareForCoupling(true);
        connectedController.prepareForCoupling(false);
        mainController.coupleWith(true, connectedID, distanceTo, contraptionCoupling);
        connectedController.coupleWith(false, mainID, distanceTo, contraptionCoupling);
        return true;
    }

    @Nullable
    public static MinecartController getNextInCouplingChain(class_1937 world, MinecartController controller, boolean forward) {
        UUID coupledCart = controller.getCoupledCart(forward);
        if (coupledCart == null) {
            return MinecartController.empty();
        }
        return CapabilityMinecartController.getIfPresent(world, coupledCart);
    }

    public static void status(class_1657 player, String key) {
        if (player == null) {
            return;
        }
        player.method_7353((class_2561)Lang.translateDirect("minecart_coupling." + key, new Object[0]), true);
    }
}

