/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.pulley;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.components.structureMovement.AssemblyException;
import com.simibubi.create.content.contraptions.components.structureMovement.BlockMovementChecks;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionCollider;
import com.simibubi.create.content.contraptions.components.structureMovement.ControlledContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.piston.LinearActuatorTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.pulley.PulleyBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.pulley.PulleyContraption;
import com.simibubi.create.content.logistics.block.redstone.StockpileSwitchObservable;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3737;

public class PulleyTileEntity
extends LinearActuatorTileEntity
implements StockpileSwitchObservable {
    protected int initialOffset;
    private float prevAnimatedOffset;

    public PulleyTileEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        return super.createRenderBoundingBox().method_1012(0.0, (double)(-this.offset), 0.0);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.registerAwardables(behaviours, AllAdvancements.PULLEY_MAXED);
    }

    @Override
    public void tick() {
        float prevOffset = this.offset;
        super.tick();
        if (this.isVirtual()) {
            this.prevAnimatedOffset = this.offset;
        }
        this.invalidateRenderBoundingBox();
        if (prevOffset < 200.0f && this.offset >= 200.0f) {
            this.award(AllAdvancements.PULLEY_MAXED);
        }
    }

    @Override
    protected void assemble() throws AssemblyException {
        class_2338 ropePos;
        class_2680 ropeState;
        int i;
        if (!(this.field_11863.method_8320(this.field_11867).method_26204() instanceof PulleyBlock)) {
            return;
        }
        if (this.speed == 0.0f) {
            return;
        }
        int maxLength = (Integer)AllConfigs.SERVER.kinetics.maxRopeLength.get();
        for (i = 1; i <= maxLength && (AllBlocks.ROPE.has(ropeState = this.field_11863.method_8320(ropePos = this.field_11867.method_10087(i))) || AllBlocks.PULLEY_MAGNET.has(ropeState)); ++i) {
        }
        this.offset = i - 1;
        if (this.offset >= (float)this.getExtensionRange() && this.getSpeed() > 0.0f) {
            return;
        }
        if (this.offset <= 0.0f && this.getSpeed() < 0.0f) {
            return;
        }
        if (!this.field_11863.field_9236) {
            this.needsContraption = false;
            class_2338 anchor = this.field_11867.method_10087(class_3532.method_15375((float)(this.offset + 1.0f)));
            this.initialOffset = class_3532.method_15375((float)this.offset);
            PulleyContraption contraption = new PulleyContraption(this.initialOffset);
            boolean canAssembleStructure = contraption.assemble(this.field_11863, anchor);
            if (canAssembleStructure) {
                class_2350 movementDirection;
                class_2350 class_23502 = movementDirection = this.getSpeed() > 0.0f ? class_2350.field_11033 : class_2350.field_11036;
                if (ContraptionCollider.isCollidingWithWorld(this.field_11863, contraption, anchor.method_10093(movementDirection), movementDirection)) {
                    canAssembleStructure = false;
                }
            }
            if (!canAssembleStructure && this.getSpeed() > 0.0f) {
                return;
            }
            for (i = (int)this.offset; i > 0; --i) {
                class_2338 offset = this.field_11867.method_10087(i);
                class_2680 oldState = this.field_11863.method_8320(offset);
                if (oldState.method_26204() instanceof class_3737 && oldState.method_28498((class_2769)class_2741.field_12508) && ((Boolean)oldState.method_11654((class_2769)class_2741.field_12508)).booleanValue()) {
                    this.field_11863.method_8652(offset, class_2246.field_10382.method_9564(), 66);
                    continue;
                }
                this.field_11863.method_8652(offset, class_2246.field_10124.method_9564(), 66);
            }
            if (!contraption.getBlocks().isEmpty()) {
                contraption.removeBlocksFromWorld(this.field_11863, class_2338.field_10980);
                this.movedContraption = ControlledContraptionEntity.create(this.field_11863, this, contraption);
                this.movedContraption.method_5814(anchor.method_10263(), anchor.method_10264(), anchor.method_10260());
                this.field_11863.method_8649((class_1297)this.movedContraption);
                this.forceMove = true;
                this.needsContraption = true;
                if (contraption.containsBlockBreakers()) {
                    this.award(AllAdvancements.CONTRAPTION_ACTORS);
                }
            }
        }
        this.clientOffsetDiff = 0.0f;
        this.running = true;
        this.sendData();
    }

    @Override
    public void disassemble() {
        if (!this.running && this.movedContraption == null) {
            return;
        }
        this.offset = this.getGridOffset(this.offset);
        if (this.movedContraption != null) {
            this.resetContraptionToOffset();
        }
        if (!this.field_11863.field_9236) {
            if (!this.field_11865) {
                int i;
                if (this.offset > 0.0f) {
                    class_2338 magnetPos = this.field_11867.method_10087((int)this.offset);
                    class_3610 ifluidstate = this.field_11863.method_8316(magnetPos);
                    this.field_11863.method_22352(magnetPos, this.field_11863.method_8320(magnetPos).method_26220((class_1922)this.field_11863, magnetPos).method_1110());
                    this.field_11863.method_8652(magnetPos, (class_2680)AllBlocks.PULLEY_MAGNET.getDefaultState().method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(ifluidstate.method_15772() == class_3612.field_15910)), 66);
                }
                boolean[] waterlog = new boolean[(int)this.offset];
                for (i = 1; i <= (int)this.offset - 1; ++i) {
                    class_2338 ropePos = this.field_11867.method_10087(i);
                    class_3610 ifluidstate = this.field_11863.method_8316(ropePos);
                    waterlog[i] = ifluidstate.method_15772() == class_3612.field_15910;
                    this.field_11863.method_22352(ropePos, this.field_11863.method_8320(ropePos).method_26220((class_1922)this.field_11863, ropePos).method_1110());
                }
                for (i = 1; i <= (int)this.offset - 1; ++i) {
                    this.field_11863.method_8652(this.field_11867.method_10087(i), (class_2680)AllBlocks.ROPE.getDefaultState().method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(waterlog[i])), 66);
                }
            }
            if (this.movedContraption != null) {
                this.movedContraption.disassemble();
            }
        }
        if (this.movedContraption != null) {
            this.movedContraption.method_31472();
        }
        this.movedContraption = null;
        this.initialOffset = 0;
        this.running = false;
        this.sendData();
    }

    @Override
    protected class_243 toPosition(float offset) {
        if (this.movedContraption.getContraption() instanceof PulleyContraption) {
            PulleyContraption contraption = (PulleyContraption)this.movedContraption.getContraption();
            return class_243.method_24954((class_2382)contraption.anchor).method_1031(0.0, (double)((float)contraption.initialOffset - offset), 0.0);
        }
        return class_243.field_1353;
    }

    @Override
    protected void visitNewPosition() {
        super.visitNewPosition();
        if (this.field_11863.field_9236) {
            return;
        }
        if (this.movedContraption != null) {
            return;
        }
        if (this.getSpeed() <= 0.0f) {
            return;
        }
        class_2338 posBelow = this.field_11867.method_10087((int)(this.offset + this.getMovementSpeed()) + 1);
        class_2680 state = this.field_11863.method_8320(posBelow);
        if (!BlockMovementChecks.isMovementNecessary(state, this.field_11863, posBelow)) {
            return;
        }
        if (BlockMovementChecks.isBrittle(state)) {
            return;
        }
        this.disassemble();
        this.assembleNextTick = true;
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        this.initialOffset = compound.method_10550("InitialOffset");
        this.needsContraption = compound.method_10577("NeedsContraption");
        super.read(compound, clientPacket);
    }

    @Override
    public void write(class_2487 compound, boolean clientPacket) {
        compound.method_10569("InitialOffset", this.initialOffset);
        super.write(compound, clientPacket);
    }

    @Override
    protected int getExtensionRange() {
        return Math.max(0, Math.min((Integer)AllConfigs.SERVER.kinetics.maxRopeLength.get(), this.field_11867.method_10264() - 1 - this.field_11863.method_31607()));
    }

    @Override
    protected int getInitialOffset() {
        return this.initialOffset;
    }

    @Override
    protected class_243 toMotionVector(float speed) {
        return new class_243(0.0, (double)(-speed), 0.0);
    }

    @Override
    protected ValueBoxTransform getMovementModeSlot() {
        return new CenteredSideValueBoxTransform((state, d) -> d == class_2350.field_11036);
    }

    @Override
    public float getInterpolatedOffset(float partialTicks) {
        if (this.isVirtual()) {
            return class_3532.method_16439((float)partialTicks, (float)this.prevAnimatedOffset, (float)this.offset);
        }
        boolean moving = this.running && (this.movedContraption == null || !this.movedContraption.isStalled());
        return super.getInterpolatedOffset(moving ? partialTicks : 0.5f);
    }

    public void animateOffset(float forcedOffset) {
        this.offset = forcedOffset;
    }

    @Override
    public float getPercent() {
        int distance = this.field_11867.method_10264() - this.field_11863.method_31607();
        if (distance <= 0) {
            return 100.0f;
        }
        return 100.0f * this.getInterpolatedOffset(0.5f) / (float)distance;
    }
}

