/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.gantry;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.content.contraptions.components.structureMovement.gantry.GantryCarriageBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.gantry.GantryCarriageRenderer;
import com.simibubi.create.content.contraptions.relays.encased.ShaftInstance;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2769;
import net.minecraft.class_3532;

public class GantryCarriageInstance
extends ShaftInstance
implements DynamicInstance {
    private final ModelData gantryCogs;
    final class_2350 facing;
    final Boolean alongFirst;
    final class_2350.class_2351 rotationAxis;
    final float rotationMult;
    final class_2338 visualPos;
    private float lastAngle = Float.NaN;

    public GantryCarriageInstance(MaterialManager dispatcher, KineticTileEntity tile) {
        super(dispatcher, tile);
        this.gantryCogs = (ModelData)this.getTransformMaterial().getModel(AllBlockPartials.GANTRY_COGS, this.blockState).createInstance();
        this.facing = (class_2350)this.blockState.method_11654((class_2769)GantryCarriageBlock.FACING);
        this.alongFirst = (Boolean)this.blockState.method_11654((class_2769)GantryCarriageBlock.AXIS_ALONG_FIRST_COORDINATE);
        this.rotationAxis = KineticTileEntityRenderer.getRotationAxisOf(tile);
        this.rotationMult = GantryCarriageInstance.getRotationMultiplier(this.getGantryAxis(), this.facing);
        this.visualPos = this.facing.method_10171() == class_2350.class_2352.field_11056 ? tile.method_11016() : tile.method_11016().method_10093(this.facing.method_10153());
        this.animateCogs(this.getCogAngle());
    }

    public void beginFrame() {
        float cogAngle = this.getCogAngle();
        if (class_3532.method_15347((float)cogAngle, (float)this.lastAngle)) {
            return;
        }
        this.animateCogs(cogAngle);
    }

    private float getCogAngle() {
        return GantryCarriageRenderer.getAngleForTe((KineticTileEntity)this.blockEntity, this.visualPos, this.rotationAxis) * this.rotationMult;
    }

    private void animateCogs(float cogAngle) {
        ((ModelData)((ModelData)((ModelData)((ModelData)((ModelData)((ModelData)this.gantryCogs.loadIdentity().translate((class_2382)this.getInstancePosition())).centre()).rotateY((double)AngleHelper.horizontalAngle(this.facing))).rotateX(this.facing == class_2350.field_11036 ? 0.0 : (this.facing == class_2350.field_11033 ? 180.0 : 90.0))).rotateY(this.alongFirst ^ this.facing.method_10166() == class_2350.class_2351.field_11048 ? 0.0 : 90.0)).translate(0.0, -0.5625, 0.0).rotateX((double)(-cogAngle))).translate(0.0, 0.5625, 0.0).unCentre();
    }

    static float getRotationMultiplier(class_2350.class_2351 gantryAxis, class_2350 facing) {
        float multiplier = 1.0f;
        if (gantryAxis == class_2350.class_2351.field_11048 && facing == class_2350.field_11036) {
            multiplier *= -1.0f;
        }
        if (gantryAxis == class_2350.class_2351.field_11052 && (facing == class_2350.field_11043 || facing == class_2350.field_11034)) {
            multiplier *= -1.0f;
        }
        return multiplier;
    }

    private class_2350.class_2351 getGantryAxis() {
        class_2350.class_2351 gantryAxis = class_2350.class_2351.field_11048;
        for (class_2350.class_2351 axis : Iterate.axes) {
            if (axis == this.rotationAxis || axis == this.facing.method_10166()) continue;
            gantryAxis = axis;
        }
        return gantryAxis;
    }

    @Override
    public void updateLight() {
        this.relight(this.pos, new FlatLit[]{this.gantryCogs, this.rotatingModel});
    }

    @Override
    public void remove() {
        super.remove();
        this.gantryCogs.delete();
    }
}

