/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement;

import com.simibubi.create.content.contraptions.components.structureMovement.ITransformableBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.ITransformableTE;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2341;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2482;
import net.minecraft.class_2510;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2760;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_3709;
import net.minecraft.class_3867;

public class StructureTransform {
    public class_2350.class_2351 rotationAxis;
    public class_2338 offset;
    public int angle;
    public class_2470 rotation;
    public class_2415 mirror;

    private StructureTransform(class_2338 offset, int angle, class_2350.class_2351 axis, class_2470 rotation, class_2415 mirror) {
        this.offset = offset;
        this.angle = angle;
        this.rotationAxis = axis;
        this.rotation = rotation;
        this.mirror = mirror;
    }

    public StructureTransform(class_2338 offset, class_2350.class_2351 axis, class_2470 rotation, class_2415 mirror) {
        this(offset, rotation == class_2470.field_11467 ? 0 : (4 - rotation.ordinal()) * 90, axis, rotation, mirror);
    }

    public StructureTransform(class_2338 offset, float xRotation, float yRotation, float zRotation) {
        this.offset = offset;
        if (xRotation != 0.0f) {
            this.rotationAxis = class_2350.class_2351.field_11048;
            this.angle = Math.round(xRotation / 90.0f) * 90;
        }
        if (yRotation != 0.0f) {
            this.rotationAxis = class_2350.class_2351.field_11052;
            this.angle = Math.round(yRotation / 90.0f) * 90;
        }
        if (zRotation != 0.0f) {
            this.rotationAxis = class_2350.class_2351.field_11051;
            this.angle = Math.round(zRotation / 90.0f) * 90;
        }
        this.angle %= 360;
        if (this.angle < -90) {
            this.angle += 360;
        }
        this.rotation = class_2470.field_11467;
        if (this.angle == -90 || this.angle == 270) {
            this.rotation = class_2470.field_11463;
        }
        if (this.angle == 90) {
            this.rotation = class_2470.field_11465;
        }
        if (this.angle == 180) {
            this.rotation = class_2470.field_11464;
        }
        this.mirror = class_2415.field_11302;
    }

    public class_243 applyWithoutOffsetUncentered(class_243 localVec) {
        class_243 vec = localVec;
        if (this.mirror != null) {
            vec = VecHelper.mirror(vec, this.mirror);
        }
        if (this.rotationAxis != null) {
            vec = VecHelper.rotate(vec, this.angle, this.rotationAxis);
        }
        return vec;
    }

    public class_243 applyWithoutOffset(class_243 localVec) {
        class_243 vec = localVec;
        if (this.mirror != null) {
            vec = VecHelper.mirrorCentered(vec, this.mirror);
        }
        if (this.rotationAxis != null) {
            vec = VecHelper.rotateCentered(vec, this.angle, this.rotationAxis);
        }
        return vec;
    }

    public class_243 apply(class_243 localVec) {
        return this.applyWithoutOffset(localVec).method_1019(class_243.method_24954((class_2382)this.offset));
    }

    public class_2338 applyWithoutOffset(class_2338 localPos) {
        return new class_2338(this.applyWithoutOffset(VecHelper.getCenterOf((class_2382)localPos)));
    }

    public class_2338 apply(class_2338 localPos) {
        return this.applyWithoutOffset(localPos).method_10081((class_2382)this.offset);
    }

    public void apply(class_2586 te) {
        if (te instanceof ITransformableTE) {
            ((ITransformableTE)te).transform(this);
        }
    }

    public class_2680 apply(class_2680 state) {
        boolean halfTurn;
        class_2248 block = state.method_26204();
        if (block instanceof ITransformableBlock) {
            ITransformableBlock transformable = (ITransformableBlock)block;
            return transformable.transform(state, this);
        }
        if (this.mirror != null) {
            state = state.method_26185(this.mirror);
        }
        if (this.rotationAxis == class_2350.class_2351.field_11052) {
            if (block instanceof class_3709) {
                if (state.method_11654((class_2769)class_2741.field_17104) == class_3867.field_17101) {
                    state = (class_2680)state.method_11657((class_2769)class_2741.field_17104, (Comparable)class_3867.field_17100);
                }
                return (class_2680)state.method_11657((class_2769)class_3709.field_16324, (Comparable)this.rotation.method_10503((class_2350)state.method_11654((class_2769)class_3709.field_16324)));
            }
            return state.method_26186(this.rotation);
        }
        if (block instanceof class_2341) {
            class_2350 forcedAxis;
            class_2753 facingProperty = class_2341.field_11177;
            class_2754 faceProperty = class_2341.field_11007;
            class_2350 stateFacing = (class_2350)state.method_11654((class_2769)facingProperty);
            class_2738 stateFace = (class_2738)state.method_11654((class_2769)faceProperty);
            boolean z = this.rotationAxis == class_2350.class_2351.field_11051;
            class_2350 class_23502 = forcedAxis = z ? class_2350.field_11039 : class_2350.field_11035;
            if (stateFacing.method_10166() == this.rotationAxis && stateFace == class_2738.field_12471) {
                return state;
            }
            for (int i = 0; i < this.rotation.ordinal(); ++i) {
                stateFace = (class_2738)state.method_11654((class_2769)faceProperty);
                stateFacing = (class_2350)state.method_11654((class_2769)facingProperty);
                boolean b = state.method_11654((class_2769)faceProperty) == class_2738.field_12473;
                state = (class_2680)state.method_11657((class_2769)facingProperty, (Comparable)(b ? forcedAxis : forcedAxis.method_10153()));
                state = stateFace != class_2738.field_12471 ? (class_2680)state.method_11657((class_2769)faceProperty, (Comparable)class_2738.field_12471) : (stateFacing.method_10171() == (z ? class_2350.class_2352.field_11060 : class_2350.class_2352.field_11056) ? (class_2680)state.method_11657((class_2769)faceProperty, (Comparable)class_2738.field_12475) : (class_2680)state.method_11657((class_2769)faceProperty, (Comparable)class_2738.field_12473));
            }
            return state;
        }
        boolean bl = halfTurn = this.rotation == class_2470.field_11464;
        if (block instanceof class_2510) {
            state = this.transformStairs(state, halfTurn);
            return state;
        }
        if (state.method_28498((class_2769)class_2741.field_12525)) {
            state = (class_2680)state.method_11657((class_2769)class_2741.field_12525, (Comparable)this.rotateFacing((class_2350)state.method_11654((class_2769)class_2741.field_12525)));
        } else if (state.method_28498((class_2769)class_2741.field_12496)) {
            state = (class_2680)state.method_11657((class_2769)class_2741.field_12496, (Comparable)this.rotateAxis((class_2350.class_2351)state.method_11654((class_2769)class_2741.field_12496)));
        } else if (halfTurn) {
            class_2350 stateFacing;
            if (state.method_28498((class_2769)class_2741.field_12481) && (stateFacing = (class_2350)state.method_11654((class_2769)class_2741.field_12481)).method_10166() == this.rotationAxis) {
                return state;
            }
            if ((state = state.method_26186(this.rotation)).method_28498((class_2769)class_2482.field_11501) && state.method_11654((class_2769)class_2482.field_11501) != class_2771.field_12682) {
                state = (class_2680)state.method_11657((class_2769)class_2482.field_11501, (Comparable)(state.method_11654((class_2769)class_2482.field_11501) == class_2771.field_12681 ? class_2771.field_12679 : class_2771.field_12681));
            }
        }
        return state;
    }

    protected class_2680 transformStairs(class_2680 state, boolean halfTurn) {
        if (((class_2350)state.method_11654((class_2769)class_2510.field_11571)).method_10166() != this.rotationAxis) {
            for (int i = 0; i < this.rotation.ordinal(); ++i) {
                class_2350 direction = (class_2350)state.method_11654((class_2769)class_2510.field_11571);
                class_2760 half = (class_2760)state.method_11654((class_2769)class_2510.field_11572);
                state = direction.method_10171() == class_2350.class_2352.field_11056 ^ half == class_2760.field_12617 ^ direction.method_10166() == class_2350.class_2351.field_11051 ? (class_2680)state.method_28493((class_2769)class_2510.field_11572) : (class_2680)state.method_11657((class_2769)class_2510.field_11571, (Comparable)direction.method_10153());
            }
        } else if (halfTurn) {
            state = (class_2680)state.method_28493((class_2769)class_2510.field_11572);
        }
        return state;
    }

    public class_2350 mirrorFacing(class_2350 facing) {
        if (this.mirror != null) {
            return this.mirror.method_10343(facing);
        }
        return facing;
    }

    public class_2350.class_2351 rotateAxis(class_2350.class_2351 axis) {
        class_2350 facing = class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)axis);
        return this.rotateFacing(facing).method_10166();
    }

    public class_2350 rotateFacing(class_2350 facing) {
        for (int i = 0; i < this.rotation.ordinal(); ++i) {
            facing = facing.method_35833(this.rotationAxis);
        }
        return facing;
    }

    public static StructureTransform fromBuffer(class_2540 buffer) {
        class_2338 readBlockPos = buffer.method_10811();
        int readAngle = buffer.readInt();
        int axisIndex = buffer.method_10816();
        int rotationIndex = buffer.method_10816();
        int mirrorIndex = buffer.method_10816();
        return new StructureTransform(readBlockPos, readAngle, axisIndex == -1 ? null : class_2350.class_2351.values()[axisIndex], rotationIndex == -1 ? null : class_2470.values()[rotationIndex], mirrorIndex == -1 ? null : class_2415.values()[mirrorIndex]);
    }

    public void writeToBuffer(class_2540 buffer) {
        buffer.method_10807(this.offset);
        buffer.writeInt(this.angle);
        buffer.method_10804(this.rotationAxis == null ? -1 : this.rotationAxis.ordinal());
        buffer.method_10804(this.rotation == null ? -1 : this.rotation.ordinal());
        buffer.method_10804(this.mirror == null ? -1 : this.mirror.ordinal());
    }
}

