/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.crafter;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.base.HorizontalKineticBlock;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.components.crafter.ConnectedInputHandler;
import com.simibubi.create.content.contraptions.components.crafter.CrafterHelper;
import com.simibubi.create.content.contraptions.components.crafter.MechanicalCrafterTileEntity;
import com.simibubi.create.content.contraptions.relays.elementary.ICogWheel;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.inventory.InvManipulationBehaviour;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Pointing;
import com.simibubi.create.foundation.utility.VecHelper;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemHandlerHelper;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3965;
import net.minecraft.class_4970;

public class MechanicalCrafterBlock
extends HorizontalKineticBlock
implements ITE<MechanicalCrafterTileEntity>,
ICogWheel {
    public static final class_2754<Pointing> POINTING = class_2754.method_11850((String)"pointing", Pointing.class);

    public MechanicalCrafterBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)this.method_9564().method_11657(POINTING, (Comparable)((Object)Pointing.UP)));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515((class_2689.class_2690<class_2248, class_2680>)builder.method_11667(new class_2769[]{POINTING}));
    }

    @Override
    public class_2350.class_2351 getRotationAxis(class_2680 state) {
        return ((class_2350)state.method_11654(HORIZONTAL_FACING)).method_10166();
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        class_2350 face = context.method_8038();
        class_2338 placedOnPos = context.method_8037().method_10093(face.method_10153());
        class_2680 blockState = context.method_8045().method_8320(placedOnPos);
        if (blockState.method_26204() != this || context.method_8036() != null && context.method_8036().method_5715()) {
            class_2680 stateForPlacement = super.method_9605(context);
            class_2350 direction = (class_2350)stateForPlacement.method_11654(HORIZONTAL_FACING);
            if (direction != face) {
                stateForPlacement = (class_2680)stateForPlacement.method_11657(POINTING, (Comparable)((Object)MechanicalCrafterBlock.pointingFromFacing(face, direction)));
            }
            return stateForPlacement;
        }
        class_2350 otherFacing = (class_2350)blockState.method_11654(HORIZONTAL_FACING);
        Pointing pointing = MechanicalCrafterBlock.pointingFromFacing(face, otherFacing);
        return (class_2680)((class_2680)this.method_9564().method_11657(HORIZONTAL_FACING, (Comparable)otherFacing)).method_11657(POINTING, (Comparable)((Object)pointing));
    }

    @Override
    public void method_9536(class_2680 state, class_1937 worldIn, class_2338 pos, class_2680 newState, boolean isMoving) {
        MechanicalCrafterTileEntity crafter;
        if (state.method_26204() == newState.method_26204() && MechanicalCrafterBlock.getTargetDirection(state) != MechanicalCrafterBlock.getTargetDirection(newState) && (crafter = CrafterHelper.getCrafter((class_1920)worldIn, pos)) != null) {
            crafter.blockChanged();
        }
        if (state.method_31709() && !state.method_27852(newState.method_26204())) {
            crafter = CrafterHelper.getCrafter((class_1920)worldIn, pos);
            if (crafter != null) {
                if (crafter.covered) {
                    class_2248.method_9577((class_1937)worldIn, (class_2338)pos, (class_1799)AllItems.CRAFTER_SLOT_COVER.asStack());
                }
                if (!isMoving) {
                    crafter.ejectWholeGrid();
                }
            }
            for (class_2350 direction : Iterate.directions) {
                if (direction.method_10166() == ((class_2350)state.method_11654(HORIZONTAL_FACING)).method_10166()) continue;
                class_2338 otherPos = pos.method_10093(direction);
                ConnectedInputHandler.ConnectedInput thisInput = CrafterHelper.getInput((class_1920)worldIn, pos);
                ConnectedInputHandler.ConnectedInput otherInput = CrafterHelper.getInput((class_1920)worldIn, otherPos);
                if (thisInput == null || otherInput == null || !pos.method_10081((class_2382)thisInput.data.get(0)).equals((Object)otherPos.method_10081((class_2382)otherInput.data.get(0)))) continue;
                ConnectedInputHandler.toggleConnection(worldIn, pos, otherPos);
            }
        }
        super.method_9536(state, worldIn, pos, newState, isMoving);
    }

    public static Pointing pointingFromFacing(class_2350 pointingFace, class_2350 blockFacing) {
        Pointing pointing;
        boolean positive = blockFacing.method_10171() == class_2350.class_2352.field_11056;
        Pointing pointing2 = pointing = pointingFace == class_2350.field_11033 ? Pointing.UP : Pointing.DOWN;
        if (pointingFace == class_2350.field_11034) {
            Pointing pointing3 = pointing = positive ? Pointing.LEFT : Pointing.RIGHT;
        }
        if (pointingFace == class_2350.field_11039) {
            Pointing pointing4 = pointing = positive ? Pointing.RIGHT : Pointing.LEFT;
        }
        if (pointingFace == class_2350.field_11043) {
            Pointing pointing5 = pointing = positive ? Pointing.LEFT : Pointing.RIGHT;
        }
        if (pointingFace == class_2350.field_11035) {
            pointing = positive ? Pointing.RIGHT : Pointing.LEFT;
        }
        return pointing;
    }

    @Override
    public class_1269 onWrenched(class_2680 state, class_1838 context) {
        if (context.method_8038() == state.method_11654(HORIZONTAL_FACING)) {
            if (!context.method_8045().field_9236) {
                KineticTileEntity.switchToBlockState(context.method_8045(), context.method_8037(), (class_2680)state.method_28493(POINTING));
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public class_1269 method_9534(class_2680 state, class_1937 worldIn, class_2338 pos, class_1657 player, class_1268 handIn, class_3965 hit) {
        class_2586 te = worldIn.method_8321(pos);
        if (!(te instanceof MechanicalCrafterTileEntity)) {
            return class_1269.field_5811;
        }
        MechanicalCrafterTileEntity crafter = (MechanicalCrafterTileEntity)te;
        class_1799 heldItem = player.method_5998(handIn);
        if (AllBlocks.MECHANICAL_ARM.isIn(heldItem)) {
            return class_1269.field_5811;
        }
        boolean isHand = heldItem.method_7960() && handIn == class_1268.field_5808;
        boolean wrenched = AllItems.WRENCH.isIn(heldItem);
        if (hit.method_17780() == state.method_11654(HORIZONTAL_FACING)) {
            if (crafter.phase != MechanicalCrafterTileEntity.Phase.IDLE && !wrenched) {
                crafter.ejectWholeGrid();
                return class_1269.field_5812;
            }
            if (crafter.phase == MechanicalCrafterTileEntity.Phase.IDLE && !isHand && !wrenched) {
                if (worldIn.field_9236) {
                    return class_1269.field_5812;
                }
                if (AllItems.CRAFTER_SLOT_COVER.isIn(heldItem)) {
                    if (crafter.covered) {
                        return class_1269.field_5811;
                    }
                    if (!crafter.inventory.method_5442()) {
                        return class_1269.field_5811;
                    }
                    crafter.covered = true;
                    crafter.method_5431();
                    crafter.sendData();
                    if (!player.method_7337()) {
                        heldItem.method_7934(1);
                    }
                    return class_1269.field_5812;
                }
                if (heldItem.method_7960()) {
                    return class_1269.field_5811;
                }
                Storage<ItemVariant> capability = crafter.getItemStorage(null);
                if (capability == null) {
                    return class_1269.field_5811;
                }
                try (Transaction t = TransferUtil.getTransaction();){
                    long inserted = capability.insert((Object)ItemVariant.of((class_1799)heldItem), (long)heldItem.method_7947(), (TransactionContext)t);
                    if (inserted <= 0L) {
                        class_1269 class_12692 = class_1269.field_5811;
                        return class_12692;
                    }
                    player.method_6122(handIn, ItemHandlerHelper.copyStackWithSize((class_1799)heldItem, (int)((int)((long)heldItem.method_7947() - inserted))));
                    t.commit();
                    class_1269 class_12693 = class_1269.field_5812;
                    return class_12693;
                }
            }
            class_1799 inSlot = crafter.getInventory().method_5438(0);
            if (inSlot.method_7960()) {
                if (crafter.covered && !wrenched) {
                    if (worldIn.field_9236) {
                        return class_1269.field_5812;
                    }
                    crafter.covered = false;
                    crafter.method_5431();
                    crafter.sendData();
                    if (!player.method_7337()) {
                        player.method_31548().method_7398(AllItems.CRAFTER_SLOT_COVER.asStack());
                    }
                    return class_1269.field_5812;
                }
                return class_1269.field_5811;
            }
            if (!isHand && !ItemHandlerHelper.canItemStacksStack((class_1799)heldItem, (class_1799)inSlot)) {
                return class_1269.field_5811;
            }
            if (worldIn.field_9236) {
                return class_1269.field_5812;
            }
            player.method_31548().method_7398(inSlot);
            crafter.getInventory().setStackInSlot(0, class_1799.field_8037);
            crafter.sendData();
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public void method_9612(class_2680 state, class_1937 worldIn, class_2338 pos, class_2248 blockIn, class_2338 fromPos, boolean isMoving) {
        InvManipulationBehaviour behaviour = TileEntityBehaviour.get((class_1922)worldIn, pos, InvManipulationBehaviour.TYPE);
        if (behaviour != null) {
            behaviour.onNeighborChanged(fromPos);
        }
    }

    @Override
    public float getParticleTargetRadius() {
        return 0.85f;
    }

    @Override
    public float getParticleInitialRadius() {
        return 0.75f;
    }

    public static class_2350 getTargetDirection(class_2680 state) {
        if (!AllBlocks.MECHANICAL_CRAFTER.has(state)) {
            return class_2350.field_11036;
        }
        class_2350 facing = (class_2350)state.method_11654(HORIZONTAL_FACING);
        Pointing point = (Pointing)((Object)state.method_11654(POINTING));
        class_243 targetVec = new class_243(0.0, 1.0, 0.0);
        targetVec = VecHelper.rotate(targetVec, -point.getXRotation(), class_2350.class_2351.field_11051);
        targetVec = VecHelper.rotate(targetVec, AngleHelper.horizontalAngle(facing), class_2350.class_2351.field_11052);
        return class_2350.method_10142((double)targetVec.field_1352, (double)targetVec.field_1351, (double)targetVec.field_1350);
    }

    public static boolean isValidTarget(class_1937 world, class_2338 targetPos, class_2680 crafterState) {
        class_2680 targetState = world.method_8320(targetPos);
        if (!world.method_8477(targetPos)) {
            return false;
        }
        if (!AllBlocks.MECHANICAL_CRAFTER.has(targetState)) {
            return false;
        }
        if (crafterState.method_11654(HORIZONTAL_FACING) != targetState.method_11654(HORIZONTAL_FACING)) {
            return false;
        }
        return Math.abs(((Pointing)((Object)crafterState.method_11654(POINTING))).getXRotation() - ((Pointing)((Object)targetState.method_11654(POINTING))).getXRotation()) != 180;
    }

    @Override
    public Class<MechanicalCrafterTileEntity> getTileEntityClass() {
        return MechanicalCrafterTileEntity.class;
    }

    @Override
    public class_2591<? extends MechanicalCrafterTileEntity> getTileEntityType() {
        return (class_2591)AllTileEntities.MECHANICAL_CRAFTER.get();
    }
}

