/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.actors;

import com.simibubi.create.content.contraptions.components.actors.PortableStorageInterfaceTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.foundation.utility.fabric.ListeningStorageView;
import com.simibubi.create.foundation.utility.fabric.ProcessingIterator;
import io.github.fabricators_of_create.porting_lib.transfer.WrappedStorage;
import io.github.fabricators_of_create.porting_lib.transfer.callbacks.TransactionCallback;
import java.util.Iterator;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SidedStorageBlockEntity;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class PortableFluidInterfaceTileEntity
extends PortableStorageInterfaceTileEntity
implements SidedStorageBlockEntity {
    protected InterfaceFluidHandler capability = this.createEmptyHandler();

    public PortableFluidInterfaceTileEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void startTransferringTo(Contraption contraption, float distance) {
        this.capability.setWrapped((Storage<FluidVariant>)contraption.getSharedFluidTanks());
        super.startTransferringTo(contraption, distance);
    }

    @Override
    protected void invalidateCapability() {
        this.capability.setWrapped((Storage<FluidVariant>)Storage.empty());
    }

    @Override
    protected void stopTransferring() {
        this.capability.setWrapped((Storage<FluidVariant>)Storage.empty());
        super.stopTransferring();
    }

    private InterfaceFluidHandler createEmptyHandler() {
        return new InterfaceFluidHandler((Storage<FluidVariant>)Storage.empty());
    }

    public Storage<FluidVariant> getFluidStorage(@Nullable class_2350 face) {
        return this.capability;
    }

    public class InterfaceFluidHandler
    extends WrappedStorage<FluidVariant> {
        public InterfaceFluidHandler(Storage<FluidVariant> wrapped) {
            super(wrapped);
        }

        public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
            if (!PortableFluidInterfaceTileEntity.this.isConnected()) {
                return 0L;
            }
            long fill = this.wrapped.insert((Object)resource, maxAmount, transaction);
            if (fill > 0L) {
                TransactionCallback.onSuccess((TransactionContext)transaction, this::keepAlive);
            }
            return fill;
        }

        public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
            if (!PortableFluidInterfaceTileEntity.this.canTransfer()) {
                return 0L;
            }
            long drain = this.wrapped.extract((Object)resource, maxAmount, transaction);
            if (drain != 0L) {
                TransactionCallback.onSuccess((TransactionContext)transaction, this::keepAlive);
            }
            return drain;
        }

        @Nullable
        public StorageView<FluidVariant> exactView(FluidVariant resource) {
            return this.listen(super.exactView((Object)resource));
        }

        public Iterator<StorageView<FluidVariant>> iterator() {
            return new ProcessingIterator<StorageView<FluidVariant>>(super.iterator(), this::listen);
        }

        public <T> StorageView<T> listen(StorageView<T> view) {
            return new ListeningStorageView<T>(view, this::keepAlive);
        }

        public void keepAlive() {
            PortableFluidInterfaceTileEntity.this.onContentTransferred();
        }

        private void setWrapped(Storage<FluidVariant> wrapped) {
            this.wrapped = wrapped;
        }
    }
}

