/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.rei.category;

import com.simibubi.create.compat.rei.category.CreateRecipeCategory;
import com.simibubi.create.compat.rei.category.sequencedAssembly.ReiSequencedAssemblySubCategory;
import com.simibubi.create.compat.rei.display.CreateDisplay;
import com.simibubi.create.content.contraptions.itemAssembly.SequencedAssemblyRecipe;
import com.simibubi.create.content.contraptions.itemAssembly.SequencedRecipe;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.utility.Lang;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.util.ClientEntryStacks;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.Nullable;

public class SequencedAssemblyCategory
extends CreateRecipeCategory<SequencedAssemblyRecipe> {
    Map<class_2960, ReiSequencedAssemblySubCategory> subCategories = new HashMap<class_2960, ReiSequencedAssemblySubCategory>();
    final String[] romans = new String[]{"I", "II", "III", "IV", "V", "VI", "-"};

    public SequencedAssemblyCategory(CreateRecipeCategory.Info<SequencedAssemblyRecipe> info) {
        super(info);
    }

    @Override
    public void addWidgets(final CreateDisplay<SequencedAssemblyRecipe> display, final List<Widget> ingredients, final Point origin, final Rectangle bounds) {
        int xOffset = display.getRecipe().getOutputChance() == 1.0f ? 0 : -7;
        ingredients.add((Widget)SequencedAssemblyCategory.basicSlot(origin.x + 27 + xOffset, origin.y + 91).markInput().entries((Collection)EntryIngredients.ofItemStacks(Arrays.asList(display.getRecipe().getIngredient().method_8105()))));
        Slot output = SequencedAssemblyCategory.basicSlot(origin.x + 132 + xOffset, origin.y + 91).markOutput().entries((Collection)EntryIngredients.of((class_1799)display.getRecipe().method_8110()));
        ClientEntryStacks.setTooltipProcessor((EntryStack)output.getCurrentEntry(), (entryStack, tooltip) -> {
            float chance = ((SequencedAssemblyRecipe)display.getRecipe()).getOutputChance();
            if (chance != 1.0f) {
                tooltip.add((class_2561)Lang.translateDirect("recipe.processing.chance", (double)chance < 0.01 ? "<1" : Integer.valueOf((int)(chance * 100.0f))).method_27692(class_124.field_1065));
            }
            return tooltip;
        });
        ingredients.add((Widget)output);
        int width = 0;
        int margin = 3;
        for (SequencedRecipe<?> sequencedRecipe : display.getRecipe().getSequence()) {
            width += this.getSubCategory(sequencedRecipe).getWidth() + margin;
        }
        int x = (width -= margin) / -2 + this.getDisplayWidth(null) / 2;
        int index = 2;
        int fluidIndex = 0;
        for (SequencedRecipe<?> sequencedRecipe : display.getRecipe().getSequence()) {
            ReiSequencedAssemblySubCategory subCategory = this.getSubCategory(sequencedRecipe);
            index += subCategory.addItemIngredients(sequencedRecipe, ingredients, x, index, origin);
            fluidIndex += subCategory.addFluidIngredients(sequencedRecipe, ingredients, x, fluidIndex, origin);
            x += subCategory.getWidth() + margin;
        }
        ingredients.add((Widget)new WidgetWithBounds(){

            public Rectangle getBounds() {
                return bounds;
            }

            public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
                Point mouse = new Point(mouseX, mouseY);
                if (this.containsMouse(mouse)) {
                    for (Slot slot : Widgets.walk((Iterable)ingredients, listener -> listener instanceof Slot)) {
                        if (!slot.containsMouse(mouse) || !slot.isHighlightEnabled() || slot.getCurrentTooltip(TooltipContext.of((Point)mouse)) == null) continue;
                        return;
                    }
                    Tooltip tooltip = this.getTooltip(mouse);
                    if (tooltip != null) {
                        tooltip.queue();
                    }
                }
            }

            public List<? extends class_364> method_25396() {
                return Collections.emptyList();
            }

            @Nullable
            public Tooltip getTooltip(Point mouse) {
                List<class_2561> strings = SequencedAssemblyCategory.this.getTooltipStrings((SequencedAssemblyRecipe)display.getRecipe(), mouse.x - origin.x, mouse.y - origin.y);
                if (strings.isEmpty()) {
                    return null;
                }
                return Tooltip.create((Point)mouse, strings);
            }
        });
    }

    private ReiSequencedAssemblySubCategory getSubCategory(SequencedRecipe<?> sequencedRecipe) {
        return this.subCategories.computeIfAbsent(class_2378.field_17598.method_10221(sequencedRecipe.getRecipe().method_8119()), rl -> sequencedRecipe.getAsAssemblyRecipe().getJEISubCategory().rei().get().get());
    }

    @Override
    public void draw(SequencedAssemblyRecipe recipe, class_4587 matrixStack, double mouseX, double mouseY) {
        class_327 font = class_310.method_1551().field_1772;
        matrixStack.method_22903();
        matrixStack.method_22903();
        matrixStack.method_22904(0.0, 15.0, 0.0);
        boolean singleOutput = recipe.getOutputChance() == 1.0f;
        int xOffset = singleOutput ? 0 : -7;
        AllGuiTextures.JEI_SLOT.render(matrixStack, 26 + xOffset, 75);
        (singleOutput ? AllGuiTextures.JEI_SLOT : AllGuiTextures.JEI_CHANCE_SLOT).render(matrixStack, 131 + xOffset, 75);
        AllGuiTextures.JEI_LONG_ARROW.render(matrixStack, 52 + xOffset, 79);
        if (!singleOutput) {
            AllGuiTextures.JEI_CHANCE_SLOT.render(matrixStack, 150 + xOffset, 75);
            class_5250 component = class_2561.method_43470((String)"?").method_27692(class_124.field_1067);
            font.method_30881(matrixStack, (class_2561)component, (float)(font.method_27525((class_5348)component) / -2 + 8 + 150 + xOffset), 80.0f, 0xEFEFEF);
        }
        if (recipe.getLoops() > 1) {
            matrixStack.method_22903();
            matrixStack.method_22904(15.0, 9.0, 0.0);
            AllIcons.I_SEQ_REPEAT.render(matrixStack, 50 + xOffset, 75);
            class_5250 repeat = class_2561.method_43470((String)("x" + recipe.getLoops()));
            font.method_30883(matrixStack, (class_2561)repeat, (float)(66 + xOffset), 80.0f, 0x888888);
            matrixStack.method_22909();
        }
        matrixStack.method_22909();
        int width = 0;
        int margin = 3;
        for (SequencedRecipe<?> sequencedRecipe : recipe.getSequence()) {
            width += this.getSubCategory(sequencedRecipe).getWidth() + margin;
        }
        matrixStack.method_22904((double)((width -= margin) / -2 + this.getDisplayWidth(null) / 2), 0.0, 0.0);
        matrixStack.method_22903();
        List<SequencedRecipe<?>> sequence = recipe.getSequence();
        for (int i = 0; i < sequence.size(); ++i) {
            SequencedRecipe<?> sequencedRecipe = sequence.get(i);
            ReiSequencedAssemblySubCategory subCategory = this.getSubCategory(sequencedRecipe);
            int subWidth = subCategory.getWidth();
            class_5250 component = class_2561.method_43470((String)this.romans[Math.min(i, 6)]);
            font.method_30883(matrixStack, (class_2561)component, (float)(font.method_27525((class_5348)component) / -2 + subWidth / 2), 2.0f, 0x888888);
            subCategory.draw(sequencedRecipe, matrixStack, mouseX, mouseY, i);
            matrixStack.method_22904((double)(subWidth + margin), 0.0, 0.0);
        }
        matrixStack.method_22909();
        matrixStack.method_22909();
    }

    public List<class_2561> getTooltipStrings(SequencedAssemblyRecipe recipe, double mouseX, double mouseY) {
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        class_5250 junk = Lang.translateDirect("recipe.assembly.junk", new Object[0]);
        boolean singleOutput = recipe.getOutputChance() == 1.0f;
        boolean willRepeat = recipe.getLoops() > 1;
        int xOffset = -7;
        int minX = 150 + xOffset;
        int maxX = minX + 18;
        int minY = 90;
        int maxY = minY + 18;
        if (!singleOutput && mouseX >= (double)minX && mouseX < (double)maxX && mouseY >= (double)minY && mouseY < (double)maxY) {
            float chance = recipe.getOutputChance();
            tooltip.add((class_2561)junk);
            tooltip.add((class_2561)Lang.translateDirect("recipe.processing.chance", (double)chance < 0.01 ? "<1" : Integer.valueOf(100 - (int)(chance * 100.0f))).method_27692(class_124.field_1065));
            return tooltip;
        }
        minX = 55 + xOffset;
        maxX = minX + 65;
        minY = 92;
        maxY = minY + 24;
        if (willRepeat && mouseX >= (double)minX && mouseX < (double)maxX && mouseY >= (double)minY && mouseY < (double)maxY) {
            tooltip.add((class_2561)Lang.translateDirect("recipe.assembly.repeat", recipe.getLoops()));
            return tooltip;
        }
        if (mouseY > 5.0 && mouseY < 84.0) {
            int width = 0;
            int margin = 3;
            for (SequencedRecipe<?> sequencedRecipe : recipe.getSequence()) {
                width += this.getSubCategory(sequencedRecipe).getWidth() + margin;
            }
            xOffset = (width -= margin) / 2 + this.getDisplayWidth(null) / -2;
            double relativeX = mouseX + (double)xOffset;
            List<SequencedRecipe<?>> sequence = recipe.getSequence();
            for (int i = 0; i < sequence.size(); ++i) {
                SequencedRecipe<?> sequencedRecipe = sequence.get(i);
                ReiSequencedAssemblySubCategory subCategory = this.getSubCategory(sequencedRecipe);
                if (relativeX >= 0.0 && relativeX < (double)subCategory.getWidth()) {
                    tooltip.add((class_2561)Lang.translateDirect("recipe.assembly.step", i + 1));
                    tooltip.add((class_2561)sequencedRecipe.getAsAssemblyRecipe().getDescriptionForAssembly().method_27662().method_27692(class_124.field_1077));
                    return tooltip;
                }
                relativeX -= (double)(subCategory.getWidth() + margin);
            }
        }
        return tooltip;
    }

    private List<FluidIngredient> getAllFluidIngredients(SequencedAssemblyRecipe recipe) {
        ArrayList<FluidIngredient> assemblyFluidIngredients = new ArrayList<FluidIngredient>();
        recipe.addAdditionalFluidIngredients(assemblyFluidIngredients);
        return assemblyFluidIngredients;
    }

    private List<class_1856> getAllItemIngredients(SequencedAssemblyRecipe recipe) {
        ArrayList<class_1856> assemblyIngredients = new ArrayList<class_1856>();
        assemblyIngredients.add(recipe.getIngredient());
        assemblyIngredients.add(class_1856.method_8101((class_1799[])new class_1799[]{recipe.getTransitionalItem()}));
        recipe.addAdditionalIngredientsAndMachines(assemblyIngredients);
        return assemblyIngredients;
    }
}

