/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tradingpost.world.level.block;

import fuzs.tradingpost.TradingPost;
import fuzs.tradingpost.config.ServerConfig;
import fuzs.tradingpost.init.ModRegistry;
import fuzs.tradingpost.mixin.accessor.VillagerAccessor;
import fuzs.tradingpost.world.entity.npc.MerchantCollection;
import fuzs.tradingpost.world.inventory.TradingPostMenu;
import fuzs.tradingpost.world.level.block.entity.TradingPostBlockEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1275;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1915;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3908;
import net.minecraft.class_3914;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_747;

public class TradingPostBlock
extends class_2237
implements class_3737 {
    public static final class_2561 CONTAINER_TITLE = class_2561.method_43471((String)"container.trading_post");
    public static final class_2561 NO_MERCHANT_FOUND = class_2561.method_43471((String)"trading_post.no_trader_found");
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    private static final class_265 LEG1 = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)8.0, (double)4.0);
    private static final class_265 LEG2 = class_2248.method_9541((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)4.0);
    private static final class_265 LEG3 = class_2248.method_9541((double)0.0, (double)0.0, (double)12.0, (double)4.0, (double)8.0, (double)16.0);
    private static final class_265 LEG4 = class_2248.method_9541((double)12.0, (double)0.0, (double)12.0, (double)16.0, (double)8.0, (double)16.0);
    private static final class_265 TOP = class_2248.method_9541((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final class_265 SHAPE = class_259.method_17786((class_265)TOP, (class_265[])new class_265[]{LEG1, LEG2, LEG3, LEG4});

    public TradingPostBlock(class_4970.class_2251 blockProperties) {
        super(blockProperties);
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public boolean method_9526(class_2680 state) {
        return true;
    }

    public class_265 method_9530(class_2680 state, class_1922 blockReader, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 oldState, class_1936 level, class_2338 newPos, class_2338 oldPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            level.method_39281(newPos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)level));
        }
        return super.method_9559(state, direction, oldState, level, newPos, oldPos);
    }

    public class_2680 method_9605(class_1750 context) {
        class_3610 fluidstate = context.method_8045().method_8316(context.method_8037());
        return (class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.method_15772() == class_3612.field_15910));
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    @Nullable
    public class_2586 method_10123(class_2338 pPos, class_2680 pState) {
        return new TradingPostBlockEntity(pPos, pState);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 pLevel, class_2680 pState, class_2591<T> pBlockEntityType) {
        return pLevel.field_9236 ? TradingPostBlock.method_31618(pBlockEntityType, (class_2591)((class_2591)ModRegistry.TRADING_POST_BLOCK_ENTITY_TYPE.get()), TradingPostBlockEntity::tickEmeraldAnimation) : null;
    }

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 rayTraceResult) {
        int verticalRange;
        int horizontalRange;
        if (level.field_9236) {
            return class_1269.field_5812;
        }
        class_243 blockCenterPos = class_243.method_24953((class_2382)pos);
        List nearbyTraders = level.method_8390(class_1297.class, new class_238(blockCenterPos.method_1031((double)(-(horizontalRange = ((ServerConfig)TradingPost.CONFIG.get(ServerConfig.class)).horizontalRange)), (double)(-(verticalRange = ((ServerConfig)TradingPost.CONFIG.get(ServerConfig.class)).verticalRange)), (double)(-horizontalRange)), blockCenterPos.method_1031((double)horizontalRange, (double)verticalRange, (double)horizontalRange)), this::canTrade);
        if (!nearbyTraders.isEmpty()) {
            class_3914 access = class_3914.method_17392((class_1937)level, (class_2338)pos);
            MerchantCollection merchants = new MerchantCollection(access);
            for (class_1297 merchant : nearbyTraders) {
                if (merchant instanceof class_1646) {
                    ((VillagerAccessor)merchant).callUpdateSpecialPrices(player);
                }
                merchants.addMerchant(merchant.method_5628(), (class_1915)merchant);
            }
            merchants.method_8259(player);
            merchants.buildOffers(merchants.getIdToOfferCountMap());
            class_2561 title = this.getContainerTitle(level, pos);
            this.openTradingScreen(player, merchants, title, access);
        } else {
            player.method_7353(NO_MERCHANT_FOUND, false);
        }
        return class_1269.field_21466;
    }

    private boolean canTrade(class_1297 entity) {
        if (((ServerConfig)TradingPost.CONFIG.get(ServerConfig.class)).traderBlacklist.contains(entity.method_5864()) || entity.method_5864().method_20210(ModRegistry.BLACKLISTED_TRADERS_TAG)) {
            return false;
        }
        if (!entity.method_5805() || !(entity instanceof class_1915) || ((class_1915)entity).method_8257() != null || ((class_1915)entity).method_8264().isEmpty()) {
            return false;
        }
        return !(entity instanceof class_1309) || !((class_1309)entity).method_6113() && !((class_1309)entity).method_6109();
    }

    private class_2561 getContainerTitle(class_1937 level, class_2338 pos) {
        class_2586 tileentity = level.method_8321(pos);
        return tileentity instanceof TradingPostBlockEntity ? ((class_1275)tileentity).method_5476() : CONTAINER_TITLE;
    }

    private void openTradingScreen(class_1657 player, MerchantCollection merchants, class_2561 title, class_3914 worldPosCallable) {
        player.method_17355((class_3908)new class_747((containerMenuId, playerInventory, playerEntity) -> new TradingPostMenu(containerMenuId, playerInventory, merchants, worldPosCallable), title)).ifPresent(containerId -> merchants.sendMerchantData(containerId, player));
    }

    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, class_1309 entity, class_1799 stack) {
        class_2586 tileentity;
        if (stack.method_7938() && (tileentity = level.method_8321(pos)) instanceof TradingPostBlockEntity) {
            ((TradingPostBlockEntity)tileentity).setCustomName(stack.method_7964());
        }
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{WATERLOGGED});
    }

    public boolean method_9516(class_2680 state, class_1922 blockReader, class_2338 pos, class_10 pathType) {
        return false;
    }
}

