/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tradingpost.client.gui.screens.inventory;

import com.mojang.blaze3d.systems.RenderSystem;
import fuzs.puzzleslib.client.core.ClientCoreServices;
import fuzs.puzzleslib.network.Message;
import fuzs.tradingpost.TradingPost;
import fuzs.tradingpost.client.TradingPostClient;
import fuzs.tradingpost.mixin.client.accessor.ButtonAccessor;
import fuzs.tradingpost.mixin.client.accessor.MerchantScreenAccessor;
import fuzs.tradingpost.mixin.client.accessor.TradeOfferButtonAccessor;
import fuzs.tradingpost.network.client.C2SClearSlotsMessage;
import fuzs.tradingpost.world.inventory.TradingPostMenu;
import fuzs.tradingpost.world.item.trading.TradingPostOffers;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.class_1058;
import net.minecraft.class_1129;
import net.minecraft.class_1661;
import net.minecraft.class_1723;
import net.minecraft.class_1728;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1914;
import net.minecraft.class_1916;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2863;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_492;
import net.minecraft.class_5348;
import net.minecraft.class_757;

public class TradingPostScreen
extends class_492 {
    public static final class_2960 MAGNIFYING_GLASS_LOCATION = new class_2960("tradingpost", "item/magnifying_glass");
    private static final class_2960 VILLAGER_LOCATION = new class_2960("textures/gui/container/villager2.png");
    private static final class_2960 CREATIVE_INVENTORY_LOCATION = new class_2960("textures/gui/container/creative_inventory/tab_item_search.png");
    private static final class_2561 DEPRECATED_TOOLTIP = class_2561.method_43471((String)"merchant.deprecated");
    private static final class_2561 MERCHANT_GONE = class_2561.method_43471((String)"trading_post.trader_gone");
    private class_4185[] tradeOfferButtons = new class_4185[7];
    private class_342 searchBox;
    private boolean ignoreTextInput;

    public TradingPostScreen(class_1728 container, class_1661 playerInventory, class_2561 title) {
        super(container, playerInventory, title);
    }

    protected void method_25426() {
        super.method_25426();
        for (class_4185 tradeOfferButton : this.tradeOfferButtons = this.getTradeOfferButtons(ClientCoreServices.SCREENS.getRenderableButtons((class_437)this))) {
            ((ButtonAccessor)tradeOfferButton).setOnPress(button -> {
                MerchantScreenAccessor accessor = (MerchantScreenAccessor)((Object)this);
                int shopItem = ((TradeOfferButtonAccessor)button).getIndex() + accessor.getScrollOff();
                class_1916 offers = this.getMenu().method_17438();
                accessor.setShopItem(shopItem);
                this.getMenu().method_7650(shopItem);
                this.getMenu().getTraders().setActiveOffer((class_1914)offers.get(shopItem));
                this.getMenu().method_20215(shopItem);
                this.field_22787.method_1562().method_2883((class_2596)new class_2863(offers instanceof TradingPostOffers ? ((TradingPostOffers)offers).getOrigShopItem(shopItem) : shopItem));
            });
        }
        this.searchBox = new class_342(this.field_22793, this.field_2776 + 13, this.field_2800 + 6, 80, 9, (class_2561)class_2561.method_43471((String)"itemGroup.search")){

            public boolean method_25402(double mouseX, double mouseY, int button) {
                if (this.method_1885() && button == 1) {
                    this.method_1852("");
                    TradingPostScreen.this.refreshSearchResults();
                }
                return super.method_25402(mouseX, mouseY, button);
            }
        };
        this.searchBox.method_1880(50);
        this.searchBox.method_1858(false);
        this.searchBox.method_1868(0xFFFFFF);
        this.method_25429((class_364)this.searchBox);
    }

    private class_4185[] getTradeOfferButtons(List<class_4068> buttons) {
        class_4185[] tradeOfferButtons = (class_4185[])buttons.stream().filter(button -> button instanceof TradeOfferButtonAccessor).map(button -> (class_4185)button).toArray(class_4185[]::new);
        if (tradeOfferButtons.length != 7) {
            TradingPost.LOGGER.warn("Unable to find enough tradeOfferButtons");
        }
        return tradeOfferButtons;
    }

    public void method_25410(class_310 mc, int newWidth, int newHeight) {
        String lastSearch = this.searchBox.method_1882();
        super.method_25410(mc, newWidth, newHeight);
        this.searchBox.method_1852(lastSearch);
        if (!this.searchBox.method_1882().isEmpty()) {
            this.refreshSearchResults();
        }
    }

    protected void method_2388(class_4587 matrixStack, int mouseX, int mouseY) {
        class_2561 title = this.getMenu().getTraders().getDisplayName();
        if (title != null) {
            int traderLevel = ((class_1728)this.field_2797).method_19258();
            if (traderLevel > 0 && traderLevel <= 5 && ((class_1728)this.field_2797).method_19259()) {
                title = title.method_27661().method_27693(" - ").method_10852((class_2561)class_2561.method_43471((String)("merchant.level." + traderLevel)));
            }
        } else {
            title = this.field_22785;
        }
        this.field_22793.method_30883(matrixStack, title, (float)(49 + this.field_2792 / 2 - this.field_22793.method_27525((class_5348)title) / 2), 6.0f, 0x404040);
        this.field_22793.method_30883(matrixStack, this.field_29347, (float)this.field_25269, (float)this.field_25270, 0x404040);
    }

    public void method_25394(class_4587 matrixStack, int mouseX, int mouseY, float partialTime) {
        class_1916 merchantoffers = this.getMenu().method_17438();
        this.setButtonsActive(merchantoffers);
        int scrollOff = ((MerchantScreenAccessor)((Object)this)).getScrollOff();
        class_1735 hoveredSlot = this.field_2787;
        this.lock(true, merchantoffers.size(), null);
        super.method_25394(matrixStack, mouseX, mouseY, partialTime);
        this.lock(false, scrollOff, hoveredSlot);
        if (!merchantoffers.isEmpty()) {
            class_1914 merchantoffer;
            int shopItem = ((MerchantScreenAccessor)((Object)this)).getShopItem();
            if (shopItem >= 0 && shopItem < merchantoffers.size() && (merchantoffer = (class_1914)merchantoffers.get(shopItem)).method_8255()) {
                RenderSystem.setShader(class_757::method_34542);
                RenderSystem.setShaderTexture((int)0, (class_2960)VILLAGER_LOCATION);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                TradingPostScreen.method_25291((class_4587)matrixStack, (int)(this.field_2776 + 83 + 99), (int)(this.field_2800 + 35), (int)this.method_25305(), (float)311.0f, (float)0.0f, (int)28, (int)21, (int)512, (int)256);
            }
            int width = (this.field_22789 - this.field_2792) / 2;
            int height = (this.field_22790 - this.field_2779) / 2;
            int posX = width + 5;
            int posY = height + 16 + 2;
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderTexture((int)0, (class_2960)VILLAGER_LOCATION);
            ((MerchantScreenAccessor)((Object)this)).callRenderScroller(matrixStack, width, height, merchantoffers);
            int merchantoffersSize = merchantoffers.size();
            for (int i = 0; i < merchantoffersSize; ++i) {
                if (merchantoffers.size() > 7 && (i < scrollOff || i >= 7 + scrollOff)) continue;
                class_1914 merchantoffer2 = (class_1914)merchantoffers.get(i);
                ((MerchantScreenAccessor)((Object)this)).callRenderButtonArrows(matrixStack, merchantoffer2, width, posY + 1);
                if (!this.getMenu().getTraders().checkOffer(merchantoffer2)) {
                    class_332.method_25294((class_4587)matrixStack, (int)posX, (int)posY, (int)(posX + 88), (int)(posY + 20), (int)0x30FF0000);
                }
                class_1799 itemstack = merchantoffer2.method_8246();
                class_1799 itemstack1 = merchantoffer2.method_19272();
                class_1799 itemstack2 = merchantoffer2.method_8247();
                class_1799 itemstack3 = merchantoffer2.method_8250();
                this.field_22788.field_4730 = 100.0f;
                this.field_22788.method_27953(itemstack1, posX + 5, posY + 1);
                if (!itemstack2.method_7960()) {
                    this.field_22788.method_27953(itemstack2, posX + 35, posY + 1);
                }
                this.field_22788.method_27953(itemstack3, posX + 68, posY + 1);
                if (!this.getMenu().getTraders().checkOffer(merchantoffer2)) {
                    RenderSystem.depthFunc((int)516);
                    class_332.method_25294((class_4587)matrixStack, (int)posX, (int)posY, (int)(posX + 88), (int)(posY + 20), (int)0x30FFFFFF);
                    RenderSystem.depthFunc((int)515);
                }
                if (itemstack.method_7947() == itemstack1.method_7947()) {
                    this.field_22788.method_4025(this.field_22793, itemstack1, posX + 5, posY + 1);
                } else {
                    this.field_22788.method_4022(this.field_22793, itemstack, posX + 5, posY + 1, itemstack.method_7947() == 1 ? "1" : null);
                    this.field_22788.method_4022(this.field_22793, itemstack1, posX + 5 + 14, posY + 1, itemstack1.method_7947() == 1 ? "1" : null);
                    RenderSystem.setShader(class_757::method_34542);
                    RenderSystem.setShaderTexture((int)0, (class_2960)VILLAGER_LOCATION);
                    this.method_25304(this.method_25305() + 300);
                    TradingPostScreen.method_25291((class_4587)matrixStack, (int)(posX + 5 + 7), (int)(posY + 1 + 12), (int)this.method_25305(), (float)0.0f, (float)176.0f, (int)9, (int)2, (int)512, (int)256);
                    this.method_25304(this.method_25305() - 300);
                }
                if (!itemstack2.method_7960()) {
                    this.field_22788.method_4025(this.field_22793, itemstack2, posX + 35, posY + 1);
                }
                this.field_22788.method_4025(this.field_22793, itemstack3, posX + 68, posY + 1);
                this.field_22788.field_4730 = 0.0f;
                posY += 20;
            }
            class_1914 activeOffer = (class_1914)merchantoffers.get(shopItem);
            if (this.getMenu().method_19259()) {
                ((MerchantScreenAccessor)((Object)this)).callRenderProgressBar(matrixStack, width, height, activeOffer);
            }
            if (activeOffer.method_8255() && this.method_2378(186, 35, 22, 21, mouseX, mouseY) && this.getMenu().method_20701()) {
                this.method_25424(matrixStack, DEPRECATED_TOOLTIP, mouseX, mouseY);
            }
            posY = height + 16 + 2;
            int merchantoffersSize2 = merchantoffers.size();
            for (int i = 0; i < merchantoffersSize2; ++i) {
                if (merchantoffers.size() > 7 && (i < scrollOff || i >= 7 + scrollOff)) continue;
                class_1914 merchantoffer3 = (class_1914)merchantoffers.get(i);
                if (!this.getMenu().getTraders().checkOffer(merchantoffer3) && this.method_2378(posX, posY, 88, 19, mouseX + this.field_2776, mouseY + this.field_2800)) {
                    this.method_25424(matrixStack, MERCHANT_GONE, mouseX, mouseY);
                }
                posY += 20;
            }
            RenderSystem.enableDepthTest();
        }
        class_4185[] offerButtons = this.tradeOfferButtons;
        int offerButtonsLength = offerButtons.length;
        for (int i = 0; i < offerButtonsLength; ++i) {
            class_4185 button = offerButtons[i];
            if (button.field_22763 && button.method_25367()) {
                button.method_25352(matrixStack, mouseX, mouseY);
            }
            button.field_22764 = i < this.getMenu().method_17438().size();
        }
        this.method_2380(matrixStack, mouseX, mouseY);
    }

    private void setButtonsActive(class_1916 merchantoffers) {
        if (!merchantoffers.isEmpty()) {
            int merchantoffersSize = merchantoffers.size();
            for (int i = 0; i < merchantoffersSize; ++i) {
                int scrollOff = ((MerchantScreenAccessor)((Object)this)).getScrollOff();
                if (merchantoffers.size() > 7 && (i < scrollOff || i >= 7 + scrollOff)) continue;
                class_1914 offer = (class_1914)merchantoffers.get(i);
                this.tradeOfferButtons[i - scrollOff].field_22763 = this.getMenu().getTraders().checkOffer(offer);
            }
        }
    }

    private void lock(boolean lockOffers, int newScrollOff, class_1735 newHoveredSlot) {
        this.getMenu().lockOffers(lockOffers);
        ((MerchantScreenAccessor)((Object)this)).setScrollOff(newScrollOff);
        this.field_2787 = newHoveredSlot;
    }

    protected void method_2389(class_4587 matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.method_2389(matrixStack, partialTicks, mouseX, mouseY);
        this.renderSearchBox(matrixStack, partialTicks, mouseX, mouseY);
        class_1058 textureatlassprite = (class_1058)this.field_22787.method_1549(class_1723.field_21668).apply(MAGNIFYING_GLASS_LOCATION);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)textureatlassprite.method_24119().method_24106());
        TradingPostScreen.method_25298((class_4587)matrixStack, (int)this.field_2776, (int)(this.field_2800 + 4), (int)this.method_25305(), (int)16, (int)16, (class_1058)textureatlassprite);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)VILLAGER_LOCATION);
    }

    private void renderSearchBox(class_4587 matrixStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)CREATIVE_INVENTORY_LOCATION);
        int i = (this.field_22789 - this.field_2792) / 2;
        int j = (this.field_22790 - this.field_2779) / 2;
        TradingPostScreen.method_25291((class_4587)matrixStack, (int)(i + 11), (int)(j + 4), (int)this.method_25305(), (float)80.0f, (float)4.0f, (int)90, (int)12, (int)256, (int)256);
        this.searchBox.method_25394(matrixStack, mouseX, mouseY, partialTicks);
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseKey) {
        if (this.searchBox.method_25402(mouseX, mouseY, mouseKey)) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, mouseKey);
    }

    protected void method_37432() {
        this.searchBox.method_1865();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifierKeys) {
        this.ignoreTextInput = false;
        String lastSearch = this.searchBox.method_1882();
        if (this.searchBox.method_25404(keyCode, scanCode, modifierKeys)) {
            if (!Objects.equals(this.searchBox.method_1882(), lastSearch)) {
                this.refreshSearchResults();
            }
            return true;
        }
        if (this.searchBox.method_25370() && this.searchBox.method_1885() && keyCode != 256) {
            return true;
        }
        if (this.field_22787.field_1690.field_1890.method_1417(keyCode, scanCode) && !this.searchBox.method_25370()) {
            this.ignoreTextInput = true;
            this.searchBox.method_1876(true);
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifierKeys);
    }

    public boolean method_25400(char typedChar, int modifierKeys) {
        String lastSearch = this.searchBox.method_1882();
        if (!this.ignoreTextInput && this.searchBox.method_25400(typedChar, modifierKeys)) {
            if (!Objects.equals(this.searchBox.method_1882(), lastSearch)) {
                this.refreshSearchResults();
            }
            return true;
        }
        return super.method_25400(typedChar, modifierKeys);
    }

    public void refreshSearchResults() {
        class_1916 class_19162 = this.getMenu().method_17438();
        if (!(class_19162 instanceof TradingPostOffers)) {
            return;
        }
        TradingPostOffers offers = (TradingPostOffers)class_19162;
        String query = this.searchBox.method_1882();
        if (query.isEmpty()) {
            offers.clearFilter();
        } else {
            class_1129 isearchtree = this.field_22787.method_1484(TradingPostClient.OFFER_SEARCH_TREE);
            offers.setFilter(isearchtree.method_4810(query.toLowerCase(Locale.ROOT)));
        }
        ((MerchantScreenAccessor)((Object)this)).setScrollOff(0);
        ((MerchantScreenAccessor)((Object)this)).setShopItem(0);
        this.getMenu().method_7650(-1);
        this.getMenu().getTraders().setActiveOffer(null);
        this.getMenu().clearPaymentSlots();
        TradingPost.NETWORK.sendToServer((Message)new C2SClearSlotsMessage());
    }

    public TradingPostMenu getMenu() {
        return (TradingPostMenu)super.method_17577();
    }
}

