/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item.curio;

import artifacts.Artifacts;
import artifacts.common.events.PlayHurtSoundCallback;
import artifacts.common.item.ArtifactItem;
import artifacts.common.trinkets.TrinketsHelper;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.Trinket;
import dev.emi.trinkets.api.TrinketItem;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5250;
import net.minecraft.class_5536;
import net.minecraft.class_5630;

public class CurioItem
extends ArtifactItem
implements Trinket {
    public CurioItem() {
        PlayHurtSoundCallback.EVENT.register(this::playExtraHurtSound);
        TrinketsApi.registerTrinket((class_1792)this, (Trinket)this);
    }

    public class_1814 method_7862(class_1799 itemStack) {
        return class_1814.field_8903;
    }

    public boolean method_31566(class_1799 slotStack, class_1799 holdingStack, class_1735 slot, class_5536 clickAction, class_1657 player, class_5630 slotAccess) {
        if (clickAction == class_5536.field_27014 && holdingStack.method_7960()) {
            class_2487 tag = slotStack.method_7911("Artifacts");
            tag.method_10567("Status", (byte)ArtifactStatus.nextIndex(tag.method_10571("Status")));
            slotStack.method_7959("Artifacts", (class_2520)tag);
            return true;
        }
        return false;
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        if (TrinketItem.equipItem((class_1657)user, (class_1799)stack)) {
            SoundInfo sound = this.getEquipSoundInfo();
            user.method_5783(sound.soundEvent(), sound.volume(), sound.pitch());
            return class_1271.method_29237((Object)stack, (boolean)level.method_8608());
        }
        return super.method_7836(level, user, hand);
    }

    public void tick(class_1799 stack, SlotReference slot, class_1309 entity) {
        if (TrinketsHelper.areEffectsEnabled(stack)) {
            this.curioTick(entity, stack);
        }
    }

    protected void curioTick(class_1309 livingEntity, class_1799 stack) {
    }

    public final Multimap<class_1320, class_1322> getModifiers(class_1799 stack, SlotReference slot, class_1309 entity, UUID uuid) {
        if (TrinketsHelper.areEffectsEnabled(stack)) {
            return this.applyModifiers(stack, slot, entity, uuid);
        }
        return HashMultimap.create();
    }

    protected Multimap<class_1320, class_1322> applyModifiers(class_1799 stack, SlotReference slot, class_1309 entity, UUID uuid) {
        return HashMultimap.create();
    }

    @Override
    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 flags) {
        super.method_7851(stack, world, tooltip, flags);
        CurioItem.getEffectsEnabledLanguageKey(stack).ifPresent(key -> {
            class_5250 enabled = class_2561.method_43471((String)key).method_27692(class_124.field_1065);
            class_5250 toggletooltip = class_2561.method_43471((String)"artifacts.status.toggletooltip").method_27692(class_124.field_1080);
            tooltip.add((class_2561)enabled.method_27693(" ").method_10852((class_2561)toggletooltip));
        });
    }

    protected SoundInfo getEquipSoundInfo() {
        return new SoundInfo(class_3417.field_14883);
    }

    protected class_3414 getExtraHurtSound() {
        return null;
    }

    public class_1293 getPermanentEffect() {
        return null;
    }

    private void playExtraHurtSound(class_1309 entity, float volume, float pitch) {
        class_3414 hurtSound;
        if (Artifacts.CONFIG.general.playExtraHurtSounds && (hurtSound = this.getExtraHurtSound()) != null && TrinketsHelper.isEquipped(this, entity, true)) {
            entity.method_5783(hurtSound, volume, pitch);
        }
    }

    public static void addModifier(class_1324 instance, class_1322 modifier) {
        if (!instance.method_6196(modifier)) {
            instance.method_26835(modifier);
        }
    }

    public static void removeModifier(class_1324 instance, class_1322 modifier) {
        if (instance.method_6196(modifier)) {
            instance.method_6202(modifier);
        }
    }

    private static Optional<String> getEffectsEnabledLanguageKey(class_1799 stack) {
        return CurioItem.getArtifactStatus(stack).map(status -> switch (status) {
            default -> throw new IncompatibleClassChangeError();
            case ArtifactStatus.ALL_ENABLED -> "artifacts.status.allenabled";
            case ArtifactStatus.COSMETIC_ONLY -> "artifacts.status.cosmeticonly";
            case ArtifactStatus.EFFECTS_ONLY -> "artifacts.status.effectsonly";
        });
    }

    public static Optional<ArtifactStatus> getArtifactStatus(class_1799 stack) {
        if (!(stack.method_7909() instanceof CurioItem)) {
            return Optional.empty();
        }
        class_2487 tag = stack.method_7941("Artifacts");
        if (tag == null || !tag.method_10573("Status", 1)) {
            return Optional.of(ArtifactStatus.ALL_ENABLED);
        }
        return Optional.ofNullable(ArtifactStatus.values()[tag.method_10571("Status")]);
    }

    public static enum ArtifactStatus {
        ALL_ENABLED(true, true),
        COSMETIC_ONLY(false, true),
        EFFECTS_ONLY(true, false);

        private final boolean hasEffects;
        private final boolean hasCosmetics;

        private ArtifactStatus(boolean hasEffects, boolean hasCosmetics) {
            this.hasEffects = hasEffects;
            this.hasCosmetics = hasCosmetics;
        }

        public boolean hasEffects() {
            return this.hasEffects;
        }

        public boolean hasCosmetics() {
            return this.hasCosmetics;
        }

        public static int nextIndex(int index) {
            return index >= ArtifactStatus.values().length - 1 ? 0 : index + 1;
        }
    }

    protected record SoundInfo(class_3414 soundEvent, float volume, float pitch) {
        public SoundInfo(class_3414 soundEvent) {
            this(soundEvent, 1.0f, 1.0f);
        }
    }
}

