/*
 * Decompiled with CFR 0.152.
 */
package com.connectivity.config;

import com.connectivity.Connectivity;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class CommonConfiguration {
    public boolean disableLoginLimits = true;
    public boolean disablePacketLimits = true;
    public boolean debugPrintMessages = false;
    public boolean showFullResourceLocationException = false;
    public int logintimeout = 2400;
    public int packetHistoryMinutes = 5;
    public int disconnectTimeout = 60;

    protected CommonConfiguration() {
    }

    public JsonObject serialize() {
        JsonObject root = new JsonObject();
        JsonObject entry = new JsonObject();
        entry.addProperty("desc:", "Should login packet size limits be disabled? Error:(IOException(\"Payload may not be larger than 1048576 bytes\")) default:true");
        entry.addProperty("disableLoginLimits", Boolean.valueOf(this.disableLoginLimits));
        root.add("disableLoginLimits", (JsonElement)entry);
        JsonObject entry2 = new JsonObject();
        entry2.addProperty("desc:", "Should play packet size limits be disabled? Error:(Badly compressed packet) default:true");
        entry2.addProperty("disablePacketLimits", Boolean.valueOf(this.disablePacketLimits));
        root.add("disablePacketLimits", (JsonElement)entry2);
        JsonObject entry3 = new JsonObject();
        entry3.addProperty("desc:", "Enable addition debug logging for networking errors. default:false");
        entry3.addProperty("debugPrintMessages", Boolean.valueOf(this.debugPrintMessages));
        root.add("debugPrintMessages", (JsonElement)entry3);
        JsonObject entry4 = new JsonObject();
        entry4.addProperty("desc:", "Set the max login timeout in ticks. 20 ticks = 1 sec, default = 2400 ticks");
        entry4.addProperty("logintimeout", (Number)this.logintimeout);
        root.add("logintimeout", (JsonElement)entry4);
        JsonObject entry5 = new JsonObject();
        entry5.addProperty("desc:", "Set the ingame disconnect timeout for disconnecting players. Default = 60sec");
        entry5.addProperty("disconnectTimeout", (Number)this.disconnectTimeout);
        root.add("disconnectTimeout", (JsonElement)entry5);
        JsonObject entry6 = new JsonObject();
        entry6.addProperty("desc:", "Set the amount of minutes for which network packet history data is saved. Default = 5 minutes");
        entry6.addProperty("packetHistoryMinutes", (Number)this.packetHistoryMinutes);
        root.add("packetHistoryMinutes", (JsonElement)entry6);
        JsonObject entry7 = new JsonObject();
        entry7.addProperty("desc:", "Enable to see the full log output for all resource location exceptions. Default = false");
        entry7.addProperty("showFullResourceLocationException", Boolean.valueOf(this.showFullResourceLocationException));
        root.add("showFullResourceLocationException", (JsonElement)entry7);
        return root;
    }

    public void deserialize(JsonObject data) {
        if (data == null) {
            Connectivity.LOGGER.error("Config file was empty!");
            return;
        }
        try {
            this.disableLoginLimits = data.get("disableLoginLimits").getAsJsonObject().get("disableLoginLimits").getAsBoolean();
            this.disablePacketLimits = data.get("disablePacketLimits").getAsJsonObject().get("disablePacketLimits").getAsBoolean();
            this.debugPrintMessages = data.get("debugPrintMessages").getAsJsonObject().get("debugPrintMessages").getAsBoolean();
            this.showFullResourceLocationException = data.get("showFullResourceLocationException").getAsJsonObject().get("showFullResourceLocationException").getAsBoolean();
            this.logintimeout = data.get("logintimeout").getAsJsonObject().get("logintimeout").getAsInt();
            this.disconnectTimeout = data.get("disconnectTimeout").getAsJsonObject().get("disconnectTimeout").getAsInt();
            this.packetHistoryMinutes = data.get("packetHistoryMinutes").getAsJsonObject().get("packetHistoryMinutes").getAsInt();
        }
        catch (Exception e) {
            Connectivity.LOGGER.error("Could not parse config file", (Throwable)e);
        }
    }
}

