/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easymagic.world.inventory;

import com.google.common.collect.Lists;
import fuzs.easymagic.EasyMagic;
import fuzs.easymagic.config.ServerConfig;
import fuzs.easymagic.core.CommonAbstractions;
import fuzs.easymagic.init.ModRegistry;
import fuzs.easymagic.mixin.accessor.EnchantmentMenuAccessor;
import fuzs.easymagic.mixin.accessor.PlayerAccessor;
import fuzs.easymagic.network.S2CEnchantingDataMessage;
import fuzs.easymagic.util.ExperienceUtil;
import fuzs.puzzleslib.network.Message;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1712;
import net.minecraft.class_1718;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2331;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_259;
import net.minecraft.class_3222;
import net.minecraft.class_3914;
import net.minecraft.class_3915;
import net.minecraft.class_3917;
import net.minecraft.class_5819;

public class ModEnchantmentMenu
extends class_1718
implements class_1712 {
    public static final int REROLL_CATALYST_SLOT = 38;
    private final class_1263 enchantSlots;
    private final class_3914 access;
    private final class_1657 player;
    private final class_5819 random;
    private final class_3915 enchantmentSeed;

    public ModEnchantmentMenu(int id, class_1661 playerInventory) {
        this(id, playerInventory, (class_1263)new class_1277(((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).dedicatedRerollCatalyst ? 3 : 2), class_3914.field_17304);
    }

    public ModEnchantmentMenu(int id, class_1661 inventory, class_1263 container, class_3914 access) {
        super(id, inventory, access);
        this.enchantSlots = container;
        this.access = access;
        this.player = inventory.field_7546;
        this.random = ((EnchantmentMenuAccessor)((Object)this)).getRandom();
        this.enchantmentSeed = ((EnchantmentMenuAccessor)((Object)this)).getEnchantmentSeed();
        ((EnchantmentMenuAccessor)((Object)this)).setEnchantSlots(container);
        boolean dedicatedRerollCatalyst = ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).dedicatedRerollCatalyst;
        if (dedicatedRerollCatalyst) {
            this.method_7621(new class_1735(container, 2, 41, 47){

                public boolean method_7680(class_1799 stack) {
                    return stack.method_31573(ModRegistry.REROLL_CATALYSTS_ITEM_TAG);
                }
            });
        }
        this.field_7761.set(0, (Object)((class_1735)class_156.method_654((Object)new class_1735(container, 0, dedicatedRerollCatalyst ? 5 : 15, 47){

            public int method_7675() {
                return 1;
            }
        }, slot -> {
            slot.field_7874 = 0;
        })));
        this.field_7761.set(1, (Object)((class_1735)class_156.method_654((Object)new class_1735(container, 1, dedicatedRerollCatalyst ? 23 : 35, 47){

            public boolean method_7680(class_1799 stack) {
                return stack.method_31573(ModRegistry.ENCHANTING_CATALYSTS_ITEM_TAG);
            }
        }, slot -> {
            slot.field_7874 = 1;
        })));
        this.method_7596(this);
    }

    public class_3917<?> method_17358() {
        return (class_3917)ModRegistry.ENCHANTMENT_MENU_TYPE.get();
    }

    public void method_7609(class_1263 inventory) {
        if (inventory == this.enchantSlots) {
            class_1799 enchantedItem = inventory.method_5438(0);
            if (!enchantedItem.method_7960() && enchantedItem.method_7923()) {
                this.access.method_17393((world, pos) -> {
                    int power = ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).maxEnchantingPower == 0 ? 15 : this.getEnchantingPower((class_1937)world, (class_2338)pos) * 15 / ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).maxEnchantingPower;
                    this.random.method_43052((long)this.enchantmentSeed.method_17407());
                    this.updateLevels(enchantedItem, (class_1937)world, (class_2338)pos, power);
                    this.createClues(enchantedItem);
                    this.method_7623();
                    this.sendEnchantingData(enchantedItem);
                });
            } else {
                this.resetLevelsAndClues();
            }
        }
    }

    public void method_7635(class_1703 abstractContainerMenu, int i, class_1799 itemStack) {
        if (abstractContainerMenu == this) {
            this.access.method_17393((Level, BlockPos) -> {
                if (i >= 0 && i < 2) {
                    this.method_7609(this.enchantSlots);
                }
            });
        }
    }

    public void method_7633(class_1703 abstractContainerMenu, int i, int j) {
    }

    private void resetLevelsAndClues() {
        for (int i = 0; i < 3; ++i) {
            this.field_7808[i] = 0;
            this.field_7812[i] = -1;
            this.field_7810[i] = -1;
        }
    }

    private void updateLevels(class_1799 itemstack, class_1937 world, class_2338 pos, int power) {
        for (int i1 = 0; i1 < 3; ++i1) {
            this.field_7808[i1] = class_1890.method_8227((class_5819)this.random, (int)i1, (int)power, (class_1799)itemstack);
            if (this.field_7808[i1] >= i1 + 1) continue;
            this.field_7808[i1] = 0;
        }
    }

    private void createClues(class_1799 itemstack) {
        for (int j1 = 0; j1 < 3; ++j1) {
            List<class_1889> list;
            if (this.field_7808[j1] <= 0 || (list = this.createEnchantmentInstance(itemstack, j1)) == null || list.isEmpty()) continue;
            class_1889 enchantmentdata = list.get(this.random.method_43048(list.size()));
            this.field_7812[j1] = class_2378.field_11160.method_10206((Object)enchantmentdata.field_9093);
            this.field_7810[j1] = enchantmentdata.field_9094;
        }
    }

    private List<class_1889> createEnchantmentInstance(class_1799 enchantedItem, int enchantSlot) {
        return ((EnchantmentMenuAccessor)((Object)this)).callGetEnchantmentList(enchantedItem, enchantSlot, this.field_7808[enchantSlot]);
    }

    private List<class_1889> getEnchantmentHint(class_1799 enchantedItem, int enchantSlot, ServerConfig.EnchantmentHint enchantmentHint) {
        return switch (enchantmentHint) {
            default -> throw new IncompatibleClassChangeError();
            case ServerConfig.EnchantmentHint.NONE -> Lists.newArrayList();
            case ServerConfig.EnchantmentHint.SINGLE -> {
                List<class_1889> enchantmentData = this.createEnchantmentInstance(enchantedItem, enchantSlot);
                if (enchantmentData.isEmpty()) {
                    yield Lists.newArrayList();
                }
                yield Lists.newArrayList((Object[])new class_1889[]{enchantmentData.get(this.random.method_43048(enchantmentData.size()))});
            }
            case ServerConfig.EnchantmentHint.ALL -> this.createEnchantmentInstance(enchantedItem, enchantSlot);
        };
    }

    private void sendEnchantingData(class_1799 enchantedItem) {
        ServerConfig.EnchantmentHint enchantmentHint = ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).enchantmentHint;
        List<class_1889> firstSlotData = this.getEnchantmentHint(enchantedItem, 0, enchantmentHint);
        List<class_1889> secondSlotData = this.getEnchantmentHint(enchantedItem, 1, enchantmentHint);
        List<class_1889> thirdSlotData = this.getEnchantmentHint(enchantedItem, 2, enchantmentHint);
        EasyMagic.NETWORK.sendTo((Message)new S2CEnchantingDataMessage(this.field_7763, firstSlotData, secondSlotData, thirdSlotData), (class_3222)this.player);
    }

    private int getEnchantingPower(class_1937 level, class_2338 pos) {
        float j = 0.0f;
        for (class_2338 blockpos : class_2331.field_36535) {
            if (!class_2331.method_40445((class_1937)level, (class_2338)pos, (class_2338)blockpos)) continue;
            j += CommonAbstractions.INSTANCE.getEnchantPowerBonus(level.method_8320(pos.method_10081((class_2382)blockpos)), level, pos.method_10081((class_2382)blockpos));
        }
        return (int)j;
    }

    public static boolean isBlockEmpty(class_1937 world, class_2338 pos) {
        if (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).lenientBookshelves) {
            return world.method_8320(pos).method_26220((class_1922)world, pos) != class_259.method_1077();
        }
        return world.method_22347(pos);
    }

    public boolean method_7604(class_1657 player, int data) {
        if (data == 4) {
            int catalystSlot;
            class_1799 itemstack;
            if (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollEnchantments && !this.enchantSlots.method_5438(0).method_7960() && ((itemstack = this.enchantSlots.method_5438(catalystSlot = ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).dedicatedRerollCatalyst ? 2 : 1)).method_7947() >= ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollCatalystCost && ExperienceUtil.getTotalExperience(player) >= ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollExperiencePointsCost || player.method_31549().field_7477)) {
                this.access.method_17393((level, pos) -> {
                    this.enchantmentSeed.method_17404(this.player.method_6051().method_43054());
                    ((PlayerAccessor)this.player).setEnchantmentSeed(this.enchantmentSeed.method_17407());
                    if (!player.method_31549().field_7477) {
                        if (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollCatalystCost > 0) {
                            itemstack.method_7934(((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollCatalystCost);
                            if (itemstack.method_7960()) {
                                this.enchantSlots.method_5447(catalystSlot, class_1799.field_8037);
                            }
                        }
                        if (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollExperiencePointsCost > 0) {
                            player.method_7255(-((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollExperiencePointsCost);
                        }
                    }
                    this.enchantSlots.method_5431();
                    this.method_7609(this.enchantSlots);
                });
                return true;
            }
            return false;
        }
        return super.method_7604(player, data);
    }

    public boolean method_7597(class_1657 playerIn) {
        return this.enchantSlots.method_5443(playerIn);
    }

    public void method_7595(class_1657 playerIn) {
        class_1799 itemstack;
        if (playerIn instanceof class_3222 && !(itemstack = this.method_34255()).method_7960()) {
            if (playerIn.method_5805() && !((class_3222)playerIn).method_14239()) {
                playerIn.method_31548().method_7398(itemstack);
            } else {
                playerIn.method_7328(itemstack, false);
            }
            this.method_34254(class_1799.field_8037);
        }
    }

    public int getRerollCatalystCount() {
        if (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).dedicatedRerollCatalyst) {
            return this.enchantSlots.method_5438(2).method_7947();
        }
        return this.method_7638();
    }

    public class_1799 method_7601(class_1657 player, int index) {
        class_1799 itemStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot != null && slot.method_7681()) {
            class_1799 itemStack2 = slot.method_7677();
            itemStack = itemStack2.method_7972();
            boolean override = false;
            boolean dedicatedRerollCatalyst = ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).dedicatedRerollCatalyst;
            if (dedicatedRerollCatalyst && index == 38) {
                override = true;
                if (!this.method_7616(itemStack2, 2, 38, true)) {
                    return class_1799.field_8037;
                }
            } else if (index != 0 && index != 1) {
                if (itemStack2.method_31573(ModRegistry.ENCHANTING_CATALYSTS_ITEM_TAG)) {
                    override = true;
                    if (!this.method_7616(itemStack2, 1, 2, true)) {
                        return class_1799.field_8037;
                    }
                } else if (dedicatedRerollCatalyst && itemStack2.method_31573(ModRegistry.REROLL_CATALYSTS_ITEM_TAG)) {
                    override = true;
                    if (!this.method_7616(itemStack2, 38, 39, true)) {
                        return class_1799.field_8037;
                    }
                }
            }
            if (!override) {
                return super.method_7601(player, index);
            }
            if (itemStack2.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
            if (itemStack2.method_7947() == itemStack.method_7947()) {
                return class_1799.field_8037;
            }
            slot.method_7667(player, itemStack2);
        }
        return itemStack;
    }
}

