/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easymagic.client.gui.screens.inventory;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import fuzs.easymagic.EasyMagic;
import fuzs.easymagic.config.ClientConfig;
import fuzs.easymagic.config.ServerConfig;
import fuzs.easymagic.util.ExperienceUtil;
import fuzs.easymagic.world.inventory.ModEnchantmentMenu;
import fuzs.puzzleslib.core.ModLoaderEnvironment;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1718;
import net.minecraft.class_1735;
import net.minecraft.class_1802;
import net.minecraft.class_1889;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_4587;
import net.minecraft.class_486;
import net.minecraft.class_487;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_757;

public class ModEnchantmentScreen
extends class_486 {
    private static final class_2960 ENCHANTING_TABLE_LOCATION = new class_2960("textures/gui/container/enchanting_table.png");
    private static final class_2960 ENCHANTING_TABLE_REROLL_LOCATION = new class_2960("easymagic", "textures/gui/container/enchanting_table_reroll.png");
    private final List<List<class_1889>> slotData = IntStream.range(0, 3).mapToObj(i -> Lists.newArrayList()).collect(Collectors.toList());

    public ModEnchantmentScreen(class_1718 container, class_1661 playerInventory, class_2561 textComponent) {
        super(container, playerInventory, textComponent);
    }

    protected void method_2389(class_4587 poseStack, float tickDelta, int mouseX, int mouseY) {
        if (!((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollEnchantments || ((ClientConfig)EasyMagic.CONFIG.get(ClientConfig.class)).keepEnchantmentScreenBook) {
            super.method_2389(poseStack, tickDelta, mouseX, mouseY);
        } else {
            this.renderVanillaBg(poseStack, tickDelta, mouseX, mouseY);
            this.renderRerollButton(poseStack, tickDelta, mouseX, mouseY);
        }
        if (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).dedicatedRerollCatalyst) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderTexture((int)0, (class_2960)ENCHANTING_TABLE_LOCATION);
            this.method_25302(poseStack, this.field_2776 + 4, this.field_2800 + 46, 14, 46, 18, 18);
            this.method_25302(poseStack, this.field_2776 + 22, this.field_2800 + 46, 34, 46, 18, 18);
            RenderSystem.setShaderTexture((int)0, (class_2960)ENCHANTING_TABLE_REROLL_LOCATION);
            this.method_25302(poseStack, this.field_2776 + 40, this.field_2800 + 46, 0, 81, 18, 18);
        }
    }

    private void renderVanillaBg(class_4587 poseStack, float tickDelta, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)ENCHANTING_TABLE_LOCATION);
        int k = (this.field_22789 - this.field_2792) / 2;
        int l = (this.field_22790 - this.field_2779) / 2;
        this.method_25302(poseStack, k, l, 0, 0, this.field_2792, this.field_2779);
        class_487.method_2481().method_2480((long)((class_1718)this.field_2797).method_17413());
        int q = ((class_1718)this.field_2797).method_7638();
        for (int r = 0; r < 3; ++r) {
            int s = k + 60;
            int t = s + 20;
            this.method_25304(0);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderTexture((int)0, (class_2960)ENCHANTING_TABLE_LOCATION);
            int u = ((class_1718)this.field_2797).field_7808[r];
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (u == 0) {
                this.method_25302(poseStack, s, l + 14 + 19 * r, 0, 185, 108, 19);
                continue;
            }
            String string = "" + u;
            int v = 86 - this.field_22793.method_1727(string);
            class_5348 formattedText = class_487.method_2481().method_2479(this.field_22793, v);
            int w = 6839882;
            if (!(q >= r + 1 && this.field_22787.field_1724.field_7520 >= u || this.field_22787.field_1724.method_31549().field_7477)) {
                this.method_25302(poseStack, s, l + 14 + 19 * r, 0, 185, 108, 19);
                this.method_25302(poseStack, s + 1, l + 15 + 19 * r, 16 * r, 239, 16, 16);
                this.field_22793.method_1712(formattedText, t, l + 16 + 19 * r, v, (w & 0xFEFEFE) >> 1);
                w = 4226832;
            } else {
                int x = mouseX - (k + 60);
                int y = mouseY - (l + 14 + 19 * r);
                if (x >= 0 && y >= 0 && x < 108 && y < 19) {
                    this.method_25302(poseStack, s, l + 14 + 19 * r, 0, 204, 108, 19);
                    w = 0xFFFF80;
                } else {
                    this.method_25302(poseStack, s, l + 14 + 19 * r, 0, 166, 108, 19);
                }
                this.method_25302(poseStack, s + 1, l + 15 + 19 * r, 16 * r, 223, 16, 16);
                this.field_22793.method_1712(formattedText, t, l + 16 + 19 * r, v, w);
                w = 8453920;
            }
            this.field_22793.method_1720(poseStack, string, (float)(t + 86 - this.field_22793.method_1727(string)), (float)(l + 16 + 19 * r + 7), w);
        }
    }

    private void renderRerollButton(class_4587 poseStack, float tickDelta, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)ENCHANTING_TABLE_REROLL_LOCATION);
        int experienceCost = ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollExperiencePointsCost;
        int lapisCost = ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollCatalystCost;
        boolean invalid = !this.field_22787.field_1724.method_31549().field_7477 && (ExperienceUtil.getTotalExperience((class_1657)this.field_22787.field_1724) < experienceCost || this.getMenu().getRerollCatalystCount() < lapisCost);
        int buttonX = this.field_2776 + (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).dedicatedRerollCatalyst ? 12 : 14);
        int buttonY = this.field_2800 + 16;
        boolean hovered = this.isMouseOverReroll(mouseX, mouseY);
        this.method_25302(poseStack, buttonX, buttonY, 0, !this.canUseReroll() || invalid ? 0 : (hovered ? 54 : 27), 38, 27);
        if (!this.canUseReroll()) {
            return;
        }
        if (experienceCost == 0 && lapisCost == 0) {
            this.method_25302(poseStack, buttonX + 12, buttonY + 6, 64, invalid ? 0 : (hovered ? 30 : 15), 15, 15);
        } else {
            this.method_25302(poseStack, buttonX + 3, buttonY + 6, 64, invalid ? 0 : (hovered ? 30 : 15), 15, 15);
            if (experienceCost > 0 && lapisCost > 0) {
                this.renderCostOrb(poseStack, buttonX + (experienceCost > 9 ? 17 : 20), buttonY + 13, 38, invalid ? 39 : 0, experienceCost, invalid ? class_124.field_1061 : class_124.field_1060);
                this.renderCostOrb(poseStack, buttonX + (lapisCost > 9 ? 17 : 20), buttonY + 1, 51, invalid ? 39 : 0, lapisCost, invalid ? class_124.field_1061 : class_124.field_1078);
            } else if (experienceCost > 0) {
                this.renderCostOrb(poseStack, buttonX + (experienceCost > 9 ? 17 : 20), buttonY + 7, 38, invalid ? 39 : 0, experienceCost, invalid ? class_124.field_1061 : class_124.field_1060);
            } else if (lapisCost > 0) {
                this.renderCostOrb(poseStack, buttonX + (lapisCost > 9 ? 17 : 20), buttonY + 7, 51, invalid ? 39 : 0, lapisCost, invalid ? class_124.field_1061 : class_124.field_1078);
            }
        }
    }

    private void renderCostOrb(class_4587 poseStack, int posX, int posY, int textureX, int textureY, int cost, class_124 color) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)ENCHANTING_TABLE_REROLL_LOCATION);
        this.method_25302(poseStack, posX, posY, textureX, textureY + Math.min(2, cost / 5) * 13, 13, 13);
        this.renderReadableText(poseStack, posX + 8, posY + 3, String.valueOf(cost), color.method_532());
    }

    private void renderReadableText(class_4587 poseStack, int posX, int posY, String text, int color) {
        this.field_22793.method_1729(poseStack, text, (float)(posX - 1), (float)posY, 0);
        this.field_22793.method_1729(poseStack, text, (float)(posX + 1), (float)posY, 0);
        this.field_22793.method_1729(poseStack, text, (float)posX, (float)(posY - 1), 0);
        this.field_22793.method_1729(poseStack, text, (float)posX, (float)(posY + 1), 0);
        this.field_22793.method_1729(poseStack, text, (float)posX, (float)posY, color);
    }

    private boolean canUseReroll() {
        return IntStream.of(((class_1718)this.field_2797).field_7808).sum() > 0;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollEnchantments && this.isMouseOverReroll((int)mouseX, (int)mouseY) && ((class_1718)this.field_2797).method_7604((class_1657)this.field_22787.field_1724, 4)) {
            this.field_22787.field_1761.method_2900(((class_1718)this.field_2797).field_7763, 4);
            this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15119, (float)1.0f));
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void method_25394(class_4587 matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(matrixStack, mouseX, mouseY, partialTicks);
        int slot = this.getEnchantingSlot(mouseX, mouseY);
        if (slot != -1) {
            if (!this.slotData.get(slot).isEmpty()) {
                ArrayList tooltip = Lists.newArrayList();
                boolean hasValidEnchantment = this.gatherSlotEnchantmentsTooltip(this.slotData.get(slot), tooltip);
                this.gatherSlotCostsTooltip(slot, tooltip, hasValidEnchantment);
                this.method_30901(matrixStack, tooltip, mouseX, mouseY);
            }
        } else if (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollEnchantments && this.isMouseOverReroll(mouseX, mouseY) && this.canUseReroll()) {
            ArrayList tooltip = Lists.newArrayList();
            this.gatherRerollTooltip(tooltip);
            this.method_30901(matrixStack, tooltip, mouseX, mouseY);
        }
    }

    private boolean isMouseOverReroll(int mouseX, int mouseY) {
        int startX = this.field_2776 + (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).dedicatedRerollCatalyst ? 12 : 14);
        int startY = this.field_2800 + 16;
        return startX < mouseX && mouseX <= startX + 38 && startY < mouseY && mouseY <= startY + 27;
    }

    protected boolean method_2378(int x, int y, int width, int height, double mouseX, double mouseY) {
        if (this.getSelectedSlot(mouseX, mouseY) != null) {
            return super.method_2378(x, y, width, height, mouseX, mouseY);
        }
        return false;
    }

    @Nullable
    private class_1735 getSelectedSlot(double mouseX, double mouseY) {
        for (int i = 0; i < ((class_1718)this.field_2797).field_7761.size(); ++i) {
            class_1735 slot = (class_1735)((class_1718)this.field_2797).field_7761.get(i);
            if (!this.isSlotSelected(slot, mouseX, mouseY) || !slot.method_7682()) continue;
            return slot;
        }
        return null;
    }

    private boolean isSlotSelected(class_1735 slotIn, double mouseX, double mouseY) {
        return super.method_2378(slotIn.field_7873, slotIn.field_7872, 16, 16, mouseX, mouseY);
    }

    private int getEnchantingSlot(int mouseX, int mouseY) {
        for (int j = 0; j < 3; ++j) {
            int levels = ((class_1718)this.field_2797).field_7808[j];
            if (!super.method_2378(60, 14 + 19 * j, 108, 17, (double)mouseX, (double)mouseY) || levels <= 0) continue;
            return j;
        }
        return -1;
    }

    public void setSlotData(int slot, List<class_1889> data) {
        this.slotData.set(slot, data);
    }

    private boolean gatherSlotEnchantmentsTooltip(List<class_1889> slotData, List<class_2561> slotTooltip) {
        boolean hasValidEnchantment = slotData.isEmpty();
        for (class_1889 data : slotData) {
            if (data.field_9093 == null) continue;
            if (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).enchantmentHint == ServerConfig.EnchantmentHint.ALL) {
                slotTooltip.add((class_2561)((class_5250)data.field_9093.method_8179(data.field_9094)).method_27692(class_124.field_1080));
            } else {
                slotTooltip.add((class_2561)class_2561.method_43469((String)"container.enchant.clue", (Object[])new Object[]{data.field_9093.method_8179(data.field_9094)}).method_27692(class_124.field_1080));
            }
            hasValidEnchantment = true;
        }
        return hasValidEnchantment;
    }

    private void gatherSlotCostsTooltip(int slot, List<class_2561> slotTooltip, boolean hasValidEnchantment) {
        ArrayList additionalTooltip = Lists.newArrayList();
        if (ModLoaderEnvironment.INSTANCE.getModLoader().isForge() && !hasValidEnchantment) {
            additionalTooltip.add(class_2561.method_43471((String)"forge.container.enchant.limitedEnchantability").method_27692(class_124.field_1061));
        } else if (!this.field_22787.field_1724.method_31549().field_7477) {
            int enchantLevels = ((class_1718)this.field_2797).field_7808[slot];
            if (this.field_22787.field_1724.field_7520 < enchantLevels) {
                additionalTooltip.add(class_2561.method_43469((String)"container.enchant.level.requirement", (Object[])new Object[]{enchantLevels}).method_27692(class_124.field_1061));
            } else {
                ModEnchantmentScreen.getEnchantingComponent(slot + 1, ((class_1718)this.field_2797).method_7638(), "container.enchant.lapis.one", "container.enchant.lapis.many").ifPresent(additionalTooltip::add);
                ModEnchantmentScreen.getEnchantingComponent(slot + 1, this.field_22787.field_1724.field_7520, "container.enchant.level.one", "container.enchant.level.many").ifPresent(additionalTooltip::add);
            }
        }
        if (!additionalTooltip.isEmpty()) {
            if (!slotTooltip.isEmpty()) {
                slotTooltip.add((class_2561)class_2561.method_43473());
            }
            slotTooltip.addAll(additionalTooltip);
        }
    }

    private void gatherRerollTooltip(List<class_2561> tooltip) {
        tooltip.add((class_2561)class_2561.method_43471((String)"container.enchant.reroll").method_27692(class_124.field_1080));
        ArrayList additionalTooltip = Lists.newArrayList();
        if (!this.field_22787.field_1724.method_31549().field_7477) {
            int rerollCatalystCost = ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollCatalystCost;
            if (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).dedicatedRerollCatalyst) {
                class_5250 component = class_2561.method_43470((String)(rerollCatalystCost + " ")).method_10852(class_1802.field_27063.method_7848());
                ModEnchantmentScreen.getEnchantingComponent(rerollCatalystCost, this.getMenu().getRerollCatalystCount(), component).ifPresent(additionalTooltip::add);
            } else {
                ModEnchantmentScreen.getEnchantingComponent(rerollCatalystCost, this.getMenu().getRerollCatalystCount(), "container.enchant.lapis.one", "container.enchant.lapis.many").ifPresent(additionalTooltip::add);
            }
            ModEnchantmentScreen.getEnchantingComponent(((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollExperiencePointsCost, ExperienceUtil.getTotalExperience((class_1657)this.field_22787.field_1724), "container.enchant.experience.one", "container.enchant.experience.many").ifPresent(additionalTooltip::add);
        }
        if (!additionalTooltip.isEmpty()) {
            tooltip.add((class_2561)class_2561.method_43473());
            tooltip.addAll(additionalTooltip);
        }
    }

    private static Optional<class_2561> getEnchantingComponent(int requiredAmount, int currentAmount, String singleKey, String manyKey) {
        if (requiredAmount < 1) {
            return Optional.empty();
        }
        class_5250 component = requiredAmount == 1 ? class_2561.method_43471((String)singleKey) : class_2561.method_43469((String)manyKey, (Object[])new Object[]{requiredAmount});
        return ModEnchantmentScreen.getEnchantingComponent(requiredAmount, currentAmount, component);
    }

    private static Optional<class_2561> getEnchantingComponent(int requiredAmount, int currentAmount, class_5250 component) {
        if (requiredAmount < 1) {
            return Optional.empty();
        }
        return Optional.of(component.method_27692(currentAmount >= requiredAmount ? class_124.field_1080 : class_124.field_1061));
    }

    public ModEnchantmentMenu getMenu() {
        return (ModEnchantmentMenu)super.method_17577();
    }
}

