/*
 * Decompiled with CFR 0.152.
 */
package paulevs.edenring.world.generator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_6544;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import org.betterx.bclib.api.v2.generator.BiomePicker;
import org.betterx.bclib.api.v2.generator.map.hex.HexBiomeMap;
import org.betterx.bclib.interfaces.BiomeMap;
import paulevs.edenring.noise.InterpolationCell;
import paulevs.edenring.registries.EdenBiomes;
import paulevs.edenring.world.generator.GeneratorOptions;
import paulevs.edenring.world.generator.MultiThreadGenerator;
import paulevs.edenring.world.generator.TerrainGenerator;

public class EdenBiomeSource
extends class_1966 {
    public static final Codec<EdenBiomeSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_6903.method_40419((class_5321)class_2378.field_25114).forGetter(theEndBiomeSource -> null)).apply((Applicative)instance, instance.stable(EdenBiomeSource::new)));
    private Map<class_1923, InterpolationCell> terrainCache = new ConcurrentHashMap<class_1923, InterpolationCell>();
    private BiomePicker pickerLand;
    private BiomePicker pickerVoid;
    private BiomePicker pickerCave;
    private BiomeMap mapLand;
    private BiomeMap mapVoid;
    private BiomeMap mapCave;

    public EdenBiomeSource(class_2378<class_1959> biomeRegistry) {
        super(biomeRegistry.method_29722().stream().filter(entry -> ((class_5321)entry.getKey()).method_29177().method_12836().equals("edenring")).map(entry -> (class_6880)biomeRegistry.method_40268((class_5321)entry.getKey()).get().left().get()).collect(Collectors.toList()));
        if (this.pickerLand == null) {
            this.pickerLand = new BiomePicker(biomeRegistry);
            EdenBiomes.BIOMES_LAND.forEach(biome -> this.pickerLand.addBiome(biome));
            this.pickerLand.rebuild();
            this.pickerVoid = new BiomePicker(biomeRegistry);
            EdenBiomes.BIOMES_VOID.forEach(biome -> this.pickerVoid.addBiome(biome));
            this.pickerVoid.rebuild();
            this.pickerCave = new BiomePicker(biomeRegistry);
            EdenBiomes.BIOMES_CAVE.forEach(biome -> this.pickerCave.addBiome(biome));
            this.pickerCave.rebuild();
        }
        this.mapLand = new HexBiomeMap(0L, GeneratorOptions.biomeSizeLand, this.pickerLand);
        this.mapVoid = new HexBiomeMap(0L, GeneratorOptions.biomeSizeVoid, this.pickerVoid);
        this.mapCave = new HexBiomeMap(0L, GeneratorOptions.biomeSizeCave, this.pickerCave);
    }

    protected Codec<? extends class_1966> method_28442() {
        return CODEC;
    }

    public class_6880<class_1959> method_38109(int x, int y, int z, class_6544.class_6552 sampler) {
        class_2338.class_2339 pos;
        this.cleanCache(x, z);
        int px = x << 2 | 2;
        int py = y << 2 | 2;
        int pz = z << 2 | 2;
        class_1923 chunkPos = new class_1923(px >> 4, pz >> 4);
        InterpolationCell cell = this.terrainCache.get(chunkPos);
        if (cell == null) {
            TerrainGenerator generator = MultiThreadGenerator.getTerrainGenerator();
            cell = new InterpolationCell(generator, 3, 33, 8, 8, new class_2338(chunkPos.method_8326(), 0, chunkPos.method_8328()));
            this.terrainCache.put(chunkPos, cell);
        }
        if (this.isLand(cell, pos = new class_2338.class_2339(px, 0, pz))) {
            if (this.isCave(cell, pos.method_33098(py))) {
                return this.mapCave.getBiome((double)((double)px), (double)0.0, (double)((double)pz)).biome;
            }
            return this.mapLand.getBiome((double)((double)px), (double)0.0, (double)((double)pz)).biome;
        }
        return this.mapVoid.getBiome((double)((double)px), (double)0.0, (double)((double)pz)).biome;
    }

    public void setSeed(long seed) {
        this.mapLand = new HexBiomeMap(seed, GeneratorOptions.biomeSizeLand, this.pickerLand);
        this.mapVoid = new HexBiomeMap(seed, GeneratorOptions.biomeSizeVoid, this.pickerVoid);
        this.mapCave = new HexBiomeMap(seed, GeneratorOptions.biomeSizeCave, this.pickerCave);
    }

    private void cleanCache(int x, int z) {
        if ((x & 0x3F) == 0 && (z & 0x3F) == 0) {
            this.terrainCache.clear();
            this.mapLand.clearCache();
            this.mapVoid.clearCache();
            this.mapCave.clearCache();
        }
    }

    private boolean isLand(InterpolationCell cell, class_2338.class_2339 pos) {
        for (int py = 0; py < 256; py = (int)((short)(py + 8))) {
            if (!(cell.get((class_2338)pos.method_33098(py), false) > -0.05f)) continue;
            return true;
        }
        return false;
    }

    private boolean isCave(InterpolationCell cell, class_2338.class_2339 pos) {
        if (pos.method_10264() < 8 || pos.method_10264() > 240) {
            return false;
        }
        boolean v1 = cell.get((class_2338)pos, false) > 0.0f;
        boolean v2 = cell.get((class_2338)pos.method_33098(pos.method_10264() + 12), false) > 0.0f;
        boolean v3 = cell.get((class_2338)pos.method_33098(pos.method_10264() - 16), false) > 0.0f;
        return v1 && v2 && v3;
    }
}

