/*
 * Decompiled with CFR 0.152.
 */
package paulevs.edenring.registries;

import com.google.common.collect.Lists;
import java.util.List;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiome;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.bclib.config.EntryConfig;
import org.betterx.bclib.config.IdConfig;
import paulevs.edenring.world.biomes.CaveBiomes;
import paulevs.edenring.world.biomes.LandBiomes;
import paulevs.edenring.world.biomes.VoidBiomes;

public class EdenBiomes {
    private static final IdConfig CONFIG = new EntryConfig("edenring", "biomes");
    public static final List<BCLBiome> BIOMES_LAND = Lists.newArrayList();
    public static final List<BCLBiome> BIOMES_VOID = Lists.newArrayList();
    public static final List<BCLBiome> BIOMES_CAVE = Lists.newArrayList();
    public static final BCLBiome STONE_GARDEN = EdenBiomes.registerLand(LandBiomes.makeStoneGardenBiome());
    public static final BCLBiome GOLDEN_FOREST = EdenBiomes.registerLand(LandBiomes.makeGoldenForestBiome());
    public static final BCLBiome MYCOTIC_FOREST = EdenBiomes.registerLand(LandBiomes.makeMycoticForestBiome());
    public static final BCLBiome PULSE_FOREST = EdenBiomes.registerLand(LandBiomes.makePulseForestBiome());
    public static final BCLBiome BRAINSTORM = EdenBiomes.registerLand(LandBiomes.makeBrainstormBiome());
    public static final BCLBiome LAKESIDE_DESERT = EdenBiomes.registerLand(LandBiomes.makeLakesideDesertBiome());
    public static final BCLBiome WIND_VALLEY = EdenBiomes.registerLand(LandBiomes.makeWindValleyBiome());
    public static final BCLBiome AIR_OCEAN = EdenBiomes.registerVoid(VoidBiomes.makeAirOcean());
    public static final BCLBiome SKY_COLONY = EdenBiomes.registerVoid(VoidBiomes.makeSkyColony());
    public static final BCLBiome EMPTY_CAVE = EdenBiomes.registerCave(CaveBiomes.makeEmptyCaveBiome());
    public static final BCLBiome ERODED_CAVE = EdenBiomes.registerCave(CaveBiomes.makeErodedCaveBiome());
    public static final BCLBiome OLD_MYCOTIC_FOREST = EdenBiomes.registerSubLand(MYCOTIC_FOREST, LandBiomes.makeOldMycoticForestBiome());

    public static void init() {
        CONFIG.saveChanges();
    }

    private static BCLBiome registerLand(BCLBiome biome) {
        BIOMES_LAND.add(biome);
        return BiomeAPI.registerBuiltinBiomeAndOverrideIntendedDimension((BCLBiome)biome, (BiomeAPI.BiomeType)BiomeAPI.BiomeType.NONE);
    }

    private static BCLBiome registerVoid(BCLBiome biome) {
        BIOMES_VOID.add(biome);
        return BiomeAPI.registerBuiltinBiomeAndOverrideIntendedDimension((BCLBiome)biome, (BiomeAPI.BiomeType)BiomeAPI.BiomeType.NONE);
    }

    private static BCLBiome registerCave(BCLBiome biome) {
        BIOMES_CAVE.add(biome);
        return BiomeAPI.registerBuiltinBiomeAndOverrideIntendedDimension((BCLBiome)biome, (BiomeAPI.BiomeType)BiomeAPI.BiomeType.NONE);
    }

    private static BCLBiome registerSubLand(BCLBiome parent, BCLBiome biome) {
        return BiomeAPI.registerSubBiome((BCLBiome)parent, (BCLBiome)biome);
    }
}

