/*
 * Decompiled with CFR 0.152.
 */
package paulevs.edenring.client.entities.renderers;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2960;
import net.minecraft.class_4581;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_638;
import net.minecraft.class_761;
import net.minecraft.class_897;
import paulevs.edenring.entities.EdenPainting;
import paulevs.edenring.paintings.PaintingColorProvider;
import paulevs.edenring.paintings.PaintingInfo;

@Environment(value=EnvType.CLIENT)
public class EdenPaintingRenderer
extends class_897<EdenPainting> {
    private static final class_2338.class_2339 POS = new class_2338.class_2339();
    private static final int WHITE = 0xFFFFFF;

    public EdenPaintingRenderer(class_5617.class_5618 context) {
        super(context);
    }

    public void render(EdenPainting painting, float f, float g, class_4587 poseStack, class_4597 multiBufferSource, int i) {
        PaintingInfo info = painting.getPainting();
        poseStack.method_22903();
        poseStack.method_22907(class_1160.field_20705.method_23214(180.0f - f));
        poseStack.method_22905(0.0625f, 0.0625f, 0.0625f);
        class_4588 vertexConsumer = multiBufferSource.getBuffer(class_1921.method_23576((class_2960)this.getTextureLocation(painting)));
        this.renderPainting(poseStack, vertexConsumer, painting, info);
        poseStack.method_22909();
        super.method_3936((class_1297)painting, f, g, poseStack, multiBufferSource, i);
    }

    public class_2960 getTextureLocation(EdenPainting painting) {
        return painting.getPainting().getTexture();
    }

    private void renderPainting(class_4587 poseStack, class_4588 vertexConsumer, EdenPainting painting, PaintingInfo info) {
        class_4587.class_4665 pose = poseStack.method_23760();
        class_4581 normal = pose.method_23762();
        class_1159 pos = pose.method_23761();
        int w = info.getWidth() >> 4;
        int h = info.getHeight() >> 4;
        float dx = (float)info.getWidth() * 0.5f;
        float dy = (float)info.getHeight() * 0.5f;
        int light = 0;
        class_2338 origin = painting.method_24515();
        class_2350 cross = painting.method_5735().method_10160();
        POS.method_10101((class_2382)origin);
        for (int x = 0; x < w; ++x) {
            POS.method_10104(cross, x);
            for (int y = 0; y < h; ++y) {
                POS.method_33098(origin.method_10264() + y);
                int l = class_761.method_23794((class_1920)painting.field_6002, (class_2338)POS);
                if (l <= light) continue;
                light = l;
            }
        }
        int rgb = 0xFFFFFF;
        PaintingColorProvider provider = info.getProvider();
        if (provider != null) {
            rgb = provider.getColor((class_638)painting.field_6002, POS);
        }
        this.vertex(pos, normal, vertexConsumer, rgb, -dx, dy, -0.5f, 1.0f, 0.0f, light);
        this.vertex(pos, normal, vertexConsumer, rgb, dx, dy, -0.5f, 0.0f, 0.0f, light);
        this.vertex(pos, normal, vertexConsumer, rgb, dx, -dy, -0.5f, 0.0f, 1.0f, light);
        this.vertex(pos, normal, vertexConsumer, rgb, -dx, -dy, -0.5f, 1.0f, 1.0f, light);
    }

    private void vertex(class_1159 pos, class_4581 normal, class_4588 vertexConsumer, int rgb, float x, float y, float z, float u, float v, int lightmap) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        vertexConsumer.method_22918(pos, x, y, z).method_1336(r, g, b, 255).method_22913(u, v).method_22922(class_4608.field_21444).method_22916(lightmap).method_23763(normal, 0.0f, 0.0f, -1.0f).method_1344();
    }
}

