/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantinginfuser.world.inventory;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import fuzs.enchantinginfuser.EnchantingInfuser;
import fuzs.enchantinginfuser.api.EnchantingInfuserAPI;
import fuzs.enchantinginfuser.config.ServerConfig;
import fuzs.enchantinginfuser.core.CommonAbstractions;
import fuzs.enchantinginfuser.network.S2CCompatibleEnchantsMessage;
import fuzs.enchantinginfuser.util.EnchantmentUtil;
import fuzs.enchantinginfuser.world.level.block.InfuserBlock;
import fuzs.puzzleslib.network.Message;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1706;
import net.minecraft.class_1712;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_174;
import net.minecraft.class_1751;
import net.minecraft.class_1772;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2331;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_3914;
import net.minecraft.class_3915;
import net.minecraft.class_3917;
import net.minecraft.class_5819;

public class InfuserMenu
extends class_1703
implements class_1712 {
    private static final class_2960[] TEXTURE_EMPTY_SLOTS = new class_2960[]{class_1723.field_21672, class_1723.field_21671, class_1723.field_21670, class_1723.field_21669};
    private static final class_1304[] SLOT_IDS = new class_1304[]{class_1304.field_6169, class_1304.field_6174, class_1304.field_6172, class_1304.field_6166};
    private final class_1263 enchantSlots;
    private final class_3914 levelAccess;
    private final class_1657 player;
    public final ServerConfig.InfuserConfig config;
    private final class_3915 enchantingPower = class_3915.method_17403();
    private final class_3915 enchantingCost = class_3915.method_17403();
    private final class_3915 repairCost = class_3915.method_17403();
    private Map<class_1887, Integer> enchantmentsToLevel;
    private Map<class_1887, Integer> enchantmentsToLevelBase;
    private int enchantingBaseCost;
    private boolean enchantmentsChanged;

    public static InfuserMenu create(InfuserBlock.InfuserType type, int id, class_1661 inventory) {
        return new InfuserMenu(type.menuType(), id, inventory, type.config());
    }

    private InfuserMenu(class_3917<?> menuType, int id, class_1661 playerInventory, ServerConfig.InfuserConfig config) {
        this(menuType, id, playerInventory, (class_1263)new class_1277(1), class_3914.field_17304, config);
    }

    public static InfuserMenu create(InfuserBlock.InfuserType type, int id, class_1661 inventory, class_1263 container, class_3914 levelAccess) {
        return new InfuserMenu(type.menuType(), id, inventory, container, levelAccess, type.config());
    }

    private InfuserMenu(class_3917<?> menuType, int id, final class_1661 inventory, class_1263 container, class_3914 levelAccess, ServerConfig.InfuserConfig config) {
        super(menuType, id);
        InfuserMenu.method_17359((class_1263)container, (int)1);
        this.enchantSlots = container;
        this.levelAccess = levelAccess;
        this.player = inventory.field_7546;
        this.config = config;
        this.method_7621(new class_1735(container, 0, 8, config.allowRepairing ? 23 : 34){

            public int method_7675() {
                return 1;
            }
        });
        for (int k = 0; k < 4; ++k) {
            final class_1304 equipmentslot = SLOT_IDS[k];
            this.method_7621(new class_1735((class_1263)inventory, 39 - k, 8 + 188 * (k / 2), 103 + k % 2 * 18){

                public int method_7675() {
                    return 1;
                }

                public boolean method_7680(class_1799 stack) {
                    return CommonAbstractions.INSTANCE.canEquip(stack, equipmentslot, (class_1297)inventory.field_7546);
                }

                public boolean method_7674(class_1657 player) {
                    class_1799 itemstack = this.method_7677();
                    return (itemstack.method_7960() || player.method_7337() || !class_1890.method_8224((class_1799)itemstack)) && super.method_7674(player);
                }

                public Pair<class_2960, class_2960> method_7679() {
                    return Pair.of((Object)class_1723.field_21668, (Object)TEXTURE_EMPTY_SLOTS[equipmentslot.method_5927()]);
                }
            });
        }
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.method_7621(new class_1735((class_1263)inventory, j1 + (l + 1) * 9, 30 + j1 * 18, 103 + l * 18));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.method_7621(new class_1735((class_1263)inventory, i1, 30 + i1 * 18, 161));
        }
        this.method_7621(new class_1735((class_1263)inventory, 40, 8, 161){

            public Pair<class_2960, class_2960> method_7679() {
                return Pair.of((Object)class_1723.field_21668, (Object)class_1723.field_21673);
            }
        });
        this.method_17362(this.enchantingPower);
        this.method_17362(this.enchantingCost);
        this.method_17362(this.repairCost);
        this.method_7596(this);
    }

    public boolean method_7597(class_1657 pPlayer) {
        return this.enchantSlots.method_5443(pPlayer);
    }

    public void method_7609(class_1263 pInventory) {
        if (pInventory == this.enchantSlots) {
            this.enchantingCost.method_17404(0);
            this.repairCost.method_17404(0);
            class_1799 itemstack = pInventory.method_5438(0);
            if (!itemstack.method_7960() && this.mayEnchantStack(itemstack)) {
                this.levelAccess.method_17393((level, pos) -> {
                    this.setEnchantingPower((class_1937)level, (class_2338)pos);
                    this.setRepairCost();
                    List<class_1887> availableEnchantments = EnchantmentUtil.getAvailableEnchantments(itemstack, this.config.types.allowAnvilEnchantments, this.config.types.allowTreasureEnchantments, this.config.types.allowUndiscoverableEnchantments, this.config.types.allowUntradeableEnchantments, this.config.types.allowCursesEnchantments);
                    this.setAndSyncEnchantments(EnchantmentUtil.copyEnchantmentsToMap(itemstack, availableEnchantments));
                });
            } else {
                this.setAndSyncEnchantments(Map.of());
            }
        }
    }

    private boolean mayEnchantStack(class_1799 stack) {
        if (this.config.allowBooks) {
            if (stack.method_7909() instanceof class_1751) {
                return true;
            }
            if (stack.method_7909() instanceof class_1772) {
                return this.config.allowModifyingEnchantments != ServerConfig.ModifiableItems.UNENCHANTED;
            }
        } else if (stack.method_7909() instanceof class_1751 || stack.method_7909() instanceof class_1772) {
            return false;
        }
        return switch (this.config.allowModifyingEnchantments) {
            default -> throw new IncompatibleClassChangeError();
            case ServerConfig.ModifiableItems.ALL -> {
                if (stack.method_7923() || stack.method_7942()) {
                    yield true;
                }
                yield false;
            }
            case ServerConfig.ModifiableItems.FULL_DURABILITY -> {
                if ((stack.method_7923() || stack.method_7942()) && !stack.method_7986()) {
                    yield true;
                }
                yield false;
            }
            case ServerConfig.ModifiableItems.UNENCHANTED -> stack.method_7923();
        };
    }

    public void method_7635(class_1703 abstractContainerMenu, int i, class_1799 itemStack) {
        if (abstractContainerMenu == this) {
            this.levelAccess.method_17393((level, pos) -> {
                if (i == 0) {
                    this.method_7609(this.enchantSlots);
                }
            });
        }
    }

    public int setEnchantingPower(class_1937 level, class_2338 pos) {
        int power = this.getAvailablePower(level, pos);
        this.setEnchantingPower(power);
        return power;
    }

    public int setRepairCost() {
        int repairCost = this.calculateRepairCost();
        this.setRepairCost(repairCost);
        return repairCost;
    }

    public void setEnchantingPower(int power) {
        this.enchantingPower.method_17404(power);
    }

    public void setRepairCost(int repairCost) {
        this.repairCost.method_17404(repairCost);
    }

    public void method_7633(class_1703 abstractContainerMenu, int i, int j) {
    }

    private int getAvailablePower(class_1937 level, class_2338 pos) {
        float power = 0.0f;
        float maxPowerScale = 1.0f;
        for (class_2338 blockpos : class_2331.field_36535) {
            if (!InfuserMenu.isValidBookShelf(level, pos, blockpos)) continue;
            class_2680 state = level.method_8320(pos.method_10081((class_2382)blockpos));
            power += EnchantingInfuserAPI.getEnchantStatsProvider().getEnchantPowerBonus(state, level, pos.method_10081((class_2382)blockpos));
            maxPowerScale = Math.max(maxPowerScale, EnchantingInfuserAPI.getEnchantStatsProvider().getMaximumEnchantPowerScale(state, level, pos.method_10081((class_2382)blockpos)));
        }
        return (int)Math.min(Math.max(0.0f, power), (float)this.config.maximumBookshelves * maxPowerScale);
    }

    public static boolean isValidBookShelf(class_1937 level, class_2338 center, class_2338 offset) {
        return EnchantingInfuserAPI.getEnchantStatsProvider().getEnchantPowerBonus(level.method_8320(center.method_10081((class_2382)offset)), level, center.method_10081((class_2382)offset)) != 0.0f && InfuserMenu.blockWithoutCollision(level, center.method_10069(offset.method_10263() / 2, offset.method_10264(), offset.method_10260() / 2));
    }

    public static boolean blockWithoutCollision(class_1937 level, class_2338 pos) {
        return level.method_8320(pos).method_26220((class_1922)level, pos).method_1110();
    }

    public int clickEnchantmentLevelButton(class_1657 player, class_1887 enchantment, boolean increase) {
        boolean incompatible = this.enchantmentsToLevel.entrySet().stream().filter(e -> (Integer)e.getValue() > 0).map(Map.Entry::getKey).filter(e -> e != enchantment).anyMatch(e -> !EnchantingInfuserAPI.getEnchantStatsProvider().isCompatibleWith((class_1887)e, enchantment));
        if (incompatible) {
            EnchantingInfuser.LOGGER.warn("trying to add incompatible enchantment");
            return -1;
        }
        int enchantmentLevel = this.enchantmentsToLevel.get(enchantment) + (increase ? 1 : -1);
        if (enchantmentLevel != class_3532.method_15340((int)enchantmentLevel, (int)0, (int)EnchantingInfuserAPI.getEnchantStatsProvider().getMaxLevel(enchantment))) {
            EnchantingInfuser.LOGGER.warn("trying change enchantment level beyond bounds");
            return -1;
        }
        if (enchantmentLevel > (Integer)this.getMaxLevel(enchantment).getSecond()) {
            EnchantingInfuser.LOGGER.warn("trying change enchantment level beyond max allowed level");
            return -1;
        }
        this.enchantmentsToLevel.put(enchantment, enchantmentLevel);
        this.enchantingCost.method_17404(this.calculateEnchantCost());
        return enchantmentLevel;
    }

    public boolean method_7604(class_1657 player, int id) {
        return switch (id) {
            case 0 -> this.clickEnchantButton(player);
            case 1 -> this.clickRepairButton(player);
            default -> false;
        };
    }

    private boolean clickEnchantButton(class_1657 player) {
        class_1799 itemstack = this.enchantSlots.method_5438(0);
        int cost = this.calculateEnchantCost();
        if (itemstack.method_7960() || !this.enchantmentsChanged || player.field_7520 < cost && !player.method_31549().field_7477) {
            return false;
        }
        this.levelAccess.method_17393((level, pos) -> {
            class_1799 itemstack2 = itemstack;
            if (cost < 0) {
                class_1303.method_31493((class_3218)((class_3218)level), (class_243)class_243.method_24953((class_2382)pos), (int)this.calculateExperienceDelta(this.enchantmentsToLevel, this.enchantmentsToLevelBase, level.field_9229));
            } else if (!player.method_31549().field_7477) {
                player.method_7316(-cost);
            }
            itemstack2 = EnchantmentUtil.setNewEnchantments(itemstack2, this.enchantmentsToLevel, this.enchantingBaseCost != 0);
            this.enchantSlots.method_5447(0, itemstack2);
            player.method_7281(class_3468.field_15420);
            if (player instanceof class_3222) {
                class_174.field_1181.method_8870((class_3222)player, itemstack2, cost);
            }
            this.enchantSlots.method_5431();
            this.method_7609(this.enchantSlots);
            level.method_8396(null, pos, class_3417.field_15119, class_3419.field_15245, 1.0f, level.field_9229.method_43057() * 0.1f + 0.9f);
        });
        return true;
    }

    private boolean clickRepairButton(class_1657 player) {
        if (!this.config.allowRepairing) {
            return false;
        }
        class_1799 itemstack = this.enchantSlots.method_5438(0);
        if (itemstack.method_7960() || !itemstack.method_7986()) {
            return false;
        }
        double repairStep = (double)itemstack.method_7936() * this.config.repair.repairPercentageStep;
        int repairCost = (int)Math.ceil(Math.ceil((double)itemstack.method_7919() / repairStep) * this.config.repair.repairStepMultiplier);
        if (player.field_7520 >= repairCost || player.method_31549().field_7477) {
            this.levelAccess.method_17393((level, pos) -> {
                if (!player.method_31549().field_7477) {
                    player.method_7316(-repairCost);
                }
                class_1799 itemstack2 = itemstack.method_7972();
                itemstack2.method_7974(0);
                itemstack2.method_7927(class_1706.method_20398((int)itemstack.method_7928()));
                this.enchantSlots.method_5447(0, itemstack2);
                level.method_20290(1030, pos, 0);
            });
        }
        return true;
    }

    public int calculateRepairCost() {
        class_1799 itemstack = this.enchantSlots.method_5438(0);
        if (itemstack.method_7960() || !itemstack.method_7986()) {
            return 0;
        }
        double repairStep = (double)itemstack.method_7936() * this.config.repair.repairPercentageStep;
        return (int)Math.ceil(Math.ceil((double)itemstack.method_7919() / repairStep) * this.config.repair.repairStepMultiplier);
    }

    public Pair<OptionalInt, Integer> getMaxLevel(class_1887 enchantment) {
        int maxPower;
        int currentPower = this.getCurrentPower();
        Pair<OptionalInt, Integer> maxLevelSpecial = this.getSpecialMaxLevel(enchantment, currentPower, maxPower = this.getMaxPower());
        if (maxLevelSpecial != null) {
            return maxLevelSpecial;
        }
        int minPowerByRarity = this.getMinPowerByRarity(enchantment, maxPower);
        if (currentPower < minPowerByRarity) {
            return Pair.of((Object)OptionalInt.of(minPowerByRarity), (Object)0);
        }
        int totalLevels = EnchantingInfuserAPI.getEnchantStatsProvider().getMaxLevel(enchantment) - EnchantingInfuserAPI.getEnchantStatsProvider().getMinLevel(enchantment);
        double levelRange = (double)maxPower * this.config.power.rarityRange;
        double levelPercentile = totalLevels > 0 ? levelRange / (double)totalLevels : 0.0;
        for (int i = 0; i <= totalLevels; ++i) {
            int nextPower = Math.min(maxPower, (int)Math.ceil((double)minPowerByRarity + (double)i * levelPercentile));
            if (currentPower >= nextPower) continue;
            return Pair.of((Object)OptionalInt.of(nextPower), (Object)(EnchantingInfuserAPI.getEnchantStatsProvider().getMinLevel(enchantment) + i - 1));
        }
        return Pair.of((Object)OptionalInt.of(maxPower), (Object)EnchantingInfuserAPI.getEnchantStatsProvider().getMaxLevel(enchantment));
    }

    private Pair<OptionalInt, Integer> getSpecialMaxLevel(class_1887 enchantment, int currentPower, int maxPower) {
        double multiplier = -1.0;
        if (EnchantingInfuserAPI.getEnchantStatsProvider().isCurse(enchantment)) {
            multiplier = this.config.power.curseMultiplier;
        } else if (!EnchantingInfuserAPI.getEnchantStatsProvider().isDiscoverable(enchantment)) {
            multiplier = this.config.power.undiscoverableMultiplier;
        } else if (!EnchantingInfuserAPI.getEnchantStatsProvider().isTradeable(enchantment)) {
            multiplier = this.config.power.untradeableMultiplier;
        } else if (EnchantingInfuserAPI.getEnchantStatsProvider().isTreasureOnly(enchantment)) {
            multiplier = this.config.power.treasureMultiplier;
        }
        if (multiplier != -1.0) {
            int nextPower = (int)Math.round((double)maxPower * multiplier);
            return currentPower < nextPower ? Pair.of((Object)OptionalInt.of(nextPower), (Object)0) : Pair.of((Object)OptionalInt.empty(), (Object)EnchantingInfuserAPI.getEnchantStatsProvider().getMaxLevel(enchantment));
        }
        return null;
    }

    private int getMinPowerByRarity(class_1887 enchantment, int maxPower) {
        double d = maxPower;
        return (int)Math.round(d * (switch (EnchantingInfuserAPI.getEnchantStatsProvider().getRarity(enchantment)) {
            default -> throw new IncompatibleClassChangeError();
            case class_1887.class_1888.field_9087 -> this.config.power.commonMultiplier;
            case class_1887.class_1888.field_9090 -> this.config.power.uncommonMultiplier;
            case class_1887.class_1888.field_9088 -> this.config.power.rareMultiplier;
            case class_1887.class_1888.field_9091 -> this.config.power.veryRareMultiplier;
        }));
    }

    private int calculateEnchantCost() {
        this.markChanged();
        int cost = this.getScaledCosts(this.enchantmentsToLevel) - this.enchantingBaseCost;
        if (cost == 0 && this.enchantmentsChanged) {
            ++cost;
        }
        return cost;
    }

    private int calculateExperienceDelta(Map<class_1887, Integer> current, Map<class_1887, Integer> base, class_5819 random) {
        if (current.size() != base.size()) {
            throw new IllegalStateException("Enchantment map size mismatch!");
        }
        int experience = 0;
        for (Map.Entry<class_1887, Integer> entry : current.entrySet()) {
            int currentLevel;
            int baseLevel;
            class_1887 enchantment = entry.getKey();
            if (!base.containsKey(enchantment) || (baseLevel = base.get(enchantment).intValue()) <= (currentLevel = entry.getValue().intValue())) continue;
            experience += Math.max(0, EnchantingInfuserAPI.getEnchantStatsProvider().getMinCost(enchantment, baseLevel) - EnchantingInfuserAPI.getEnchantStatsProvider().getMinCost(enchantment, currentLevel));
        }
        if (experience > 0) {
            int half = (int)Math.ceil((double)experience / 2.0);
            return half + random.method_43048(half);
        }
        return 0;
    }

    private void markChanged() {
        this.enchantmentsChanged = !this.enchantmentsToLevel.equals(this.enchantmentsToLevelBase);
    }

    private int getScaledCosts(Map<class_1887, Integer> enchantmentsToLevel) {
        double totalCosts = this.getTotalCosts(enchantmentsToLevel);
        int maxCost = (int)((float)this.config.costs.maximumCost * EnchantingInfuserAPI.getEnchantStatsProvider().getMaximumCostMultiplier());
        class_1792 item = this.enchantSlots.method_5438(0).method_7909();
        if (totalCosts > (double)maxCost && !(item instanceof class_1751) && !(item instanceof class_1772)) {
            double ratio = (double)maxCost / totalCosts;
            int minCosts = enchantmentsToLevel.values().stream().mapToInt(Integer::intValue).sum();
            return Math.max((int)Math.round((double)this.getAllCosts(enchantmentsToLevel) * ratio), minCosts);
        }
        return this.getAllCosts(enchantmentsToLevel);
    }

    private int getTotalCosts(Map<class_1887, Integer> enchantmentsToLevel) {
        HashMap map = Maps.newHashMap();
        for (class_1887 enchantment : enchantmentsToLevel.keySet()) {
            boolean scaleCosts;
            boolean bl = scaleCosts = !this.config.costs.scaleCostsByVanillaOnly;
            if (!scaleCosts) {
                String namespace = class_2378.field_11160.method_10221((Object)enchantment).method_12836();
                for (String scalingNamespace : EnchantingInfuserAPI.getEnchantStatsProvider().getScalingNamespaces()) {
                    if (!namespace.equals(scalingNamespace)) continue;
                    scaleCosts = true;
                    break;
                }
            }
            if (!scaleCosts) continue;
            Pair pair2 = Pair.of((Object)EnchantingInfuserAPI.getEnchantStatsProvider().getRarity(enchantment), (Object)EnchantingInfuserAPI.getEnchantStatsProvider().getMaxLevel(enchantment));
            Optional<Map.Entry> any = map.entrySet().stream().filter(e -> !EnchantingInfuserAPI.getEnchantStatsProvider().isCompatibleWith((class_1887)e.getKey(), enchantment)).findAny();
            if (any.isPresent()) {
                Map.Entry enchantmentData = any.get();
                Pair pair1 = (Pair)enchantmentData.getValue();
                map.put((class_1887)enchantmentData.getKey(), this.compareEnchantmentData((Pair<class_1887.class_1888, Integer>)pair1, (Pair<class_1887.class_1888, Integer>)pair2));
                continue;
            }
            map.put(enchantment, pair2);
        }
        return map.values().stream().mapToInt(e -> this.getRarityCost((class_1887.class_1888)e.getFirst()) * (Integer)e.getSecond()).sum();
    }

    private Pair<class_1887.class_1888, Integer> compareEnchantmentData(Pair<class_1887.class_1888, Integer> pair1, Pair<class_1887.class_1888, Integer> pair2) {
        int cost1 = this.getRarityCost((class_1887.class_1888)pair1.getFirst()) * (Integer)pair1.getSecond();
        int cost2 = this.getRarityCost((class_1887.class_1888)pair2.getFirst()) * (Integer)pair2.getSecond();
        return cost2 > cost1 ? pair2 : pair1;
    }

    private int getAllCosts(Map<class_1887, Integer> enchantmentsToLevel) {
        return enchantmentsToLevel.entrySet().stream().filter(entry -> (Integer)entry.getValue() > 0).mapToInt(entry -> this.getAdjustedRarityCost((class_1887)entry.getKey()) * (Integer)entry.getValue()).sum();
    }

    private int getAdjustedRarityCost(class_1887 enchantment) {
        int cost = this.getRarityCost(EnchantingInfuserAPI.getEnchantStatsProvider().getRarity(enchantment));
        if (!(!this.config.costs.doubleUniques || !EnchantingInfuserAPI.getEnchantStatsProvider().isTreasureOnly(enchantment) && EnchantingInfuserAPI.getEnchantStatsProvider().isDiscoverable(enchantment) && EnchantingInfuserAPI.getEnchantStatsProvider().isTradeable(enchantment) || EnchantingInfuserAPI.getEnchantStatsProvider().isCurse(enchantment))) {
            cost *= 2;
        }
        return cost;
    }

    private int getRarityCost(class_1887.class_1888 rarity) {
        return switch (rarity) {
            default -> throw new IncompatibleClassChangeError();
            case class_1887.class_1888.field_9087 -> this.config.costs.commonCostMultiplier;
            case class_1887.class_1888.field_9090 -> this.config.costs.uncommonCostMultiplier;
            case class_1887.class_1888.field_9088 -> this.config.costs.rareCostMultiplier;
            case class_1887.class_1888.field_9091 -> this.config.costs.veryRareCostMultiplier;
        };
    }

    public class_1799 method_7601(class_1657 pPlayer, int pIndex) {
        class_1799 itemstack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(pIndex);
        if (slot != null && slot.method_7681()) {
            class_1799 itemstack1 = slot.method_7677();
            itemstack = itemstack1.method_7972();
            class_1304 equipmentslot = class_1308.method_32326((class_1799)itemstack);
            if (pIndex == 0) {
                if (equipmentslot.method_5925() == class_1304.class_1305.field_6178 && !((class_1735)this.field_7761.get(4 - equipmentslot.method_5927())).method_7681()) {
                    int i = 4 - equipmentslot.method_5927();
                    if (!this.method_7616(itemstack1, i, i + 1, false)) {
                        slot.method_7667(pPlayer, itemstack1);
                        return class_1799.field_8037;
                    }
                } else if (equipmentslot == class_1304.field_6171 && !((class_1735)this.field_7761.get(41)).method_7681() && !this.method_7616(itemstack1, 41, 42, false)) {
                    slot.method_7667(pPlayer, itemstack1);
                    return class_1799.field_8037;
                }
                if (!this.method_7616(itemstack1, 5, 41, true)) {
                    slot.method_7667(pPlayer, itemstack1);
                    return class_1799.field_8037;
                }
            } else {
                if (((class_1735)this.field_7761.get(0)).method_7681()) {
                    return class_1799.field_8037;
                }
                class_1799 itemstack2 = itemstack1.method_7972();
                itemstack2.method_7939(1);
                itemstack1.method_7934(1);
                ((class_1735)this.field_7761.get(0)).method_7673(itemstack2);
            }
            if (itemstack1.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
            if (itemstack1.method_7947() == itemstack.method_7947()) {
                return class_1799.field_8037;
            }
            slot.method_7667(pPlayer, itemstack1);
        }
        return itemstack;
    }

    public int getCurrentPower() {
        return Math.min(this.enchantingPower.method_17407(), this.getMaxPower());
    }

    public int getMaxPower() {
        int maximumEnchantPower = EnchantingInfuserAPI.getEnchantStatsProvider().getMaximumEnchantPower();
        if (maximumEnchantPower != -1) {
            return maximumEnchantPower;
        }
        return this.config.maximumBookshelves;
    }

    public class_1799 getEnchantableStack() {
        return this.enchantSlots.method_5438(0);
    }

    public int getEnchantCost() {
        return this.enchantingCost.method_17407();
    }

    public int getRepairCost() {
        return this.repairCost.method_17407();
    }

    public boolean canEnchant(class_1657 player) {
        if (!this.enchantSlots.method_5438(0).method_7960() && this.enchantmentsChanged) {
            return player.field_7520 >= this.getEnchantCost() || player.method_31549().field_7477;
        }
        return false;
    }

    public boolean canRepair(class_1657 player) {
        if (!this.enchantSlots.method_5438(0).method_7960() && this.enchantSlots.method_5438(0).method_7986()) {
            return player.field_7520 >= this.getRepairCost() || player.method_31549().field_7477;
        }
        return false;
    }

    public Map<class_1887, Integer> getValidEnchantments() {
        return ImmutableMap.copyOf(this.enchantmentsToLevel);
    }

    public List<Map.Entry<class_1887, Integer>> getSortedEntries() {
        return this.enchantmentsToLevel.entrySet().stream().sorted(Comparator.comparingInt(e -> EnchantingInfuserAPI.getEnchantStatsProvider().getRarity((class_1887)e.getKey()).ordinal()).thenComparing(e -> class_2561.method_43471((String)((class_1887)e.getKey()).method_8184()).getString())).collect(Collectors.toList());
    }

    public void setAndSyncEnchantments(Map<class_1887, Integer> enchantmentsToLevel) {
        this.enchantmentsToLevel = enchantmentsToLevel;
        this.enchantmentsToLevelBase = ImmutableMap.copyOf(enchantmentsToLevel);
        this.enchantingBaseCost = this.getScaledCosts(enchantmentsToLevel);
        this.markChanged();
        this.levelAccess.method_17393((level, blockPos) -> EnchantingInfuser.NETWORK.sendTo((Message)new S2CCompatibleEnchantsMessage(this.field_7763, enchantmentsToLevel), (class_3222)this.player));
    }
}

