/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantinginfuser.util;

import com.google.common.collect.Lists;
import fuzs.enchantinginfuser.api.EnchantingInfuserAPI;
import fuzs.enchantinginfuser.core.CommonAbstractions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1706;
import net.minecraft.class_1751;
import net.minecraft.class_1772;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class EnchantmentUtil {
    public static List<class_1887> getAvailableEnchantments(class_1799 stack, boolean allowAnvil, boolean allowTreasure, boolean allowUndiscoverable, boolean allowUntradeable, boolean allowCurse) {
        ArrayList list = Lists.newArrayList();
        boolean book = stack.method_7909() instanceof class_1751 || stack.method_7909() instanceof class_1772;
        for (class_1887 enchantment : class_2378.field_11160) {
            if (!(!allowAnvil ? CommonAbstractions.INSTANCE.canApplyAtEnchantingTable(enchantment, stack) : enchantment.method_8192(stack))) {
                if (!book || !CommonAbstractions.INSTANCE.isAllowedOnBooks(enchantment)) continue;
            }
            if (!EnchantingInfuserAPI.getEnchantStatsProvider().isDiscoverable(enchantment) ? !allowUndiscoverable : (!EnchantingInfuserAPI.getEnchantStatsProvider().isTradeable(enchantment) ? !allowUntradeable : (EnchantingInfuserAPI.getEnchantStatsProvider().isCurse(enchantment) ? !allowCurse : EnchantingInfuserAPI.getEnchantStatsProvider().isTreasureOnly(enchantment) && !allowTreasure))) continue;
            list.add(enchantment);
        }
        return list;
    }

    public static Map<class_1887, Integer> copyEnchantmentsToMap(class_1799 stack, List<class_1887> enchantments) {
        Map<class_1887, Integer> enchantmentsToLevel = enchantments.stream().collect(Collectors.toMap(Function.identity(), enchantment -> 0));
        if (stack.method_7942() || stack.method_7909() instanceof class_1772) {
            for (Map.Entry entry : class_1890.method_8222((class_1799)stack).entrySet()) {
                if (!enchantmentsToLevel.containsKey(entry.getKey())) continue;
                enchantmentsToLevel.put((class_1887)entry.getKey(), (Integer)entry.getValue());
            }
        }
        return enchantmentsToLevel;
    }

    public static class_1799 setNewEnchantments(class_1799 stack, Map<class_1887, Integer> newEnchantments, boolean increaseRepairCost) {
        for (Map.Entry entry : class_1890.method_8222((class_1799)stack).entrySet()) {
            if (newEnchantments.containsKey(entry.getKey())) continue;
            newEnchantments.put((class_1887)entry.getKey(), (Integer)entry.getValue());
        }
        Map<class_1887, Integer> enchantmentsToLevel = newEnchantments.entrySet().stream().filter(e -> (Integer)e.getValue() > 0).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        class_1799 newStack = EnchantmentUtil.getNewEnchantmentStack(stack, !enchantmentsToLevel.isEmpty(), true);
        newStack.method_7983("Enchantments");
        newStack.method_7983("StoredEnchantments");
        class_1890.method_8214(enchantmentsToLevel, (class_1799)newStack);
        if (increaseRepairCost) {
            newStack.method_7927(class_1706.method_20398((int)stack.method_7928()));
        }
        return newStack;
    }

    public static class_1799 getNewEnchantmentStack(class_1799 stack, boolean enchanted, boolean copyResult) {
        class_1799 newStack;
        if (stack.method_7909() instanceof class_1772 && !enchanted) {
            newStack = new class_1799((class_1935)class_1802.field_8529);
        } else if (stack.method_7909() instanceof class_1751 && enchanted) {
            newStack = new class_1799((class_1935)class_1802.field_8598);
        } else {
            return copyResult ? stack.method_7972() : stack;
        }
        class_2487 compoundtag = stack.method_7969();
        if (compoundtag != null) {
            newStack.method_7980(compoundtag.method_10553());
        }
        return newStack;
    }

    public static class_5250 getPlainEnchantmentName(class_1887 enchantment, int level) {
        class_5250 mutablecomponent = class_2561.method_43471((String)enchantment.method_8184());
        if (level != -1 && (level != 1 || EnchantingInfuserAPI.getEnchantStatsProvider().getMaxLevel(enchantment) != 1)) {
            mutablecomponent.method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)("enchantment.level." + level)));
        }
        return mutablecomponent;
    }
}

