/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantinginfuser.client.gui.screens.inventory;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import fuzs.enchantinginfuser.EnchantingInfuser;
import fuzs.enchantinginfuser.api.EnchantingInfuserAPI;
import fuzs.enchantinginfuser.client.gui.components.IconButton;
import fuzs.enchantinginfuser.network.client.C2SAddEnchantLevelMessage;
import fuzs.enchantinginfuser.util.EnchantmentUtil;
import fuzs.enchantinginfuser.world.inventory.InfuserMenu;
import fuzs.puzzleslib.network.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1772;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1814;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_362;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4068;
import net.minecraft.class_4069;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_487;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import net.minecraft.class_757;

public class InfuserScreen
extends class_465<InfuserMenu> {
    private static final class_2960 INFUSER_LOCATION = new class_2960("enchantinginfuser", "textures/gui/container/enchanting_infuser.png");
    private static final int BUTTONS_OFFSET_X = 7;
    private static final int ENCHANT_BUTTON_OFFSET_Y = 44;
    private static final int ENCHANT_ONLY_BUTTON_OFFSET_Y = 55;
    private static final int REPAIR_BUTTON_OFFSET_Y = 66;
    private final int enchantmentSeed = new Random().nextInt();
    private List<class_5481> activeTooltip;
    private boolean insufficientPower;
    private float scrollOffs;
    private boolean scrolling;
    private class_342 searchBox;
    private ScrollingList scrollingList;
    private boolean ignoreTextInput;
    private class_4185 enchantButton;
    private class_4185 repairButton;

    public InfuserScreen(InfuserMenu pMenu, class_1661 pPlayerInventory, class_2561 pTitle) {
        super((class_1703)pMenu, pPlayerInventory, pTitle);
        this.field_2792 = 220;
        this.field_2779 = 185;
        this.field_25269 = 30;
        this.field_25270 = this.field_2779 - 94;
    }

    public void method_37432() {
        super.method_37432();
        this.searchBox.method_1865();
        this.updateButtons();
    }

    protected void method_25426() {
        super.method_25426();
        this.field_22787.field_1774.method_1462(true);
        this.searchBox = new class_342(this.field_22793, this.field_2776 + 67, this.field_2800 + 6, 116, 9, (class_2561)class_2561.method_43471((String)"itemGroup.search")){

            public boolean method_25402(double mouseX, double mouseY, int button) {
                if (this.method_1885() && button == 1) {
                    this.method_1852("");
                    InfuserScreen.this.refreshSearchResults();
                }
                return super.method_25402(mouseX, mouseY, button);
            }
        };
        this.searchBox.method_1880(50);
        this.searchBox.method_1858(false);
        this.searchBox.method_1868(0xFFFFFF);
        this.method_25429((class_364)this.searchBox);
        this.scrollingList = new ScrollingList(this.field_2776 + 29, this.field_2800 + 17, 162, 18, 4);
        this.method_25429((class_364)this.scrollingList);
        this.enchantButton = (class_4185)this.method_37063((class_364)new IconButton(this.field_2776 + 7, this.field_2800 + (((InfuserMenu)this.field_2797).config.allowRepairing ? 44 : 55), 18, 18, 126, 185, INFUSER_LOCATION, button -> {
            if (((InfuserMenu)this.field_2797).method_7604((class_1657)this.field_22787.field_1724, 0)) {
                this.field_22787.field_1761.method_2900(((InfuserMenu)this.field_2797).field_7763, 0);
            }
            this.searchBox.method_1852("");
        }));
        if (((InfuserMenu)this.field_2797).config.allowRepairing) {
            this.repairButton = (class_4185)this.method_37063((class_364)new IconButton(this.field_2776 + 7, this.field_2800 + 66, 18, 18, 144, 185, INFUSER_LOCATION, button -> {
                if (((InfuserMenu)this.field_2797).method_7604((class_1657)this.field_22787.field_1724, 1)) {
                    this.field_22787.field_1761.method_2900(((InfuserMenu)this.field_2797).field_7763, 1);
                }
            }));
        }
        this.updateButtons();
    }

    private void updateButtons() {
        this.enchantButton.field_22763 = ((InfuserMenu)this.field_2797).canEnchant((class_1657)this.field_22787.field_1724);
        if (this.repairButton != null) {
            this.repairButton.field_22763 = ((InfuserMenu)this.field_2797).canRepair((class_1657)this.field_22787.field_1724);
        }
    }

    public void setActiveTooltip(List<class_5481> activeTooltip) {
        this.activeTooltip = activeTooltip;
    }

    public void method_25410(class_310 pMinecraft, int pWidth, int pHeight) {
        String s = this.searchBox.method_1882();
        super.method_25410(pMinecraft, pWidth, pHeight);
        this.searchBox.method_1852(s);
        this.refreshSearchResults();
    }

    public void method_25432() {
        super.method_25432();
        this.field_22787.field_1774.method_1462(false);
    }

    public boolean method_25400(char pCodePoint, int pModifiers) {
        if (this.ignoreTextInput) {
            return false;
        }
        String s = this.searchBox.method_1882();
        if (this.searchBox.method_25400(pCodePoint, pModifiers)) {
            if (!Objects.equals(s, this.searchBox.method_1882())) {
                this.refreshSearchResults();
            }
            return true;
        }
        return false;
    }

    public boolean method_25404(int pKeyCode, int pScanCode, int pModifiers) {
        this.ignoreTextInput = false;
        if (!this.searchBox.method_25370()) {
            if (this.field_22787.field_1690.field_1890.method_1417(pKeyCode, pScanCode)) {
                this.ignoreTextInput = true;
                this.searchBox.method_1876(true);
                return true;
            }
            return super.method_25404(pKeyCode, pScanCode, pModifiers);
        }
        boolean flag = this.field_2787 != null && this.field_2787.method_7681();
        boolean flag1 = class_3675.method_15985((int)pKeyCode, (int)pScanCode).method_30103().isPresent();
        if (flag && flag1 && this.method_2384(pKeyCode, pScanCode)) {
            this.ignoreTextInput = true;
            return true;
        }
        String s = this.searchBox.method_1882();
        if (this.searchBox.method_25404(pKeyCode, pScanCode, pModifiers)) {
            if (!Objects.equals(s, this.searchBox.method_1882())) {
                this.refreshSearchResults();
            }
            return true;
        }
        return this.searchBox.method_25370() && this.searchBox.method_1885() && pKeyCode != 256 || super.method_25404(pKeyCode, pScanCode, pModifiers);
    }

    public boolean method_16803(int pKeyCode, int pScanCode, int pModifiers) {
        this.ignoreTextInput = false;
        return super.method_16803(pKeyCode, pScanCode, pModifiers);
    }

    public void refreshSearchResults() {
        this.scrollingList.clearEntries();
        String s = this.searchBox.method_1882().toLowerCase(Locale.ROOT).trim();
        if (s.isEmpty()) {
            ((InfuserMenu)this.field_2797).getSortedEntries().stream().map(e -> new EnchantmentListEntry((class_1887)e.getKey(), (Integer)e.getValue())).forEach(this.scrollingList::addEntry);
        } else {
            ((InfuserMenu)this.field_2797).getSortedEntries().stream().filter(e -> class_2561.method_43471((String)((class_1887)e.getKey()).method_8184()).getString().toLowerCase(Locale.ROOT).contains(s)).filter(e -> (Integer)((InfuserMenu)this.field_2797).getMaxLevel((class_1887)e.getKey()).getSecond() > 0).map(e -> new EnchantmentListEntry((class_1887)e.getKey(), (Integer)e.getValue())).forEach(this.scrollingList::addEntry);
        }
        this.scrollOffs = 0.0f;
        this.scrollingList.scrollTo(0.0f);
    }

    public boolean method_25402(double pMouseX, double pMouseY, int pButton) {
        if (pButton == 0 && this.insideScrollbar(pMouseX, pMouseY)) {
            this.scrolling = this.scrollingList.canScroll();
            return true;
        }
        return super.method_25402(pMouseX, pMouseY, pButton);
    }

    protected boolean insideScrollbar(double pMouseX, double pMouseY) {
        int fromX = this.field_2776 + 197;
        int fromY = this.field_2800 + 17;
        int toX = fromX + 14;
        int toY = fromY + 72;
        return pMouseX >= (double)fromX && pMouseY >= (double)fromY && pMouseX < (double)toX && pMouseY < (double)toY;
    }

    public boolean method_25406(double pMouseX, double pMouseY, int pButton) {
        if (pButton == 0) {
            this.scrolling = false;
        }
        return super.method_25406(pMouseX, pMouseY, pButton);
    }

    public boolean method_25401(double pMouseX, double pMouseY, double pDelta) {
        if (!this.scrollingList.canScroll()) {
            return false;
        }
        this.scrollOffs = (float)((double)this.scrollOffs - pDelta / (double)(this.scrollingList.getItemCount() - 4));
        this.scrollOffs = class_3532.method_15363((float)this.scrollOffs, (float)0.0f, (float)1.0f);
        this.scrollingList.scrollTo(this.scrollOffs);
        return true;
    }

    public boolean method_25403(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.scrolling) {
            int i = this.field_2800 + 17;
            int j = i + 72;
            this.scrollOffs = ((float)pMouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollOffs = class_3532.method_15363((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.scrollingList.scrollTo(this.scrollOffs);
            return true;
        }
        return super.method_25403(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
        this.activeTooltip = null;
        this.insufficientPower = false;
        this.method_25420(poseStack);
        super.method_25394(poseStack, mouseX, mouseY, partialTick);
        this.scrollingList.method_25394(poseStack, mouseX, mouseY, partialTick);
        this.renderEnchantingPower(poseStack, mouseX, mouseY);
        this.renderEnchantButtonCost(poseStack, mouseX, mouseY);
        this.renderRepairButtonCost(poseStack, mouseX, mouseY);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.activeTooltip != null) {
            this.method_25417(poseStack, this.activeTooltip, mouseX, mouseY);
        } else {
            this.method_2380(poseStack, mouseX, mouseY);
        }
    }

    private void renderRepairButtonCost(class_4587 poseStack, int mouseX, int mouseY) {
        if (this.repairButton == null) {
            return;
        }
        int repairCost = ((InfuserMenu)this.field_2797).getRepairCost();
        boolean canRepair = ((InfuserMenu)this.field_2797).canRepair((class_1657)this.field_22787.field_1724);
        if (!canRepair && repairCost == 0) {
            return;
        }
        int posX = this.repairButton.field_22760;
        int posY = this.repairButton.field_22761;
        if (repairCost != 0) {
            int costColor = canRepair ? class_124.field_1060.method_532() : class_124.field_1061.method_532();
            this.renderReadableText(poseStack, posX + 1, posY + 1, String.valueOf(repairCost), costColor);
        }
        if (mouseX >= posX && mouseY >= posY && mouseX < posX + 18 && mouseY < posY + 18) {
            ArrayList list = Lists.newArrayList();
            if (canRepair) {
                class_1799 stack = ((InfuserMenu)this.field_2797).getEnchantableStack();
                class_5250 nameComponent = class_2561.method_43473().method_10852(stack.method_7964()).method_27692(stack.method_7932().field_8908);
                if (stack.method_7938()) {
                    nameComponent.method_27692(class_124.field_1056);
                }
                list.add(nameComponent);
                class_5250 changeComponent = class_2561.method_43469((String)"gui.enchantinginfuser.tooltip.change", (Object[])new Object[]{stack.method_7936() - stack.method_7919(), stack.method_7936()});
                class_5250 durabilityComponent = class_2561.method_43469((String)"gui.enchantinginfuser.tooltip.durability", (Object[])new Object[]{changeComponent}).method_27692(class_124.field_1054);
                list.add(durabilityComponent);
                list.add(class_2561.method_43473());
                class_5250 levelComponent = repairCost == 1 ? class_2561.method_43471((String)"container.enchant.level.one") : class_2561.method_43469((String)"container.enchant.level.many", (Object[])new Object[]{repairCost});
                list.add(levelComponent.method_27692(class_124.field_1080));
            } else {
                list.add(class_2561.method_43469((String)"container.enchant.level.requirement", (Object[])new Object[]{repairCost}).method_27692(class_124.field_1061));
            }
            this.setActiveTooltip(class_2477.method_10517().method_30933((List)list));
        }
    }

    private void renderEnchantButtonCost(class_4587 poseStack, int mouseX, int mouseY) {
        int enchantCost = ((InfuserMenu)this.field_2797).getEnchantCost();
        boolean canEnchant = ((InfuserMenu)this.field_2797).canEnchant((class_1657)this.field_22787.field_1724);
        if (!canEnchant && enchantCost == 0) {
            return;
        }
        int posX = this.enchantButton.field_22760;
        int posY = this.enchantButton.field_22761;
        if (enchantCost != 0) {
            int costColor = enchantCost < 0 ? class_124.field_1054.method_532() : (canEnchant ? class_124.field_1060.method_532() : class_124.field_1061.method_532());
            this.renderReadableText(poseStack, posX + 1, posY + 1, enchantCost < 0 ? "+" : String.valueOf(enchantCost), costColor);
        }
        if (mouseX >= posX && mouseY >= posY && mouseX < posX + 18 && mouseY < posY + 18) {
            ArrayList list = Lists.newArrayList();
            if (canEnchant) {
                Map<class_1887, Integer> enchantments = ((InfuserMenu)this.field_2797).getValidEnchantments();
                boolean enchanted = enchantments.values().stream().anyMatch(level -> level > 0);
                class_1799 stack = ((InfuserMenu)this.field_2797).getEnchantableStack();
                class_1799 displayStack = EnchantmentUtil.getNewEnchantmentStack(stack, enchanted, false);
                class_5250 nameComponent = class_2561.method_43473().method_10852(displayStack.method_7964()).method_27692(this.getItemNameRarity((class_1799)displayStack, (boolean)enchanted).field_8908);
                if (stack.method_7938()) {
                    nameComponent.method_27692(class_124.field_1056);
                }
                list.add(nameComponent);
                this.addEnchantments(stack, enchantments, list);
                if (enchantCost != 0) {
                    list.add(class_2561.method_43473());
                    class_5250 levelComponent = enchantCost < 0 ? class_2561.method_43471((String)"gui.enchantinginfuser.tooltip.points") : (enchantCost == 1 ? class_2561.method_43471((String)"container.enchant.level.one") : class_2561.method_43469((String)"container.enchant.level.many", (Object[])new Object[]{enchantCost}));
                    list.add(levelComponent.method_27692(class_124.field_1080));
                }
            } else {
                list.add(class_2561.method_43469((String)"container.enchant.level.requirement", (Object[])new Object[]{enchantCost}).method_27692(class_124.field_1061));
            }
            this.setActiveTooltip(class_2477.method_10517().method_30933((List)list));
        }
    }

    private class_1814 getItemNameRarity(class_1799 stack, boolean enchanted) {
        class_1814 rarity = stack.method_7909().method_7862(new class_1799((class_1935)stack.method_7909()));
        if (!enchanted || stack.method_7909() instanceof class_1772) {
            return rarity;
        }
        if (rarity == class_1814.field_8903 || rarity == class_1814.field_8904) {
            return class_1814.field_8904;
        }
        return class_1814.field_8903;
    }

    private void addEnchantments(class_1799 stack, Map<class_1887, Integer> enchantments, List<class_5348> list) {
        Map oldEnchantments = class_1890.method_8222((class_1799)stack);
        ArrayList newList = Lists.newArrayList();
        ArrayList changedList = Lists.newArrayList();
        ArrayList oldList = Lists.newArrayList();
        ArrayList removedList = Lists.newArrayList();
        HashSet allEnchantments = Sets.newHashSet(enchantments.keySet());
        allEnchantments.addAll(oldEnchantments.keySet());
        for (class_1887 enchantment : allEnchantments) {
            class_5250 component;
            int oldLevel = oldEnchantments.getOrDefault(enchantment, -1);
            int newLevel = enchantments.getOrDefault(enchantment, -1);
            if (newLevel > 0 && oldLevel <= 0) {
                component = EnchantmentUtil.getPlainEnchantmentName(enchantment, newLevel);
                newList.add(component.method_27692(class_124.field_1060));
                continue;
            }
            if (newLevel == 0 && oldLevel > 0) {
                component = EnchantmentUtil.getPlainEnchantmentName(enchantment, oldLevel);
                removedList.add(component.method_27692(class_124.field_1061));
                continue;
            }
            if (newLevel > 0 && oldLevel > 0 && newLevel != oldLevel) {
                component = EnchantmentUtil.getPlainEnchantmentName(enchantment, -1);
                class_5250 changeComponent = class_2561.method_43469((String)"gui.enchantinginfuser.tooltip.change", (Object[])new Object[]{class_2561.method_43471((String)("enchantment.level." + oldLevel)), class_2561.method_43471((String)("enchantment.level." + newLevel))});
                changedList.add(component.method_27693(" ").method_10852((class_2561)changeComponent).method_27692(class_124.field_1054));
                continue;
            }
            if (newLevel <= 0 && oldLevel <= 0) continue;
            component = EnchantmentUtil.getPlainEnchantmentName(enchantment, newLevel != 0 ? newLevel : oldLevel);
            oldList.add(component.method_27692(class_124.field_1080));
        }
        list.addAll(newList);
        list.addAll(changedList);
        list.addAll(oldList);
        list.addAll(removedList);
    }

    private void renderReadableText(class_4587 poseStack, int posX, int posY, String text, int color) {
        this.field_22793.method_1729(poseStack, text, (float)((posX += 17 - this.field_22793.method_1727(text)) - 1), (float)(posY += 9), 0);
        this.field_22793.method_1729(poseStack, text, (float)(posX + 1), (float)posY, 0);
        this.field_22793.method_1729(poseStack, text, (float)posX, (float)(posY - 1), 0);
        this.field_22793.method_1729(poseStack, text, (float)posX, (float)(posY + 1), 0);
        this.field_22793.method_1729(poseStack, text, (float)posX, (float)posY, color);
    }

    private void renderEnchantingPower(class_4587 poseStack, int mouseX, int mouseY) {
        class_1799 stack = new class_1799((class_1935)class_1802.field_8536);
        this.field_22788.field_4730 = 100.0f;
        int posX = this.field_2776 + 196;
        int posY = this.field_2800 + 161;
        this.field_22788.method_27953(stack, posX, posY);
        poseStack.method_22903();
        poseStack.method_22904(0.0, 0.0, 300.0);
        int power = ((InfuserMenu)this.field_2797).getCurrentPower();
        int maxPower = ((InfuserMenu)this.field_2797).getMaxPower();
        int textColor = power >= maxPower ? class_124.field_1054.method_532() : (this.insufficientPower ? class_124.field_1061.method_532().intValue() : class_124.field_1068.method_532().intValue());
        this.field_22793.method_1720(poseStack, String.valueOf(power), (float)(posX + 19 - 2 - this.field_22793.method_1727(String.valueOf(power))), (float)(posY + 6 + 3), textColor);
        poseStack.method_22909();
        this.field_22788.field_4730 = 0.0f;
        if (mouseX >= posX && mouseY >= posY && mouseX < posX + 16 && mouseY < posY + 16) {
            ArrayList list = Lists.newArrayList();
            list.add(class_2561.method_43469((String)"gui.enchantinginfuser.tooltip.enchanting_power", (Object[])new Object[]{power, maxPower}).method_27692(class_124.field_1054).method_30937());
            list.addAll(this.field_22793.method_1728((class_5348)class_2561.method_43471((String)"gui.enchantinginfuser.tooltip.enchanting_power.hint").method_27692(class_124.field_1080), 175));
            this.setActiveTooltip(list);
        }
    }

    protected void method_2389(class_4587 pPoseStack, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)INFUSER_LOCATION);
        int i = (this.field_22789 - this.field_2792) / 2;
        int j = (this.field_22790 - this.field_2779) / 2;
        this.method_25302(pPoseStack, i, j, 0, 0, this.field_2792, this.field_2779);
        this.searchBox.method_25394(pPoseStack, pMouseX, pMouseY, pPartialTick);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)INFUSER_LOCATION);
        int sliderX = this.field_2776 + 197 - 2;
        int sliderY = this.field_2800 + 17 - 2;
        int sliderRange = sliderY + 72 + 2 + 2;
        this.method_25302(pPoseStack, sliderX, sliderY + (int)((float)(sliderRange - sliderY - 18) * this.scrollOffs), 220, 54 + (this.scrollingList.canScroll() ? 18 : 0), 18, 18);
        this.method_25302(pPoseStack, this.field_2776 + 8 - 1, this.field_2800 + (((InfuserMenu)this.field_2797).config.allowRepairing ? 23 : 34) - 1, 162, 185, 18, 18);
    }

    private class ScrollingList
    extends class_362
    implements class_4068,
    class_6379 {
        private final List<EnchantmentListEntry> children = Lists.newArrayList();
        private final int posX;
        private final int posY;
        private final int itemWidth;
        private final int itemHeight;
        private final int length;
        private int scrollPosition;

        public ScrollingList(int posX, int posY, int itemWidth, int itemHeight, int length) {
            this.posX = posX;
            this.posY = posY;
            this.itemWidth = itemWidth;
            this.itemHeight = itemHeight;
            this.length = length;
        }

        public void scrollTo(float pos) {
            if (pos < 0.0f || pos > 1.0f) {
                throw new IllegalArgumentException("pos must be of interval 0 to 1");
            }
            this.scrollPosition = this.canScroll() ? Math.round((float)(this.getItemCount() - this.length) * pos) : 0;
        }

        public boolean canScroll() {
            return this.getItemCount() > this.length;
        }

        protected final void clearEntries() {
            this.children.clear();
        }

        protected void addEntry(EnchantmentListEntry pEntry) {
            this.children.add(pEntry);
            pEntry.setList(this);
            this.markOthersIncompatible();
        }

        protected int getItemCount() {
            return this.children.size();
        }

        public void markOthersIncompatible() {
            List<EnchantmentListEntry> activeEnchants = this.children.stream().filter(EnchantmentListEntry::isActive).toList();
            for (EnchantmentListEntry entry : this.children) {
                if (entry.isActive()) continue;
                entry.markIncompatible(activeEnchants.stream().filter(e -> e.isIncompatibleWith(entry)).collect(Collectors.toSet()));
            }
        }

        @Nullable
        protected final EnchantmentListEntry getEntryAtPosition(double mouseX, double mouseY) {
            if (this.method_25405(mouseX, mouseY)) {
                int index = this.scrollPosition + (int)((mouseY - (double)this.posY) / (double)this.itemHeight);
                return index < this.children.size() ? this.children.get(index) : null;
            }
            return null;
        }

        public boolean method_25405(double mouseX, double mouseY) {
            return mouseX >= (double)this.posX && mouseX < (double)(this.posX + this.itemWidth) && mouseY >= (double)this.posY && mouseY < (double)(this.posY + this.itemHeight * this.length);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (!this.method_25405(mouseX, mouseY)) {
                return false;
            }
            EnchantmentListEntry entry = this.getEntryAtPosition(mouseX, mouseY);
            if (entry != null && entry.method_25402(mouseX, mouseY, button)) {
                this.method_25395((class_364)entry);
                this.method_25398(true);
                return true;
            }
            return false;
        }

        public boolean method_25406(double pMouseX, double pMouseY, int pButton) {
            if (this.method_25399() != null) {
                this.method_25399().method_25406(pMouseX, pMouseY, pButton);
            }
            return false;
        }

        public List<EnchantmentListEntry> method_25396() {
            return this.children;
        }

        public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
            for (int i = 0; i < Math.min(this.length, this.getItemCount()); ++i) {
                this.children.get(this.scrollPosition + i).render(poseStack, this.posX, this.posY + this.itemHeight * i, this.itemWidth, this.itemHeight, mouseX, mouseY, partialTick);
            }
        }

        public class_6379.class_6380 method_37018() {
            return class_6379.class_6380.field_33784;
        }

        public void method_37020(class_6382 pNarrationElementOutput) {
        }
    }

    private class EnchantmentListEntry
    implements class_4069 {
        private static final class_2561 UNKNOWN_ENCHANT_COMPONENT = class_2561.method_43471((String)"gui.enchantinginfuser.tooltip.unknown_enchantment").method_27692(class_124.field_1080);
        private static final class_2561 LOW_POWER_COMPONENT = class_2561.method_43471((String)"gui.enchantinginfuser.tooltip.lowPower1").method_27692(class_124.field_1080);
        private static final class_2561 LOW_POWER_2_COMPONENT = class_2561.method_43471((String)"gui.enchantinginfuser.tooltip.lowPower2").method_27692(class_124.field_1080);
        private final class_1887 enchantment;
        private final int maxLevel;
        private final int requiredPower;
        private final class_4185 decrButton;
        private final class_4185 incrButton;
        private int level;
        private ScrollingList list;
        @Nullable
        private class_364 focused;
        private boolean dragging;
        private Set<class_1887> incompatible = Sets.newHashSet();

        public EnchantmentListEntry(class_1887 enchantment, int level) {
            this.enchantment = enchantment;
            Pair<OptionalInt, Integer> maxLevelResult = ((InfuserMenu)InfuserScreen.this.field_2797).getMaxLevel(enchantment);
            this.maxLevel = (Integer)maxLevelResult.getSecond();
            this.requiredPower = ((OptionalInt)maxLevelResult.getFirst()).orElse(-1);
            this.level = level;
            this.decrButton = new IconButton(0, 0, 18, 18, 220, 0, INFUSER_LOCATION, button -> {
                do {
                    int newLevel;
                    if ((newLevel = ((InfuserMenu)InfuserScreen.this.field_2797).clickEnchantmentLevelButton((class_1657)((InfuserScreen)InfuserScreen.this).field_22787.field_1724, this.enchantment, false)) == -1) {
                        return;
                    }
                    this.level = newLevel;
                    EnchantingInfuser.NETWORK.sendToServer((Message)new C2SAddEnchantLevelMessage(((InfuserMenu)((InfuserScreen)InfuserScreen.this).field_2797).field_7763, this.enchantment, false));
                    this.updateButtons();
                    this.list.markOthersIncompatible();
                } while (button.field_22763 && button.field_22764 && class_437.method_25442());
            }, (button, matrixStack, mouseX, mouseY) -> {
                if (this.level - 1 >= this.maxLevel && !this.isObfuscated()) {
                    InfuserScreen.this.setActiveTooltip(this.getLowPowerComponent(LOW_POWER_2_COMPONENT));
                    InfuserScreen.this.insufficientPower = true;
                }
            }){

                @Override
                public void method_25359(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
                    if (this.field_22763 && class_437.method_25442()) {
                        RenderSystem.enableDepthTest();
                        RenderSystem.setShader(class_757::method_34542);
                        RenderSystem.setShaderTexture((int)0, (class_2960)this.resourceLocation);
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_22765);
                        int index = this.method_25356(this.method_25367());
                        1.method_25290((class_4587)poseStack, (int)(this.field_22760 + 2), (int)this.field_22761, (float)this.xTexStart, (float)(this.yTexStart + index * this.yDiffTex), (int)this.field_22758, (int)this.field_22759, (int)this.textureWidth, (int)this.textureHeight);
                        1.method_25290((class_4587)poseStack, (int)(this.field_22760 - 4), (int)this.field_22761, (float)this.xTexStart, (float)(this.yTexStart + index * this.yDiffTex), (int)this.field_22758, (int)this.field_22759, (int)this.textureWidth, (int)this.textureHeight);
                        if (this.method_25367()) {
                            this.method_25352(poseStack, mouseX, mouseY);
                        }
                    } else {
                        super.method_25359(poseStack, mouseX, mouseY, partialTicks);
                    }
                }
            };
            this.incrButton = new IconButton(0, 0, 18, 18, 238, 0, INFUSER_LOCATION, button -> {
                do {
                    int newLevel;
                    if ((newLevel = ((InfuserMenu)InfuserScreen.this.field_2797).clickEnchantmentLevelButton((class_1657)((InfuserScreen)InfuserScreen.this).field_22787.field_1724, this.enchantment, true)) == -1) {
                        return;
                    }
                    this.level = newLevel;
                    EnchantingInfuser.NETWORK.sendToServer((Message)new C2SAddEnchantLevelMessage(((InfuserMenu)((InfuserScreen)InfuserScreen.this).field_2797).field_7763, this.enchantment, true));
                    this.updateButtons();
                    this.list.markOthersIncompatible();
                } while (button.field_22763 && button.field_22764 && class_437.method_25442());
            }, (button, matrixStack, mouseX, mouseY) -> {
                if (this.level >= this.maxLevel && !this.isObfuscated()) {
                    InfuserScreen.this.setActiveTooltip(this.getLowPowerComponent(LOW_POWER_COMPONENT));
                    InfuserScreen.this.insufficientPower = true;
                }
            }){

                @Override
                public void method_25359(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
                    if (this.field_22763 && class_437.method_25442()) {
                        RenderSystem.enableDepthTest();
                        RenderSystem.setShader(class_757::method_34542);
                        RenderSystem.setShaderTexture((int)0, (class_2960)this.resourceLocation);
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_22765);
                        int index = this.method_25356(this.method_25367());
                        2.method_25290((class_4587)poseStack, (int)(this.field_22760 - 2), (int)this.field_22761, (float)this.xTexStart, (float)(this.yTexStart + index * this.yDiffTex), (int)this.field_22758, (int)this.field_22759, (int)this.textureWidth, (int)this.textureHeight);
                        2.method_25290((class_4587)poseStack, (int)(this.field_22760 + 4), (int)this.field_22761, (float)this.xTexStart, (float)(this.yTexStart + index * this.yDiffTex), (int)this.field_22758, (int)this.field_22759, (int)this.textureWidth, (int)this.textureHeight);
                        if (this.method_25367()) {
                            this.method_25352(poseStack, mouseX, mouseY);
                        }
                    } else {
                        super.method_25359(poseStack, mouseX, mouseY, partialTicks);
                    }
                }
            };
            this.updateButtons();
        }

        private List<class_5481> getLowPowerComponent(class_2561 component) {
            ArrayList list = Lists.newArrayList();
            list.add(class_2561.method_43469((String)"gui.enchantinginfuser.tooltip.required_enchanting_power", (Object[])new Object[]{class_2561.method_43470((String)String.valueOf(((InfuserMenu)InfuserScreen.this.field_2797).getCurrentPower())).method_27692(class_124.field_1061), class_2561.method_43470((String)String.valueOf(this.requiredPower))}).method_30937());
            list.addAll(InfuserScreen.this.field_22793.method_1728((class_5348)component, 175));
            return list;
        }

        public void setList(ScrollingList list) {
            this.list = list;
        }

        public void markIncompatible(Collection<EnchantmentListEntry> incompatibleList) {
            this.incompatible = incompatibleList.stream().map(e -> e.enchantment).collect(Collectors.toSet());
            boolean compatible = incompatibleList.isEmpty();
            if (!compatible) {
                this.level = 0;
            }
            this.updateButtons();
            this.decrButton.field_22763 = compatible;
            this.incrButton.field_22763 &= compatible;
        }

        private void updateButtons() {
            this.decrButton.field_22764 = this.level > 0;
            this.incrButton.field_22764 = this.level < EnchantingInfuserAPI.getEnchantStatsProvider().getMaxLevel(this.enchantment);
            this.decrButton.field_22763 = this.level - 1 < this.maxLevel;
            this.incrButton.field_22763 = this.level < this.maxLevel;
        }

        public boolean isActive() {
            return this.level > 0;
        }

        public boolean isIncompatible() {
            return !this.incompatible.isEmpty();
        }

        public boolean isObfuscated() {
            return this.maxLevel == 0;
        }

        private int getYImage() {
            return this.isIncompatible() || this.isObfuscated() ? 0 : (this.isActive() ? 2 : 1);
        }

        public boolean isIncompatibleWith(EnchantmentListEntry other) {
            if (other == this) {
                return false;
            }
            return (this.isActive() || other.isActive()) && !EnchantingInfuserAPI.getEnchantStatsProvider().isCompatibleWith(this.enchantment, other.enchantment);
        }

        public void render(class_4587 poseStack, int leftPos, int topPos, int width, int height, int mouseX, int mouseY, float partialTicks) {
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderTexture((int)0, (class_2960)INFUSER_LOCATION);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            InfuserScreen.this.method_25302(poseStack, leftPos + 18, topPos, 0, 185 + this.getYImage() * 18, 126, 18);
            class_5481 formattedCharSequence = this.getRenderingName(this.enchantment, width);
            class_332.method_35719((class_4587)poseStack, (class_327)InfuserScreen.this.field_22793, (class_5481)formattedCharSequence, (int)(leftPos + width / 2), (int)(topPos + 5), (int)(this.isIncompatible() || this.isObfuscated() ? 6839882 : -1));
            if (mouseX >= leftPos + 18 && mouseX < leftPos + 18 + 126 && mouseY >= topPos && mouseY < topPos + 18) {
                this.handleTooltip(this.enchantment);
            }
            this.decrButton.field_22760 = leftPos;
            this.decrButton.field_22761 = topPos;
            this.decrButton.method_25394(poseStack, mouseX, mouseY, partialTicks);
            this.incrButton.field_22760 = leftPos + width - 18;
            this.incrButton.field_22761 = topPos;
            this.incrButton.method_25394(poseStack, mouseX, mouseY, partialTicks);
        }

        private class_5481 getRenderingName(class_1887 enchantment, int maxWidth) {
            class_5481 formattedCharSequence = null;
            if (this.isObfuscated()) {
                class_487.method_2481().method_2480((long)(InfuserScreen.this.enchantmentSeed + class_2378.field_11160.method_10206((Object)enchantment)));
                class_5348 formattedtext = class_487.method_2481().method_2479(InfuserScreen.this.field_22793, (int)((float)maxWidth * 0.72f));
                List list = InfuserScreen.this.field_22793.method_1728(formattedtext, (int)((float)maxWidth * 0.72f));
                if (!list.isEmpty()) {
                    formattedCharSequence = (class_5481)list.get(0);
                }
            }
            if (formattedCharSequence == null) {
                class_5250 component = class_2561.method_43471((String)enchantment.method_8184());
                if (this.isActive()) {
                    component.method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)("enchantment.level." + this.level)));
                }
                formattedCharSequence = component.method_30937();
            }
            return formattedCharSequence;
        }

        private void handleTooltip(class_1887 enchantment) {
            if (this.isObfuscated()) {
                InfuserScreen.this.setActiveTooltip(this.getLowPowerComponent(UNKNOWN_ENCHANT_COMPONENT));
                InfuserScreen.this.insufficientPower = true;
            } else if (this.isIncompatible()) {
                class_5250 incompatibleComponent = class_2561.method_43469((String)"gui.enchantinginfuser.tooltip.incompatible", (Object[])new Object[]{this.incompatible.stream().map(e -> class_2561.method_43471((String)e.method_8184())).reduce((o1, o2) -> o1.method_27693(", ").method_10852((class_2561)o2)).orElse(class_2561.method_43473()).method_27692(class_124.field_1080)});
                InfuserScreen.this.setActiveTooltip(InfuserScreen.this.field_22793.method_1728((class_5348)incompatibleComponent, 175));
            } else {
                ArrayList list = Lists.newArrayList();
                if (class_2477.method_10517().method_4678(enchantment.method_8184() + ".desc")) {
                    list.addAll(InfuserScreen.this.field_22793.method_1728((class_5348)class_2561.method_43471((String)(enchantment.method_8184() + ".desc")).method_27692(class_124.field_1080), 175));
                } else if (class_2477.method_10517().method_4678(enchantment.method_8184() + ".description")) {
                    list.addAll(InfuserScreen.this.field_22793.method_1728((class_5348)class_2561.method_43471((String)(enchantment.method_8184() + ".description")).method_27692(class_124.field_1080), 175));
                }
                class_5250 levelsComponent = class_2561.method_43471((String)("enchantment.level." + EnchantingInfuserAPI.getEnchantStatsProvider().getMinLevel(enchantment)));
                if (EnchantingInfuserAPI.getEnchantStatsProvider().getMinLevel(enchantment) != EnchantingInfuserAPI.getEnchantStatsProvider().getMaxLevel(enchantment)) {
                    levelsComponent.method_27693("-").method_10852((class_2561)class_2561.method_43471((String)("enchantment.level." + EnchantingInfuserAPI.getEnchantStatsProvider().getMaxLevel(enchantment))));
                }
                class_5250 wrappedComponent = class_2561.method_43470((String)"(").method_10852((class_2561)levelsComponent).method_27693(")").method_27692(class_124.field_1080);
                list.add(0, class_2561.method_43471((String)enchantment.method_8184()).method_27693(" ").method_10852((class_2561)wrappedComponent).method_30937());
                InfuserScreen.this.setActiveTooltip(list);
            }
        }

        public boolean method_25405(double pMouseX, double pMouseY) {
            return Objects.equals(this.list.getEntryAtPosition(pMouseX, pMouseY), this);
        }

        public List<? extends class_364> method_25396() {
            return ImmutableList.of((Object)this.decrButton, (Object)this.incrButton);
        }

        public boolean method_25397() {
            return this.dragging;
        }

        public void method_25398(boolean pDragging) {
            this.dragging = pDragging;
        }

        public void method_25395(@Nullable class_364 pListener) {
            this.focused = pListener;
        }

        @Nullable
        public class_364 method_25399() {
            return this.focused;
        }
    }
}

