/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.collections;

import java.util.Iterator;
import org.graalvm.collections.EconomicMapImpl;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.UnmodifiableEconomicSet;

public interface EconomicSet<E>
extends UnmodifiableEconomicSet<E> {
    public boolean add(E var1);

    public void remove(E var1);

    public void clear();

    default public void addAll(EconomicSet<E> other) {
        this.addAll(other.iterator());
    }

    default public void addAll(Iterable<E> values2) {
        this.addAll(values2.iterator());
    }

    default public void addAll(Iterator<E> iterator2) {
        while (iterator2.hasNext()) {
            this.add(iterator2.next());
        }
    }

    default public void removeAll(EconomicSet<E> other) {
        this.removeAll(other.iterator());
    }

    default public void removeAll(Iterable<E> values2) {
        this.removeAll(values2.iterator());
    }

    default public void removeAll(Iterator<E> iterator2) {
        while (iterator2.hasNext()) {
            this.remove(iterator2.next());
        }
    }

    default public void retainAll(EconomicSet<E> other) {
        Iterator iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            Object key = iterator2.next();
            if (other.contains(key)) continue;
            iterator2.remove();
        }
    }

    public static <E> EconomicSet<E> create() {
        return EconomicSet.create(Equivalence.DEFAULT);
    }

    public static <E> EconomicSet<E> create(Equivalence strategy) {
        return EconomicMapImpl.create(strategy, true);
    }

    public static <E> EconomicSet<E> create(int initialCapacity) {
        return EconomicSet.create(Equivalence.DEFAULT, initialCapacity);
    }

    public static <E> EconomicSet<E> create(UnmodifiableEconomicSet<E> c) {
        return EconomicSet.create(Equivalence.DEFAULT, c);
    }

    public static <E> EconomicSet<E> create(Equivalence strategy, int initialCapacity) {
        return EconomicMapImpl.create(strategy, initialCapacity, true);
    }

    public static <E> EconomicSet<E> create(Equivalence strategy, UnmodifiableEconomicSet<E> c) {
        return EconomicMapImpl.create(strategy, c, true);
    }
}

