/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.internal.AbstractJsonLexer;
import kotlinx.serialization.json.internal.AbstractJsonLexerKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0016\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\t\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\t\u0010\u000eJ\u0017\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0004R\u001a\u0010\u0016\u001a\u00020\u00058\u0014X\u0094\u0004\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lkotlinx/serialization/json/internal/StringJsonLexer;", "Lkotlinx/serialization/json/internal/AbstractJsonLexer;", "", "canConsumeValue", "()Z", "", "consumeKeyString", "()Ljava/lang/String;", "", "consumeNextToken", "()B", "", "expected", "", "(C)V", "", "position", "prefetchOrEof", "(I)I", "skipWhitespaces", "()I", "tryConsumeComma", "source", "Ljava/lang/String;", "getSource", "<init>", "(Ljava/lang/String;)V", "kotlinx-serialization-json"})
public final class StringJsonLexer
extends AbstractJsonLexer {
    @NotNull
    private final String source;

    public StringJsonLexer(@NotNull String source) {
        Intrinsics.checkNotNullParameter(source, "source");
        this.source = source;
    }

    @Override
    @NotNull
    protected String getSource() {
        return this.source;
    }

    @Override
    public int prefetchOrEof(int position) {
        return position < this.getSource().length() ? position : -1;
    }

    @Override
    public byte consumeNextToken() {
        String source = this.getSource();
        while (this.currentPosition != -1 && this.currentPosition < source.length()) {
            byte by = this.currentPosition;
            this.currentPosition = by + 1;
            char ch = source.charAt(by);
            if ((by = (byte)AbstractJsonLexerKt.charToTokenClass(ch)) == 3) continue;
            return by;
        }
        return 10;
    }

    @Override
    public boolean tryConsumeComma() {
        int current = this.skipWhitespaces();
        if (current == this.getSource().length() || current == -1) {
            return false;
        }
        if (this.getSource().charAt(current) == ',') {
            ++this.currentPosition;
            return true;
        }
        return false;
    }

    @Override
    public boolean canConsumeValue() {
        int current = this.currentPosition;
        if (current == -1) {
            return false;
        }
        while (current < this.getSource().length()) {
            char c = this.getSource().charAt(current);
            if (c == ' ' || c == '\n' || c == '\r' || c == '\t') {
                ++current;
                continue;
            }
            this.currentPosition = current;
            return this.isValidValueStart(c);
        }
        this.currentPosition = current;
        return false;
    }

    @Override
    public int skipWhitespaces() {
        char c;
        int current = this.currentPosition;
        if (current == -1) {
            return current;
        }
        while (current < this.getSource().length() && ((c = this.getSource().charAt(current)) == ' ' || c == '\n' || c == '\r' || c == '\t')) {
            ++current;
        }
        this.currentPosition = current;
        return current;
    }

    @Override
    public void consumeNextToken(char expected) {
        if (this.currentPosition == -1) {
            this.unexpectedToken(expected);
        }
        String source = this.getSource();
        while (this.currentPosition < source.length()) {
            int n = this.currentPosition;
            this.currentPosition = n + 1;
            char c = source.charAt(n);
            if (c == ' ' || c == '\n' || c == '\r' || c == '\t') continue;
            if (c == expected) {
                return;
            }
            this.unexpectedToken(expected);
        }
        this.unexpectedToken(expected);
    }

    @Override
    @NotNull
    public String consumeKeyString() {
        this.consumeNextToken('\"');
        int current = this.currentPosition;
        int closingQuote = StringsKt.indexOf$default((CharSequence)this.getSource(), '\"', current, false, 4, null);
        if (closingQuote == -1) {
            this.fail$kotlinx_serialization_json((byte)1);
            throw new KotlinNothingValueException();
        }
        int n = current;
        while (n < closingQuote) {
            int i = n++;
            if (this.getSource().charAt(i) != '\\') continue;
            return this.consumeString(this.getSource(), this.currentPosition, i);
        }
        this.currentPosition = closingQuote + 1;
        String string = this.getSource().substring(current, closingQuote);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string;
    }
}

