/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.encoding.AbstractDecoder;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonConfiguration;
import kotlinx.serialization.json.JsonDecoder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.internal.AbstractJsonLexer;
import kotlinx.serialization.json.internal.JsonDecoderForUnsignedTypes;
import kotlinx.serialization.json.internal.JsonElementMarker;
import kotlinx.serialization.json.internal.JsonExceptionsKt;
import kotlinx.serialization.json.internal.JsonNamesMapKt;
import kotlinx.serialization.json.internal.JsonTreeReader;
import kotlinx.serialization.json.internal.PolymorphicKt;
import kotlinx.serialization.json.internal.StreamingJsonEncoderKt;
import kotlinx.serialization.json.internal.WriteMode;
import kotlinx.serialization.json.internal.WriteModeKt;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0010\u0018\u00002\u00020\u00012\u00020\u0002B'\u0012\u0006\u0010P\u001a\u00020O\u0012\u0006\u0010X\u001a\u00020W\u0012\u0006\u0010U\u001a\u00020T\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b_\u0010`J\u0017\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0017\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001cJ\u000f\u0010 \u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b \u0010!J\u0017\u0010$\u001a\u00020#2\u0006\u0010\"\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b$\u0010%J\u000f\u0010&\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b&\u0010'J\u000f\u0010)\u001a\u00020(H\u0016\u00a2\u0006\u0004\b)\u0010*J\u000f\u0010+\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b+\u0010'J\u000f\u0010-\u001a\u00020,H\u0016\u00a2\u0006\u0004\b-\u0010.J\u000f\u0010/\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b/\u0010'J\u000f\u00100\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b0\u0010\u0011J\u0011\u00102\u001a\u0004\u0018\u000101H\u0016\u00a2\u0006\u0004\b2\u00103J\u0017\u00104\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b4\u0010\u001cJ#\u00108\u001a\u00028\u0000\"\u0004\b\u0000\u001052\f\u00107\u001a\b\u0012\u0004\u0012\u00028\u000006H\u0016\u00a2\u0006\u0004\b8\u00109J\u000f\u0010;\u001a\u00020:H\u0016\u00a2\u0006\u0004\b;\u0010<J\u000f\u0010>\u001a\u00020=H\u0016\u00a2\u0006\u0004\b>\u0010?J\u000f\u0010@\u001a\u00020=H\u0002\u00a2\u0006\u0004\b@\u0010?J\u0017\u0010A\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\bA\u0010BJ\u0017\u0010D\u001a\u00020\r2\u0006\u0010C\u001a\u00020=H\u0002\u00a2\u0006\u0004\bD\u0010EJ\u0017\u0010F\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\bF\u0010BR\u0014\u0010H\u001a\u00020G8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bH\u0010IR\u0016\u0010J\u001a\u00020\u000b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bJ\u0010KR\u0016\u0010M\u001a\u0004\u0018\u00010L8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bM\u0010NR\u0017\u0010P\u001a\u00020O8\u0006\u00a2\u0006\f\n\u0004\bP\u0010Q\u001a\u0004\bR\u0010SR\u0014\u0010U\u001a\u00020T8\u0000X\u0081\u0004\u00a2\u0006\u0006\n\u0004\bU\u0010VR\u0014\u0010X\u001a\u00020W8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bX\u0010YR\u001a\u0010[\u001a\u00020Z8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b[\u0010\\\u001a\u0004\b]\u0010^\u00a8\u0006a"}, d2={"Lkotlinx/serialization/json/internal/StreamingJsonDecoder;", "Lkotlinx/serialization/json/JsonDecoder;", "Lkotlinx/serialization/encoding/AbstractDecoder;", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "descriptor", "Lkotlinx/serialization/encoding/CompositeDecoder;", "beginStructure", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)Lkotlinx/serialization/encoding/CompositeDecoder;", "", "checkLeadingComma", "()V", "", "index", "", "coerceInputValue", "(Lkotlinx/serialization/descriptors/SerialDescriptor;I)Z", "decodeBoolean", "()Z", "", "decodeByte", "()B", "", "decodeChar", "()C", "", "decodeDouble", "()D", "decodeElementIndex", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)I", "enumDescriptor", "decodeEnum", "", "decodeFloat", "()F", "inlineDescriptor", "Lkotlinx/serialization/encoding/Decoder;", "decodeInline", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)Lkotlinx/serialization/encoding/Decoder;", "decodeInt", "()I", "Lkotlinx/serialization/json/JsonElement;", "decodeJsonElement", "()Lkotlinx/serialization/json/JsonElement;", "decodeListIndex", "", "decodeLong", "()J", "decodeMapIndex", "decodeNotNullMark", "", "decodeNull", "()Ljava/lang/Void;", "decodeObjectIndex", "T", "Lkotlinx/serialization/DeserializationStrategy;", "deserializer", "decodeSerializableValue", "(Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "", "decodeShort", "()S", "", "decodeString", "()Ljava/lang/String;", "decodeStringKey", "endStructure", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "key", "handleUnknown", "(Ljava/lang/String;)Z", "skipLeftoverElements", "Lkotlinx/serialization/json/JsonConfiguration;", "configuration", "Lkotlinx/serialization/json/JsonConfiguration;", "currentIndex", "I", "Lkotlinx/serialization/json/internal/JsonElementMarker;", "elementMarker", "Lkotlinx/serialization/json/internal/JsonElementMarker;", "Lkotlinx/serialization/json/Json;", "json", "Lkotlinx/serialization/json/Json;", "getJson", "()Lkotlinx/serialization/json/Json;", "Lkotlinx/serialization/json/internal/AbstractJsonLexer;", "lexer", "Lkotlinx/serialization/json/internal/AbstractJsonLexer;", "Lkotlinx/serialization/json/internal/WriteMode;", "mode", "Lkotlinx/serialization/json/internal/WriteMode;", "Lkotlinx/serialization/modules/SerializersModule;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "<init>", "(Lkotlinx/serialization/json/Json;Lkotlinx/serialization/json/internal/WriteMode;Lkotlinx/serialization/json/internal/AbstractJsonLexer;Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "kotlinx-serialization-json"})
public class StreamingJsonDecoder
extends AbstractDecoder
implements JsonDecoder {
    @NotNull
    private final Json json;
    @NotNull
    private final WriteMode mode;
    @JvmField
    @NotNull
    public final AbstractJsonLexer lexer;
    @NotNull
    private final SerializersModule serializersModule;
    private int currentIndex;
    @NotNull
    private final JsonConfiguration configuration;
    @Nullable
    private final JsonElementMarker elementMarker;

    public StreamingJsonDecoder(@NotNull Json json, @NotNull WriteMode mode, @NotNull AbstractJsonLexer lexer, @NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(json, "json");
        Intrinsics.checkNotNullParameter((Object)mode, "mode");
        Intrinsics.checkNotNullParameter(lexer, "lexer");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        this.json = json;
        this.mode = mode;
        this.lexer = lexer;
        this.serializersModule = this.json.getSerializersModule();
        this.currentIndex = -1;
        this.configuration = this.json.getConfiguration();
        this.elementMarker = this.configuration.getExplicitNulls() ? null : new JsonElementMarker(descriptor2);
    }

    @Override
    @NotNull
    public final Json getJson() {
        return this.json;
    }

    @Override
    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    @Override
    @NotNull
    public JsonElement decodeJsonElement() {
        return new JsonTreeReader(this.json.getConfiguration(), this.lexer).read();
    }

    @Override
    public <T> T decodeSerializableValue(@NotNull DeserializationStrategy<T> deserializer) {
        Intrinsics.checkNotNullParameter(deserializer, "deserializer");
        return PolymorphicKt.decodeSerializableValuePolymorphic(this, deserializer);
    }

    @Override
    @NotNull
    public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor2) {
        CompositeDecoder compositeDecoder;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        WriteMode newMode = WriteModeKt.switchMode(this.json, descriptor2);
        this.lexer.consumeNextToken(newMode.begin);
        this.checkLeadingComma();
        switch (WhenMappings.$EnumSwitchMapping$0[newMode.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                compositeDecoder = new StreamingJsonDecoder(this.json, newMode, this.lexer, descriptor2);
                break;
            }
            default: {
                compositeDecoder = this.mode == newMode && this.json.getConfiguration().getExplicitNulls() ? this : new StreamingJsonDecoder(this.json, newMode, this.lexer, descriptor2);
            }
        }
        return compositeDecoder;
    }

    @Override
    public void endStructure(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        if (this.json.getConfiguration().getIgnoreUnknownKeys() && descriptor2.getElementsCount() == 0) {
            this.skipLeftoverElements(descriptor2);
        }
        this.lexer.consumeNextToken(this.mode.end);
    }

    private final void skipLeftoverElements(SerialDescriptor descriptor2) {
        while (this.decodeElementIndex(descriptor2) != -1) {
        }
    }

    @Override
    public boolean decodeNotNullMark() {
        boolean bl;
        JsonElementMarker jsonElementMarker = this.elementMarker;
        return !(jsonElementMarker == null ? false : (bl = jsonElementMarker.isUnmarkedNull$kotlinx_serialization_json())) && this.lexer.tryConsumeNotNull();
    }

    @Override
    @Nullable
    public Void decodeNull() {
        return null;
    }

    private final void checkLeadingComma() {
        if (this.lexer.peekNextToken() == 4) {
            AbstractJsonLexer.fail$default(this.lexer, "Unexpected leading comma", 0, 2, null);
            throw new KotlinNothingValueException();
        }
    }

    @Override
    public int decodeElementIndex(@NotNull SerialDescriptor descriptor2) {
        int n;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        switch (WhenMappings.$EnumSwitchMapping$0[this.mode.ordinal()]) {
            case 4: {
                n = this.decodeObjectIndex(descriptor2);
                break;
            }
            case 2: {
                n = this.decodeMapIndex();
                break;
            }
            default: {
                n = this.decodeListIndex();
            }
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private final int decodeMapIndex() {
        int n;
        boolean decodingKey;
        boolean hasComma = false;
        boolean bl = decodingKey = this.currentIndex % 2 != 0;
        if (decodingKey) {
            if (this.currentIndex != -1) {
                hasComma = this.lexer.tryConsumeComma();
            }
        } else {
            this.lexer.consumeNextToken(':');
        }
        if (this.lexer.canConsumeValue()) {
            if (decodingKey) {
                if (this.currentIndex == -1) {
                    void this_$iv;
                    AbstractJsonLexer abstractJsonLexer = this.lexer;
                    boolean condition$iv = !hasComma;
                    int position$iv = AbstractJsonLexer.access$getCurrentPosition$p((AbstractJsonLexer)this_$iv);
                    boolean $i$f$require$kotlinx_serialization_json = false;
                    if (!condition$iv) {
                        void var8_11 = this_$iv;
                        boolean bl2 = false;
                        var8_11.fail("Unexpected trailing comma", position$iv);
                        throw new KotlinNothingValueException();
                    }
                } else {
                    AbstractJsonLexer this_$iv = this.lexer;
                    int position$iv = AbstractJsonLexer.access$getCurrentPosition$p(this_$iv);
                    boolean $i$f$require$kotlinx_serialization_json = false;
                    if (!hasComma) {
                        AbstractJsonLexer abstractJsonLexer = this_$iv;
                        boolean bl3 = false;
                        abstractJsonLexer.fail("Expected comma after the key-value pair", position$iv);
                        throw new KotlinNothingValueException();
                    }
                }
            }
            n = ++this.currentIndex;
        } else {
            if (hasComma) {
                AbstractJsonLexer.fail$default(this.lexer, "Expected '}', but had ',' instead", 0, 2, null);
                throw new KotlinNothingValueException();
            }
            n = -1;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean coerceInputValue(SerialDescriptor descriptor2, int index) {
        void $this$tryCoerceValue$iv;
        void elementDescriptor$iv;
        Json json = this.json;
        SerialDescriptor serialDescriptor = descriptor2.getElementDescriptor(index);
        boolean $i$f$tryCoerceValue = false;
        if (!elementDescriptor$iv.isNullable()) {
            boolean bl = false;
            if (!this.lexer.tryConsumeNotNull()) {
                return true;
            }
            boolean bl2 = false;
            if (bl2) {
                return true;
            }
        }
        if (!Intrinsics.areEqual(elementDescriptor$iv.getKind(), SerialKind.ENUM.INSTANCE)) return false;
        boolean bl = false;
        String string = this.lexer.peekString(this.configuration.isLenient());
        if (string == null) {
            return false;
        }
        String enumValue$iv = string;
        int enumIndex$iv = JsonNamesMapKt.getJsonNameIndex((SerialDescriptor)elementDescriptor$iv, (Json)$this$tryCoerceValue$iv, enumValue$iv);
        if (enumIndex$iv != -3) return false;
        boolean bl3 = false;
        this.lexer.consumeString();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final int decodeObjectIndex(SerialDescriptor descriptor2) {
        int n;
        boolean hasComma = this.lexer.tryConsumeComma();
        while (this.lexer.canConsumeValue()) {
            boolean isUnknown;
            boolean bl;
            String key;
            block7: {
                hasComma = false;
                key = this.decodeStringKey();
                this.lexer.consumeNextToken(':');
                int index = JsonNamesMapKt.getJsonNameIndex(descriptor2, this.json, key);
                if (index != -3) {
                    if (this.configuration.getCoerceInputValues() && this.coerceInputValue(descriptor2, index)) {
                        hasComma = this.lexer.tryConsumeComma();
                        bl = false;
                        break block7;
                    } else {
                        JsonElementMarker jsonElementMarker = this.elementMarker;
                        if (jsonElementMarker == null) {
                            return index;
                        }
                        jsonElementMarker.mark$kotlinx_serialization_json(index);
                        return index;
                    }
                }
                bl = true;
            }
            if (!(isUnknown = bl)) continue;
            hasComma = this.handleUnknown(key);
        }
        if (hasComma) {
            AbstractJsonLexer.fail$default(this.lexer, "Unexpected trailing comma", 0, 2, null);
            throw new KotlinNothingValueException();
        }
        JsonElementMarker jsonElementMarker = this.elementMarker;
        if (jsonElementMarker == null) {
            return -1;
        }
        int n2 = n = jsonElementMarker.nextUnmarkedIndex$kotlinx_serialization_json();
        return n2;
    }

    private final boolean handleUnknown(String key) {
        if (this.configuration.getIgnoreUnknownKeys()) {
            this.lexer.skipElement(this.configuration.isLenient());
        } else {
            this.lexer.failOnUnknownKey(key);
        }
        return this.lexer.tryConsumeComma();
    }

    private final int decodeListIndex() {
        int n;
        boolean hasComma = this.lexer.tryConsumeComma();
        if (this.lexer.canConsumeValue()) {
            if (this.currentIndex != -1 && !hasComma) {
                AbstractJsonLexer.fail$default(this.lexer, "Expected end of the array or comma", 0, 2, null);
                throw new KotlinNothingValueException();
            }
            n = ++this.currentIndex;
        } else {
            if (hasComma) {
                AbstractJsonLexer.fail$default(this.lexer, "Unexpected trailing comma", 0, 2, null);
                throw new KotlinNothingValueException();
            }
            n = -1;
        }
        return n;
    }

    @Override
    public boolean decodeBoolean() {
        return this.configuration.isLenient() ? this.lexer.consumeBooleanLenient() : this.lexer.consumeBoolean();
    }

    @Override
    public byte decodeByte() {
        long value = this.lexer.consumeNumericLiteral();
        if (value != (long)((byte)value)) {
            AbstractJsonLexer.fail$default(this.lexer, "Failed to parse byte for input '" + value + '\'', 0, 2, null);
            throw new KotlinNothingValueException();
        }
        return (byte)value;
    }

    @Override
    public short decodeShort() {
        long value = this.lexer.consumeNumericLiteral();
        if (value != (long)((short)value)) {
            AbstractJsonLexer.fail$default(this.lexer, "Failed to parse short for input '" + value + '\'', 0, 2, null);
            throw new KotlinNothingValueException();
        }
        return (short)value;
    }

    @Override
    public int decodeInt() {
        long value = this.lexer.consumeNumericLiteral();
        if (value != (long)((int)value)) {
            AbstractJsonLexer.fail$default(this.lexer, "Failed to parse int for input '" + value + '\'', 0, 2, null);
            throw new KotlinNothingValueException();
        }
        return (int)value;
    }

    @Override
    public long decodeLong() {
        return this.lexer.consumeNumericLiteral();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float decodeFloat() {
        float f;
        float f2;
        void $this$parseString$iv;
        AbstractJsonLexer abstractJsonLexer = this.lexer;
        String expectedType$iv = "float";
        boolean $i$f$parseString = false;
        String input$iv = $this$parseString$iv.consumeStringLenient();
        try {
            String $this$decodeFloat_u24lambda_u2d5 = input$iv;
            boolean bl = false;
            f2 = Float.parseFloat($this$decodeFloat_u24lambda_u2d5);
        }
        catch (IllegalArgumentException e$iv) {
            AbstractJsonLexer.fail$default((AbstractJsonLexer)$this$parseString$iv, "Failed to parse type '" + expectedType$iv + "' for input '" + input$iv + '\'', 0, 2, null);
            throw new KotlinNothingValueException();
        }
        float result2 = f2;
        boolean specialFp = this.json.getConfiguration().getAllowSpecialFloatingPointValues();
        if (specialFp || !Float.isInfinite(f = result2) && !Float.isNaN(f)) {
            return result2;
        }
        JsonExceptionsKt.throwInvalidFloatingPointDecoded(this.lexer, Float.valueOf(result2));
        throw new KotlinNothingValueException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double decodeDouble() {
        double d;
        double d2;
        void $this$parseString$iv;
        AbstractJsonLexer abstractJsonLexer = this.lexer;
        String expectedType$iv = "double";
        boolean $i$f$parseString = false;
        String input$iv = $this$parseString$iv.consumeStringLenient();
        try {
            String $this$decodeDouble_u24lambda_u2d6 = input$iv;
            boolean bl = false;
            d2 = Double.parseDouble($this$decodeDouble_u24lambda_u2d6);
        }
        catch (IllegalArgumentException e$iv) {
            AbstractJsonLexer.fail$default((AbstractJsonLexer)$this$parseString$iv, "Failed to parse type '" + expectedType$iv + "' for input '" + input$iv + '\'', 0, 2, null);
            throw new KotlinNothingValueException();
        }
        double result2 = d2;
        boolean specialFp = this.json.getConfiguration().getAllowSpecialFloatingPointValues();
        if (specialFp || !Double.isInfinite(d = result2) && !Double.isNaN(d)) {
            return result2;
        }
        JsonExceptionsKt.throwInvalidFloatingPointDecoded(this.lexer, result2);
        throw new KotlinNothingValueException();
    }

    @Override
    public char decodeChar() {
        String string = this.lexer.consumeStringLenient();
        if (string.length() != 1) {
            AbstractJsonLexer.fail$default(this.lexer, "Expected single char, but got '" + string + '\'', 0, 2, null);
            throw new KotlinNothingValueException();
        }
        return string.charAt(0);
    }

    private final String decodeStringKey() {
        return this.configuration.isLenient() ? this.lexer.consumeStringLenientNotNull() : this.lexer.consumeKeyString();
    }

    @Override
    @NotNull
    public String decodeString() {
        return this.configuration.isLenient() ? this.lexer.consumeStringLenientNotNull() : this.lexer.consumeString();
    }

    @Override
    @NotNull
    public Decoder decodeInline(@NotNull SerialDescriptor inlineDescriptor) {
        Intrinsics.checkNotNullParameter(inlineDescriptor, "inlineDescriptor");
        return StreamingJsonEncoderKt.isUnsignedNumber(inlineDescriptor) ? (Decoder)new JsonDecoderForUnsignedTypes(this.lexer, this.json) : super.decodeInline(inlineDescriptor);
    }

    @Override
    public int decodeEnum(@NotNull SerialDescriptor enumDescriptor) {
        Intrinsics.checkNotNullParameter(enumDescriptor, "enumDescriptor");
        return JsonNamesMapKt.getJsonNameIndexOrThrow(enumDescriptor, this.json, this.decodeString());
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WriteMode.values().length];
            nArray[WriteMode.LIST.ordinal()] = 1;
            nArray[WriteMode.MAP.ordinal()] = 2;
            nArray[WriteMode.POLY_OBJ.ordinal()] = 3;
            nArray[WriteMode.OBJ.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

