/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Arrays;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlinx.serialization.json.internal.AbstractJsonLexer;
import kotlinx.serialization.json.internal.AbstractJsonLexerKt;
import kotlinx.serialization.json.internal.ArrayAsSequence;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\u000e\n\u0002\u0010\u0019\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u001b\b\u0016\u0012\u0006\u00103\u001a\u000202\u0012\b\b\u0002\u00105\u001a\u000204\u00a2\u0006\u0004\b6\u00107B\u0019\u0012\u0006\u0010&\u001a\u00020%\u0012\b\b\u0002\u0010#\u001a\u00020\"\u00a2\u0006\u0004\b6\u00108J\u001f\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001f\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001f\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u000f\u0010!\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b!\u0010\nR\u0016\u0010#\u001a\u00020\"8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u0014\u0010&\u001a\u00020%8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010'R*\u0010*\u001a\u00020(2\u0006\u0010)\u001a\u00020(8\u0014@VX\u0094\u000e\u00a2\u0006\u0012\n\u0004\b*\u0010+\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u0016\u00100\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b0\u00101\u00a8\u00069"}, d2={"Lkotlinx/serialization/json/internal/ReaderJsonLexer;", "Lkotlinx/serialization/json/internal/AbstractJsonLexer;", "", "fromIndex", "toIndex", "", "appendRange", "(II)V", "", "canConsumeValue", "()Z", "", "consumeKeyString", "()Ljava/lang/String;", "", "consumeNextToken", "()B", "ensureHaveChars", "()V", "", "char", "startPos", "indexOf", "(CI)I", "position", "prefetchOrEof", "(I)I", "spaceLeft", "preload", "(I)V", "endPos", "substring", "(II)Ljava/lang/String;", "tryConsumeComma", "", "_source", "[C", "Ljava/io/Reader;", "reader", "Ljava/io/Reader;", "", "<set-?>", "source", "Ljava/lang/CharSequence;", "getSource", "()Ljava/lang/CharSequence;", "setSource", "(Ljava/lang/CharSequence;)V", "threshold", "I", "Ljava/io/InputStream;", "i", "Ljava/nio/charset/Charset;", "charset", "<init>", "(Ljava/io/InputStream;Ljava/nio/charset/Charset;)V", "(Ljava/io/Reader;[C)V", "kotlinx-serialization-json"})
public final class ReaderJsonLexer
extends AbstractJsonLexer {
    @NotNull
    private final Reader reader;
    @NotNull
    private char[] _source;
    private int threshold;
    @NotNull
    private CharSequence source;

    public ReaderJsonLexer(@NotNull Reader reader, @NotNull char[] _source) {
        Intrinsics.checkNotNullParameter(reader, "reader");
        Intrinsics.checkNotNullParameter(_source, "_source");
        this.reader = reader;
        this._source = _source;
        this.threshold = 128;
        this.source = new ArrayAsSequence(this._source);
        this.preload(0);
    }

    public /* synthetic */ ReaderJsonLexer(Reader reader, char[] cArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            cArray = new char[16384];
        }
        this(reader, cArray);
    }

    public ReaderJsonLexer(@NotNull InputStream i, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter(i, "i");
        Intrinsics.checkNotNullParameter(charset, "charset");
        Closeable closeable = i;
        closeable = new InputStreamReader((InputStream)closeable, charset);
        int n = 262144;
        this(closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n), null, 2, null);
    }

    public /* synthetic */ ReaderJsonLexer(InputStream inputStream, Charset charset, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        this(inputStream, charset);
    }

    @Override
    @NotNull
    protected CharSequence getSource() {
        return this.source;
    }

    public void setSource(@NotNull CharSequence charSequence) {
        Intrinsics.checkNotNullParameter(charSequence, "<set-?>");
        this.source = charSequence;
    }

    @Override
    public boolean tryConsumeComma() {
        int current = this.skipWhitespaces();
        if (current >= this.getSource().length() || current == -1) {
            return false;
        }
        if (this.getSource().charAt(current) == ',') {
            ++this.currentPosition;
            return true;
        }
        return false;
    }

    @Override
    public boolean canConsumeValue() {
        this.ensureHaveChars();
        int current = this.currentPosition;
        while ((current = this.prefetchOrEof(current)) != -1) {
            char c = this.getSource().charAt(current);
            if (c == ' ' || c == '\n' || c == '\r' || c == '\t') {
                ++current;
                continue;
            }
            this.currentPosition = current;
            return this.isValidValueStart(c);
        }
        this.currentPosition = current;
        return false;
    }

    private final void preload(int spaceLeft) {
        int actual;
        char[] buffer = this._source;
        System.arraycopy(buffer, this.currentPosition, buffer, 0, spaceLeft);
        int sizeTotal = this._source.length;
        for (int read = spaceLeft; read != sizeTotal; read += actual) {
            actual = this.reader.read(buffer, read, sizeTotal - read);
            if (actual != -1) continue;
            char[] cArray = Arrays.copyOf(this._source, read);
            Intrinsics.checkNotNullExpressionValue(cArray, "copyOf(this, newSize)");
            this._source = cArray;
            this.setSource(new ArrayAsSequence(this._source));
            this.threshold = -1;
            break;
        }
        this.currentPosition = 0;
    }

    @Override
    public int prefetchOrEof(int position) {
        if (position < this.getSource().length()) {
            return position;
        }
        this.currentPosition = position;
        this.ensureHaveChars();
        if (this.currentPosition != 0 || this.getSource().length() == 0) {
            return -1;
        }
        return 0;
    }

    @Override
    public byte consumeNextToken() {
        this.ensureHaveChars();
        CharSequence source = this.getSource();
        int cpos = this.currentPosition;
        while ((cpos = this.prefetchOrEof(cpos)) != -1) {
            int n = cpos;
            cpos = n + 1;
            char ch = source.charAt(n);
            byte tc = AbstractJsonLexerKt.charToTokenClass(ch);
            if (tc == 3) continue;
            this.currentPosition = cpos;
            return tc;
        }
        this.currentPosition = cpos;
        return 10;
    }

    @Override
    public void ensureHaveChars() {
        int oldSize = this._source.length;
        int cur = this.currentPosition;
        int spaceLeft = oldSize - cur;
        if (spaceLeft > this.threshold) {
            return;
        }
        this.preload(spaceLeft);
    }

    @Override
    @NotNull
    public String consumeKeyString() {
        this.consumeNextToken('\"');
        int current = this.currentPosition;
        int closingQuote = this.indexOf('\"', current);
        if (closingQuote == -1) {
            if ((current = this.prefetchOrEof(current)) == -1) {
                this.fail$kotlinx_serialization_json((byte)1);
                throw new KotlinNothingValueException();
            }
            return this.consumeString(this.getSource(), this.currentPosition, current);
        }
        int n = current;
        while (n < closingQuote) {
            int i = n++;
            if (this.getSource().charAt(i) != '\\') continue;
            return this.consumeString(this.getSource(), this.currentPosition, i);
        }
        this.currentPosition = closingQuote + 1;
        return this.substring(current, closingQuote);
    }

    @Override
    public int indexOf(char c, int startPos) {
        char[] src = this._source;
        int n = startPos;
        int n2 = src.length;
        while (n < n2) {
            int i;
            if (src[i = n++] != c) continue;
            return i;
        }
        return -1;
    }

    @Override
    @NotNull
    public String substring(int startPos, int endPos) {
        char[] cArray = this._source;
        int n = endPos - startPos;
        return new String(cArray, startPos, n);
    }

    @Override
    protected void appendRange(int fromIndex, int toIndex) {
        this.getEscapedString().append(this._source, fromIndex, toIndex - fromIndex);
    }
}

