/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlinx.serialization.json.internal.JsonStringBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u001b\b\u0016\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0014\u0010\u0015B\u000f\u0012\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0014\u0010\u0016J\u001f\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0019\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\u0007\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fR\u0014\u0010\u000e\u001a\u00020\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lkotlinx/serialization/json/internal/JsonToWriterStringBuilder;", "Lkotlinx/serialization/json/internal/JsonStringBuilder;", "", "oldSize", "additional", "ensureTotalCapacity", "(II)I", "sz", "", "flush", "(I)V", "release", "()V", "Ljava/io/Writer;", "writer", "Ljava/io/Writer;", "Ljava/io/OutputStream;", "os", "Ljava/nio/charset/Charset;", "charset", "<init>", "(Ljava/io/OutputStream;Ljava/nio/charset/Charset;)V", "(Ljava/io/Writer;)V", "kotlinx-serialization-json"})
public final class JsonToWriterStringBuilder
extends JsonStringBuilder {
    @NotNull
    private final Writer writer;

    public JsonToWriterStringBuilder(@NotNull Writer writer) {
        Intrinsics.checkNotNullParameter(writer, "writer");
        super(new char[16384]);
        this.writer = writer;
    }

    public JsonToWriterStringBuilder(@NotNull OutputStream os, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter(os, "os");
        Intrinsics.checkNotNullParameter(charset, "charset");
        Closeable closeable = os;
        closeable = new OutputStreamWriter((OutputStream)closeable, charset);
        int n = 262144;
        this(closeable instanceof BufferedWriter ? (BufferedWriter)closeable : new BufferedWriter((Writer)closeable, n));
    }

    public /* synthetic */ JsonToWriterStringBuilder(OutputStream outputStream, Charset charset, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        this(outputStream, charset);
    }

    @Override
    protected int ensureTotalCapacity(int oldSize, int additional) {
        int currentSize = this.array.length;
        int requiredSize = oldSize + additional;
        if (currentSize <= requiredSize) {
            this.flush(oldSize);
            if (additional > currentSize) {
                this.array = new char[RangesKt.coerceAtLeast(requiredSize, currentSize * 2)];
            }
            return 0;
        }
        return oldSize;
    }

    private final void flush(int sz) {
        this.writer.write(this.array, 0, sz);
        this.setSize(0);
    }

    static /* synthetic */ void flush$default(JsonToWriterStringBuilder jsonToWriterStringBuilder, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = jsonToWriterStringBuilder.getSize();
        }
        jsonToWriterStringBuilder.flush(n);
    }

    @Override
    public void release() {
        JsonToWriterStringBuilder.flush$default(this, 0, 1, null);
        this.writer.flush();
    }
}

