/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.internal.AbstractJsonTreeEncoder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b0\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\u0004\u0018\u00010\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lkotlinx/serialization/json/internal/JsonPrimitiveEncoder;", "Lkotlinx/serialization/json/internal/AbstractJsonTreeEncoder;", "Lkotlinx/serialization/json/JsonElement;", "getCurrent", "()Lkotlinx/serialization/json/JsonElement;", "", "key", "element", "", "putElement", "(Ljava/lang/String;Lkotlinx/serialization/json/JsonElement;)V", "content", "Lkotlinx/serialization/json/JsonElement;", "Lkotlinx/serialization/json/Json;", "json", "Lkotlin/Function1;", "nodeConsumer", "<init>", "(Lkotlinx/serialization/json/Json;Lkotlin/jvm/functions/Function1;)V", "kotlinx-serialization-json"})
final class JsonPrimitiveEncoder
extends AbstractJsonTreeEncoder {
    @Nullable
    private JsonElement content;

    public JsonPrimitiveEncoder(@NotNull Json json, @NotNull Function1<? super JsonElement, Unit> nodeConsumer) {
        Intrinsics.checkNotNullParameter(json, "json");
        Intrinsics.checkNotNullParameter(nodeConsumer, "nodeConsumer");
        super(json, nodeConsumer, null);
        this.pushTag("primitive");
    }

    @Override
    public void putElement(@NotNull String key, @NotNull JsonElement element) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(element, "element");
        if (!(key == "primitive")) {
            boolean $i$a$-require-JsonPrimitiveEncoder$putElement$32 = false;
            String $i$a$-require-JsonPrimitiveEncoder$putElement$32 = "This output can only consume primitives with 'primitive' tag";
            throw new IllegalArgumentException($i$a$-require-JsonPrimitiveEncoder$putElement$32.toString());
        }
        if (!(this.content == null)) {
            boolean bl = false;
            String string = "Primitive element was already recorded. Does call to .encodeXxx happen more than once?";
            throw new IllegalArgumentException(string.toString());
        }
        this.content = element;
    }

    @Override
    @NotNull
    public JsonElement getCurrent() {
        JsonElement jsonElement = this.content;
        if (jsonElement == null) {
            boolean bl = false;
            String string = "Primitive element has not been recorded. Is call to .encodeXxx is missing in serializer?";
            throw new IllegalArgumentException(string.toString());
        }
        return jsonElement;
    }
}

