/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.Iterator;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.DecodeSequenceMode;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.internal.AbstractJsonLexer;
import kotlinx.serialization.json.internal.JsonIteratorArrayWrapped;
import kotlinx.serialization.json.internal.JsonIteratorWsSeparated;
import kotlinx.serialization.json.internal.ReaderJsonLexer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u001aA\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\t\"\u0004\b\u0000\u0010\u00002\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007H\u0000\u00a2\u0006\u0004\b\n\u0010\u000b\u001a\u001b\u0010\u000e\u001a\u00020\u0001*\u00020\f2\u0006\u0010\r\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000f\u001a\u0013\u0010\u0011\u001a\u00020\u0010*\u00020\fH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"T", "Lkotlinx/serialization/json/DecodeSequenceMode;", "mode", "Lkotlinx/serialization/json/Json;", "json", "Lkotlinx/serialization/json/internal/ReaderJsonLexer;", "lexer", "Lkotlinx/serialization/DeserializationStrategy;", "deserializer", "", "JsonIterator", "(Lkotlinx/serialization/json/DecodeSequenceMode;Lkotlinx/serialization/json/Json;Lkotlinx/serialization/json/internal/ReaderJsonLexer;Lkotlinx/serialization/DeserializationStrategy;)Ljava/util/Iterator;", "Lkotlinx/serialization/json/internal/AbstractJsonLexer;", "suggested", "determineFormat", "(Lkotlinx/serialization/json/internal/AbstractJsonLexer;Lkotlinx/serialization/json/DecodeSequenceMode;)Lkotlinx/serialization/json/DecodeSequenceMode;", "", "tryConsumeStartArray", "(Lkotlinx/serialization/json/internal/AbstractJsonLexer;)Z", "kotlinx-serialization-json"})
public final class JsonIteratorKt {
    @NotNull
    public static final <T> Iterator<T> JsonIterator(@NotNull DecodeSequenceMode mode, @NotNull Json json, @NotNull ReaderJsonLexer lexer, @NotNull DeserializationStrategy<T> deserializer) {
        Iterator iterator2;
        Intrinsics.checkNotNullParameter((Object)mode, "mode");
        Intrinsics.checkNotNullParameter(json, "json");
        Intrinsics.checkNotNullParameter(lexer, "lexer");
        Intrinsics.checkNotNullParameter(deserializer, "deserializer");
        switch (WhenMappings.$EnumSwitchMapping$0[JsonIteratorKt.determineFormat(lexer, mode).ordinal()]) {
            case 1: {
                iterator2 = new JsonIteratorWsSeparated<T>(json, lexer, deserializer);
                break;
            }
            case 2: {
                iterator2 = new JsonIteratorArrayWrapped<T>(json, lexer, deserializer);
                break;
            }
            case 3: {
                throw new IllegalStateException("AbstractJsonLexer.determineFormat must be called beforehand.".toString());
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return iterator2;
    }

    private static final DecodeSequenceMode determineFormat(AbstractJsonLexer $this$determineFormat, DecodeSequenceMode suggested) {
        DecodeSequenceMode decodeSequenceMode;
        switch (WhenMappings.$EnumSwitchMapping$0[suggested.ordinal()]) {
            case 1: {
                decodeSequenceMode = DecodeSequenceMode.WHITESPACE_SEPARATED;
                break;
            }
            case 2: {
                if (JsonIteratorKt.tryConsumeStartArray($this$determineFormat)) {
                    decodeSequenceMode = DecodeSequenceMode.ARRAY_WRAPPED;
                    break;
                }
                $this$determineFormat.fail$kotlinx_serialization_json((byte)8);
                throw new KotlinNothingValueException();
            }
            case 3: {
                if (JsonIteratorKt.tryConsumeStartArray($this$determineFormat)) {
                    decodeSequenceMode = DecodeSequenceMode.ARRAY_WRAPPED;
                    break;
                }
                decodeSequenceMode = DecodeSequenceMode.WHITESPACE_SEPARATED;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return decodeSequenceMode;
    }

    private static final boolean tryConsumeStartArray(AbstractJsonLexer $this$tryConsumeStartArray) {
        if ($this$tryConsumeStartArray.peekNextToken() == 8) {
            $this$tryConsumeStartArray.consumeNextToken((byte)8);
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DecodeSequenceMode.values().length];
            nArray[DecodeSequenceMode.WHITESPACE_SEPARATED.ordinal()] = 1;
            nArray[DecodeSequenceMode.ARRAY_WRAPPED.ordinal()] = 2;
            nArray[DecodeSequenceMode.AUTO_DETECT.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

