/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.ArrayList;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.internal.AbstractJsonLexerKt;
import kotlinx.serialization.json.internal.JsonExceptionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\r\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0005\n\u0002\b\u0004\n\u0002\u0010\f\n\u0000\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0010\u0001\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b \u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\bl\u00103J\u0017\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\b\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\r\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0015\u001a\u00020\u0014H&\u00a2\u0006\u0004\b\u0015\u0010\u0016J\r\u0010\u0017\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0017\u0010\u0016J\u0017\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0002H\u0003\u00a2\u0006\u0004\b\u0017\u0010\u0019J\r\u0010\u001a\u001a\u00020\u0014\u00a2\u0006\u0004\b\u001a\u0010\u0016J\u001f\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u000f\u0010\u001f\u001a\u00020\u001bH&\u00a2\u0006\u0004\b\u001f\u0010 J\u000f\u0010\"\u001a\u00020!H&\u00a2\u0006\u0004\b\"\u0010#J\u0015\u0010\"\u001a\u00020!2\u0006\u0010$\u001a\u00020!\u00a2\u0006\u0004\b\"\u0010%J\u0017\u0010\"\u001a\u00020\u00112\u0006\u0010$\u001a\u00020&H\u0016\u00a2\u0006\u0004\b\"\u0010'J\r\u0010)\u001a\u00020(\u00a2\u0006\u0004\b)\u0010*J\r\u0010+\u001a\u00020\u001b\u00a2\u0006\u0004\b+\u0010 J'\u0010+\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0005\u00a2\u0006\u0004\b+\u0010,J\r\u0010-\u001a\u00020\u001b\u00a2\u0006\u0004\b-\u0010 J\r\u0010.\u001a\u00020\u001b\u00a2\u0006\u0004\b.\u0010 J\u001f\u00100\u001a\u00020\u001b2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010/\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b0\u00101J\u000f\u00102\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b2\u00103J\r\u00104\u001a\u00020\u0011\u00a2\u0006\u0004\b4\u00103J\u0017\u00109\u001a\u0002062\u0006\u00105\u001a\u00020!H\u0000\u00a2\u0006\u0004\b7\u00108J\u001f\u00109\u001a\u0002062\u0006\u0010:\u001a\u00020\u001b2\b\b\u0002\u0010;\u001a\u00020\u0002\u00a2\u0006\u0004\b9\u0010<J\u0015\u0010>\u001a\u00020\u00112\u0006\u0010=\u001a\u00020\u001b\u00a2\u0006\u0004\b>\u0010?J\u001f\u0010@\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010/\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b@\u0010\u000eJ\u001f\u0010B\u001a\u00020\u00022\u0006\u0010A\u001a\u00020&2\u0006\u0010\f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\bB\u0010CJ\r\u0010D\u001a\u00020\u0014\u00a2\u0006\u0004\bD\u0010\u0016J\u0017\u0010F\u001a\u00020\u00142\u0006\u0010E\u001a\u00020&H\u0004\u00a2\u0006\u0004\bF\u0010GJ\r\u0010H\u001a\u00020!\u00a2\u0006\u0004\bH\u0010#J\u0017\u0010J\u001a\u0004\u0018\u00010\u001b2\u0006\u0010I\u001a\u00020\u0014\u00a2\u0006\u0004\bJ\u0010KJ\u0017\u0010L\u001a\u00020\u00022\u0006\u0010;\u001a\u00020\u0002H&\u00a2\u0006\u0004\bL\u0010\u0005J3\u0010Q\u001a\u00020\u00112\u0006\u0010M\u001a\u00020\u00142\b\b\u0002\u0010;\u001a\u00020\u00022\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u001b0NH\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0004\bO\u0010PJ\u0015\u0010S\u001a\u00020\u00112\u0006\u0010R\u001a\u00020\u0014\u00a2\u0006\u0004\bS\u0010TJ\u000f\u0010U\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\bU\u0010VJ\u001f\u0010X\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010W\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\bX\u00101J\u000f\u0010Y\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\bY\u0010 J\u000f\u0010Z\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\bZ\u0010 J\u000f\u0010[\u001a\u00020\u0014H&\u00a2\u0006\u0004\b[\u0010\u0016J\r\u0010\\\u001a\u00020\u0014\u00a2\u0006\u0004\b\\\u0010\u0016J\u0017\u0010]\u001a\u00020\u00112\u0006\u0010$\u001a\u00020&H\u0004\u00a2\u0006\u0004\b]\u0010'J\u000f\u0010^\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b^\u0010\u0016R\u0016\u0010/\u001a\u00020\u00028\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0006\n\u0004\b/\u0010_R&\u0010b\u001a\u00060`j\u0002`a8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\bb\u0010c\u001a\u0004\bd\u0010e\"\u0004\bf\u0010gR\u0018\u0010h\u001a\u0004\u0018\u00010\u001b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bh\u0010iR\u0014\u0010\u000b\u001a\u00020\n8$X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\bj\u0010k\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006m"}, d2={"Lkotlinx/serialization/json/internal/AbstractJsonLexer;", "", "", "startPosition", "appendEsc", "(I)I", "lastPosition", "current", "appendEscape", "(II)I", "", "source", "startPos", "appendHex", "(Ljava/lang/CharSequence;I)I", "fromIndex", "toIndex", "", "appendRange", "(II)V", "", "canConsumeValue", "()Z", "consumeBoolean", "start", "(I)Z", "consumeBooleanLenient", "", "literalSuffix", "consumeBooleanLiteral", "(Ljava/lang/String;I)V", "consumeKeyString", "()Ljava/lang/String;", "", "consumeNextToken", "()B", "expected", "(B)B", "", "(C)V", "", "consumeNumericLiteral", "()J", "consumeString", "(Ljava/lang/CharSequence;II)Ljava/lang/String;", "consumeStringLenient", "consumeStringLenientNotNull", "currentPosition", "decodedString", "(II)Ljava/lang/String;", "ensureHaveChars", "()V", "expectEof", "expectedToken", "", "fail$kotlinx_serialization_json", "(B)Ljava/lang/Void;", "fail", "message", "position", "(Ljava/lang/String;I)Ljava/lang/Void;", "key", "failOnUnknownKey", "(Ljava/lang/String;)V", "fromHexChar", "char", "indexOf", "(CI)I", "isNotEof", "c", "isValidValueStart", "(C)Z", "peekNextToken", "isLenient", "peekString", "(Z)Ljava/lang/String;", "prefetchOrEof", "condition", "Lkotlin/Function0;", "require$kotlinx_serialization_json", "(ZILkotlin/jvm/functions/Function0;)V", "require", "allowLenientStrings", "skipElement", "(Z)V", "skipWhitespaces", "()I", "endPos", "substring", "takePeeked", "toString", "tryConsumeComma", "tryConsumeNotNull", "unexpectedToken", "wasUnquotedString", "I", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "escapedString", "Ljava/lang/StringBuilder;", "getEscapedString", "()Ljava/lang/StringBuilder;", "setEscapedString", "(Ljava/lang/StringBuilder;)V", "peekedString", "Ljava/lang/String;", "getSource", "()Ljava/lang/CharSequence;", "<init>", "kotlinx-serialization-json"})
public abstract class AbstractJsonLexer {
    @JvmField
    protected int currentPosition;
    @Nullable
    private String peekedString;
    @NotNull
    private StringBuilder escapedString = new StringBuilder();

    @NotNull
    protected abstract CharSequence getSource();

    public void ensureHaveChars() {
    }

    public final boolean isNotEof() {
        return this.peekNextToken() != 10;
    }

    public abstract int prefetchOrEof(int var1);

    public abstract boolean tryConsumeComma();

    public abstract boolean canConsumeValue();

    public abstract byte consumeNextToken();

    protected final boolean isValidValueStart(char c) {
        char c2 = c;
        return !(((c2 == '}' ? true : c2 == ']') ? true : c2 == ':') ? true : c2 == ',');
    }

    public final void expectEof() {
        byte nextToken = this.consumeNextToken();
        if (nextToken != 10) {
            AbstractJsonLexer.fail$default(this, "Expected EOF after parsing, but had " + this.getSource().charAt(this.currentPosition - 1) + " instead", 0, 2, null);
            throw new KotlinNothingValueException();
        }
    }

    @NotNull
    protected final StringBuilder getEscapedString() {
        return this.escapedString;
    }

    protected final void setEscapedString(@NotNull StringBuilder stringBuilder) {
        Intrinsics.checkNotNullParameter(stringBuilder, "<set-?>");
        this.escapedString = stringBuilder;
    }

    public final byte consumeNextToken(byte expected) {
        byte token = this.consumeNextToken();
        if (token != expected) {
            this.fail$kotlinx_serialization_json(expected);
            throw new KotlinNothingValueException();
        }
        return token;
    }

    public void consumeNextToken(char expected) {
        this.ensureHaveChars();
        CharSequence source = this.getSource();
        int cpos = this.currentPosition;
        while ((cpos = this.prefetchOrEof(cpos)) != -1) {
            int n = cpos;
            cpos = n + 1;
            char c = source.charAt(n);
            if (c == ' ' || c == '\n' || c == '\r' || c == '\t') continue;
            this.currentPosition = cpos;
            if (c == expected) {
                return;
            }
            this.unexpectedToken(expected);
        }
        this.currentPosition = cpos;
        this.unexpectedToken(expected);
    }

    protected final void unexpectedToken(char expected) {
        this.currentPosition += -1;
        if (this.currentPosition >= 0 && expected == '\"' && Intrinsics.areEqual(this.consumeStringLenient(), "null")) {
            this.fail("Expected string literal but 'null' literal was found.\nUse 'coerceInputValues = true' in 'Json {}` builder to coerce nulls to default values.", this.currentPosition - 4);
            throw new KotlinNothingValueException();
        }
        this.fail$kotlinx_serialization_json(AbstractJsonLexerKt.charToTokenClass(expected));
        throw new KotlinNothingValueException();
    }

    @NotNull
    public final Void fail$kotlinx_serialization_json(byte expectedToken) {
        byte by = expectedToken;
        String expected = by == 1 ? "quotation mark '\"'" : (by == 4 ? "comma ','" : (by == 5 ? "semicolon ':'" : (by == 6 ? "start of the object '{'" : (by == 7 ? "end of the object '}'" : (by == 8 ? "start of the array '['" : (by == 9 ? "end of the array ']'" : "valid token"))))));
        String s = this.currentPosition == this.getSource().length() || this.currentPosition <= 0 ? "EOF" : String.valueOf(this.getSource().charAt(this.currentPosition - 1));
        this.fail("Expected " + expected + ", but had '" + s + "' instead", this.currentPosition - 1);
        throw new KotlinNothingValueException();
    }

    public final byte peekNextToken() {
        CharSequence source = this.getSource();
        int cpos = this.currentPosition;
        while ((cpos = this.prefetchOrEof(cpos)) != -1) {
            char ch = source.charAt(cpos);
            if (ch == ' ' || ch == '\n' || ch == '\r' || ch == '\t') {
                ++cpos;
                continue;
            }
            this.currentPosition = cpos;
            return AbstractJsonLexerKt.charToTokenClass(ch);
        }
        this.currentPosition = cpos;
        return 10;
    }

    public final boolean tryConsumeNotNull() {
        int current = this.skipWhitespaces();
        current = this.prefetchOrEof(current);
        int len = this.getSource().length() - current;
        if (len < 4 || current == -1) {
            return true;
        }
        int n = 0;
        while (n < 4) {
            int i;
            if ("null".charAt(i = n++) == this.getSource().charAt(current + i)) continue;
            return true;
        }
        if (len > 4 && AbstractJsonLexerKt.charToTokenClass(this.getSource().charAt(current + 4)) == 0) {
            return true;
        }
        this.currentPosition = current + 4;
        return false;
    }

    public int skipWhitespaces() {
        char c;
        int current = this.currentPosition;
        while ((current = this.prefetchOrEof(current)) != -1 && ((c = this.getSource().charAt(current)) == ' ' || c == '\n' || c == '\r' || c == '\t')) {
            ++current;
        }
        this.currentPosition = current;
        return current;
    }

    @Nullable
    public final String peekString(boolean isLenient) {
        String string;
        String string2;
        byte token = this.peekNextToken();
        if (isLenient) {
            if (token != 1 && token != 0) {
                return null;
            }
            string2 = this.consumeStringLenient();
        } else {
            if (token != 1) {
                return null;
            }
            string2 = this.consumeString();
        }
        this.peekedString = string = string2;
        return string;
    }

    public int indexOf(char c, int startPos) {
        return StringsKt.indexOf$default(this.getSource(), c, startPos, false, 4, null);
    }

    @NotNull
    public String substring(int startPos, int endPos) {
        return ((Object)this.getSource().subSequence(startPos, endPos)).toString();
    }

    @NotNull
    public abstract String consumeKeyString();

    @NotNull
    public final String consumeString() {
        if (this.peekedString != null) {
            return this.takePeeked();
        }
        return this.consumeKeyString();
    }

    @NotNull
    protected final String consumeString(@NotNull CharSequence source, int startPosition, int current) {
        Intrinsics.checkNotNullParameter(source, "source");
        int currentPosition = current;
        int lastPosition = startPosition;
        char c = source.charAt(currentPosition);
        boolean usedAppend = false;
        while (c != '\"') {
            if (c == '\\') {
                usedAppend = true;
                if ((currentPosition = this.prefetchOrEof(this.appendEscape(lastPosition, currentPosition))) == -1) {
                    this.fail("EOF", currentPosition);
                    throw new KotlinNothingValueException();
                }
                lastPosition = currentPosition;
            } else if (++currentPosition >= source.length()) {
                usedAppend = true;
                this.appendRange(lastPosition, currentPosition);
                currentPosition = this.prefetchOrEof(currentPosition);
                if (currentPosition == -1) {
                    this.fail("EOF", currentPosition);
                    throw new KotlinNothingValueException();
                }
                lastPosition = currentPosition;
            }
            c = source.charAt(currentPosition);
        }
        String string = !usedAppend ? this.substring(lastPosition, currentPosition) : this.decodedString(lastPosition, currentPosition);
        this.currentPosition = currentPosition + 1;
        return string;
    }

    private final int appendEscape(int lastPosition, int current) {
        this.appendRange(lastPosition, current);
        return this.appendEsc(current + 1);
    }

    private final String decodedString(int lastPosition, int currentPosition) {
        this.appendRange(lastPosition, currentPosition);
        String string = this.escapedString.toString();
        Intrinsics.checkNotNullExpressionValue(string, "escapedString.toString()");
        String result2 = string;
        this.escapedString.setLength(0);
        return result2;
    }

    private final String takePeeked() {
        String string;
        String string2 = this.peekedString;
        Intrinsics.checkNotNull(string2);
        String it = string = string2;
        boolean bl = false;
        this.peekedString = null;
        return string;
    }

    @NotNull
    public final String consumeStringLenientNotNull() {
        String result2 = this.consumeStringLenient();
        if (Intrinsics.areEqual(result2, "null") && this.wasUnquotedString()) {
            AbstractJsonLexer.fail$default(this, "Unexpected 'null' value instead of string literal", 0, 2, null);
            throw new KotlinNothingValueException();
        }
        return result2;
    }

    private final boolean wasUnquotedString() {
        return this.getSource().charAt(this.currentPosition - 1) != '\"';
    }

    @NotNull
    public final String consumeStringLenient() {
        if (this.peekedString != null) {
            return this.takePeeked();
        }
        int current = this.skipWhitespaces();
        if (current >= this.getSource().length() || current == -1) {
            this.fail("EOF", current);
            throw new KotlinNothingValueException();
        }
        byte token = AbstractJsonLexerKt.charToTokenClass(this.getSource().charAt(current));
        if (token == 1) {
            return this.consumeString();
        }
        if (token != 0) {
            AbstractJsonLexer.fail$default(this, Intrinsics.stringPlus("Expected beginning of the string, but got ", Character.valueOf(this.getSource().charAt(current))), 0, 2, null);
            throw new KotlinNothingValueException();
        }
        boolean usedAppend = false;
        while (AbstractJsonLexerKt.charToTokenClass(this.getSource().charAt(current)) == 0) {
            if (++current < this.getSource().length()) continue;
            usedAppend = true;
            this.appendRange(this.currentPosition, current);
            int eof = this.prefetchOrEof(current);
            if (eof == -1) {
                this.currentPosition = current;
                return this.decodedString(0, 0);
            }
            current = eof;
        }
        String result2 = !usedAppend ? this.substring(this.currentPosition, current) : this.decodedString(this.currentPosition, current);
        this.currentPosition = current;
        return result2;
    }

    protected void appendRange(int fromIndex, int toIndex) {
        this.escapedString.append(this.getSource(), fromIndex, toIndex);
    }

    private final int appendEsc(int startPosition) {
        int currentPosition = startPosition;
        if ((currentPosition = this.prefetchOrEof(currentPosition)) == -1) {
            AbstractJsonLexer.fail$default(this, "Expected escape sequence to continue, got EOF", 0, 2, null);
            throw new KotlinNothingValueException();
        }
        int n = currentPosition;
        currentPosition = n + 1;
        char currentChar = this.getSource().charAt(n);
        if (currentChar == 'u') {
            return this.appendHex(this.getSource(), currentPosition);
        }
        char c = AbstractJsonLexerKt.escapeToChar(currentChar);
        if (c == '\u0000') {
            AbstractJsonLexer.fail$default(this, "Invalid escaped char '" + currentChar + '\'', 0, 2, null);
            throw new KotlinNothingValueException();
        }
        this.escapedString.append(c);
        return currentPosition;
    }

    private final int appendHex(CharSequence source, int startPos) {
        if (startPos + 4 >= source.length()) {
            this.currentPosition = startPos;
            this.ensureHaveChars();
            if (this.currentPosition + 4 >= source.length()) {
                AbstractJsonLexer.fail$default(this, "Unexpected EOF during unicode escape", 0, 2, null);
                throw new KotlinNothingValueException();
            }
            return this.appendHex(source, this.currentPosition);
        }
        this.escapedString.append((char)((this.fromHexChar(source, startPos) << 12) + (this.fromHexChar(source, startPos + 1) << 8) + (this.fromHexChar(source, startPos + 2) << 4) + this.fromHexChar(source, startPos + 3)));
        return startPos + 4;
    }

    public final void require$kotlinx_serialization_json(boolean condition2, int position, @NotNull Function0<String> message) {
        Intrinsics.checkNotNullParameter(message, "message");
        boolean $i$f$require$kotlinx_serialization_json = false;
        if (!condition2) {
            this.fail(message.invoke(), position);
            throw new KotlinNothingValueException();
        }
    }

    public static /* synthetic */ void require$kotlinx_serialization_json$default(AbstractJsonLexer this_, boolean condition2, int position, Function0 message, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: require");
        }
        if ((n & 2) != 0) {
            position = this_.currentPosition;
        }
        Intrinsics.checkNotNullParameter(message, "message");
        boolean $i$f$require$kotlinx_serialization_json = false;
        if (!condition2) {
            this_.fail((String)message.invoke(), position);
            throw new KotlinNothingValueException();
        }
    }

    private final int fromHexChar(CharSequence source, int currentPosition) {
        int n;
        char character = source.charAt(currentPosition);
        boolean bl = '0' <= character ? character < ':' : false;
        if (bl) {
            n = character - 48;
        } else {
            boolean bl2 = 'a' <= character ? character < 'g' : false;
            if (bl2) {
                n = character - 97 + 10;
            } else {
                boolean bl3 = 'A' <= character ? character < 'G' : false;
                if (bl3) {
                    n = character - 65 + 10;
                } else {
                    AbstractJsonLexer.fail$default(this, "Invalid toHexChar char '" + character + "' in unicode escape", 0, 2, null);
                    throw new KotlinNothingValueException();
                }
            }
        }
        return n;
    }

    public final void skipElement(boolean allowLenientStrings) {
        List tokenStack = new ArrayList();
        byte lastToken = this.peekNextToken();
        if (lastToken != 8 && lastToken != 6) {
            this.consumeStringLenient();
            return;
        }
        while (true) {
            if ((lastToken = this.peekNextToken()) == 1) {
                if (allowLenientStrings) {
                    this.consumeStringLenient();
                    continue;
                }
                this.consumeKeyString();
                continue;
            }
            byte by = lastToken;
            if (by == 8 ? true : by == 6) {
                tokenStack.add(lastToken);
            } else if (by == 9) {
                if (((Number)CollectionsKt.last(tokenStack)).byteValue() != 8) {
                    throw JsonExceptionsKt.JsonDecodingException(this.currentPosition, "found ] instead of }", this.getSource());
                }
                CollectionsKt.removeLast(tokenStack);
            } else if (by == 7) {
                if (((Number)CollectionsKt.last(tokenStack)).byteValue() != 6) {
                    throw JsonExceptionsKt.JsonDecodingException(this.currentPosition, "found } instead of ]", this.getSource());
                }
                CollectionsKt.removeLast(tokenStack);
            } else if (by == 10) {
                AbstractJsonLexer.fail$default(this, "Unexpected end of input due to malformed JSON during ignoring unknown keys", 0, 2, null);
                throw new KotlinNothingValueException();
            }
            this.consumeNextToken();
            if (tokenStack.size() == 0) break;
        }
    }

    @NotNull
    public String toString() {
        return "JsonReader(source='" + this.getSource() + "', currentPosition=" + this.currentPosition + ')';
    }

    public final void failOnUnknownKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        String processed = this.substring(0, this.currentPosition);
        int lastIndexOf = StringsKt.lastIndexOf$default((CharSequence)processed, key, 0, false, 6, null);
        this.fail("Encountered an unknown key '" + key + "'.\nUse 'ignoreUnknownKeys = true' in 'Json {}' builder to ignore unknown keys.", lastIndexOf);
        throw new KotlinNothingValueException();
    }

    @NotNull
    public final Void fail(@NotNull String message, int position) {
        Intrinsics.checkNotNullParameter(message, "message");
        throw JsonExceptionsKt.JsonDecodingException(position, message, this.getSource());
    }

    public static /* synthetic */ Void fail$default(AbstractJsonLexer abstractJsonLexer, String string, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: fail");
        }
        if ((n2 & 2) != 0) {
            n = abstractJsonLexer.currentPosition;
        }
        return abstractJsonLexer.fail(string, n);
    }

    public final long consumeNumericLiteral() {
        long l;
        boolean bl;
        int current = this.skipWhitespaces();
        if ((current = this.prefetchOrEof(current)) >= this.getSource().length() || current == -1) {
            AbstractJsonLexer.fail$default(this, "EOF", 0, 2, null);
            throw new KotlinNothingValueException();
        }
        if (this.getSource().charAt(current) == '\"') {
            if (++current == this.getSource().length()) {
                AbstractJsonLexer.fail$default(this, "EOF", 0, 2, null);
                throw new KotlinNothingValueException();
            }
            bl = true;
        } else {
            bl = false;
        }
        boolean hasQuotation = bl;
        long accumulator = 0L;
        boolean isNegative = false;
        int start2 = current;
        boolean hasChars = true;
        while (hasChars) {
            char ch = this.getSource().charAt(current);
            if (ch == '-') {
                if (current != start2) {
                    AbstractJsonLexer.fail$default(this, "Unexpected symbol '-' in numeric literal", 0, 2, null);
                    throw new KotlinNothingValueException();
                }
                isNegative = true;
                ++current;
                continue;
            }
            byte token = AbstractJsonLexerKt.charToTokenClass(ch);
            if (token != 0) break;
            hasChars = ++current != this.getSource().length();
            int digit = ch - 48;
            if (!(0 <= digit ? digit < 10 : false)) {
                AbstractJsonLexer.fail$default(this, "Unexpected symbol '" + ch + "' in numeric literal", 0, 2, null);
                throw new KotlinNothingValueException();
            }
            if ((accumulator = accumulator * (long)10 - (long)digit) <= 0L) continue;
            AbstractJsonLexer.fail$default(this, "Numeric value overflow", 0, 2, null);
            throw new KotlinNothingValueException();
        }
        if (start2 == current || isNegative && start2 == current - 1) {
            AbstractJsonLexer.fail$default(this, "Expected numeric literal", 0, 2, null);
            throw new KotlinNothingValueException();
        }
        if (hasQuotation) {
            if (!hasChars) {
                AbstractJsonLexer.fail$default(this, "EOF", 0, 2, null);
                throw new KotlinNothingValueException();
            }
            if (this.getSource().charAt(current) != '\"') {
                AbstractJsonLexer.fail$default(this, "Expected closing quotation mark", 0, 2, null);
                throw new KotlinNothingValueException();
            }
            ++current;
        }
        this.currentPosition = current;
        if (isNegative) {
            l = accumulator;
        } else if (accumulator != Long.MIN_VALUE) {
            l = -accumulator;
        } else {
            AbstractJsonLexer.fail$default(this, "Numeric value overflow", 0, 2, null);
            throw new KotlinNothingValueException();
        }
        return l;
    }

    public final boolean consumeBoolean() {
        return this.consumeBoolean(this.skipWhitespaces());
    }

    public final boolean consumeBooleanLenient() {
        boolean bl;
        int current = this.skipWhitespaces();
        if (current == this.getSource().length()) {
            AbstractJsonLexer.fail$default(this, "EOF", 0, 2, null);
            throw new KotlinNothingValueException();
        }
        if (this.getSource().charAt(current) == '\"') {
            ++current;
            bl = true;
        } else {
            bl = false;
        }
        boolean hasQuotation = bl;
        boolean result2 = this.consumeBoolean(current);
        if (hasQuotation) {
            if (this.currentPosition == this.getSource().length()) {
                AbstractJsonLexer.fail$default(this, "EOF", 0, 2, null);
                throw new KotlinNothingValueException();
            }
            if (this.getSource().charAt(this.currentPosition) != '\"') {
                AbstractJsonLexer.fail$default(this, "Expected closing quotation mark", 0, 2, null);
                throw new KotlinNothingValueException();
            }
            ++this.currentPosition;
        }
        return result2;
    }

    private final boolean consumeBoolean(int start2) {
        boolean bl;
        int current = this.prefetchOrEof(start2);
        if (current >= this.getSource().length() || current == -1) {
            AbstractJsonLexer.fail$default(this, "EOF", 0, 2, null);
            throw new KotlinNothingValueException();
        }
        int n = current;
        current = n + 1;
        int n2 = this.getSource().charAt(n) | 0x20;
        if (n2 == 116) {
            this.consumeBooleanLiteral("rue", current);
            bl = true;
        } else if (n2 == 102) {
            this.consumeBooleanLiteral("alse", current);
            bl = false;
        } else {
            AbstractJsonLexer.fail$default(this, "Expected valid boolean literal prefix, but had '" + this.consumeStringLenient() + '\'', 0, 2, null);
            throw new KotlinNothingValueException();
        }
        return bl;
    }

    private final void consumeBooleanLiteral(String literalSuffix, int current) {
        if (this.getSource().length() - current < literalSuffix.length()) {
            AbstractJsonLexer.fail$default(this, "Unexpected end of boolean literal", 0, 2, null);
            throw new KotlinNothingValueException();
        }
        int n = 0;
        int n2 = literalSuffix.length();
        while (n < n2) {
            char actual;
            int i;
            char expected;
            if ((expected = literalSuffix.charAt(i = n++)) == ((actual = this.getSource().charAt(current + i)) | 0x20)) continue;
            AbstractJsonLexer.fail$default(this, "Expected valid boolean literal prefix, but had '" + this.consumeStringLenient() + '\'', 0, 2, null);
            throw new KotlinNothingValueException();
        }
        this.currentPosition = current + literalSuffix.length();
    }
}

