/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.internal;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.ClassSerialDescriptorBuilder;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorsKt;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0006\b\u0001\u0018\u0000*\u000e\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u00028\u00000\u00012\b\u0012\u0004\u0012\u00028\u00000\u0003B\u001d\u0012\u0006\u0010\u0019\u001a\u00020\u000e\u0012\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u0006\u001a\u00028\u00002\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001f\u0010\f\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0012\u001a\u00020\u00118\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001c"}, d2={"Lkotlinx/serialization/internal/EnumSerializer;", "", "T", "Lkotlinx/serialization/KSerializer;", "Lkotlinx/serialization/encoding/Decoder;", "decoder", "deserialize", "(Lkotlinx/serialization/encoding/Decoder;)Ljava/lang/Enum;", "Lkotlinx/serialization/encoding/Encoder;", "encoder", "value", "", "serialize", "(Lkotlinx/serialization/encoding/Encoder;Ljava/lang/Enum;)V", "", "toString", "()Ljava/lang/String;", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "", "values", "[Ljava/lang/Enum;", "serialName", "<init>", "(Ljava/lang/String;[Ljava/lang/Enum;)V", "kotlinx-serialization-core"})
@PublishedApi
public final class EnumSerializer<T extends Enum<T>>
implements KSerializer<T> {
    @NotNull
    private final T[] values;
    @NotNull
    private final SerialDescriptor descriptor;

    public EnumSerializer(@NotNull String serialName, @NotNull T[] values2) {
        Intrinsics.checkNotNullParameter(serialName, "serialName");
        Intrinsics.checkNotNullParameter(values2, "values");
        this.values = values2;
        this.descriptor = SerialDescriptorsKt.buildSerialDescriptor(serialName, SerialKind.ENUM.INSTANCE, new SerialDescriptor[0], (Function1<? super ClassSerialDescriptorBuilder, Unit>)new Function1<ClassSerialDescriptorBuilder, Unit>(this, serialName){
            final /* synthetic */ EnumSerializer<T> this$0;
            final /* synthetic */ String $serialName;
            {
                this.this$0 = $receiver;
                this.$serialName = $serialName;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ClassSerialDescriptorBuilder $this$buildSerialDescriptor) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter($this$buildSerialDescriptor, "$this$buildSerialDescriptor");
                Enum[] enumArray = EnumSerializer.access$getValues$p(this.this$0);
                String string = this.$serialName;
                boolean $i$f$forEach = false;
                for (void element$iv : $this$forEach$iv) {
                    void it = element$iv;
                    boolean bl = false;
                    String fqn = string + '.' + it.name();
                    SerialDescriptor enumMemberDescriptor = SerialDescriptorsKt.buildSerialDescriptor$default(fqn, StructureKind.OBJECT.INSTANCE, new SerialDescriptor[0], null, 8, null);
                    ClassSerialDescriptorBuilder.element$default($this$buildSerialDescriptor, it.name(), enumMemberDescriptor, null, false, 12, null);
                }
            }
        });
    }

    @Override
    @NotNull
    public SerialDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public void serialize(@NotNull Encoder encoder2, @NotNull T value) {
        Intrinsics.checkNotNullParameter(encoder2, "encoder");
        Intrinsics.checkNotNullParameter(value, "value");
        int index = ArraysKt.indexOf(this.values, value);
        if (index == -1) {
            StringBuilder stringBuilder = new StringBuilder().append(value).append(" is not a valid enum ").append(this.getDescriptor().getSerialName()).append(", must be one of ");
            String string = Arrays.toString(this.values);
            Intrinsics.checkNotNullExpressionValue(string, "toString(this)");
            throw new SerializationException(stringBuilder.append(string).toString());
        }
        encoder2.encodeEnum(this.getDescriptor(), index);
    }

    @Override
    @NotNull
    public T deserialize(@NotNull Decoder decoder) {
        Intrinsics.checkNotNullParameter(decoder, "decoder");
        int index = decoder.decodeEnum(this.getDescriptor());
        if (!(0 <= index ? index < this.values.length : false)) {
            throw new SerializationException(index + " is not among valid " + this.getDescriptor().getSerialName() + " enum values, values size is " + this.values.length);
        }
        return this.values[index];
    }

    @NotNull
    public String toString() {
        return "kotlinx.serialization.internal.EnumSerializer<" + this.getDescriptor().getSerialName() + '>';
    }

    public static final /* synthetic */ Enum[] access$getValues$p(EnumSerializer $this) {
        return $this.values;
    }
}

