/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.internal;

import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.descriptors.SerialDescriptor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0016\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0001\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB)\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u0012\u0018\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0007\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\n\u001a\u00020\u0002\u00a2\u0006\u0004\b\n\u0010\tJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\r\u0010\u000eR\u0014\u0010\u0010\u001a\u00020\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0015\u001a\u00020\u00148\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R&\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00180\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001e"}, d2={"Lkotlinx/serialization/internal/ElementMarker;", "", "", "index", "", "mark", "(I)V", "markHigh", "nextUnmarkedHighIndex", "()I", "nextUnmarkedIndex", "elementsCount", "", "prepareHighMarksArray", "(I)[J", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "highMarksArray", "[J", "", "lowerMarks", "J", "Lkotlin/Function2;", "", "readIfAbsent", "Lkotlin/jvm/functions/Function2;", "<init>", "(Lkotlinx/serialization/descriptors/SerialDescriptor;Lkotlin/jvm/functions/Function2;)V", "Companion", "kotlinx-serialization-core"})
@PublishedApi
public final class ElementMarker {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final SerialDescriptor descriptor;
    @NotNull
    private final Function2<SerialDescriptor, Integer, Boolean> readIfAbsent;
    private long lowerMarks;
    @NotNull
    private final long[] highMarksArray;
    @Deprecated
    @NotNull
    private static final long[] EMPTY_HIGH_MARKS = new long[0];

    public ElementMarker(@NotNull SerialDescriptor descriptor2, @NotNull Function2<? super SerialDescriptor, ? super Integer, Boolean> readIfAbsent) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(readIfAbsent, "readIfAbsent");
        this.descriptor = descriptor2;
        this.readIfAbsent = readIfAbsent;
        int elementsCount = this.descriptor.getElementsCount();
        if (elementsCount <= 64) {
            this.lowerMarks = elementsCount == 64 ? 0L : -1L << elementsCount;
            this.highMarksArray = EMPTY_HIGH_MARKS;
        } else {
            this.lowerMarks = 0L;
            this.highMarksArray = this.prepareHighMarksArray(elementsCount);
        }
    }

    public final void mark(int index) {
        if (index < 64) {
            this.lowerMarks |= 1L << index;
        } else {
            this.markHigh(index);
        }
    }

    public final int nextUnmarkedIndex() {
        int elementsCount = this.descriptor.getElementsCount();
        while (this.lowerMarks != -1L) {
            int index = Long.numberOfTrailingZeros(this.lowerMarks ^ 0xFFFFFFFFFFFFFFFFL);
            this.lowerMarks |= 1L << index;
            if (!this.readIfAbsent.invoke(this.descriptor, index).booleanValue()) continue;
            return index;
        }
        if (elementsCount > 64) {
            return this.nextUnmarkedHighIndex();
        }
        return -1;
    }

    private final long[] prepareHighMarksArray(int elementsCount) {
        int slotsCount = elementsCount - 1 >>> 6;
        int elementsInLastSlot = elementsCount & 0x3F;
        long[] highMarks = new long[slotsCount];
        if (elementsInLastSlot != 0) {
            highMarks[ArraysKt.getLastIndex((long[])highMarks)] = -1L << elementsCount;
        }
        return highMarks;
    }

    private final void markHigh(int index) {
        int slot = (index >>> 6) - 1;
        int offsetInSlot = index & 0x3F;
        this.highMarksArray[slot] = this.highMarksArray[slot] | 1L << offsetInSlot;
    }

    private final int nextUnmarkedHighIndex() {
        int n = 0;
        int n2 = this.highMarksArray.length;
        while (n < n2) {
            long slotMarks;
            int indexInSlot;
            int slot = n++;
            int slotOffset = (slot + 1) * 64;
            for (slotMarks = this.highMarksArray[slot]; slotMarks != -1L; slotMarks |= 1L << indexInSlot) {
                indexInSlot = Long.numberOfTrailingZeros(slotMarks ^ 0xFFFFFFFFFFFFFFFFL);
                int index = slotOffset + indexInSlot;
                if (!this.readIfAbsent.invoke(this.descriptor, index).booleanValue()) continue;
                this.highMarksArray[slot] = slotMarks;
                return index;
            }
            this.highMarksArray[slot] = slotMarks;
        }
        return -1;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0016\n\u0002\b\u0005\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0007"}, d2={"Lkotlinx/serialization/internal/ElementMarker$Companion;", "", "", "EMPTY_HIGH_MARKS", "[J", "<init>", "()V", "kotlinx-serialization-core"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

