/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.calls;

import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.jvm.internal.KotlinReflectionInternalError;
import kotlin.reflect.jvm.internal.UtilKt;
import kotlin.reflect.jvm.internal.calls.BoundCaller;
import kotlin.reflect.jvm.internal.calls.Caller;
import kotlin.reflect.jvm.internal.calls.CallerImpl;
import kotlin.reflect.jvm.internal.calls.CallerKt;
import kotlin.reflect.jvm.internal.calls.InlineClassAwareCallerKt;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ReceiverParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.InlineClassesUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000*\f\b\u0000\u0010\u0002 \u0001*\u0004\u0018\u00010\u00012\b\u0012\u0004\u0012\u00028\u00000\u0003:\u0001 B%\u0012\u0006\u0010\u001d\u001a\u00020\u001c\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001d\u0010\u0007\u001a\u0004\u0018\u00010\u00062\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\nR\u0014\u0010\f\u001a\u00020\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0013\u001a\u00028\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u001b\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006!"}, d2={"Lkotlin/reflect/jvm/internal/calls/InlineClassAwareCaller;", "Ljava/lang/reflect/Member;", "M", "Lkotlin/reflect/jvm/internal/calls/Caller;", "", "args", "", "call", "([Ljava/lang/Object;)Ljava/lang/Object;", "caller", "Lkotlin/reflect/jvm/internal/calls/Caller;", "Lkotlin/reflect/jvm/internal/calls/InlineClassAwareCaller$BoxUnboxData;", "data", "Lkotlin/reflect/jvm/internal/calls/InlineClassAwareCaller$BoxUnboxData;", "", "isDefault", "Z", "getMember", "()Ljava/lang/reflect/Member;", "member", "", "Ljava/lang/reflect/Type;", "getParameterTypes", "()Ljava/util/List;", "parameterTypes", "getReturnType", "()Ljava/lang/reflect/Type;", "returnType", "Lkotlin/reflect/jvm/internal/impl/descriptors/CallableMemberDescriptor;", "descriptor", "<init>", "(Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;Lkotlin/reflect/jvm/internal/calls/Caller;Z)V", "BoxUnboxData", "kotlin-reflection"})
public final class InlineClassAwareCaller<M extends Member>
implements Caller<M> {
    @NotNull
    private final Caller<M> caller;
    private final boolean isDefault;
    @NotNull
    private final BoxUnboxData data;

    /*
     * WARNING - void declaration
     */
    public InlineClassAwareCaller(@NotNull CallableMemberDescriptor descriptor2, @NotNull Caller<? extends M> caller2, boolean isDefault) {
        BoxUnboxData boxUnboxData;
        Method box;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(caller2, "caller");
        this.caller = caller2;
        this.isDefault = isDefault;
        InlineClassAwareCaller inlineClassAwareCaller = this;
        InlineClassAwareCaller inlineClassAwareCaller2 = this;
        boolean bl = false;
        KotlinType kotlinType = descriptor2.getReturnType();
        Intrinsics.checkNotNull(kotlinType);
        Class<?> clazz = InlineClassAwareCallerKt.toInlineClass(kotlinType);
        Method method = box = clazz != null ? InlineClassAwareCallerKt.getBoxMethod(clazz, descriptor2) : null;
        if (InlineClassesUtilsKt.isGetterOfUnderlyingPropertyOfInlineClass(descriptor2)) {
            boolean $i$f$emptyArray = false;
            boxUnboxData = new BoxUnboxData(IntRange.Companion.getEMPTY(), (Method[])((Object[])new Method[0]), box);
        } else {
            KotlinType extensionReceiverType;
            ArrayList<KotlinType> arrayList;
            int n;
            void $this$data_u24lambda_u2d1;
            if ($this$data_u24lambda_u2d1.caller instanceof CallerImpl.Method.BoundStatic) {
                n = -1;
            } else if (descriptor2 instanceof ConstructorDescriptor) {
                n = $this$data_u24lambda_u2d1.caller instanceof BoundCaller ? -1 : 0;
            } else if (descriptor2.getDispatchReceiverParameter() != null && !($this$data_u24lambda_u2d1.caller instanceof BoundCaller)) {
                DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
                Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "descriptor.containingDeclaration");
                n = InlineClassesUtilsKt.isInlineClass(declarationDescriptor) ? 0 : 1;
            } else {
                n = 0;
            }
            int shift = n;
            int extraArgumentsTail = ($this$data_u24lambda_u2d1.isDefault ? 2 : 0) + (descriptor2 instanceof FunctionDescriptor && ((FunctionDescriptor)descriptor2).isSuspend() ? 1 : 0);
            ArrayList<KotlinType> kotlinParameterTypes = arrayList = new ArrayList<KotlinType>();
            boolean bl2 = false;
            ReceiverParameterDescriptor receiverParameterDescriptor = descriptor2.getExtensionReceiverParameter();
            KotlinType kotlinType2 = extensionReceiverType = receiverParameterDescriptor != null ? receiverParameterDescriptor.getType() : null;
            if (extensionReceiverType != null) {
                kotlinParameterTypes.add(extensionReceiverType);
            } else if (descriptor2 instanceof ConstructorDescriptor) {
                ClassDescriptor classDescriptor = ((ConstructorDescriptor)descriptor2).getConstructedClass();
                Intrinsics.checkNotNullExpressionValue(classDescriptor, "descriptor.constructedClass");
                ClassDescriptor constructedClass = classDescriptor;
                if (constructedClass.isInner()) {
                    DeclarationDescriptor declarationDescriptor = constructedClass.getContainingDeclaration();
                    Intrinsics.checkNotNull(declarationDescriptor, "null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                    kotlinParameterTypes.add(((ClassDescriptor)declarationDescriptor).getDefaultType());
                }
            } else {
                DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
                Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "descriptor.containingDeclaration");
                DeclarationDescriptor containingDeclaration = declarationDescriptor;
                if (containingDeclaration instanceof ClassDescriptor && InlineClassesUtilsKt.isInlineClass(containingDeclaration)) {
                    kotlinParameterTypes.add(((ClassDescriptor)containingDeclaration).getDefaultType());
                }
            }
            List<ValueParameterDescriptor> list = descriptor2.getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list, "descriptor.valueParameters");
            Iterable $this$mapTo$iv = list;
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void p0;
                ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv;
                Collection collection = kotlinParameterTypes;
                boolean bl3 = false;
                collection.add(p0.getType());
            }
            List kotlinParameterTypes2 = arrayList;
            int expectedArgsSize = kotlinParameterTypes2.size() + shift + extraArgumentsTail;
            if (CallerKt.getArity((Caller)$this$data_u24lambda_u2d1) != expectedArgsSize) {
                throw new KotlinReflectionInternalError("Inconsistent number of parameters in the descriptor and Java reflection object: " + CallerKt.getArity((Caller)$this$data_u24lambda_u2d1) + " != " + expectedArgsSize + "\nCalling: " + descriptor2 + "\nParameter types: " + $this$data_u24lambda_u2d1.getParameterTypes() + ")\nDefault: " + $this$data_u24lambda_u2d1.isDefault);
            }
            IntRange argumentRange = RangesKt.until(Math.max(shift, 0), kotlinParameterTypes2.size() + shift);
            Method[] methodArray = new Method[expectedArgsSize];
            for (int i = 0; i < expectedArgsSize; ++i) {
                Method method2;
                int n2 = i;
                int n3 = argumentRange.getFirst();
                boolean bl4 = n2 <= argumentRange.getLast() ? n3 <= n2 : false;
                if (bl4) {
                    Class<?> clazz2 = InlineClassAwareCallerKt.toInlineClass((KotlinType)kotlinParameterTypes2.get(n2 - shift));
                    method2 = clazz2 != null ? InlineClassAwareCallerKt.getUnboxMethod(clazz2, descriptor2) : null;
                } else {
                    method2 = null;
                }
                methodArray[n2] = method2;
            }
            Method[] unbox = methodArray;
            boxUnboxData = new BoxUnboxData(argumentRange, unbox, box);
        }
        inlineClassAwareCaller2.data = boxUnboxData;
    }

    @Override
    public M getMember() {
        return this.caller.getMember();
    }

    @Override
    @NotNull
    public Type getReturnType() {
        return this.caller.getReturnType();
    }

    @Override
    @NotNull
    public List<Type> getParameterTypes() {
        return this.caller.getParameterTypes();
    }

    @Override
    @Nullable
    public Object call(@NotNull Object[] args2) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter(args2, "args");
        BoxUnboxData boxUnboxData = this.data;
        IntRange range = boxUnboxData.component1();
        Method[] unbox = boxUnboxData.component2();
        Method box = boxUnboxData.component3();
        Object[] objectArray2 = Arrays.copyOf(args2, args2.length);
        Intrinsics.checkNotNullExpressionValue(objectArray2, "copyOf(this, size)");
        Intrinsics.checkNotNull(objectArray2, "null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
        Object[] unboxed = objectArray2;
        int index = range.getFirst();
        int n = range.getLast();
        if (index <= n) {
            while (true) {
                Object object;
                Method method = unbox[index];
                Object arg = args2[index];
                if (method != null) {
                    if (arg != null) {
                        object = method.invoke(arg, new Object[0]);
                    } else {
                        Class<?> clazz = method.getReturnType();
                        Intrinsics.checkNotNullExpressionValue(clazz, "method.returnType");
                        object = UtilKt.defaultPrimitiveValue(clazz);
                    }
                } else {
                    object = unboxed[index] = arg;
                }
                if (index == n) break;
                ++index;
            }
        }
        Object result2 = this.caller.call(unboxed);
        Object object = box;
        if (object == null || (object = ((Method)object).invoke(null, objectArray = new Object[]{result2})) == null) {
            object = result2;
        }
        return object;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u000b\u001a\u00020\u0002\u0012\u000e\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0003\u001a\u00020\u0002H\u0086\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005H\u0086\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\t\u001a\u0004\u0018\u00010\u0006H\u0086\u0002\u00a2\u0006\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u0004R\u0019\u0010\u000e\u001a\u0004\u0018\u00010\u00068\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\nR\u001f\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\b\u00a8\u0006\u0016"}, d2={"Lkotlin/reflect/jvm/internal/calls/InlineClassAwareCaller$BoxUnboxData;", "", "Lkotlin/ranges/IntRange;", "component1", "()Lkotlin/ranges/IntRange;", "", "Ljava/lang/reflect/Method;", "component2", "()[Ljava/lang/reflect/Method;", "component3", "()Ljava/lang/reflect/Method;", "argumentRange", "Lkotlin/ranges/IntRange;", "getArgumentRange", "box", "Ljava/lang/reflect/Method;", "getBox", "unbox", "[Ljava/lang/reflect/Method;", "getUnbox", "<init>", "(Lkotlin/ranges/IntRange;[Ljava/lang/reflect/Method;Ljava/lang/reflect/Method;)V", "kotlin-reflection"})
    private static final class BoxUnboxData {
        @NotNull
        private final IntRange argumentRange;
        @NotNull
        private final Method[] unbox;
        @Nullable
        private final Method box;

        public BoxUnboxData(@NotNull IntRange argumentRange, @NotNull Method[] unbox, @Nullable Method box) {
            Intrinsics.checkNotNullParameter(argumentRange, "argumentRange");
            Intrinsics.checkNotNullParameter(unbox, "unbox");
            this.argumentRange = argumentRange;
            this.unbox = unbox;
            this.box = box;
        }

        @NotNull
        public final IntRange component1() {
            return this.argumentRange;
        }

        @NotNull
        public final Method[] component2() {
            return this.unbox;
        }

        @Nullable
        public final Method component3() {
            return this.box;
        }
    }
}

