/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.util;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.objects.Accessor;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSProperty;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import com.oracle.truffle.js.runtime.objects.PropertyProxy;
import com.oracle.truffle.js.runtime.objects.Undefined;

public final class DefinePropertyUtil {
    private DefinePropertyUtil() {
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean ordinaryDefineOwnProperty(JSDynamicObject thisObj, Object propertyKey, PropertyDescriptor descriptor2, boolean doThrow) {
        PropertyDescriptor current = JSObject.getOwnProperty(thisObj, propertyKey);
        return DefinePropertyUtil.validateAndApplyPropertyDescriptor(thisObj, propertyKey, JSObject.isExtensible(thisObj), descriptor2, current, doThrow);
    }

    public static boolean isCompatiblePropertyDescriptor(boolean extensible, PropertyDescriptor descriptor2, PropertyDescriptor current) {
        return DefinePropertyUtil.isCompatiblePropertyDescriptor(extensible, descriptor2, current, false);
    }

    public static boolean isCompatiblePropertyDescriptor(boolean extensible, PropertyDescriptor descriptor2, PropertyDescriptor current, boolean doThrow) {
        return DefinePropertyUtil.validateAndApplyPropertyDescriptor(Undefined.instance, Undefined.instance, extensible, descriptor2, current, doThrow);
    }

    public static boolean validateAndApplyPropertyDescriptor(JSDynamicObject thisObj, Object propertyKey, boolean extensible, PropertyDescriptor descriptor2, PropertyDescriptor current, boolean doThrow) {
        CompilerAsserts.neverPartOfCompilation();
        if (current == null) {
            if (!extensible) {
                return DefinePropertyUtil.reject(doThrow, DefinePropertyUtil.notExtensibleMessage(propertyKey, doThrow));
            }
            if (thisObj == Undefined.instance) {
                return true;
            }
            return DefinePropertyUtil.definePropertyNew(thisObj, propertyKey, descriptor2, doThrow);
        }
        return DefinePropertyUtil.definePropertyExisting(thisObj, propertyKey, descriptor2, doThrow, current);
    }

    public static Property getPropertyByKey(JSDynamicObject thisObj, Object key) {
        assert (JSRuntime.isPropertyKey(key));
        return thisObj.getShape().getProperty(key);
    }

    private static boolean definePropertyExisting(JSDynamicObject thisObj, Object key, PropertyDescriptor descriptor2, boolean doThrow, PropertyDescriptor currentDesc) {
        boolean writable;
        int newAttr;
        CompilerAsserts.neverPartOfCompilation();
        assert (currentDesc.isFullyPopulatedPropertyDescriptor());
        if (descriptor2.hasNoFields()) {
            return true;
        }
        boolean currentEnumerable = currentDesc.getEnumerable();
        boolean currentConfigurable = currentDesc.getConfigurable();
        boolean currentWritable = currentDesc.getWritable();
        boolean enumerable = descriptor2.getIfHasEnumerable(currentEnumerable);
        boolean configurable = descriptor2.getIfHasConfigurable(currentConfigurable);
        if (!currentConfigurable && (configurable || descriptor2.hasEnumerable() && enumerable != currentEnumerable)) {
            return DefinePropertyUtil.reject(doThrow, DefinePropertyUtil.nonConfigurableMessage(key, doThrow));
        }
        if (descriptor2.isGenericDescriptor()) {
            newAttr = JSAttributes.fromConfigurableEnumerableWritable(configurable, enumerable, currentWritable);
        } else if (currentDesc.isDataDescriptor() && descriptor2.isDataDescriptor()) {
            writable = descriptor2.getIfHasWritable(currentWritable);
            if (!currentConfigurable && !currentWritable) {
                Object value;
                if (writable) {
                    return DefinePropertyUtil.reject(doThrow, DefinePropertyUtil.nonConfigurableMessage(key, doThrow));
                }
                if (descriptor2.hasValue() && !JSRuntime.isSameValue(value = descriptor2.getValue(), currentDesc.getValue())) {
                    return DefinePropertyUtil.reject(doThrow, DefinePropertyUtil.nonWritableMessage(key, doThrow));
                }
                return true;
            }
            newAttr = JSAttributes.fromConfigurableEnumerableWritable(configurable, enumerable, writable);
        } else if (currentDesc.isAccessorDescriptor() && descriptor2.isAccessorDescriptor()) {
            if (!currentConfigurable) {
                Accessor currentAccessor = DefinePropertyUtil.getAccessorFromDescriptor(currentDesc, doThrow);
                if (currentAccessor == null) {
                    return false;
                }
                if (descriptor2.hasSet() && !JSRuntime.isSameValue(descriptor2.getSet(), currentAccessor.getSetter())) {
                    return DefinePropertyUtil.reject(doThrow, DefinePropertyUtil.nonConfigurableMessage(key, doThrow));
                }
                if (descriptor2.hasGet() && !JSRuntime.isSameValue(descriptor2.getGet(), currentAccessor.getGetter())) {
                    return DefinePropertyUtil.reject(doThrow, DefinePropertyUtil.nonConfigurableMessage(key, doThrow));
                }
                return true;
            }
            newAttr = JSAttributes.fromConfigurableEnumerable(configurable, enumerable);
        } else {
            if (!currentConfigurable) {
                return DefinePropertyUtil.reject(doThrow, DefinePropertyUtil.nonConfigurableMessage(key, doThrow));
            }
            writable = descriptor2.getIfHasWritable(currentDesc.isDataDescriptor());
            newAttr = JSAttributes.fromConfigurableEnumerableWritable(configurable, enumerable, writable);
        }
        if (thisObj == Undefined.instance) {
            return true;
        }
        Property currentProperty = DefinePropertyUtil.getPropertyByKey(thisObj, key);
        if (JSProperty.isProxy(currentProperty) && descriptor2.isDataDescriptor()) {
            PropertyProxy proxy = (PropertyProxy)JSDynamicObject.getOrNull(thisObj, key);
            if (currentProperty.getFlags() != newAttr) {
                if (descriptor2.hasValue()) {
                    JSObjectUtil.defineDataProperty(thisObj, key, descriptor2.getValue(), newAttr);
                } else {
                    JSObjectUtil.defineProxyProperty(thisObj, key, proxy, newAttr);
                }
            } else if (descriptor2.hasValue()) {
                JSObject.set(thisObj, key, descriptor2.getValue(), doThrow, null);
            }
            return true;
        }
        if (currentDesc.isDataDescriptor() && descriptor2.isDataDescriptor() && currentProperty.getFlags() == newAttr) {
            if (descriptor2.hasValue()) {
                boolean present = DynamicObjectLibrary.getUncached().putIfPresent(thisObj, key, descriptor2.getValue());
                assert (present) : key;
            }
        } else {
            if (currentDesc.isAccessorDescriptor() && descriptor2.isAccessorDescriptor()) {
                if (descriptor2.hasSet() || descriptor2.hasGet()) {
                    Accessor currentAccessor = DefinePropertyUtil.getAccessorFromDescriptor(currentDesc, doThrow);
                    Accessor newAccessor = DefinePropertyUtil.getAccessorFromDescriptor(descriptor2, doThrow);
                    if (newAccessor == null || currentAccessor == null) {
                        assert (!doThrow);
                        return false;
                    }
                    if (currentAccessor.getGetter() != Undefined.instance && !descriptor2.hasGet()) {
                        newAccessor = new Accessor(currentAccessor.getGetter(), newAccessor.getSetter());
                    }
                    if (currentAccessor.getSetter() != Undefined.instance && !descriptor2.hasSet()) {
                        newAccessor = new Accessor(newAccessor.getGetter(), currentAccessor.getSetter());
                    }
                    if (currentProperty.getFlags() == newAttr) {
                        boolean present = DynamicObjectLibrary.getUncached().putIfPresent(thisObj, key, newAccessor);
                        assert (present) : key;
                    } else {
                        JSObjectUtil.defineAccessorProperty(thisObj, key, newAccessor, newAttr);
                    }
                }
                return true;
            }
            if (descriptor2.isAccessorDescriptor()) {
                Accessor accessor = DefinePropertyUtil.getAccessorFromDescriptor(descriptor2, doThrow);
                if (accessor == null) {
                    assert (!doThrow);
                    return false;
                }
                JSObjectUtil.defineAccessorProperty(thisObj, key, accessor, newAttr);
            } else if (descriptor2.isDataDescriptor()) {
                Object value = descriptor2.hasValue() ? descriptor2.getValue() : (currentDesc.isDataDescriptor() ? currentDesc.getValue() : Undefined.instance);
                JSObjectUtil.defineDataProperty(thisObj, key, value, newAttr);
            } else {
                assert (descriptor2.isGenericDescriptor());
                if (currentProperty.getFlags() != newAttr) {
                    JSObjectUtil.changePropertyFlags(thisObj, key, newAttr);
                }
            }
        }
        return true;
    }

    private static boolean definePropertyNew(JSDynamicObject thisObj, Object key, PropertyDescriptor descriptor2, boolean doThrow) {
        boolean enumerable = descriptor2.getIfHasEnumerable(false);
        boolean configurable = descriptor2.getIfHasConfigurable(false);
        JSContext context = JSObject.getJSContext(thisObj);
        if (descriptor2.isGenericDescriptor() || descriptor2.isDataDescriptor()) {
            return DefinePropertyUtil.definePropertyNewData(thisObj, key, descriptor2, enumerable, configurable, context);
        }
        return DefinePropertyUtil.definePropertyNewAccessor(thisObj, key, descriptor2, doThrow, enumerable, configurable, context);
    }

    private static boolean definePropertyNewAccessor(JSDynamicObject thisObj, Object key, PropertyDescriptor descriptor2, boolean doThrow, boolean enumerable, boolean configurable, JSContext context) {
        Accessor accessor = DefinePropertyUtil.getAccessorFromDescriptor(descriptor2, doThrow);
        if (accessor == null) {
            assert (!doThrow);
            return false;
        }
        JSObjectUtil.putAccessorProperty(context, thisObj, key, accessor, JSAttributes.fromConfigurableEnumerable(configurable, enumerable));
        return true;
    }

    private static boolean definePropertyNewData(JSDynamicObject thisObj, Object key, PropertyDescriptor descriptor2, boolean enumerable, boolean configurable, JSContext context) {
        boolean writable = descriptor2.getIfHasWritable(false);
        int attributes = JSAttributes.fromConfigurableEnumerableWritable(configurable, enumerable, writable);
        if (descriptor2.hasValue()) {
            JSObjectUtil.putDataProperty(context, thisObj, key, descriptor2.getValue(), attributes);
        } else {
            JSObjectUtil.putDeclaredDataProperty(context, thisObj, key, Undefined.instance, attributes);
        }
        return true;
    }

    private static Accessor getAccessorFromDescriptor(PropertyDescriptor descriptor2, boolean doThrow) {
        if (descriptor2.hasValue()) {
            DefinePropertyUtil.reject(doThrow, "Invalid property. A property cannot both have accessors and be writable or have a value");
            return null;
        }
        if (descriptor2.hasSet() && descriptor2.getSet() != Undefined.instance && !JSRuntime.isCallable(descriptor2.getSet())) {
            DefinePropertyUtil.reject(doThrow, "setter cannot be called");
            return null;
        }
        if (descriptor2.hasGet() && descriptor2.getGet() != Undefined.instance && !JSRuntime.isCallable(descriptor2.getGet())) {
            DefinePropertyUtil.reject(doThrow, "getter cannot be called");
            return null;
        }
        if (descriptor2.hasWritable()) {
            DefinePropertyUtil.reject(doThrow, "cannot have accessor and data properties");
            return null;
        }
        return new Accessor(descriptor2.getGet(), descriptor2.getSet());
    }

    public static boolean reject(boolean doThrow, String message) {
        if (doThrow) {
            throw Errors.createTypeError(message);
        }
        return false;
    }

    public static String notExtensibleMessage(Object key, boolean reject) {
        if (reject) {
            return "Cannot define property " + key + ", object is not extensible";
        }
        return "";
    }

    public static String nonConfigurableMessage(Object key, boolean reject) {
        if (reject) {
            return DefinePropertyUtil.isNashornMode() ? "property is not configurable" : DefinePropertyUtil.cannotRedefineMessage(key);
        }
        return "";
    }

    public static String nonWritableMessage(Object key, boolean reject) {
        if (reject) {
            return DefinePropertyUtil.isNashornMode() ? "property is not writable" : DefinePropertyUtil.cannotRedefineMessage(key);
        }
        return "";
    }

    private static boolean isNashornMode() {
        return JavaScriptLanguage.getCurrentLanguage().getJSContext().isOptionNashornCompatibilityMode();
    }

    private static String cannotRedefineMessage(Object key) {
        return JSRuntime.stringConcat("Cannot redefine property: ", JSRuntime.javaToString(key));
    }
}

