/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Properties;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.ToDisplayStringFormat;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.objects.Accessor;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSOrdinaryObject;
import com.oracle.truffle.js.runtime.objects.JSProperty;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.DefinePropertyUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.graalvm.collections.EconomicMap;

public final class JSDictionary
extends JSNonProxy {
    private static final HiddenKey HASHMAP_PROPERTY_NAME = new HiddenKey("%hashMap");
    public static final JSDictionary INSTANCE = new JSDictionary();

    private JSDictionary() {
    }

    public static boolean isJSDictionaryObject(Object obj) {
        return JSDynamicObject.isJSDynamicObject(obj) && JSDictionary.isJSDictionaryObject((JSDynamicObject)obj);
    }

    public static boolean isJSDictionaryObject(JSDynamicObject obj) {
        return JSDictionary.isInstance(obj, (JSClass)INSTANCE);
    }

    @Override
    public TruffleString getClassName(JSDynamicObject object) {
        return Strings.UC_OBJECT;
    }

    @Override
    public TruffleString toDisplayStringImpl(JSDynamicObject obj, boolean allowSideEffects, ToDisplayStringFormat format, int depth) {
        return this.defaultToString(obj);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object getOwnHelper(JSDynamicObject store, Object thisObj, Object key, Node encapsulatingNode) {
        assert (JSRuntime.isPropertyKey(key));
        PropertyDescriptor desc = (PropertyDescriptor)JSDictionary.getHashMap(store).get(key);
        if (desc != null) {
            return JSDictionary.getValue(desc, thisObj, encapsulatingNode);
        }
        return super.getOwnHelper(store, thisObj, key, encapsulatingNode);
    }

    public static Object getValue(PropertyDescriptor property, Object receiver, Node encapsulatingNode) {
        if (property.isAccessorDescriptor()) {
            Object getter = property.getGet();
            if (getter != Undefined.instance) {
                return JSRuntime.call(getter, receiver, JSArguments.EMPTY_ARGUMENTS_ARRAY, encapsulatingNode);
            }
            return Undefined.instance;
        }
        assert (property.isDataDescriptor());
        return property.getValue();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public List<Object> getOwnPropertyKeys(JSDynamicObject thisObj, boolean strings, boolean symbols) {
        assert (JSDictionary.isJSDictionaryObject(thisObj));
        List<Object> keys2 = JSDictionary.ordinaryOwnPropertyKeysSlow(thisObj, strings, symbols);
        for (Object key : JSDictionary.getHashMap(thisObj).getKeys()) {
            assert (JSRuntime.isPropertyKey(key));
            if (!symbols && key instanceof Symbol || !strings && Strings.isTString(key)) continue;
            keys2.add(key);
        }
        Collections.sort(keys2, JSRuntime::comparePropertyKeys);
        return keys2;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean delete(JSDynamicObject thisObj, Object key, boolean isStrict) {
        assert (JSRuntime.isPropertyKey(key));
        EconomicMap<Object, PropertyDescriptor> hashMap = JSDictionary.getHashMap(thisObj);
        PropertyDescriptor desc = (PropertyDescriptor)hashMap.get(key);
        if (desc != null) {
            if (!desc.getConfigurable()) {
                if (isStrict) {
                    throw Errors.createTypeErrorNotConfigurableProperty(key);
                }
                return false;
            }
            hashMap.removeKey(key);
            return true;
        }
        return super.delete(thisObj, key, isStrict);
    }

    @Override
    public boolean delete(JSDynamicObject thisObj, long index, boolean isStrict) {
        return this.delete(thisObj, Strings.fromLong(index), isStrict);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean hasOwnProperty(JSDynamicObject thisObj, Object key) {
        assert (JSRuntime.isPropertyKey(key));
        if (JSDictionary.getHashMap(thisObj).containsKey(key)) {
            return true;
        }
        return super.hasOwnProperty(thisObj, key);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean set(JSDynamicObject thisObj, long index, Object value, Object receiver, boolean isStrict, Node encapsulatingNode) {
        TruffleString key = Strings.fromLong(index);
        return JSDictionary.dictionaryObjectSet(thisObj, key, value, receiver, isStrict, encapsulatingNode);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean set(JSDynamicObject thisObj, Object key, Object value, Object receiver, boolean isStrict, Node encapsulatingNode) {
        assert (JSRuntime.isPropertyKey(key));
        return JSDictionary.dictionaryObjectSet(thisObj, key, value, receiver, isStrict, encapsulatingNode);
    }

    protected static boolean dictionaryObjectSet(JSDynamicObject thisObj, Object key, Object value, Object receiver, boolean isStrict, Node encapsulatingNode) {
        assert (JSRuntime.isPropertyKey(key));
        if (receiver != thisObj) {
            return JSDictionary.ordinarySetWithReceiver(thisObj, key, value, receiver, isStrict, encapsulatingNode);
        }
        PropertyDescriptor property = (PropertyDescriptor)JSDictionary.getHashMap(thisObj).get(key);
        if (property != null) {
            return JSDictionary.setValue(key, property, thisObj, receiver, value, isStrict, encapsulatingNode);
        }
        Property entry = DefinePropertyUtil.getPropertyByKey(thisObj, key);
        if (entry != null) {
            return JSProperty.setValue(entry, thisObj, receiver, value, isStrict, encapsulatingNode);
        }
        return JSDictionary.setPropertySlow(thisObj, key, value, receiver, isStrict, false, encapsulatingNode);
    }

    private static boolean setValue(Object key, PropertyDescriptor property, JSDynamicObject store, Object thisObj, Object value, boolean isStrict, Node encapsulatingNode) {
        if (property.isAccessorDescriptor()) {
            Object setter = property.getSet();
            if (setter != Undefined.instance) {
                JSRuntime.call(setter, thisObj, new Object[]{value}, encapsulatingNode);
                return true;
            }
            if (isStrict) {
                throw Errors.createTypeErrorCannotSetAccessorProperty(key, store);
            }
            return false;
        }
        assert (property.isDataDescriptor());
        if (property.getWritable()) {
            property.setValue(value);
            return true;
        }
        if (isStrict) {
            throw Errors.createTypeErrorNotWritableProperty(key, thisObj);
        }
        return false;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public PropertyDescriptor getOwnProperty(JSDynamicObject thisObj, Object key) {
        assert (JSRuntime.isPropertyKey(key));
        PropertyDescriptor prop = (PropertyDescriptor)JSDictionary.getHashMap(thisObj).get(key);
        if (prop != null) {
            return prop;
        }
        return super.getOwnProperty(thisObj, key);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean defineOwnProperty(JSDynamicObject thisObj, Object key, PropertyDescriptor desc, boolean doThrow) {
        assert (JSRuntime.isPropertyKey(key));
        PropertyDescriptor current = (PropertyDescriptor)JSDictionary.getHashMap(thisObj).get(key);
        if (current == null) {
            current = super.getOwnProperty(thisObj, key);
            boolean extensible = JSObject.isExtensible(thisObj);
            if (current == null) {
                if (!extensible) {
                    return DefinePropertyUtil.reject(doThrow, DefinePropertyUtil.notExtensibleMessage(key, doThrow));
                }
                JSDictionary.validateAndPutDesc(thisObj, key, JSDictionary.makeFullyPopulatedPropertyDescriptor(desc));
                return true;
            }
            return DefinePropertyUtil.validateAndApplyPropertyDescriptor(thisObj, key, extensible, desc, current, doThrow);
        }
        return JSDictionary.validateAndApplyPropertyDescriptorExisting(thisObj, key, desc, current, doThrow);
    }

    private static PropertyDescriptor validateAndPutDesc(JSDynamicObject thisObj, Object key, PropertyDescriptor newDesc) {
        assert (newDesc.isFullyPopulatedPropertyDescriptor());
        return JSDictionary.getHashMap(thisObj).put(key, newDesc);
    }

    private static PropertyDescriptor makeFullyPopulatedPropertyDescriptor(PropertyDescriptor desc) {
        if (desc.isAccessorDescriptor()) {
            if (desc.hasGet() && desc.hasSet() && desc.hasEnumerable() && desc.hasConfigurable()) {
                return desc;
            }
            return PropertyDescriptor.createAccessor(desc.getGet(), desc.getSet(), desc.getEnumerable(), desc.getConfigurable());
        }
        if (desc.isDataDescriptor()) {
            if (desc.hasValue() && desc.hasWritable() && desc.hasEnumerable() && desc.hasConfigurable()) {
                return desc;
            }
            Object value = desc.hasValue() ? desc.getValue() : Undefined.instance;
            return PropertyDescriptor.createData(value, desc.getEnumerable(), desc.getWritable(), desc.getConfigurable());
        }
        assert (desc.isGenericDescriptor());
        return PropertyDescriptor.createData(Undefined.instance, desc.getEnumerable(), desc.getWritable(), desc.getConfigurable());
    }

    private static boolean validateAndApplyPropertyDescriptorExisting(JSDynamicObject thisObj, Object key, PropertyDescriptor descriptor2, PropertyDescriptor currentDesc, boolean doThrow) {
        CompilerAsserts.neverPartOfCompilation();
        assert (currentDesc.isFullyPopulatedPropertyDescriptor());
        if (descriptor2.hasNoFields()) {
            return true;
        }
        if (!currentDesc.getConfigurable()) {
            if (descriptor2.hasConfigurable() && descriptor2.getConfigurable() || descriptor2.hasEnumerable() && descriptor2.getEnumerable() != currentDesc.getEnumerable()) {
                return DefinePropertyUtil.reject(doThrow, DefinePropertyUtil.nonConfigurableMessage(key, doThrow));
            }
            if (!descriptor2.isGenericDescriptor() && descriptor2.isAccessorDescriptor() != currentDesc.isAccessorDescriptor()) {
                return DefinePropertyUtil.reject(doThrow, DefinePropertyUtil.nonConfigurableMessage(key, doThrow));
            }
            if (currentDesc.isAccessorDescriptor()) {
                if (descriptor2.hasGet() && !JSRuntime.isSameValue(descriptor2.getGet(), currentDesc.getGet()) || descriptor2.hasSet() && !JSRuntime.isSameValue(descriptor2.getSet(), currentDesc.getSet())) {
                    return DefinePropertyUtil.reject(doThrow, DefinePropertyUtil.nonConfigurableMessage(key, doThrow));
                }
            } else {
                assert (currentDesc.isDataDescriptor());
                if (!currentDesc.getWritable()) {
                    if (descriptor2.hasWritable() && descriptor2.getWritable()) {
                        return DefinePropertyUtil.reject(doThrow, DefinePropertyUtil.nonConfigurableMessage(key, doThrow));
                    }
                    if (descriptor2.hasValue() && !JSRuntime.isSameValue(descriptor2.getValue(), currentDesc.getValue())) {
                        return DefinePropertyUtil.reject(doThrow, DefinePropertyUtil.nonWritableMessage(key, doThrow));
                    }
                }
            }
        }
        if (currentDesc.isDataDescriptor() && descriptor2.isAccessorDescriptor()) {
            PropertyDescriptor newDesc = PropertyDescriptor.createAccessor(descriptor2.getGet(), descriptor2.getSet(), descriptor2.getIfHasEnumerable(currentDesc.getEnumerable()), descriptor2.getIfHasConfigurable(currentDesc.getConfigurable()));
            JSDictionary.validateAndPutDesc(thisObj, key, newDesc);
            return true;
        }
        if (currentDesc.isAccessorDescriptor() && descriptor2.isDataDescriptor()) {
            Object value = descriptor2.hasValue() ? descriptor2.getValue() : Undefined.instance;
            PropertyDescriptor newDesc = PropertyDescriptor.createData(value, descriptor2.getIfHasEnumerable(currentDesc.getEnumerable()), descriptor2.getIfHasConfigurable(currentDesc.getConfigurable()), descriptor2.getWritable());
            JSDictionary.validateAndPutDesc(thisObj, key, newDesc);
            return true;
        }
        if (descriptor2.hasConfigurable()) {
            currentDesc.setConfigurable(descriptor2.getConfigurable());
        }
        if (descriptor2.hasEnumerable()) {
            currentDesc.setEnumerable(descriptor2.getEnumerable());
        }
        if (descriptor2.hasWritable()) {
            currentDesc.setWritable(descriptor2.getWritable());
        }
        if (descriptor2.hasValue()) {
            currentDesc.setValue(descriptor2.getValue());
        }
        if (descriptor2.hasGet()) {
            currentDesc.setGet(descriptor2.getGet());
        }
        if (descriptor2.hasSet()) {
            currentDesc.setSet(descriptor2.getSet());
        }
        return true;
    }

    static EconomicMap<Object, PropertyDescriptor> getHashMap(JSDynamicObject obj) {
        assert (JSDictionary.isJSDictionaryObject(obj));
        return (EconomicMap)JSDynamicObject.getOrNull(obj, HASHMAP_PROPERTY_NAME);
    }

    public static void makeDictionaryObject(JSDynamicObject obj, String reason) {
        CompilerAsserts.neverPartOfCompilation();
        if (!JSOrdinary.isJSOrdinaryObject(obj)) {
            return;
        }
        Shape currentShape = obj.getShape();
        assert (!JSDictionary.isJSDictionaryObject(obj) && currentShape.getProperty(HASHMAP_PROPERTY_NAME) == null);
        JSContext context = JSObject.getJSContext(obj);
        Shape newRootShape = JSDictionary.makeEmptyShapeForNewType(context, currentShape, INSTANCE, obj);
        assert (JSShape.hasExternalProperties(newRootShape.getFlags()));
        DynamicObjectLibrary lib = DynamicObjectLibrary.getUncached();
        List<Property> allProperties2 = currentShape.getPropertyListInternal(true);
        ArrayList<Object> archive = new ArrayList<Object>(allProperties2.size());
        for (Property prop : allProperties2) {
            Object key = prop.getKey();
            Object value = Properties.getOrDefault(lib, obj, key, null);
            assert (value != null);
            archive.add(value);
        }
        lib.resetShape(obj, newRootShape);
        EconomicMap<Object, PropertyDescriptor> hashMap = EconomicMap.create();
        for (int i = 0; i < archive.size(); ++i) {
            Property p = allProperties2.get(i);
            Object key = p.getKey();
            if (newRootShape.hasProperty(key)) continue;
            Object value = archive.get(i);
            if (key instanceof HiddenKey || JSProperty.isProxy(p)) {
                if (p.getLocation().isConstant()) {
                    Properties.putConstant(lib, obj, key, value, p.getFlags());
                    continue;
                }
                Properties.putWithFlags(lib, obj, key, value, p.getFlags());
                continue;
            }
            hashMap.put(key, JSDictionary.toPropertyDescriptor(p, value));
        }
        JSObjectUtil.putHiddenProperty(obj, HASHMAP_PROPERTY_NAME, hashMap);
        assert (JSDictionary.isJSDictionaryObject(obj) && obj.getShape().getProperty(HASHMAP_PROPERTY_NAME) != null);
    }

    private static Shape makeEmptyShapeForNewType(JSContext context, Shape currentShape, JSClass jsclass, JSDynamicObject fromObject) {
        Property prototypeProperty = JSShape.getPrototypeProperty(currentShape);
        if (!prototypeProperty.getLocation().isConstant()) {
            return context.makeEmptyShapeWithPrototypeInObject(jsclass);
        }
        JSDynamicObject prototype = JSObjectUtil.getPrototype(fromObject);
        if (prototype == Null.instance) {
            return context.makeEmptyShapeWithNullPrototype(jsclass);
        }
        return JSObjectUtil.getProtoChildShape(prototype, jsclass, context);
    }

    private static PropertyDescriptor toPropertyDescriptor(Property p, Object value) {
        PropertyDescriptor desc;
        if (JSProperty.isAccessor(p)) {
            desc = PropertyDescriptor.createAccessor(((Accessor)value).getGetter(), ((Accessor)value).getSetter());
            desc.setConfigurable(JSProperty.isConfigurable(p));
            desc.setEnumerable(JSProperty.isEnumerable(p));
        } else {
            assert (JSProperty.isData(p));
            desc = PropertyDescriptor.createData(value, JSProperty.isEnumerable(p), JSProperty.isWritable(p), JSProperty.isConfigurable(p));
        }
        return desc;
    }

    public static Shape makeDictionaryShape(JSContext context, JSDynamicObject prototype) {
        assert (prototype != Null.instance);
        return JSObjectUtil.getProtoChildShape(prototype, INSTANCE, context);
    }

    public static JSDynamicObject create(JSContext context, JSRealm realm) {
        JSObjectFactory factory = context.getDictionaryObjectFactory();
        JSOrdinaryObject obj = JSOrdinaryObject.create(factory.getShape(realm));
        factory.initProto(obj, realm);
        JSObjectUtil.putHiddenProperty(obj, HASHMAP_PROPERTY_NAME, JSDictionary.newHashMap());
        return context.trackAllocation(obj);
    }

    private static EconomicMap<Object, PropertyDescriptor> newHashMap() {
        return EconomicMap.create();
    }

    @Override
    public boolean usesOrdinaryGetOwnProperty() {
        return false;
    }
}

