/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.unary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.unary.FlattenNode;
import com.oracle.truffle.js.runtime.SafeInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=FlattenNode.class)
public final class FlattenNodeGen
extends FlattenNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private volatile int state_0_;
    @Node.Child
    private TruffleString.MaterializeNode lazyString_materializeNode_;

    private FlattenNodeGen() {
    }

    @Override
    public Object execute(Object arg0Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 1) != 0 && arg0Value instanceof TruffleString) {
            TruffleString arg0Value_ = (TruffleString)arg0Value;
            return FlattenNode.doLazyString(arg0Value_, this.lazyString_materializeNode_);
        }
        if ((state_0 & 2) != 0 && arg0Value instanceof SafeInteger) {
            SafeInteger arg0Value_ = (SafeInteger)arg0Value;
            return FlattenNode.doSafeInteger(arg0Value_);
        }
        if ((state_0 & 4) != 0 && FlattenNodeGen.fallbackGuard_(state_0, arg0Value)) {
            return FlattenNode.doOther(arg0Value);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAndSpecialize(Object arg0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        try {
            int state_0 = this.state_0_;
            if (arg0Value instanceof TruffleString) {
                TruffleString arg0Value_ = (TruffleString)arg0Value;
                this.lazyString_materializeNode_ = super.insert(TruffleString.MaterializeNode.create());
                this.state_0_ = state_0 |= 1;
                lock.unlock();
                hasLock = false;
                TruffleString truffleString = FlattenNode.doLazyString(arg0Value_, this.lazyString_materializeNode_);
                return truffleString;
            }
            if (arg0Value instanceof SafeInteger) {
                SafeInteger arg0Value_ = (SafeInteger)arg0Value;
                this.state_0_ = state_0 |= 2;
                lock.unlock();
                hasLock = false;
                Double d = FlattenNode.doSafeInteger(arg0Value_);
                return d;
            }
            this.state_0_ = state_0 |= 4;
            lock.unlock();
            hasLock = false;
            Object object = FlattenNode.doOther(arg0Value);
            return object;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if (state_0 == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & state_0 - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        Object[] data2 = new Object[4];
        data2[0] = 0;
        int state_0 = this.state_0_;
        Object[] s = new Object[3];
        s[0] = "doLazyString";
        if ((state_0 & 1) != 0) {
            s[1] = (byte)1;
            ArrayList<List<TruffleString.MaterializeNode>> cached = new ArrayList<List<TruffleString.MaterializeNode>>();
            cached.add(Arrays.asList(this.lazyString_materializeNode_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data2[1] = s;
        s = new Object[3];
        s[0] = "doSafeInteger";
        s[1] = (state_0 & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data2[2] = s;
        s = new Object[3];
        s[0] = "doOther";
        s[1] = (state_0 & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data2[3] = s;
        return Introspection.Provider.create(data2);
    }

    private static boolean fallbackGuard_(int state_0, Object arg0Value) {
        if ((state_0 & 1) == 0 && arg0Value instanceof TruffleString) {
            return false;
        }
        return (state_0 & 2) != 0 || !(arg0Value instanceof SafeInteger);
    }

    public static FlattenNode create() {
        return new FlattenNodeGen();
    }
}

