/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.temporal.TemporalGetOptionNodeGen;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.TemporalErrors;
import com.oracle.truffle.js.runtime.util.TemporalUtil;
import java.util.List;

@GenerateUncached
public abstract class TemporalGetOptionNode
extends JavaScriptBaseNode {
    protected TemporalGetOptionNode() {
    }

    public static TemporalGetOptionNode create() {
        return TemporalGetOptionNodeGen.create();
    }

    public static TemporalGetOptionNode getUncached() {
        return TemporalGetOptionNodeGen.getUncached();
    }

    public abstract Object execute(JSDynamicObject var1, TruffleString var2, TemporalUtil.OptionType var3, List<?> var4, Object var5);

    @Specialization
    protected Object getOption(JSDynamicObject options, TruffleString property, TemporalUtil.OptionType types, List<?> values2, Object fallback, @Cached BranchProfile errorBranch, @Cached ConditionProfile isFallbackProfile, @Cached JSToBooleanNode toBooleanNode, @Cached(uncached="createEmptyToString()") JSToStringNode toStringNode, @Cached(uncached="createEmptyToNumber()") JSToNumberNode toNumberNode) {
        assert (JSRuntime.isObject(options));
        Object value = JSObject.get(options, property);
        if (isFallbackProfile.profile(value == Undefined.instance)) {
            return fallback;
        }
        TemporalUtil.OptionType type2 = value instanceof Boolean && types.allowsBoolean() ? TemporalUtil.OptionType.BOOLEAN : (Strings.isTString(value) && types.allowsString() ? TemporalUtil.OptionType.STRING : (JSRuntime.isNumber(value) && types.allowsNumber() ? TemporalUtil.OptionType.NUMBER : types.getLast()));
        if (type2.allowsBoolean()) {
            value = toBooleanNode.executeBoolean(value);
        } else if (type2.allowsNumber()) {
            Object object = value = toNumberNode == null ? (Number)JSRuntime.toNumber(value) : (Number)toNumberNode.executeNumber(value);
            if (JSRuntime.isNaN(value)) {
                errorBranch.enter();
                throw TemporalErrors.createRangeErrorNumberIsNaN();
            }
        } else if (type2.allowsString()) {
            Object object = value = toStringNode == null ? JSRuntime.toString(value) : toStringNode.executeString(value);
        }
        if (value != Undefined.instance && values2 != null && !Boundaries.listContainsUnchecked(values2, value)) {
            errorBranch.enter();
            throw TemporalErrors.createRangeErrorOptionsNotContained(values2, value);
        }
        return value;
    }

    protected JSToStringNode createEmptyToString() {
        return null;
    }

    protected JSToNumberNode createEmptyToNumber() {
        return null;
    }
}

