/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.host;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.host.HostEngineException;
import com.oracle.truffle.host.HostLanguage;
import com.oracle.truffle.host.HostMethodDesc;
import java.lang.reflect.Field;
import java.util.Arrays;
import sun.misc.Unsafe;

final class HostMethodScope {
    private static final ScopedObject[] EMTPY_SCOPE_ARRAY = new ScopedObject[0];
    private static final Unsafe UNSAFE = HostMethodScope.getUnsafe();
    private ScopedObject[] scope;
    private int nextDynamicIndex;

    HostMethodScope(ScopedObject[] staticScope) {
        this.scope = staticScope;
        this.nextDynamicIndex = staticScope.length;
    }

    HostMethodScope(int initialDynamicCapacity) {
        this.scope = new ScopedObject[initialDynamicCapacity];
        this.nextDynamicIndex = 0;
    }

    static HostMethodScope openDynamic(HostMethodDesc.SingleMethod method, int argumentCount, BranchProfile seenScope) {
        if (method.hasScopedParameters()) {
            seenScope.enter();
            return new HostMethodScope(argumentCount);
        }
        return null;
    }

    static HostMethodScope openStatic(HostMethodDesc.SingleMethod method) {
        CompilerAsserts.partialEvaluationConstant(method);
        if (method.hasScopedParameters()) {
            int[] scopePos = method.getScopedParameters();
            ScopedObject[] scopeArray = scopePos.length > 0 ? new ScopedObject[scopePos.length] : EMTPY_SCOPE_ARRAY;
            return new HostMethodScope(scopeArray);
        }
        return null;
    }

    static Object addToScopeDynamic(HostMethodScope scope2, Object value) {
        if (scope2 != null) {
            assert (!(value instanceof ScopedObject));
            return scope2.addToScopeDynamicImpl(value);
        }
        return value;
    }

    static Object addToScopeStatic(HostMethodScope scope2, HostMethodDesc.SingleMethod method, int argumentIndex, Object value) {
        CompilerAsserts.partialEvaluationConstant(method);
        if (scope2 != null) {
            assert (!(value instanceof ScopedObject));
            int[] scopePos = method.getScopedParameters();
            int targetIndex = scopePos[argumentIndex];
            if (targetIndex != -1) {
                scope2.scope[targetIndex] = new ScopedObject(scope2, value, targetIndex);
                return scope2.scope[targetIndex];
            }
        }
        return value;
    }

    static void pin(Object value) {
        if (value instanceof ScopedObject) {
            ((ScopedObject)value).pin();
        }
    }

    static void closeStatic(HostMethodScope scope2, HostMethodDesc.SingleMethod method, BranchProfile seenDynamicScope) {
        if (method.hasScopedParameters()) {
            ScopedObject o;
            int i;
            int[] scopePos = method.getScopedParameters();
            ScopedObject[] array = scope2.scope;
            for (i = 0; i < scopePos.length; ++i) {
                o = array[i];
                if (o == null) continue;
                o.release();
            }
            for (i = scopePos.length; i < array.length; ++i) {
                seenDynamicScope.enter();
                o = array[i];
                if (o == null) continue;
                o.release();
            }
        } else assert (scope2 == null);
    }

    static void closeDynamic(HostMethodScope scope2, HostMethodDesc.SingleMethod method) {
        if (method.hasScopedParameters()) {
            ScopedObject[] array = scope2.scope;
            for (int i = 0; i < array.length; ++i) {
                ScopedObject o = array[i];
                if (o == null) continue;
                o.release();
            }
        } else assert (scope2 == null);
    }

    @CompilerDirectives.TruffleBoundary
    private synchronized Object addToScopeDynamicImpl(Object argument) {
        int index = this.nextDynamicIndex;
        ScopedObject[] localScope = this.scope;
        if (index >= localScope.length) {
            this.scope = localScope = Arrays.copyOf(localScope, localScope.length << 1);
        }
        if (index < 0) {
            throw HostMethodScope.createReleaseException("Too many scoped values created for scoped method instance.");
        }
        ScopedObject newArgument = localScope[index] = new ScopedObject(this, argument, index);
        this.nextDynamicIndex = index + 1;
        return newArgument;
    }

    @CompilerDirectives.TruffleBoundary
    private static RuntimeException createReleaseException(String message) {
        return HostEngineException.toEngineException(HostLanguage.get(null).access, new IllegalStateException("This scoped object has already been released. " + message));
    }

    private static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException securityException) {
            try {
                Field theUnsafeInstance = Unsafe.class.getDeclaredField("theUnsafe");
                theUnsafeInstance.setAccessible(true);
                return (Unsafe)theUnsafeInstance.get(Unsafe.class);
            }
            catch (Exception e) {
                throw new RuntimeException("exception while trying to get Unsafe.theUnsafe via reflection:", e);
            }
        }
    }

    @ExportLibrary(value=ReflectionLibrary.class)
    static final class ScopedObject
    implements TruffleObject {
        static final Object OTHER_VALUE;
        static final ReflectionLibrary OTHER_VALUE_UNCACHED;
        static final long DELEGATE_OFFSET;
        volatile Object delegate;
        volatile HostMethodScope scope;
        private final int index;

        ScopedObject(HostMethodScope scope2, Object delegate2, int index) {
            this.delegate = delegate2;
            this.scope = scope2;
            this.index = index;
        }

        @ExportMessage
        Object send(Message message, Object[] args2, @CachedLibrary(limit="5") ReflectionLibrary library, @Cached BranchProfile seenError, @Cached BranchProfile seenOther) throws Exception {
            if (message.getLibraryClass() != InteropLibrary.class) {
                seenOther.enter();
                return ScopedObject.fallbackSend(message, args2);
            }
            Object d = this.delegate;
            if (d == null) {
                seenError.enter();
                throw HostMethodScope.createReleaseException("Released objects cannot be accessed. Avoid accessing scoped objects after their corresponding method has finished execution. Alternatively, use Value.pin() to prevent a scoped object from being released after the host call completed.");
            }
            assert (d != null) : "delegate must not be null here";
            Object returnValue = library.send(d, message, args2);
            if (message.getReturnType() == Object.class && !(d instanceof PinnedObject)) {
                return HostMethodScope.addToScopeDynamic(this.scope, returnValue);
            }
            return returnValue;
        }

        @CompilerDirectives.TruffleBoundary
        private static Object fallbackSend(Message message, Object[] args2) throws Exception {
            return OTHER_VALUE_UNCACHED.send(OTHER_VALUE, message, args2);
        }

        void release() {
            Object d = this.delegate;
            assert (d != null);
            if (d instanceof PinnedObject || !UNSAFE.compareAndSwapObject(this, DELEGATE_OFFSET, d, null)) {
                return;
            }
            assert (this.delegate == null) : "Scoped objects can only be released once.";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void pin() {
            HostMethodScope s;
            PinnedObject update;
            Object expect;
            do {
                s = this.scope;
                expect = this.delegate;
                if (expect instanceof PinnedObject) {
                    return;
                }
                if (expect != null) continue;
                throw HostMethodScope.createReleaseException("Released objects cannot be pinned.");
            } while (!UNSAFE.compareAndSwapObject(this, DELEGATE_OFFSET, expect, update = new PinnedObject(expect)));
            this.scope = null;
            HostMethodScope hostMethodScope = s;
            synchronized (hostMethodScope) {
                s.scope[this.index] = null;
            }
            assert (this.delegate != null) : "delegate must not be set to null after pinning ";
        }

        Object unwrapForGuest() {
            Object d = this.delegate;
            if (d == null) {
                throw HostMethodScope.createReleaseException("Released objects cannot be converted to a guest value.");
            }
            if (d instanceof PinnedObject) {
                return ((PinnedObject)d).delegate;
            }
            return d;
        }

        static {
            Field f;
            OTHER_VALUE = new Object();
            OTHER_VALUE_UNCACHED = ReflectionLibrary.getFactory().getUncached(OTHER_VALUE);
            try {
                f = ScopedObject.class.getDeclaredField("delegate");
            }
            catch (NoSuchFieldException | SecurityException e) {
                throw CompilerDirectives.shouldNotReachHere(e);
            }
            DELEGATE_OFFSET = UNSAFE.objectFieldOffset(f);
        }
    }

    @ExportLibrary(value=InteropLibrary.class, delegateTo="delegate")
    static final class PinnedObject
    implements TruffleObject {
        final Object delegate;

        PinnedObject(Object delegate2) {
            this.delegate = delegate2;
        }
    }
}

