/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.util.math;

import com.cobblemon.mod.common.util.math.DoubleRange;
import com.cobblemon.mod.common.util.math.FloatRange;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import net.minecraft.class_243;
import net.minecraft.class_4581;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000V\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a%\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006\u001a\u001d\u0010\n\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\u000b\u001a\u0019\u0010\u000e\u001a\u00020\f*\u00020\f2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000f\u001a\u0019\u0010\u0011\u001a\u00020\u0010*\u00020\f2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u0011\u0010\u0012\u001a\u0013\u0010\u0013\u001a\u00020\u0000*\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001a\u0013\u0010\u0013\u001a\u00020\u0015*\u0004\u0018\u00010\u0015\u00a2\u0006\u0004\b\u0013\u0010\u0016\u001a\u0013\u0010\u0013\u001a\u00020\u0017*\u0004\u0018\u00010\u0017\u00a2\u0006\u0004\b\u0013\u0010\u0018\u001a\u0013\u0010\u0019\u001a\u00020\u0000*\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\u0019\u0010\u0014\u001a\u0013\u0010\u0019\u001a\u00020\u0015*\u0004\u0018\u00010\u0015\u00a2\u0006\u0004\b\u0019\u0010\u0016\u001a\u0013\u0010\u0019\u001a\u00020\u0017*\u0004\u0018\u00010\u0017\u00a2\u0006\u0004\b\u0019\u0010\u0018\u001a\u001c\u0010\u001b\u001a\u00020\u0017*\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0017H\u0086\u0004\u00a2\u0006\u0004\b\u001b\u0010\u001c\u001a\u001d\u0010\u001e\u001a\u00020\u0015*\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u001d\u00a2\u0006\u0004\b\u001e\u0010\u001f\u001a!\u0010#\u001a\u00020\u0000*\u00020\u00002\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020 \u00a2\u0006\u0004\b#\u0010$\u001a9\u0010#\u001a\u00020\u0000*\u00020\u00002\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00000\u001d2\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00000\u001d\u00a2\u0006\u0004\b#\u0010%\u001a!\u0010#\u001a\u00020\u0015*\u00020\u00152\u0006\u0010!\u001a\u00020&2\u0006\u0010\"\u001a\u00020&\u00a2\u0006\u0004\b#\u0010'\u001a9\u0010#\u001a\u00020\u0015*\u00020\u00152\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u001d2\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u001d\u00a2\u0006\u0004\b#\u0010(\u001a9\u0010#\u001a\u00020\u0017*\u00020\u00172\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u001d2\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u001d\u00a2\u0006\u0004\b#\u0010)\u001a!\u0010#\u001a\u00020\u0017*\u00020\u00172\u0006\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\f\u00a2\u0006\u0004\b#\u0010*\u001a\u001c\u0010,\u001a\u00020\u0004*\u00020\t2\u0006\u0010+\u001a\u00020\u0004H\u0086\u0002\u00a2\u0006\u0004\b,\u0010-\u001a#\u0010/\u001a\u0014\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00000.*\u00020\u0017\u00a2\u0006\u0004\b/\u00100\u00a8\u00061"}, d2={"", "radius", "theta", "psi", "Lnet/minecraft/class_243;", "convertSphericalToCartesian", "(DDD)Lnet/minecraft/class_243;", "from", "to", "Lnet/minecraft/class_4581;", "getRotationMatrix", "(Lnet/minecraft/class_243;Lnet/minecraft/class_243;)Lnet/minecraft/class_4581;", "Lkotlin/ranges/IntRange;", "other", "intersection", "(Lkotlin/ranges/IntRange;Lkotlin/ranges/IntRange;)Lkotlin/ranges/IntRange;", "", "intersects", "(Lkotlin/ranges/IntRange;Lkotlin/ranges/IntRange;)Z", "orMax", "(Ljava/lang/Double;)D", "", "(Ljava/lang/Float;)F", "", "(Ljava/lang/Integer;)I", "orMin", "power", "pow", "(II)I", "Lkotlin/Pair;", "random", "(Lkotlin/Pair;)F", "Lcom/cobblemon/mod/common/util/math/DoubleRange;", "start", "end", "remap", "(DLcom/cobblemon/mod/common/util/math/DoubleRange;Lcom/cobblemon/mod/common/util/math/DoubleRange;)D", "(DLkotlin/Pair;Lkotlin/Pair;)D", "Lcom/cobblemon/mod/common/util/math/FloatRange;", "(FLcom/cobblemon/mod/common/util/math/FloatRange;Lcom/cobblemon/mod/common/util/math/FloatRange;)F", "(FLkotlin/Pair;Lkotlin/Pair;)F", "(ILkotlin/Pair;Lkotlin/Pair;)I", "(ILkotlin/ranges/IntRange;Lkotlin/ranges/IntRange;)I", "vec3d", "times", "(Lnet/minecraft/class_4581;Lnet/minecraft/class_243;)Lnet/minecraft/class_243;", "Lkotlin/Triple;", "toRGB", "(I)Lkotlin/Triple;", "common"})
public final class SimpleMathExtensionsKt {
    public static final int pow(int $this$pow, int power) {
        return (int)Math.pow($this$pow, power);
    }

    public static final double orMax(@Nullable Double $this$orMax) {
        Double d = $this$orMax;
        return d != null ? d : Double.MAX_VALUE;
    }

    public static final double orMin(@Nullable Double $this$orMin) {
        Double d = $this$orMin;
        return d != null ? d : -2.147483648E9;
    }

    public static final float orMax(@Nullable Float $this$orMax) {
        Float f = $this$orMax;
        return f != null ? f.floatValue() : 2.1474836E9f;
    }

    public static final float orMin(@Nullable Float $this$orMin) {
        Float f = $this$orMin;
        return f != null ? f.floatValue() : -2.1474836E9f;
    }

    public static final int orMax(@Nullable Integer $this$orMax) {
        Integer n = $this$orMax;
        return n != null ? n : Integer.MAX_VALUE;
    }

    public static final int orMin(@Nullable Integer $this$orMin) {
        Integer n = $this$orMin;
        return n != null ? n : Integer.MIN_VALUE;
    }

    @NotNull
    public static final Triple<Double, Double, Double> toRGB(int $this$toRGB) {
        double r = (double)($this$toRGB >> 16 & 0xFF) / 255.0;
        double g = (double)($this$toRGB >> 8 & 0xFF) / 255.0;
        double b = (double)($this$toRGB & 0xFF) / 255.0;
        return new Triple<Double, Double, Double>(r, g, b);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean intersects(@NotNull IntRange $this$intersects, @NotNull IntRange other) {
        boolean bl;
        boolean bl2;
        Intrinsics.checkNotNullParameter($this$intersects, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        int n = other.getFirst();
        int n2 = other.getLast();
        int n3 = $this$intersects.getStart();
        if (n <= n3) {
            if (n3 <= n2) {
                return true;
            }
            bl2 = false;
        } else {
            bl2 = false;
        }
        if (bl2) return true;
        n = other.getFirst();
        n2 = other.getLast();
        n3 = $this$intersects.getEndInclusive();
        if (n <= n3) {
            if (n3 <= n2) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        n = $this$intersects.getFirst();
        n2 = $this$intersects.getLast();
        n3 = other.getStart();
        if (n > n3) return false;
        if (n3 > n2) return false;
        return true;
    }

    @NotNull
    public static final IntRange intersection(@NotNull IntRange $this$intersection, @NotNull IntRange other) {
        Intrinsics.checkNotNullParameter($this$intersection, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        int intersectionStart = Math.max(other.getStart(), $this$intersection.getStart());
        int intersectionEnd = Math.min(other.getEndInclusive(), $this$intersection.getEndInclusive());
        return new IntRange(intersectionStart, intersectionEnd);
    }

    public static final float random(@NotNull Pair<Float, Float> $this$random) {
        Intrinsics.checkNotNullParameter($this$random, "<this>");
        return Random.Default.nextFloat() * (((Number)$this$random.getSecond()).floatValue() - ((Number)$this$random.getFirst()).floatValue()) + ((Number)$this$random.getFirst()).floatValue();
    }

    public static final float remap(float $this$remap, @NotNull Pair<Float, Float> from, @NotNull Pair<Float, Float> to) {
        Intrinsics.checkNotNullParameter(from, "from");
        Intrinsics.checkNotNullParameter(to, "to");
        float fromMin = ((Number)from.component1()).floatValue();
        float fromMax = ((Number)from.component2()).floatValue();
        float toMin = ((Number)to.component1()).floatValue();
        float toMax = ((Number)to.component2()).floatValue();
        return ($this$remap - fromMin) / (fromMax - fromMin) * (toMax - toMin) + toMin;
    }

    public static final float remap(float $this$remap, @NotNull FloatRange start2, @NotNull FloatRange end2) {
        Intrinsics.checkNotNullParameter(start2, "start");
        Intrinsics.checkNotNullParameter(end2, "end");
        Pair<Float, Float> pair = TuplesKt.to(start2.getStart(), start2.getEndInclusive());
        float fromMin = ((Number)pair.component1()).floatValue();
        float fromMax = ((Number)pair.component2()).floatValue();
        Pair<Float, Float> pair2 = TuplesKt.to(end2.getStart(), end2.getEndInclusive());
        float toMin = ((Number)pair2.component1()).floatValue();
        float toMax = ((Number)pair2.component2()).floatValue();
        return ($this$remap - fromMin) / (fromMax - fromMin) * (toMax - toMin) + toMin;
    }

    public static final int remap(int $this$remap, @NotNull Pair<Integer, Integer> from, @NotNull Pair<Integer, Integer> to) {
        Intrinsics.checkNotNullParameter(from, "from");
        Intrinsics.checkNotNullParameter(to, "to");
        int fromMin = ((Number)from.component1()).intValue();
        int fromMax = ((Number)from.component2()).intValue();
        int toMin = ((Number)to.component1()).intValue();
        int toMax = ((Number)to.component2()).intValue();
        return ($this$remap - fromMin) / (fromMax - fromMin) * (toMax - toMin) + toMin;
    }

    public static final int remap(int $this$remap, @NotNull IntRange start2, @NotNull IntRange end2) {
        Intrinsics.checkNotNullParameter(start2, "start");
        Intrinsics.checkNotNullParameter(end2, "end");
        Pair<Integer, Integer> pair = TuplesKt.to(start2.getFirst(), start2.getLast());
        int fromMin = ((Number)pair.component1()).intValue();
        int fromMax = ((Number)pair.component2()).intValue();
        Pair<Integer, Integer> pair2 = TuplesKt.to(end2.getFirst(), end2.getLast());
        int toMin = ((Number)pair2.component1()).intValue();
        int toMax = ((Number)pair2.component2()).intValue();
        return ($this$remap - fromMin) / (fromMax - fromMin) * (toMax - toMin) + toMin;
    }

    public static final double remap(double $this$remap, @NotNull Pair<Double, Double> from, @NotNull Pair<Double, Double> to) {
        Intrinsics.checkNotNullParameter(from, "from");
        Intrinsics.checkNotNullParameter(to, "to");
        double fromMin = ((Number)from.component1()).doubleValue();
        double fromMax = ((Number)from.component2()).doubleValue();
        double toMin = ((Number)to.component1()).doubleValue();
        double toMax = ((Number)to.component2()).doubleValue();
        return ($this$remap - fromMin) / (fromMax - fromMin) * (toMax - toMin) + toMin;
    }

    public static final double remap(double $this$remap, @NotNull DoubleRange start2, @NotNull DoubleRange end2) {
        Intrinsics.checkNotNullParameter(start2, "start");
        Intrinsics.checkNotNullParameter(end2, "end");
        Pair<Double, Double> pair = TuplesKt.to(start2.getStart(), start2.getEndInclusive());
        double fromMin = ((Number)pair.component1()).doubleValue();
        double fromMax = ((Number)pair.component2()).doubleValue();
        Pair<Double, Double> pair2 = TuplesKt.to(end2.getStart(), end2.getEndInclusive());
        double toMin = ((Number)pair2.component1()).doubleValue();
        double toMax = ((Number)pair2.component2()).doubleValue();
        return ($this$remap - fromMin) / (fromMax - fromMin) * (toMax - toMin) + toMin;
    }

    @NotNull
    public static final class_243 convertSphericalToCartesian(double radius, double theta, double psi) {
        return new class_243(radius * Math.cos(theta) * Math.sin(psi), radius * Math.sin(theta) * Math.sin(psi), radius * Math.cos(psi));
    }

    @NotNull
    public static final class_4581 getRotationMatrix(@NotNull class_243 from, @NotNull class_243 to) {
        Intrinsics.checkNotNullParameter(from, "from");
        Intrinsics.checkNotNullParameter(to, "to");
        class_243 v = from.method_1036(to);
        double c = from.method_1026(to);
        class_4581 identity = new class_4581();
        identity.method_22856();
        if (c == -1.0) {
            identity.method_23729(-1.0f);
            return identity;
        }
        if (c == 1.0) {
            return identity;
        }
        class_4581 vx = new class_4581();
        vx.method_26288(0, 1, -((float)v.field_1350));
        vx.method_26288(0, 2, (float)v.field_1351);
        vx.method_26288(1, 0, (float)v.field_1350);
        vx.method_26288(1, 2, -((float)v.field_1352));
        vx.method_26288(2, 0, -((float)v.field_1351));
        vx.method_26288(2, 1, (float)v.field_1352);
        class_4581 vx2 = new class_4581(vx);
        vx2.method_22855(vx2);
        class_4581 r = new class_4581(identity);
        vx2.method_23729((float)(1.0 / (1.0 + c)));
        r.method_35265(vx);
        r.method_35265(vx2);
        return r;
    }

    @NotNull
    public static final class_243 times(@NotNull class_4581 $this$times, @NotNull class_243 vec3d) {
        Intrinsics.checkNotNullParameter($this$times, "<this>");
        Intrinsics.checkNotNullParameter(vec3d, "vec3d");
        return new class_243((double)$this$times.field_21633 * vec3d.field_1352 + (double)$this$times.field_21634 * vec3d.field_1351 + (double)$this$times.field_21635 * vec3d.field_1350, (double)$this$times.field_21636 * vec3d.field_1352 + (double)$this$times.field_21637 * vec3d.field_1351 + (double)$this$times.field_21638 * vec3d.field_1350, (double)$this$times.field_21639 * vec3d.field_1352 + (double)$this$times.field_21640 * vec3d.field_1351 + (double)$this$times.field_21641 * vec3d.field_1350);
    }
}

