/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.starter;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.advancement.CobblemonCriteria;
import com.cobblemon.mod.common.api.events.Cancelable;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.starter.StarterChosenEvent;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.reactive.EventObservable;
import com.cobblemon.mod.common.api.starter.StarterHandler;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.api.storage.player.PlayerData;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.config.starter.StarterCategory;
import com.cobblemon.mod.common.net.messages.client.starter.OpenStarterUIPacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013J'\u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lcom/cobblemon/mod/common/starter/CobblemonStarterHandler;", "Lcom/cobblemon/mod/common/api/starter/StarterHandler;", "Lnet/minecraft/class_3222;", "player", "", "categoryName", "", "index", "", "chooseStarter", "(Lnet/minecraft/class_3222;Ljava/lang/String;I)V", "", "Lcom/cobblemon/mod/common/config/starter/StarterCategory;", "getStarterList", "(Lnet/minecraft/class_3222;)Ljava/util/List;", "handleJoin", "(Lnet/minecraft/class_3222;)V", "requestStarterChoice", "<init>", "()V", "common"})
public class CobblemonStarterHandler
implements StarterHandler {
    @Override
    @NotNull
    public List<StarterCategory> getStarterList(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter(player, "player");
        return Cobblemon.INSTANCE.getStarterConfig().getStarters();
    }

    @Override
    public void handleJoin(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter(player, "player");
    }

    @Override
    public void requestStarterChoice(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter(player, "player");
        PlayerData playerData = Cobblemon.INSTANCE.getPlayerData().get((class_1657)player);
        if (playerData.getStarterSelected()) {
            playerData.sendToPlayer(player);
            class_5250 class_52502 = LocalizationUtilsKt.lang("ui.starter.alreadyselected", new Object[0]);
            Intrinsics.checkNotNullExpressionValue(class_52502, "lang(\"ui.starter.alreadyselected\")");
            player.method_43496((class_2561)TextKt.red(class_52502));
        } else if (playerData.getStarterLocked()) {
            class_5250 class_52503 = LocalizationUtilsKt.lang("ui.starter.cannotchoose", new Object[0]);
            Intrinsics.checkNotNullExpressionValue(class_52503, "lang(\"ui.starter.cannotchoose\")");
            player.method_43496((class_2561)TextKt.red(class_52503));
        } else {
            new OpenStarterUIPacket(this.getStarterList(player)).sendToPlayer(player);
            playerData.setStarterPrompted(true);
            Cobblemon.INSTANCE.getPlayerData().saveSingle(playerData);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void chooseStarter(@NotNull class_3222 player, @NotNull String categoryName, int index) {
        void this_$iv$iv;
        void $this$iv;
        Object v2;
        Object object;
        PlayerData playerData;
        block7: {
            Intrinsics.checkNotNullParameter(player, "player");
            Intrinsics.checkNotNullParameter(categoryName, "categoryName");
            playerData = Cobblemon.INSTANCE.getPlayerData().get((class_1657)player);
            if (playerData.getStarterSelected()) {
                class_5250 class_52502 = LocalizationUtilsKt.lang("ui.starter.alreadyselected", new Object[0]);
                Intrinsics.checkNotNullExpressionValue(class_52502, "lang(\"ui.starter.alreadyselected\")");
                player.method_43496((class_2561)TextKt.red(class_52502));
                return;
            }
            if (playerData.getStarterLocked()) {
                class_5250 class_52503 = LocalizationUtilsKt.lang("ui.starter.cannotchoose", new Object[0]);
                Intrinsics.checkNotNullExpressionValue(class_52503, "lang(\"ui.starter.cannotchoose\")");
                player.method_43496((class_2561)TextKt.red(class_52503));
                return;
            }
            object = this.getStarterList(player);
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                Object t = iterator2.next();
                StarterCategory it = (StarterCategory)t;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getName(), categoryName)) continue;
                v2 = t;
                break block7;
            }
            v2 = null;
        }
        StarterCategory starterCategory = v2;
        if (starterCategory == null) {
            return;
        }
        StarterCategory category = starterCategory;
        if (index > category.getPokemon().size()) {
            return;
        }
        PokemonProperties properties2 = category.getPokemon().get(index);
        Pokemon pokemon = properties2.create();
        object = CobblemonEvents.STARTER_CHOSEN;
        Cancelable event$iv = new StarterChosenEvent(player, properties2, pokemon);
        boolean $i$f$postThen = false;
        EventObservable bl = (EventObservable)$this$iv;
        Cancelable[] cancelableArray = new Cancelable[]{event$iv};
        Cancelable[] events$iv$iv = cancelableArray;
        boolean $i$f$post = false;
        this_$iv$iv.emit(Arrays.copyOf(events$iv$iv, events$iv$iv.length));
        Cancelable[] $this$forEach$iv$iv$iv = events$iv$iv;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv$iv$iv.length;
        for (int i = 0; i < n; ++i) {
            void it;
            Pokemon pokemon2;
            Cancelable it2;
            Cancelable element$iv$iv$iv;
            Cancelable it$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl2 = false;
            if (it$iv.isCanceled()) {
                Cancelable cancelable = it$iv;
                boolean bl3 = false;
                it2 = cancelable;
                continue;
            }
            it2 = (StarterChosenEvent)it$iv;
            boolean bl4 = false;
            Pokemon pokemon3 = pokemon2 = ((StarterChosenEvent)it2).getPokemon();
            PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty(player);
            boolean bl5 = false;
            playerData.setStarterSelected(true);
            playerData.setStarterUUID(it.getUuid());
            playerPartyStore.add(pokemon2);
            CobblemonCriteria.INSTANCE.getPICK_STARTER().trigger(player, pokemon);
            Cobblemon.INSTANCE.getPlayerData().saveSingle(playerData);
            playerData.sendToPlayer(player);
        }
    }
}

