/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.pokemon.evolution.requirements;

import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.pokemon.evolution.requirement.EvolutionRequirement;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.Iterator;
import java.util.Optional;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.optionals.OptionalsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\t\b\u0016\u00a2\u0006\u0004\b\f\u0010\rB\u000f\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\f\u0010\u000eJ\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/cobblemon/mod/common/pokemon/evolution/requirements/BattleCriticalHitsRequirement;", "Lcom/cobblemon/mod/common/api/pokemon/evolution/requirement/EvolutionRequirement;", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "", "check", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;)Z", "", "amount", "I", "getAmount", "()I", "<init>", "()V", "(I)V", "Companion", "common"})
public final class BattleCriticalHitsRequirement
implements EvolutionRequirement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int amount;
    @NotNull
    public static final String ADAPTER_VARIANT = "battle_critical_hits";

    public BattleCriticalHitsRequirement(int amount) {
        this.amount = amount;
    }

    public BattleCriticalHitsRequirement() {
        this(0);
    }

    public final int getAmount() {
        return this.amount;
    }

    @Override
    public boolean check(@NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter(pokemon, "pokemon");
        PokemonEntity pokemonEntity = pokemon.getEntity();
        if (pokemonEntity == null) {
            return false;
        }
        PokemonEntity pokemonEntity2 = pokemonEntity;
        Object t = pokemonEntity2.getBattleId().get();
        Intrinsics.checkNotNullExpressionValue(t, "pokemonEntity.battleId.get()");
        UUID uUID = (UUID)OptionalsKt.getOrNull((Optional)t);
        if (uUID == null) {
            return false;
        }
        UUID battleId = uUID;
        PokemonBattle pokemonBattle = BattleRegistry.INSTANCE.getBattle(battleId);
        if (pokemonBattle == null) {
            return false;
        }
        PokemonBattle battle = pokemonBattle;
        Iterable<BattleActor> $this$forEach$iv = battle.getActors();
        boolean $i$f$forEach = false;
        Iterator<BattleActor> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            BattleActor element$iv;
            BattleActor actor = element$iv = iterator2.next();
            boolean bl = false;
            Iterable $this$forEach$iv2 = actor.getPokemonList();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                BattlePokemon battlePokemon = (BattlePokemon)element$iv2;
                boolean bl2 = false;
                if (!Intrinsics.areEqual(battlePokemon.getEffectedPokemon().getUuid(), pokemon.getUuid())) continue;
                return battlePokemon.getCriticalHits() >= this.amount;
            }
        }
        return false;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0003\u001a\u00020\u00028\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0007"}, d2={"Lcom/cobblemon/mod/common/pokemon/evolution/requirements/BattleCriticalHitsRequirement$Companion;", "", "", "ADAPTER_VARIANT", "Ljava/lang/String;", "<init>", "()V", "common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

