/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.pokemon;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.reactive.SimpleObservable;
import com.cobblemon.mod.common.net.IntSize;
import com.cobblemon.mod.common.util.NetExtensionsKt;
import com.cobblemon.mod.common.util.ResourceLocationExtensionsKt;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import net.minecraft.class_151;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0010&\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010)\n\u0002\u0010'\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0004\b&\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001B\u0007\u00a2\u0006\u0004\bD\u00102J\u001f\u0010\b\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0004H\u0014\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001b\u0010\u0012\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001b\u0010\u0014\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0004\b\u0014\u0010\u0013J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0015\u001a\u00020\u0003H\u0086\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0015\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0018\u0010\u0019J\"\u0010\u001c\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u001b0\u001aH\u0096\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0015\u0010 \u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u001e\u00a2\u0006\u0004\b \u0010!J\u0015\u0010$\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\"\u00a2\u0006\u0004\b$\u0010%J\u0015\u0010(\u001a\u00020\u00002\u0006\u0010'\u001a\u00020&\u00a2\u0006\u0004\b(\u0010)J\u0015\u0010*\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u001e\u00a2\u0006\u0004\b*\u0010!J\u0015\u0010+\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"\u00a2\u0006\u0004\b+\u0010,J\u0015\u0010-\u001a\u00020&2\u0006\u0010'\u001a\u00020&\u00a2\u0006\u0004\b-\u0010.J \u0010/\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0004H\u0096\u0002\u00a2\u0006\u0004\b/\u00100J\r\u00101\u001a\u00020\u0010\u00a2\u0006\u0004\b1\u00102R\u0014\u00106\u001a\u0002038&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u0014\u00109\u001a\u00020\u00048&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u0016\u0010:\u001a\u00020\u00078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b:\u0010;R\u001d\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00000<8\u0006\u00a2\u0006\f\n\u0004\b=\u0010>\u001a\u0004\b?\u0010@R \u0010B\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040A8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bB\u0010C\u00a8\u0006E"}, d2={"Lcom/cobblemon/mod/common/pokemon/PokemonStats;", "", "", "Lcom/cobblemon/mod/common/api/pokemon/stats/Stat;", "", "stat", "value", "", "canSet", "(Lcom/cobblemon/mod/common/api/pokemon/stats/Stat;I)Z", "Lnet/minecraft/class_2960;", "identifier", "", "cleanStatIdentifier", "(Lnet/minecraft/class_2960;)Ljava/lang/String;", "Lkotlin/Function0;", "", "action", "doThenEmit", "(Lkotlin/jvm/functions/Function0;)V", "doWithoutEmitting", "key", "get", "(Lcom/cobblemon/mod/common/api/pokemon/stats/Stat;)Ljava/lang/Integer;", "getOrDefault", "(Lcom/cobblemon/mod/common/api/pokemon/stats/Stat;)I", "", "", "iterator", "()Ljava/util/Iterator;", "Lnet/minecraft/class_2540;", "buffer", "loadFromBuffer", "(Lnet/minecraft/class_2540;)V", "Lcom/google/gson/JsonObject;", "json", "loadFromJSON", "(Lcom/google/gson/JsonObject;)Lcom/cobblemon/mod/common/pokemon/PokemonStats;", "Lnet/minecraft/class_2487;", "nbt", "loadFromNBT", "(Lnet/minecraft/class_2487;)Lcom/cobblemon/mod/common/pokemon/PokemonStats;", "saveToBuffer", "saveToJSON", "(Lcom/google/gson/JsonObject;)Lcom/google/gson/JsonObject;", "saveToNBT", "(Lnet/minecraft/class_2487;)Lnet/minecraft/class_2487;", "set", "(Lcom/cobblemon/mod/common/api/pokemon/stats/Stat;I)V", "update", "()V", "Lkotlin/ranges/IntRange;", "getAcceptableRange", "()Lkotlin/ranges/IntRange;", "acceptableRange", "getDefaultValue", "()I", "defaultValue", "emit", "Z", "Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "observable", "Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "getObservable", "()Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "", "stats", "Ljava/util/Map;", "<init>", "common"})
public abstract class PokemonStats
implements Iterable<Map.Entry<? extends Stat, ? extends Integer>>,
KMappedMarker {
    @NotNull
    private final SimpleObservable<PokemonStats> observable = new SimpleObservable();
    @NotNull
    private final Map<Stat, Integer> stats = new LinkedHashMap();
    private boolean emit = true;

    @NotNull
    public abstract IntRange getAcceptableRange();

    public abstract int getDefaultValue();

    @Override
    @NotNull
    public Iterator<Map.Entry<Stat, Integer>> iterator() {
        return this.stats.entrySet().iterator();
    }

    @NotNull
    public final SimpleObservable<PokemonStats> getObservable() {
        return this.observable;
    }

    public final void doWithoutEmitting(@NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter(action, "action");
        this.emit = false;
        action.invoke();
        this.emit = true;
    }

    public final void doThenEmit(@NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter(action, "action");
        this.doWithoutEmitting(action);
        this.update();
    }

    public final void update() {
        if (this.emit) {
            PokemonStats[] pokemonStatsArray = new PokemonStats[]{this};
            this.observable.emit((PokemonStats[])pokemonStatsArray);
        }
    }

    @Nullable
    public final Integer get(@NotNull Stat key) {
        Intrinsics.checkNotNullParameter(key, "key");
        return this.stats.get(key);
    }

    public void set(@NotNull Stat key, int value) {
        Intrinsics.checkNotNullParameter(key, "key");
        if (this.canSet(key, value)) {
            Integer n = value;
            this.stats.put(key, n);
            this.update();
        }
    }

    protected boolean canSet(@NotNull Stat stat, int value) {
        Intrinsics.checkNotNullParameter(stat, "stat");
        IntRange intRange = this.getAcceptableRange();
        int n = intRange.getFirst();
        return value <= intRange.getLast() ? n <= value : false;
    }

    @NotNull
    public final class_2487 saveToNBT(@NotNull class_2487 nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        Map<Stat, Integer> $this$forEach$iv = this.stats;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Stat, Integer>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Stat, Integer> element$iv;
            Map.Entry<Stat, Integer> entry = element$iv = iterator2.next();
            boolean bl = false;
            Stat stat = entry.getKey();
            int value = ((Number)entry.getValue()).intValue();
            if (value == this.getDefaultValue()) continue;
            nbt.method_10575(this.cleanStatIdentifier(stat.getIdentifier()), (short)value);
        }
        return nbt;
    }

    @NotNull
    public final PokemonStats loadFromNBT(@NotNull class_2487 nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        this.stats.clear();
        Set set2 = nbt.method_10541();
        Intrinsics.checkNotNullExpressionValue(set2, "nbt.keys");
        Iterable $this$forEach$iv = set2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String statId = (String)element$iv;
            boolean bl = false;
            try {
                Stat stat;
                Intrinsics.checkNotNullExpressionValue(statId, "statId");
                class_2960 identifier = ResourceLocationExtensionsKt.asIdentifierDefaultingNamespace$default(statId, null, 1, null);
                if (Cobblemon.INSTANCE.getStatProvider().fromIdentifier(identifier) == null) continue;
                this.set(stat, nbt.method_10568(statId));
            }
            catch (class_151 class_1512) {
            }
        }
        return this;
    }

    @NotNull
    public final JsonObject saveToJSON(@NotNull JsonObject json) {
        Intrinsics.checkNotNullParameter(json, "json");
        Map<Stat, Integer> $this$forEach$iv = this.stats;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Stat, Integer>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Stat, Integer> element$iv;
            Map.Entry<Stat, Integer> entry = element$iv = iterator2.next();
            boolean bl = false;
            Stat stat = entry.getKey();
            int value = ((Number)entry.getValue()).intValue();
            if (value == this.getDefaultValue()) continue;
            json.addProperty(this.cleanStatIdentifier(stat.getIdentifier()), (Number)value);
        }
        return json;
    }

    @NotNull
    public final PokemonStats loadFromJSON(@NotNull JsonObject json) {
        Intrinsics.checkNotNullParameter(json, "json");
        this.stats.clear();
        Set set2 = json.entrySet();
        Intrinsics.checkNotNullExpressionValue(set2, "json.entrySet()");
        Iterable $this$forEach$iv = set2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(entry, "(key, element)");
            String key = (String)entry.getKey();
            JsonElement element = (JsonElement)entry.getValue();
            try {
                Stat stat;
                Intrinsics.checkNotNullExpressionValue(key, "key");
                class_2960 identifier = ResourceLocationExtensionsKt.asIdentifierDefaultingNamespace$default(key, null, 1, null);
                if (Cobblemon.INSTANCE.getStatProvider().fromIdentifier(identifier) == null) continue;
                this.set(stat, element.getAsInt());
            }
            catch (class_151 class_1512) {
            }
        }
        return this;
    }

    public final void saveToBuffer(@NotNull class_2540 buffer) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        NetExtensionsKt.writeSizedInt((ByteBuf)buffer, IntSize.U_BYTE, this.stats.size());
        for (Map.Entry<Stat, Integer> entry : this.stats.entrySet()) {
            Stat stat = entry.getKey();
            int value = ((Number)entry.getValue()).intValue();
            Cobblemon.INSTANCE.getStatProvider().encode(buffer, stat);
            NetExtensionsKt.writeSizedInt((ByteBuf)buffer, IntSize.U_SHORT, value);
        }
    }

    public final void loadFromBuffer(@NotNull class_2540 buffer) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        this.stats.clear();
        int n = buffer.readUnsignedByte();
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            Stat stat = Cobblemon.INSTANCE.getStatProvider().decode(buffer);
            int value = buffer.readUnsignedShort();
            Integer n3 = value;
            this.stats.put(stat, n3);
        }
    }

    public final int getOrDefault(@NotNull Stat stat) {
        Intrinsics.checkNotNullParameter(stat, "stat");
        Integer n = this.get(stat);
        return n != null ? n.intValue() : this.getDefaultValue();
    }

    private final String cleanStatIdentifier(class_2960 identifier) {
        String string = identifier.toString();
        Intrinsics.checkNotNullExpressionValue(string, "identifier.toString()");
        return StringsKt.substringAfter$default(string, "cobblemon:", null, 2, null);
    }
}

