/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.pokeball.catching.calculators;

import com.cobblemon.mod.common.api.pokeball.catching.CaptureContext;
import com.cobblemon.mod.common.api.pokeball.catching.calculators.CaptureCalculator;
import com.cobblemon.mod.common.api.pokeball.catching.calculators.CriticalCaptureProvider;
import com.cobblemon.mod.common.pokeball.PokeBall;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.status.PersistentStatus;
import com.cobblemon.mod.common.pokemon.status.PersistentStatusContainer;
import com.cobblemon.mod.common.pokemon.status.statuses.BurnStatus;
import com.cobblemon.mod.common.pokemon.status.statuses.FrozenStatus;
import com.cobblemon.mod.common.pokemon.status.statuses.ParalysisStatus;
import com.cobblemon.mod.common.pokemon.status.statuses.PoisonBadlyStatus;
import com.cobblemon.mod.common.pokemon.status.statuses.PoisonStatus;
import com.cobblemon.mod.common.pokemon.status.statuses.SleepStatus;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import net.minecraft.class_1309;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0005J'\u0010\r\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lcom/cobblemon/mod/common/pokeball/catching/calculators/Gen8CaptureCalculator;", "Lcom/cobblemon/mod/common/api/pokeball/catching/calculators/CaptureCalculator;", "Lcom/cobblemon/mod/common/api/pokeball/catching/calculators/CriticalCaptureProvider;", "", "id", "()Ljava/lang/String;", "Lnet/minecraft/class_1309;", "thrower", "Lcom/cobblemon/mod/common/pokeball/PokeBall;", "pokeBall", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "target", "Lcom/cobblemon/mod/common/api/pokeball/catching/CaptureContext;", "processCapture", "(Lnet/minecraft/class_1309;Lcom/cobblemon/mod/common/pokeball/PokeBall;Lcom/cobblemon/mod/common/pokemon/Pokemon;)Lcom/cobblemon/mod/common/api/pokeball/catching/CaptureContext;", "<init>", "()V", "common"})
public final class Gen8CaptureCalculator
implements CaptureCalculator,
CriticalCaptureProvider {
    @NotNull
    public static final Gen8CaptureCalculator INSTANCE = new Gen8CaptureCalculator();

    private Gen8CaptureCalculator() {
    }

    @Override
    @NotNull
    public String id() {
        return "generation_8";
    }

    @Override
    @NotNull
    public CaptureContext processCapture(@NotNull class_1309 thrower, @NotNull PokeBall pokeBall, @NotNull Pokemon target) {
        Intrinsics.checkNotNullParameter(thrower, "thrower");
        Intrinsics.checkNotNullParameter(pokeBall, "pokeBall");
        Intrinsics.checkNotNullParameter(target, "target");
        if (pokeBall.getCatchRateModifier().isGuaranteed()) {
            return CaptureContext.Companion.successful$default(CaptureContext.Companion, false, 1, null);
        }
        float catchRate = target.getForm().getCatchRate();
        boolean validModifier = pokeBall.getCatchRateModifier().isValid(thrower, target);
        PersistentStatusContainer persistentStatusContainer = target.getStatus();
        PersistentStatus persistentStatus = persistentStatusContainer != null ? persistentStatusContainer.getStatus() : null;
        float bonusStatus = (persistentStatus instanceof SleepStatus ? true : persistentStatus instanceof FrozenStatus) ? 2.5f : ((((persistentStatus instanceof ParalysisStatus ? true : persistentStatus instanceof BurnStatus) ? true : persistentStatus instanceof PoisonStatus) ? true : persistentStatus instanceof PoisonBadlyStatus) ? 1.5f : 1.0f);
        int bonusLevel = target.getLevel() < 20 ? Math.max((30 - target.getLevel()) / 10, 1) : 1;
        int ballBonus = validModifier ? RangesKt.coerceAtLeast(MathKt.roundToInt(pokeBall.getCatchRateModifier().value(thrower, target)), 1) : 1;
        float modifiedCatchRate = ((Number)pokeBall.getCatchRateModifier().behavior(thrower, target).getMutator().invoke(Float.valueOf((3.0f * (float)target.getHp() - 2.0f * (float)target.getCurrentHealth()) * catchRate), Float.valueOf(ballBonus))).floatValue() / (3.0f * (float)target.getHp()) * bonusStatus * (float)bonusLevel;
        boolean critical = thrower instanceof class_3222 ? this.shouldHaveCriticalCapture((class_3222)thrower, modifiedCatchRate) : false;
        int shakeProbability = MathKt.roundToInt(65536.0f / (float)Math.pow(255.0f / modifiedCatchRate, 0.1875f));
        int shakes = 0;
        int n = 4;
        for (int i = 0; i < n; ++i) {
            int it = i;
            boolean bl = false;
            int n2 = Random.Default.nextInt(65537);
            if (n2 < shakeProbability) {
                ++shakes;
            }
            if (it != 0 || !critical) continue;
            return new CaptureContext(1, shakes == 1, true);
        }
        return new CaptureContext(shakes, shakes == 4, false);
    }

    @Override
    public boolean shouldHaveCriticalCapture(@NotNull class_3222 player, float modifiedCatchRate) {
        return CriticalCaptureProvider.DefaultImpls.shouldHaveCriticalCapture(this, player, modifiedCatchRate);
    }
}

