/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.pokeball.catching.calculators;

import com.cobblemon.mod.common.api.pokeball.PokeBalls;
import com.cobblemon.mod.common.api.pokeball.catching.CaptureContext;
import com.cobblemon.mod.common.api.pokeball.catching.calculators.CaptureCalculator;
import com.cobblemon.mod.common.api.pokeball.catching.calculators.CriticalCaptureProvider;
import com.cobblemon.mod.common.api.pokeball.catching.calculators.PokedexProgressCaptureMultiplierProvider;
import com.cobblemon.mod.common.pokeball.PokeBall;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.status.PersistentStatus;
import com.cobblemon.mod.common.pokemon.status.PersistentStatusContainer;
import com.cobblemon.mod.common.pokemon.status.statuses.BurnStatus;
import com.cobblemon.mod.common.pokemon.status.statuses.FrozenStatus;
import com.cobblemon.mod.common.pokemon.status.statuses.ParalysisStatus;
import com.cobblemon.mod.common.pokemon.status.statuses.PoisonBadlyStatus;
import com.cobblemon.mod.common.pokemon.status.statuses.PoisonStatus;
import com.cobblemon.mod.common.pokemon.status.statuses.SleepStatus;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.random.Random;
import net.minecraft.class_1309;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J'\u0010\u000e\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lcom/cobblemon/mod/common/pokeball/catching/calculators/Gen5CaptureCalculator;", "Lcom/cobblemon/mod/common/api/pokeball/catching/calculators/CaptureCalculator;", "Lcom/cobblemon/mod/common/api/pokeball/catching/calculators/CriticalCaptureProvider;", "Lcom/cobblemon/mod/common/api/pokeball/catching/calculators/PokedexProgressCaptureMultiplierProvider;", "", "id", "()Ljava/lang/String;", "Lnet/minecraft/class_1309;", "thrower", "Lcom/cobblemon/mod/common/pokeball/PokeBall;", "pokeBall", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "target", "Lcom/cobblemon/mod/common/api/pokeball/catching/CaptureContext;", "processCapture", "(Lnet/minecraft/class_1309;Lcom/cobblemon/mod/common/pokeball/PokeBall;Lcom/cobblemon/mod/common/pokemon/Pokemon;)Lcom/cobblemon/mod/common/api/pokeball/catching/CaptureContext;", "", "apricornPokeballs", "Ljava/util/Set;", "<init>", "()V", "common"})
public final class Gen5CaptureCalculator
implements CaptureCalculator,
CriticalCaptureProvider,
PokedexProgressCaptureMultiplierProvider {
    @NotNull
    public static final Gen5CaptureCalculator INSTANCE = new Gen5CaptureCalculator();
    @NotNull
    private static final Set<PokeBall> apricornPokeballs;

    private Gen5CaptureCalculator() {
    }

    @Override
    @NotNull
    public String id() {
        return "generation_5";
    }

    @Override
    @NotNull
    public CaptureContext processCapture(@NotNull class_1309 thrower, @NotNull PokeBall pokeBall, @NotNull Pokemon target) {
        boolean critical;
        Intrinsics.checkNotNullParameter(thrower, "thrower");
        Intrinsics.checkNotNullParameter(pokeBall, "pokeBall");
        Intrinsics.checkNotNullParameter(target, "target");
        if (pokeBall.getCatchRateModifier().isGuaranteed()) {
            return new CaptureContext(3, true, false);
        }
        int darkGrass = thrower instanceof class_3222 ? MathKt.roundToInt(this.caughtMultiplierFor((class_3222)thrower)) : 1;
        float catchRate = target.getForm().getCatchRate();
        boolean validModifier = pokeBall.getCatchRateModifier().isValid(thrower, target);
        PersistentStatusContainer persistentStatusContainer = target.getStatus();
        PersistentStatus persistentStatus = persistentStatusContainer != null ? persistentStatusContainer.getStatus() : null;
        float bonusStatus = (persistentStatus instanceof SleepStatus ? true : persistentStatus instanceof FrozenStatus) ? 2.5f : ((((persistentStatus instanceof ParalysisStatus ? true : persistentStatus instanceof BurnStatus) ? true : persistentStatus instanceof PoisonStatus) ? true : persistentStatus instanceof PoisonBadlyStatus) ? 1.5f : 1.0f);
        float rate = 0.0f;
        int ballBonus = 0;
        if (apricornPokeballs.contains(pokeBall)) {
            rate = validModifier ? pokeBall.getCatchRateModifier().modifyCatchRate(catchRate, thrower, target) : 1.0f;
            ballBonus = 1;
        } else {
            rate = catchRate;
            ballBonus = validModifier ? MathKt.roundToInt(pokeBall.getCatchRateModifier().value(thrower, target)) : 1;
        }
        float modifiedCatchRate = ((Number)pokeBall.getCatchRateModifier().behavior(thrower, target).getMutator().invoke(Float.valueOf((3.0f * (float)target.getHp() - 2.0f * (float)target.getCurrentHealth()) * (float)darkGrass * rate), Float.valueOf(ballBonus))).floatValue() / (3.0f * (float)target.getHp()) * bonusStatus;
        boolean bl = critical = thrower instanceof class_3222 ? this.shouldHaveCriticalCapture((class_3222)thrower, modifiedCatchRate) : false;
        if (modifiedCatchRate >= 1044480.0f) {
            return CaptureContext.Companion.successful(critical);
        }
        int shakeProbability = MathKt.roundToInt(65336.0f / (float)MathKt.roundToInt(Math.sqrt(Math.sqrt(MathKt.roundToInt(1044480.0f / modifiedCatchRate)))));
        int shakes = 0;
        int n = 3;
        for (int i = 0; i < n; ++i) {
            int it = i;
            boolean bl2 = false;
            boolean failed = true;
            int n2 = Random.Default.nextInt(65537);
            if (n2 < shakeProbability) {
                ++shakes;
                failed = false;
            }
            if (critical && it == 0) {
                return new CaptureContext(1, !failed, true);
            }
            if (it == 0 && failed && !critical) {
                return new CaptureContext(0, false, false);
            }
            if (it == 1 && failed && !critical) {
                return new CaptureContext(1, false, false);
            }
            if (it != 2 || !failed || critical) continue;
            return new CaptureContext(3, false, false);
        }
        return new CaptureContext(shakes, true, false);
    }

    @Override
    public boolean shouldHaveCriticalCapture(@NotNull class_3222 player, float modifiedCatchRate) {
        return CriticalCaptureProvider.DefaultImpls.shouldHaveCriticalCapture(this, player, modifiedCatchRate);
    }

    @Override
    public float caughtMultiplierFor(@NotNull class_3222 player) {
        return PokedexProgressCaptureMultiplierProvider.DefaultImpls.caughtMultiplierFor(this, player);
    }

    static {
        PokeBall[] pokeBallArray = new PokeBall[]{PokeBalls.INSTANCE.getHEAVY_BALL(), PokeBalls.INSTANCE.getLURE_BALL(), PokeBalls.INSTANCE.getFRIEND_BALL(), PokeBalls.INSTANCE.getLOVE_BALL(), PokeBalls.INSTANCE.getLEVEL_BALL(), PokeBalls.INSTANCE.getFAST_BALL(), PokeBalls.INSTANCE.getMOON_BALL()};
        apricornPokeballs = SetsKt.setOf(pokeBallArray);
    }
}

