/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.pokeball.catching.calculators;

import com.cobblemon.mod.common.api.pokeball.PokeBalls;
import com.cobblemon.mod.common.api.pokeball.catching.CaptureContext;
import com.cobblemon.mod.common.api.pokeball.catching.calculators.CaptureCalculator;
import com.cobblemon.mod.common.pokeball.PokeBall;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.status.PersistentStatus;
import com.cobblemon.mod.common.pokemon.status.PersistentStatusContainer;
import com.cobblemon.mod.common.pokemon.status.statuses.BurnStatus;
import com.cobblemon.mod.common.pokemon.status.statuses.FrozenStatus;
import com.cobblemon.mod.common.pokemon.status.statuses.ParalysisStatus;
import com.cobblemon.mod.common.pokemon.status.statuses.PoisonBadlyStatus;
import com.cobblemon.mod.common.pokemon.status.statuses.PoisonStatus;
import com.cobblemon.mod.common.pokemon.status.statuses.SleepStatus;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.random.Random;
import net.minecraft.class_1309;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004J'\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lcom/cobblemon/mod/common/pokeball/catching/calculators/Gen3And4CaptureCalculator;", "Lcom/cobblemon/mod/common/api/pokeball/catching/calculators/CaptureCalculator;", "", "id", "()Ljava/lang/String;", "Lnet/minecraft/class_1309;", "thrower", "Lcom/cobblemon/mod/common/pokeball/PokeBall;", "pokeBall", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "target", "Lcom/cobblemon/mod/common/api/pokeball/catching/CaptureContext;", "processCapture", "(Lnet/minecraft/class_1309;Lcom/cobblemon/mod/common/pokeball/PokeBall;Lcom/cobblemon/mod/common/pokemon/Pokemon;)Lcom/cobblemon/mod/common/api/pokeball/catching/CaptureContext;", "", "apricornPokeballs", "Ljava/util/Set;", "<init>", "()V", "common"})
public final class Gen3And4CaptureCalculator
implements CaptureCalculator {
    @NotNull
    public static final Gen3And4CaptureCalculator INSTANCE = new Gen3And4CaptureCalculator();
    @NotNull
    private static final Set<PokeBall> apricornPokeballs;

    private Gen3And4CaptureCalculator() {
    }

    @Override
    @NotNull
    public String id() {
        return "generation_3_and_4";
    }

    @Override
    @NotNull
    public CaptureContext processCapture(@NotNull class_1309 thrower, @NotNull PokeBall pokeBall, @NotNull Pokemon target) {
        Intrinsics.checkNotNullParameter(thrower, "thrower");
        Intrinsics.checkNotNullParameter(pokeBall, "pokeBall");
        Intrinsics.checkNotNullParameter(target, "target");
        if (pokeBall.getCatchRateModifier().isGuaranteed()) {
            return CaptureContext.Companion.successful$default(CaptureContext.Companion, false, 1, null);
        }
        float catchRate = target.getForm().getCatchRate();
        boolean validModifier = pokeBall.getCatchRateModifier().isValid(thrower, target);
        PersistentStatusContainer persistentStatusContainer = target.getStatus();
        PersistentStatus persistentStatus = persistentStatusContainer != null ? persistentStatusContainer.getStatus() : null;
        float bonusStatus = (persistentStatus instanceof SleepStatus ? true : persistentStatus instanceof FrozenStatus) ? 2.0f : ((((persistentStatus instanceof ParalysisStatus ? true : persistentStatus instanceof BurnStatus) ? true : persistentStatus instanceof PoisonStatus) ? true : persistentStatus instanceof PoisonBadlyStatus) ? 1.5f : 1.0f);
        float rate = 0.0f;
        float ballBonus = 0.0f;
        if (apricornPokeballs.contains(pokeBall)) {
            rate = validModifier ? pokeBall.getCatchRateModifier().modifyCatchRate(catchRate, thrower, target) : 1.0f;
            ballBonus = 1.0f;
        } else {
            rate = catchRate;
            ballBonus = validModifier ? pokeBall.getCatchRateModifier().value(thrower, target) : 1.0f;
        }
        float modifiedCatchRate = ((Number)pokeBall.getCatchRateModifier().behavior(thrower, target).getMutator().invoke(Float.valueOf((3.0f * (float)target.getHp() - 2.0f * (float)target.getCurrentHealth()) * rate), Float.valueOf(ballBonus))).floatValue() / (3.0f * (float)target.getHp()) * bonusStatus;
        int shakeProbability = MathKt.roundToInt(1048560.0f / (float)MathKt.roundToInt(Math.sqrt(Math.sqrt(MathKt.roundToInt(1.671168E7f / modifiedCatchRate)))));
        int shakes = 0;
        int n = 4;
        for (int i = 0; i < n; ++i) {
            int it = i;
            boolean bl = false;
            int n2 = Random.Default.nextInt(65537);
            if (n2 >= shakeProbability) continue;
            ++shakes;
        }
        return new CaptureContext(shakes, shakes == 4, false);
    }

    static {
        PokeBall[] pokeBallArray = new PokeBall[]{PokeBalls.INSTANCE.getHEAVY_BALL(), PokeBalls.INSTANCE.getLURE_BALL(), PokeBalls.INSTANCE.getFRIEND_BALL(), PokeBalls.INSTANCE.getLOVE_BALL(), PokeBalls.INSTANCE.getLEVEL_BALL(), PokeBalls.INSTANCE.getFAST_BALL(), PokeBalls.INSTANCE.getMOON_BALL()};
        apricornPokeballs = SetsKt.setOf(pokeBallArray);
    }
}

