/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.pokeball.catching.calculators;

import com.cobblemon.mod.common.api.pokeball.PokeBalls;
import com.cobblemon.mod.common.api.pokeball.catching.CaptureContext;
import com.cobblemon.mod.common.api.pokeball.catching.calculators.CaptureCalculator;
import com.cobblemon.mod.common.pokeball.PokeBall;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.status.PersistentStatus;
import com.cobblemon.mod.common.pokemon.status.PersistentStatusContainer;
import com.cobblemon.mod.common.pokemon.status.statuses.BurnStatus;
import com.cobblemon.mod.common.pokemon.status.statuses.FrozenStatus;
import com.cobblemon.mod.common.pokemon.status.statuses.ParalysisStatus;
import com.cobblemon.mod.common.pokemon.status.statuses.PoisonBadlyStatus;
import com.cobblemon.mod.common.pokemon.status.statuses.PoisonStatus;
import com.cobblemon.mod.common.pokemon.status.statuses.SleepStatus;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import net.minecraft.class_1309;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J'\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ'\u0010\u0011\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0014\u00a8\u0006\u0018"}, d2={"Lcom/cobblemon/mod/common/pokeball/catching/calculators/Gen1CaptureCalculator;", "Lcom/cobblemon/mod/common/api/pokeball/catching/calculators/CaptureCalculator;", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "target", "", "ballValue", "f", "calculateShakes", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;II)I", "", "id", "()Ljava/lang/String;", "Lnet/minecraft/class_1309;", "thrower", "Lcom/cobblemon/mod/common/pokeball/PokeBall;", "pokeBall", "Lcom/cobblemon/mod/common/api/pokeball/catching/CaptureContext;", "processCapture", "(Lnet/minecraft/class_1309;Lcom/cobblemon/mod/common/pokeball/PokeBall;Lcom/cobblemon/mod/common/pokemon/Pokemon;)Lcom/cobblemon/mod/common/api/pokeball/catching/CaptureContext;", "FRZ_SLEEP_THRESHOLD", "I", "PARA_BRN_PSN_THRESHOLD", "<init>", "()V", "common"})
public final class Gen1CaptureCalculator
implements CaptureCalculator {
    @NotNull
    public static final Gen1CaptureCalculator INSTANCE = new Gen1CaptureCalculator();
    private static final int FRZ_SLEEP_THRESHOLD = 25;
    private static final int PARA_BRN_PSN_THRESHOLD = 12;

    private Gen1CaptureCalculator() {
    }

    @Override
    @NotNull
    public String id() {
        return "generation_1";
    }

    @Override
    @NotNull
    public CaptureContext processCapture(@NotNull class_1309 thrower, @NotNull PokeBall pokeBall, @NotNull Pokemon target) {
        PersistentStatus status;
        Intrinsics.checkNotNullParameter(thrower, "thrower");
        Intrinsics.checkNotNullParameter(pokeBall, "pokeBall");
        Intrinsics.checkNotNullParameter(target, "target");
        if (pokeBall.getCatchRateModifier().isGuaranteed()) {
            return CaptureContext.Companion.successful$default(CaptureContext.Companion, false, 1, null);
        }
        PokeBall pokeBall2 = pokeBall;
        int nBound = Intrinsics.areEqual(pokeBall2, PokeBalls.INSTANCE.getPOKE_BALL()) ? 255 : (Intrinsics.areEqual(pokeBall2, PokeBalls.INSTANCE.getGREAT_BALL()) ? 200 : 150);
        int n = Random.Default.nextInt(nBound + 1);
        int usedThreshold = 0;
        PersistentStatusContainer persistentStatusContainer = target.getStatus();
        PersistentStatus persistentStatus = status = persistentStatusContainer != null ? persistentStatusContainer.getStatus() : null;
        if ((status instanceof FrozenStatus || status instanceof SleepStatus) && n < 25) {
            usedThreshold = 25;
            return CaptureContext.Companion.successful$default(CaptureContext.Companion, false, 1, null);
        }
        if ((status instanceof ParalysisStatus || status instanceof BurnStatus || status instanceof PoisonStatus || status instanceof PoisonBadlyStatus) && n < 12) {
            usedThreshold = 12;
            return CaptureContext.Companion.successful$default(CaptureContext.Companion, false, 1, null);
        }
        if (n - usedThreshold > target.getForm().getCatchRate()) {
            return new CaptureContext(0, false, false);
        }
        int m = Random.Default.nextInt(256);
        float ballValue = Intrinsics.areEqual(pokeBall, PokeBalls.INSTANCE.getGREAT_BALL()) ? 8.0f : 12.0f;
        int f = MathKt.roundToInt(RangesKt.coerceIn((float)target.getHp() * 255.0f * 4.0f / ((float)target.getCurrentHealth() * ballValue), 1.0f, 255.0f));
        if (f >= m) {
            return CaptureContext.Companion.successful$default(CaptureContext.Companion, false, 1, null);
        }
        return new CaptureContext(this.calculateShakes(target, nBound, f), false, false);
    }

    private final int calculateShakes(Pokemon target, int ballValue, int f) {
        float d = (float)target.getForm().getCatchRate() * 100.0f / (float)ballValue;
        if (d >= 256.0f) {
            return 3;
        }
        PersistentStatusContainer persistentStatusContainer = target.getStatus();
        PersistentStatus persistentStatus = persistentStatusContainer != null ? persistentStatusContainer.getStatus() : null;
        int s = (persistentStatus instanceof FrozenStatus ? true : persistentStatus instanceof SleepStatus) ? 10 : ((((persistentStatus instanceof ParalysisStatus ? true : persistentStatus instanceof BurnStatus) ? true : persistentStatus instanceof PoisonStatus) ? true : persistentStatus instanceof PoisonBadlyStatus) ? 5 : 0);
        float x = d * (float)f / (float)255 + (float)s;
        return x < 10.0f ? 0 : (x < 30.0f ? 1 : (x < 70.0f ? 2 : 3));
    }
}

