/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.pokeball.catching.calculators;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.pokeball.catching.CaptureContext;
import com.cobblemon.mod.common.api.pokeball.catching.calculators.CaptureCalculator;
import com.cobblemon.mod.common.api.pokeball.catching.calculators.CriticalCaptureProvider;
import com.cobblemon.mod.common.api.pokeball.catching.calculators.PokedexProgressCaptureMultiplierProvider;
import com.cobblemon.mod.common.api.reactive.SettableObservable;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.battles.actor.PlayerBattleActor;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.config.CobblemonConfig;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokeball.PokeBall;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.status.PersistentStatus;
import com.cobblemon.mod.common.pokemon.status.PersistentStatusContainer;
import com.cobblemon.mod.common.pokemon.status.statuses.BurnStatus;
import com.cobblemon.mod.common.pokemon.status.statuses.FrozenStatus;
import com.cobblemon.mod.common.pokemon.status.statuses.ParalysisStatus;
import com.cobblemon.mod.common.pokemon.status.statuses.PoisonBadlyStatus;
import com.cobblemon.mod.common.pokemon.status.statuses.PoisonStatus;
import com.cobblemon.mod.common.pokemon.status.statuses.SleepStatus;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import net.minecraft.class_1309;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J!\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ'\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0018"}, d2={"Lcom/cobblemon/mod/common/pokeball/catching/calculators/CobblemonCaptureCalculator;", "Lcom/cobblemon/mod/common/api/pokeball/catching/calculators/CaptureCalculator;", "Lcom/cobblemon/mod/common/api/pokeball/catching/calculators/CriticalCaptureProvider;", "Lcom/cobblemon/mod/common/api/pokeball/catching/calculators/PokedexProgressCaptureMultiplierProvider;", "Lnet/minecraft/class_3222;", "player", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "", "findHighestThrowerLevel", "(Lnet/minecraft/class_3222;Lcom/cobblemon/mod/common/pokemon/Pokemon;)Ljava/lang/Integer;", "", "id", "()Ljava/lang/String;", "Lnet/minecraft/class_1309;", "thrower", "Lcom/cobblemon/mod/common/pokeball/PokeBall;", "pokeBall", "target", "Lcom/cobblemon/mod/common/api/pokeball/catching/CaptureContext;", "processCapture", "(Lnet/minecraft/class_1309;Lcom/cobblemon/mod/common/pokeball/PokeBall;Lcom/cobblemon/mod/common/pokemon/Pokemon;)Lcom/cobblemon/mod/common/api/pokeball/catching/CaptureContext;", "<init>", "()V", "common"})
public final class CobblemonCaptureCalculator
implements CaptureCalculator,
CriticalCaptureProvider,
PokedexProgressCaptureMultiplierProvider {
    @NotNull
    public static final CobblemonCaptureCalculator INSTANCE = new CobblemonCaptureCalculator();

    private CobblemonCaptureCalculator() {
    }

    @Override
    @NotNull
    public String id() {
        return "cobblemon";
    }

    @Override
    @NotNull
    public CaptureContext processCapture(@NotNull class_1309 thrower, @NotNull PokeBall pokeBall, @NotNull Pokemon target) {
        Integer highestLevelThrower;
        Intrinsics.checkNotNullParameter(thrower, "thrower");
        Intrinsics.checkNotNullParameter(pokeBall, "pokeBall");
        Intrinsics.checkNotNullParameter(target, "target");
        if (pokeBall.getCatchRateModifier().isGuaranteed()) {
            return CaptureContext.Companion.successful$default(CaptureContext.Companion, false, 1, null);
        }
        float darkGrass = 1.0f;
        Object object = target.getEntity();
        float inBattleModifier = (object != null && (object = ((PokemonEntity)object).getBattleId()) != null && (object = (Optional)((SettableObservable)object).get()) != null ? ((Optional)object).isPresent() : false) ? 1.0f : 0.5f;
        float catchRate = target.getForm().getCatchRate();
        boolean validModifier = pokeBall.getCatchRateModifier().isValid(thrower, target);
        PersistentStatusContainer persistentStatusContainer = target.getStatus();
        PersistentStatus persistentStatus = persistentStatusContainer != null ? persistentStatusContainer.getStatus() : null;
        float bonusStatus = (persistentStatus instanceof SleepStatus ? true : persistentStatus instanceof FrozenStatus) ? 2.5f : ((((persistentStatus instanceof ParalysisStatus ? true : persistentStatus instanceof BurnStatus) ? true : persistentStatus instanceof PoisonStatus) ? true : persistentStatus instanceof PoisonBadlyStatus) ? 1.5f : 1.0f);
        int bonusLevel = target.getLevel() < 13 ? Math.max((36 - 2 * target.getLevel()) / 10, 1) : 1;
        int ballBonus = validModifier ? RangesKt.coerceAtLeast(MathKt.roundToInt(pokeBall.getCatchRateModifier().value(thrower, target)), 1) : 1;
        float modifiedCatchRate = ((Number)pokeBall.getCatchRateModifier().behavior(thrower, target).getMutator().invoke(Float.valueOf((3.0f * (float)target.getHp() - 2.0f * (float)target.getCurrentHealth()) * darkGrass * catchRate * inBattleModifier), Float.valueOf(ballBonus))).floatValue() / (3.0f * (float)target.getHp());
        modifiedCatchRate *= bonusStatus * (float)bonusLevel;
        if (thrower instanceof class_3222 && (highestLevelThrower = this.findHighestThrowerLevel((class_3222)thrower, target)) != null && highestLevelThrower < target.getLevel()) {
            CobblemonConfig config = Cobblemon.INSTANCE.getConfig();
            modifiedCatchRate *= Math.max(0.1f, Math.min(1.0f, 1.0f - (float)((target.getLevel() - highestLevelThrower) / (config.getMaxPokemonLevel() / 2))));
        }
        boolean critical = thrower instanceof class_3222 ? this.shouldHaveCriticalCapture((class_3222)thrower, modifiedCatchRate) : false;
        int shakeProbability = MathKt.roundToInt(65536.0f / (float)Math.pow(255.0f / modifiedCatchRate, 0.1875f));
        int shakes = 0;
        int n = 4;
        for (int i = 0; i < n; ++i) {
            int it = i;
            boolean bl = false;
            int n2 = Random.Default.nextInt(65537);
            if (n2 < shakeProbability) {
                ++shakes;
            }
            if (it != 0 || !critical) continue;
            return new CaptureContext(1, shakes == 1, true);
        }
        return new CaptureContext(shakes, shakes == 4, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Integer findHighestThrowerLevel(class_3222 player, Pokemon pokemon) {
        Comparable comparable;
        BattleActor battleActor;
        block10: {
            BattleActor element$iv;
            boolean bl;
            PokemonEntity pokemonEntity = pokemon.getEntity();
            if (pokemonEntity == null) {
                return null;
            }
            PokemonEntity entity2 = pokemonEntity;
            UUID uUID = ((Optional)entity2.getBattleId().get()).orElse(null);
            if (uUID == null) {
                return null;
            }
            UUID battleId = uUID;
            PokemonBattle pokemonBattle = BattleRegistry.INSTANCE.getBattle(battleId);
            if (pokemonBattle == null) {
                return null;
            }
            PokemonBattle battle = pokemonBattle;
            Iterable<BattleActor> $this$firstOrNull$iv = battle.getActors();
            boolean $i$f$firstOrNull = false;
            Iterator<BattleActor> iterator2 = $this$firstOrNull$iv.iterator();
            do {
                block13: {
                    boolean bl2;
                    block11: {
                        Iterator iterator3;
                        block15: {
                            block12: {
                                Iterable $this$any$iv;
                                block14: {
                                    if (!iterator2.hasNext()) break block12;
                                    BattleActor actor = element$iv = iterator2.next();
                                    boolean bl3 = false;
                                    if (!(actor instanceof PlayerBattleActor) || !Intrinsics.areEqual(player.method_5667(), actor.getUuid())) break block13;
                                    $this$any$iv = actor.getActivePokemon();
                                    boolean $i$f$any = false;
                                    if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) break block14;
                                    bl2 = false;
                                    break block11;
                                }
                                iterator3 = $this$any$iv.iterator();
                                break block15;
                            }
                            battleActor = null;
                            break block10;
                        }
                        while (iterator3.hasNext()) {
                            Object element$iv2 = iterator3.next();
                            ActiveBattlePokemon active = (ActiveBattlePokemon)element$iv2;
                            boolean bl4 = false;
                            Object object = active.getBattlePokemon();
                            if (!Intrinsics.areEqual(object != null && (object = ((BattlePokemon)object).getEffectedPokemon()) != null ? ((Pokemon)object).getUuid() : null, pokemon.getUuid())) continue;
                            bl2 = true;
                            break block11;
                        }
                        bl2 = false;
                    }
                    if (bl2) {
                        bl = true;
                        continue;
                    }
                }
                bl = false;
            } while (!bl);
            battleActor = element$iv;
        }
        BattleActor battleActor2 = battleActor;
        if (battleActor2 == null) {
            return null;
        }
        BattleActor actor = battleActor2;
        Iterator iterator4 = ((Iterable)actor.getSide().getOppositeSide().getActivePokemon()).iterator();
        if (!iterator4.hasNext()) {
            comparable = null;
            return (Integer)comparable;
        }
        ActiveBattlePokemon it = (ActiveBattlePokemon)iterator4.next();
        boolean bl = false;
        Object object = it.getBattlePokemon();
        Comparable comparable2 = Integer.valueOf(object != null && (object = ((BattlePokemon)object).getEffectedPokemon()) != null ? ((Pokemon)object).getLevel() : 1);
        while (true) {
            if (!iterator4.hasNext()) {
                comparable = comparable2;
                return (Integer)comparable;
            }
            ActiveBattlePokemon it2 = (ActiveBattlePokemon)iterator4.next();
            $i$a$-maxOfOrNull-CobblemonCaptureCalculator$findHighestThrowerLevel$1 = false;
            Object object2 = it2.getBattlePokemon();
            Comparable comparable3 = Integer.valueOf(object2 != null && (object2 = ((BattlePokemon)object2).getEffectedPokemon()) != null ? ((Pokemon)object2).getLevel() : 1);
            if (comparable2.compareTo(comparable3) >= 0) continue;
            comparable2 = comparable3;
        }
    }

    @Override
    public boolean shouldHaveCriticalCapture(@NotNull class_3222 player, float modifiedCatchRate) {
        return CriticalCaptureProvider.DefaultImpls.shouldHaveCriticalCapture(this, player, modifiedCatchRate);
    }

    @Override
    public float caughtMultiplierFor(@NotNull class_3222 player) {
        return PokedexProgressCaptureMultiplierProvider.DefaultImpls.caughtMultiplierFor(this, player);
    }
}

