/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.net.messages.client.storage.pc;

import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.api.storage.pc.PCBox;
import com.cobblemon.mod.common.net.IntSize;
import com.cobblemon.mod.common.net.messages.PokemonDTO;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.NetExtensionsKt;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u001f\u001a\u00020\u001e\u00a2\u0006\u0004\b \u0010!B\u0007\u00a2\u0006\u0004\b \u0010\"J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0007\u0010\u0006R\"\u0010\t\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR.\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00100\u000f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\"\u0010\u0018\u001a\u00020\u00178\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006#"}, d2={"Lcom/cobblemon/mod/common/net/messages/client/storage/pc/SetPCBoxPokemonPacket;", "Lcom/cobblemon/mod/common/api/net/NetworkPacket;", "Lnet/minecraft/class_2540;", "buffer", "", "decode", "(Lnet/minecraft/class_2540;)V", "encode", "", "boxNumber", "I", "getBoxNumber", "()I", "setBoxNumber", "(I)V", "", "Lcom/cobblemon/mod/common/net/messages/PokemonDTO;", "pokemon", "Ljava/util/Map;", "getPokemon", "()Ljava/util/Map;", "setPokemon", "(Ljava/util/Map;)V", "Ljava/util/UUID;", "storeID", "Ljava/util/UUID;", "getStoreID", "()Ljava/util/UUID;", "setStoreID", "(Ljava/util/UUID;)V", "Lcom/cobblemon/mod/common/api/storage/pc/PCBox;", "box", "<init>", "(Lcom/cobblemon/mod/common/api/storage/pc/PCBox;)V", "()V", "common"})
public final class SetPCBoxPokemonPacket
implements NetworkPacket {
    public UUID storeID;
    private int boxNumber;
    @NotNull
    private Map<Integer, PokemonDTO> pokemon;

    public SetPCBoxPokemonPacket() {
        this.pokemon = MapsKt.emptyMap();
    }

    @NotNull
    public final UUID getStoreID() {
        UUID uUID = this.storeID;
        if (uUID != null) {
            return uUID;
        }
        Intrinsics.throwUninitializedPropertyAccessException("storeID");
        return null;
    }

    public final void setStoreID(@NotNull UUID uUID) {
        Intrinsics.checkNotNullParameter(uUID, "<set-?>");
        this.storeID = uUID;
    }

    public final int getBoxNumber() {
        return this.boxNumber;
    }

    public final void setBoxNumber(int n) {
        this.boxNumber = n;
    }

    @NotNull
    public final Map<Integer, PokemonDTO> getPokemon() {
        return this.pokemon;
    }

    public final void setPokemon(@NotNull Map<Integer, PokemonDTO> map) {
        Intrinsics.checkNotNullParameter(map, "<set-?>");
        this.pokemon = map;
    }

    /*
     * WARNING - void declaration
     */
    public SetPCBoxPokemonPacket(@NotNull PCBox box) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(box, "box");
        this();
        this.setStoreID(box.getPc().getUuid());
        this.boxNumber = box.getBoxNumber();
        Map<Integer, Pokemon> map = box.getNonEmptySlots();
        SetPCBoxPokemonPacket setPCBoxPokemonPacket = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to(it.getKey(), new PokemonDTO((Pokemon)it.getValue(), true)));
        }
        setPCBoxPokemonPacket.pokemon = MapsKt.toMap((List)destination$iv$iv);
    }

    @Override
    public void encode(@NotNull class_2540 buffer) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        buffer.method_10797(this.getStoreID());
        NetExtensionsKt.writeSizedInt((ByteBuf)buffer, IntSize.U_BYTE, this.boxNumber);
        NetExtensionsKt.writeMapK$default((ByteBuf)buffer, null, this.pokemon, new Function1<Map.Entry<? extends Integer, ? extends PokemonDTO>, Unit>(buffer){
            final /* synthetic */ class_2540 $buffer;
            {
                this.$buffer = $buffer;
                super(1);
            }

            public final void invoke(@NotNull Map.Entry<Integer, PokemonDTO> entry) {
                Intrinsics.checkNotNullParameter(entry, "<name for destructuring parameter 0>");
                int slot = ((Number)entry.getKey()).intValue();
                PokemonDTO pokemon = entry.getValue();
                NetExtensionsKt.writeSizedInt((ByteBuf)this.$buffer, IntSize.U_BYTE, slot);
                pokemon.encode(this.$buffer);
            }
        }, 1, null);
    }

    @Override
    public void decode(@NotNull class_2540 buffer) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        UUID uUID = buffer.method_10790();
        Intrinsics.checkNotNullExpressionValue(uUID, "buffer.readUuid()");
        this.setStoreID(uUID);
        this.boxNumber = NetExtensionsKt.readSizedInt((ByteBuf)buffer, IntSize.U_BYTE);
        Map pokemonMap = new LinkedHashMap();
        NetExtensionsKt.readMapK$default((ByteBuf)buffer, null, pokemonMap, new Function0<Pair<? extends Integer, ? extends PokemonDTO>>(buffer){
            final /* synthetic */ class_2540 $buffer;
            {
                this.$buffer = $buffer;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Pair<Integer, PokemonDTO> invoke() {
                void it;
                PokemonDTO pokemonDTO = new PokemonDTO();
                class_2540 class_25402 = this.$buffer;
                PokemonDTO pokemonDTO2 = pokemonDTO;
                Integer n = NetExtensionsKt.readSizedInt((ByteBuf)this.$buffer, IntSize.U_BYTE);
                boolean bl = false;
                it.decode(class_25402);
                return TuplesKt.to(n, pokemonDTO);
            }
        }, 1, null);
        this.pokemon = pokemonMap;
    }

    @Override
    public void sendToPlayer(@NotNull class_3222 player) {
        NetworkPacket.DefaultImpls.sendToPlayer(this, player);
    }

    @Override
    public void sendToPlayers(@NotNull Iterable<? extends class_3222> players) {
        NetworkPacket.DefaultImpls.sendToPlayers(this, players);
    }

    @Override
    public void sendToAllPlayers() {
        NetworkPacket.DefaultImpls.sendToAllPlayers(this);
    }

    @Override
    public void sendToServer() {
        NetworkPacket.DefaultImpls.sendToServer(this);
    }

    @Override
    public void sendToPlayersAround(double x, double y, double z, double distance, @NotNull class_5321<class_1937> worldKey, @NotNull Function1<? super class_3222, Boolean> exclusionCondition) {
        NetworkPacket.DefaultImpls.sendToPlayersAround(this, x, y, z, distance, worldKey, exclusionCondition);
    }
}

