/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.net.messages.client.storage.pc;

import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.api.storage.pc.PCStore;
import com.cobblemon.mod.common.net.IntSize;
import com.cobblemon.mod.common.util.NetExtensionsKt;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0004\b\u001f\u0010 B\u0007\u00a2\u0006\u0004\b\u001f\u0010!J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0007\u0010\u0006R\"\u0010\t\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\"\u0010\u0010\u001a\u00020\u000f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\"\u0010\u0017\u001a\u00020\u00168\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006\""}, d2={"Lcom/cobblemon/mod/common/net/messages/client/storage/pc/InitializePCPacket;", "Lcom/cobblemon/mod/common/api/net/NetworkPacket;", "Lnet/minecraft/class_2540;", "buffer", "", "decode", "(Lnet/minecraft/class_2540;)V", "encode", "", "boxCount", "I", "getBoxCount", "()I", "setBoxCount", "(I)V", "", "hasOverflowed", "Z", "getHasOverflowed", "()Z", "setHasOverflowed", "(Z)V", "Ljava/util/UUID;", "storeID", "Ljava/util/UUID;", "getStoreID", "()Ljava/util/UUID;", "setStoreID", "(Ljava/util/UUID;)V", "Lcom/cobblemon/mod/common/api/storage/pc/PCStore;", "pc", "<init>", "(Lcom/cobblemon/mod/common/api/storage/pc/PCStore;)V", "()V", "common"})
public final class InitializePCPacket
implements NetworkPacket {
    public UUID storeID;
    private int boxCount;
    private boolean hasOverflowed;

    public InitializePCPacket() {
    }

    @NotNull
    public final UUID getStoreID() {
        UUID uUID = this.storeID;
        if (uUID != null) {
            return uUID;
        }
        Intrinsics.throwUninitializedPropertyAccessException("storeID");
        return null;
    }

    public final void setStoreID(@NotNull UUID uUID) {
        Intrinsics.checkNotNullParameter(uUID, "<set-?>");
        this.storeID = uUID;
    }

    public final int getBoxCount() {
        return this.boxCount;
    }

    public final void setBoxCount(int n) {
        this.boxCount = n;
    }

    public final boolean getHasOverflowed() {
        return this.hasOverflowed;
    }

    public final void setHasOverflowed(boolean bl) {
        this.hasOverflowed = bl;
    }

    public InitializePCPacket(@NotNull PCStore pc) {
        Intrinsics.checkNotNullParameter(pc, "pc");
        this();
        this.setStoreID(pc.getUuid());
        this.boxCount = pc.getBoxes().size();
        this.hasOverflowed = CollectionsKt.any(pc.getBackupStore());
    }

    @Override
    public void encode(@NotNull class_2540 buffer) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        buffer.method_10797(this.getStoreID());
        NetExtensionsKt.writeSizedInt((ByteBuf)buffer, IntSize.U_BYTE, this.boxCount);
        buffer.writeBoolean(this.hasOverflowed);
    }

    @Override
    public void decode(@NotNull class_2540 buffer) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        UUID uUID = buffer.method_10790();
        Intrinsics.checkNotNullExpressionValue(uUID, "buffer.readUuid()");
        this.setStoreID(uUID);
        this.boxCount = NetExtensionsKt.readSizedInt((ByteBuf)buffer, IntSize.U_BYTE);
        this.hasOverflowed = buffer.readBoolean();
    }

    @Override
    public void sendToPlayer(@NotNull class_3222 player) {
        NetworkPacket.DefaultImpls.sendToPlayer(this, player);
    }

    @Override
    public void sendToPlayers(@NotNull Iterable<? extends class_3222> players) {
        NetworkPacket.DefaultImpls.sendToPlayers(this, players);
    }

    @Override
    public void sendToAllPlayers() {
        NetworkPacket.DefaultImpls.sendToAllPlayers(this);
    }

    @Override
    public void sendToServer() {
        NetworkPacket.DefaultImpls.sendToServer(this);
    }

    @Override
    public void sendToPlayersAround(double x, double y, double z, double distance, @NotNull class_5321<class_1937> worldKey, @NotNull Function1<? super class_3222, Boolean> exclusionCondition) {
        NetworkPacket.DefaultImpls.sendToPlayersAround(this, x, y, z, distance, worldKey, exclusionCondition);
    }
}

